<?php

namespace App\Http\Controllers\Service;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;
use Response;
use Mail;
use Config;

class ServiceController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function create(Request $request)
    {   

         /* added by brijesh on 13-12-2019*/
         $input=$request->all();
        if(!empty($input) || !empty($product_id))
        {
        $vendor_id=$input['vendor'];
         $product_id=$input['product_id'];
        }
        if(!empty($vendor_id))
        {
            
           // $today = Carbon::now();
            $end_date = DB::table('amcs')
                        ->select('end_date')
                        ->where('vendor_id','=',$vendor_id)
                        ->where('product_id','=',$product_id)
                        ->first();


            return Response::json($end_date);         
            
        }

        //$vendors = Vendor::all();
		$vendors = DB::table('vendor')
					->where('deleted_at','=','N')
                    ->where('status','=','Active')
					->orderBy('name','asc')
                    ->get(); 
        $products = DB::table('products')
                    ->orderBy('product_name','asc')
                    ->get();  
    	return view('services.create')->withVendors($vendors)->withProducts($products);
    }
    
   public function auto()
    {
        $vendors = Vendor::all();
        $products = DB::table('products')
                    ->get();  
    	return view('services.auto')->withVendors($vendors)->withProducts($products);
    }
	
	public function autocomplete($name){
	
	$queries = DB::table('bikers')
		->where('first_name', 'LIKE', '%'.$name.'%')
		->orWhere('last_name', 'LIKE', '%'.$name.'%')
		->take(5)->get();
	
	foreach ($queries as $query)
	{
	    $results[] = [ 'id' => $query->id, 'value' => $query->first_name.' '.$query->last_name ];
	}
	return Response::json($results);


	}

    public function store(Request $request)
    { 
        $month = date('m');
        $year = date('Y');

    //code added on 23 oct 2019
        //get count of services created monthly
        $monthly_services_count = DB::table('shipment')
                                    ->whereMonth('created_at', '=', $month)
                                    ->whereYear('created_at', '=', $year)
                                    ->count();     
        //get user have which plan from apniamc_master db
        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
        $client_plan = '';              
        if(!empty($clients)) {
            $client_plan = $clients->client_plan;
        } 
        $limit_sevices = 50;

        //if user has BASIC plan then check and restrict it to make only 50 services 
        if($client_plan == 'BA') {
            if($monthly_services_count >= $limit_sevices) {
                session::flash('unable_create_serv_mesg', 'Please upgrade your plan to make more Services. Please contact on this number 9137858155.');
                return redirect('/service/create');
            } else {
                return  $this->finalStoreServices($request);
            }
        }  

        else {
            return  $this->finalStoreServices($request);
        }    
    }
 //code added on 23 oct 2019
    //this function will be called to create the services
    public function finalStoreServices(Request $request) {
        $this->validate($request, [
            'vendor_id' => 'required',
            'product_id' => 'required',
            'service_description' => 'required',
            'service_type' => 'required'
            // 'mobileno' => 'required|regex:/^[0-9]+$/',
            ]);

        $input = $request->all();
         //print_r($input);exit();
        $product_code = DB::table('products')
                        ->select('*')
                        ->where('products.id','=',$input['product_id'])
                        ->first();
         $custid = Session::get('custid');
        $custname = Session::get('custname');
        if(isset($custid) && $custid)
        {
            $user =  $custname;  
            $typ = "Desktop - ".$user; 
            $username =  "Customer - " .$user; 
            $awb_date = Carbon::now()->format('dmYHis');
            $awb_no = "SUPP".$awb_date.$product_code->product_code;
            $admin = $user;
        } 
        else 
        {                
            $user = Auth::user();   
            $typ = "Desktop - ".$user->first_name." ".$user->last_name; 
            $username =  "Admin - " .$user->first_name." ".$user->last_name; 
            $awb_date = Carbon::now()->format('dmYHis');
            $awb_no = "SUPP".$awb_date.$product_code->product_code;
            
            $admin = $user->first_name." ".$user->last_name;
        }
    //if ($input['set_priority'] == '') {
    //  $input['set_priority'] = 0; 
    //}
        if($_SERVER['REMOTE_ADDR']=='1.146.221.120') 
        {
         //    //update ticket no
         //    $awb_no = Config::get('app.ticketprefix')."12";
         //    //$servicelist = VendorShipment::find($service->id);
         //    //$servicelist->awb_no = $awb_no;
         //    //$servicelist->save();
         //    //update ticket no

         //    $vinfo = DB::table('vendor')
         //               ->select('*')
         //               ->where('vendor.id','=',$input['vendor_id'])
         //               ->first();

         //              // print_r($vinfo);exit();
         //    $vname = $vinfo->name;
         //    $vemail = "vickey@mukesoft.com";
         //    $vpwd = $vinfo->plain_password;

         //    $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$input['service_description']." For Product ".$product_code->product_name.".";
         //   $emailcontent = array (
         //    'email'=>$vemail,
         //       'password'=>$vpwd,
         //        'cno' => $awb_no
         //    );

         //   $mobno = $input['mobileno'];   
         //    $st = str_replace(' ', '%20', $awb_no);
         //    $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";

         //   // echo $link3;die;
        
         //    $client3 = new \GuzzleHttp\Client();
         //    $this->response = $client3->get($link3)->getBody()->getContents(); 
         // //print_r($this->response); exit();

         //    $m1 = "7666333422";

         //    $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
         //        $client1 = new \GuzzleHttp\Client();
         //        $this->response = $client1->get($link1)->getBody()->getContents();
         //    //end

         //        Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
         //        $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
         //        $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

         //    $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

         //    }); 

        }
        else
        {
        $service = VendorShipment::create([
            'vendor_id' => $input['vendor_id'],
            'product_id' => $input['product_id'],
            'service_description' => $input['service_description'],
            'awb_no' => $awb_no,
            'order_time' => Carbon::now()->toDateTimeString(),
            'delivery_status' => "New",
            'created_type'=> $typ,
            'created_by'=> $username,
             //created_by'=>$username,
            'service_type'=> $input['service_type'],
            'mobileno'=> $input['mobileno'],
        'priority' =>$input['set_priority'],
            ]);
 
        //update ticket no
        $awb_no = Config::get('app.ticketprefix').$service->id;
        $servicelist = VendorShipment::find($service->id);
        $servicelist->awb_no = $awb_no;
        $servicelist->save();
        //update ticket no


        
        $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$input['vendor_id'])
                       ->first();

                      // print_r($vinfo);exit();
            $vname = $vinfo->name;
            $vemail = $vinfo->email;
            $vpwd = $vinfo->plain_password;
            
            $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$input['service_description']." For Product ".$product_code->product_name.".";
           $emailcontent = array (
            'email'=>$vemail,
               'password'=>$vpwd,
                'cno' => $awb_no
            );
         $mobno = $input['mobileno'];   
        $st = str_replace(' ', '%20', $awb_no);
        $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
        
            $client3 = new \GuzzleHttp\Client();
            $this->response = $client3->get($link3)->getBody()->getContents(); 
         //print_r($this->response); exit();
            //send sms
        $m1 = $vinfo->mobile_no;

        $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client1 = new \GuzzleHttp\Client();
            $this->response = $client1->get($link1)->getBody()->getContents();
        //end
        
        
        
        StatusHistory::create([
            'by_whom_role' => "Vendor", 
            'by_whom_id' => $input['vendor_id'],
            'date_time' => Carbon::now()->toDateTimeString(),
            'shipment_id' => $service->id,
            'status' => "New",
            ]);
        
         Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

            $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

        }); 
     } //else
        if(isset($custid) && $custid)
        {
            $request->session()->flash('flash_message','Service added successfully !!!');
            return back();
        }
        else
        {
            $request->session()->flash('flash_message','Service added successfully !!!');
            return redirect('managedelivery?type=today');
        }
    }

	 public function smscheck() {
	 $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=','75')
                       ->first();
        $product_code = DB::table('products')
                        ->select('*')
                        ->where('products.id','=','4')
                        ->first();					   
	$m1 = $vinfo->mobile_no;
	 $awb_date = Carbon::now()->format('dmYHis');
        $awb_no = Config::get('app.ticketprefix').$service->id;
		$st = str_replace(' ', '%20', $awb_no);
		$link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20complaint%20has%20been%20registered,Complaint No.$st,%20Your%20Complaint%20Will%20Attend%20Shortly.For%20further%20assistance%20pls%20call%208080922970.&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client1 = new \GuzzleHttp\Client();
			$this->response = $client1->get($link1)->getBody()->getContents();
			}

    public function createautoservice(Request $request)
    {

        $amcs = DB::table('amcs')
                        ->select('*')
                        ->where('end_date','>=',date('Y-m-d'))
                        ->where('next_service_date','=',date('Y-m-d'))
                        ->get();
        if($amcs)
        {
        foreach($amcs as $amc)
        {

            $product_id = $amc->product_id;
            $vendor_id = $amc->vendor_id;
        
        $product_code = DB::table('products')
                        ->select('*')
                        ->where('products.id','=',$product_id)
                        ->first();

                          $user = Auth::user();   

        $username =  "Admin - " .$user->first_name." ".$user->last_name; 
         
        $typ = "Desktop - Auto Generate Service";     
        $awb_date = Carbon::now()->format('dmYHis');
        $awb_no = "SUPP".$awb_date.$product_code->product_code;

        $admin = "Auto Generated";

        $service_description = 'auto generated ticket';
        $service_type = 'Complain';
        $mobno = '';

        $service = VendorShipment::create([
            'vendor_id' => $vendor_id,
            'product_id' => $product_id,
            'service_description' => $service_description,
            'awb_no' => $awb_no,
            'order_time' => Carbon::now()->toDateTimeString(),
            'delivery_status' => "New",
            'created_type'=> $typ,
            // 'created_by'=>"Admin",
            'created_by'=> $username,
            'service_type'=> $service_type,
            'mobno'=> $mobno,
            ]);

        //update ticket no
        $awb_no = Config::get('app.ticketprefix').$service->id;
        $servicelist = VendorShipment::find($service->id);
        $servicelist->awb_no = $awb_no;
        $servicelist->save();
        //update ticket no
        
         

        $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$vendor_id)
                       ->first();
            $vname = $vinfo->name;
            $vemail = $vinfo->email;
            $vpwd = $vinfo->plain_password;
            $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$service_description." For Product ".$product_code->product_name.".";
           $emailcontent = array (
            'email'=>$vemail,
               'password'=>$vpwd,
                'cno' => $awb_no
            );
          
        $st = str_replace(' ', '%20', $awb_no);
        $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client3 = new \GuzzleHttp\Client();
            $this->response = $client3->get($link3)->getBody()->getContents(); 
            //print_r($this->response); exit();
            //send sms
        $m1 = $vinfo->mobile_no;

        
        $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client1 = new \GuzzleHttp\Client();
            $this->response = $client1->get($link1)->getBody()->getContents();
        //end
        
        
        
        
        
        StatusHistory::create([
            'by_whom_role' => "Vendor",
            'by_whom_id' => $vendor_id,
            'date_time' => Carbon::now()->toDateTimeString(),
            'shipment_id' => $service->id,
            'status' => "New",
            ]);

            //update
            $service_timeframe = '';
            $next_service_date = '';

            if($amc->service_timeframe!='')
            {
                $service_timeframe = $amc->service_timeframe;
                switch($service_timeframe)
                {
                    case '15 Days' :

                        $daystoadd = 15;
                        $next_service_date = date('Y-m-d', strtotime("+15 days",strtotime($amc->next_service_date)));
                        break;

                    case 'Monthly' :
                        $next_service_date = date('Y-m-d', strtotime("+1 month",strtotime($amc->next_service_date)));
                        break;

                    case 'Quaterly' :
                        $next_service_date = date('Y-m-d', strtotime("+3 months",strtotime($amc->next_service_date)));
                        break;
                }
            }  

            DB::table('amcs')
            ->where('id', $amc->id)
            ->update(['next_service_date' => $next_service_date]);

            //update

        
        //  Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
        //     $message->from(Config::get('app.fromemail'), Config::get('app.companyname'));

        //     $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');
            

        // }); 
         //$request->session()->flash('flash_message','Service successfully added');
        //return redirect('service/create');
     } //foreach
    }
    }
}
