<?php
namespace App\Http\Controllers\SLA_Setting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;
use Response;
use Mail;
use Config;

class SLA_SettingController extends Controller {

	public function __construct()
	{
		$this->middleware('auth');
	}

    /**
     * this function is used to get the data from the sla_setting table
     */
    public function sla_form()
    {
        # code...
        $sla_settings = DB::table('sla_setting')->select('*')->get();
        $sla_array = array();

        if ($sla_settings){
            $sla_array['sla_turn_around_time'] = $sla_settings[0]->sla_turn_around_time;
            $sla_array['sla_close_time'] = $sla_settings[0]->sla_close_time;
            $sla_array['service_turn_around_time'] = $sla_settings[0]->service_turn_around_time;
            $sla_array['service_close_time'] = $sla_settings[0]->service_close_time;
            $sla_array['sla_close_time'] = $sla_settings[0]->sla_close_time;
            $sla_array['esc_email'] = $sla_settings[0]->esc_email;
            $sla_array['sla_esc_email'] = $sla_settings[0]->sla_esc_email;
        } else{
            $sla_array['sla_turn_around_time'] = 0;
            $sla_array['sla_close_time'] = 0;
            $sla_array['service_turn_around_time'] = 0;
            $sla_array['service_close_time'] = 0;
            $sla_array['sla_close_time'] = 0;
            $sla_array['esc_email'] = "";
            $sla_array['sla_esc_email'] = "";
        }

		return view('sla_setting.sla_form')->with("sla_form",$sla_array);
    }

    /**
     * this function is used to update the data
     */
    public function sla_formUpdate(Request $request)
    {
        # code...
        $update = $request->all();
        $sla_turn_around_time = $update['sla_turn_around_time'];
        $sla_close_time = $update['sla_close_time'];
        $service_turn_around_time = $update['service_turn_around_time'];
        $service_close_time = $update['service_close_time'];
        $esc_email = $update['esc_email'];
        $sla_esc_email = $update['sla_esc_email'];
        $date = date('y-m-d H:i:s');

        // DB::table('sla_setting')->where('id', $amc->id)->update(['next_service_date' => $next_service_date]);
        DB::table('sla_setting')->update([
                'sla_turn_around_time' => $sla_turn_around_time,'sla_close_time'=>$sla_close_time,
                'service_turn_around_time'=>$service_turn_around_time,
                'service_close_time'=>$service_close_time,
                'esc_email'=>$esc_email,'sla_esc_email'=>$sla_esc_email,
                'updated_at'=>$date]);

        $request->session()->flash('flash_message','SLA Settting Update Successfully !!!');

		return redirect('sla_setting/sla_form');
    }


}

?>