<?php

namespace App\Http\Controllers\ManageRma;

use App\Vendor;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Mail;
use DB;
use Input;
use Config;
use App\Rma_service;
use Auth;

class RmaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
       public function index()
    {
       

        if (!empty(Input::get('sort'))) {
                $sort = Input::get('sort');
        } else {
                $sort = 'rma_service.id';
        }
        if (!empty(Input::get('order'))) {
                $order = Input::get('order');
        } else {
                $order = 'DESC';
        }

        if ($order == 'ASC') {
                $url = '?order=DESC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
                $url = '?order=ASC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        }
        if(!empty(Input::get('order'))) {
       //     $url .= "?order=".Input::get('order');
        }
       
       if(!empty(Input::get('sort'))) {
         //   $url .= "&sort=".Input::get('sort');
        }

        $sort_data = array(

            'rma_service.model_no',
            'rma_service.serial_no',
            'rma_service.product_name',
            'rma_service.product_descp',
            'rma_service.rma_type',
            'rma_service.biker_id',
            'rma_service.shipment_id',
            'rma_service.client_name',
            'rma_service.company_name',
            'rma_service.biker_name',
            'rma_service.quantity',
            'rma_service.issue',
            'rma_service.warranty',
            'rma_service.brought_by',
            'rma_service.recieved_product_date',
            'rma_service.date_of_repairing',
            'rma_service.no_of_days',
            'rma_service.challan_no',
            'rma_service.status',
            'rma_service.remark',
        );
        //$query = Vendor::select();
        $query = DB::table('rma_service')->select('*');
       // $query;
                    if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "rma_service.id";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query->orderby($sort_col_name,'desc');
                    } else {
                        $query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        
                        $query->whereRaw("(rma_service.company_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  rma_service.model_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  rma_service.serial_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.product_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.product_descp LIKE '%".trim(addslashes(Input::get('filter_name')))."%'  OR rma_service.rma_type LIKE '%".trim(addslashes(Input::get('filter_name')))."%'  OR rma_service.biker_id LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.rma_type LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.shipment_id LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.client_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.company_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.biker_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.quantity LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.issue LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.warranty LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.brought_by LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.recieved_product_date LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.date_of_repairing LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.no_of_days LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.challan_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.status LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.remark LIKE '%".trim(addslashes(Input::get('filter_name')))."%')");
                           
                    }
                    //$myModelsPaginator->appends($input);

        $rma_service = $query->paginate(10);            
//echo $url;exit();
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
        //export start
        
              
         
         if(Input::get('report') == 1) {


             $query1tmp = DB::table('rma_service')          
                  ->select('*');
                  

            if(!empty(Input::get('filter_name'))) {

                        
                    $query1tmp->whereRaw("(rma_service.company_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  rma_service.model_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  rma_service.serial_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.product_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.product_descp LIKE '%".trim(addslashes(Input::get('filter_name')))."%'  OR rma_service.rma_type LIKE '%".trim(addslashes(Input::get('filter_name')))."%'  OR rma_service.biker_id LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.rma_type LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.shipment_id LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.client_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.company_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.biker_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.quantity LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.issue LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.warranty LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.brought_by LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.recieved_product_date LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.date_of_repairing LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.no_of_days LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.challan_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.status LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR rma_service.remark LIKE '%".trim(addslashes(Input::get('filter_name')))."%')");
                       
                    }

            if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(rma_service.id IN (".$selectedval.") )");
            }

                if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "rma_service.id";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query1tmp->orderby($sort_col_name,'desc');
                    } else {
                        $query1tmp->orderby($sort_col_name,'asc');
                    }

                  $query1 =   $query1tmp->get();

            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array(' ','RMA REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Service Id', 'Client Name', 'Company Name', 'RMA Type', 'Product Name', 'Serial No', 'Model No', 'Product Desc', 'Technician Name', 'Issue', 'Warranty', 'Recieved Product Date', 'Date Of Repairing', 'No Of Days', 'Challan No', 'Status', 'Remark', 'Stand By Device Received Back From Client', 'Stand By Device Submitted By Technician'));
             foreach ($query1 as $line) { 
                $stdfrmclient = ($line->standbydeviceweb=="1") ? "Yes" : "No";
                if($line->standbydeviceweb=="1")
                {
                    $stdfrmclient .= " - (Serial No. : ".$line->standbywebserialno.") - (Model No. : ".$line->standbywebmodelno.")";
                }

                $stdbytech = ($line->standbydevice=="1") ? "Yes" : "No";
                if($line->standbydevice=="1")
                {
                    $stdbytech .= " - (Serial No. : ".$line->standbyserialno.") - (Model No. : ".$line->standbymodelno.")";
                }

                $data = array(
                    'shipment_id' => $line->shipment_id,
                    'client_name' => $line->client_name,
                    'company_name' => $line->company_name,
                    'rma_type' => $line->rma_type,
                    'product_name' => $line->product_name,
                    'serial_no' => $line->serial_no,
                    'model_no' => $line->model_no,
                    'product_descp' => $line->product_descp,
                    'biker_name' => $line->biker_name,
                    'issue' => $line->issue,
                    'warranty' => $line->warranty,
                    'recieved_product_date' => $line->recieved_product_date,
                    'date_of_repairing' => $line->date_of_repairing,
                    'no_of_days' => $line->no_of_days,
                    'challan_no' => $line->challan_no,
                    'status' => $line->status,
                    'remark' => $line->remark,
                    'standbyfrmclient' => $stdfrmclient,
                    'standbytech' => $stdbytech,
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('rma_report.csv');
            die;
            return;
        }
        //end start
        return view('managerma.index')->withrma_service($rma_service)->withFilter($filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
/*    public function create() {

       //  echo "testing2";die();
         $states = DB::table('state')->get();
         return view('vendor.create')->withStates($states);
    }*/

    public function create() 
    {
       // echo "create".die();
   
      $shipment_id=$_GET['id'] ;
      $awb_no=2; //domi

      $delivery_details = DB::table('shipment as sh')
                ->leftjoin('vendor as v','v.id','=','sh.vendor_id')
                ->leftjoin('products as p','p.id','=','sh.product_id')
                ->leftjoin('amcs as a','a.vendor_id','=','sh.vendor_id')
                ->leftjoin('bikers as biker','biker.id','=','sh.biker_id')
                ->select('sh.id','sh.delivery_status','biker.mobile','biker.first_name as biker_firstname','biker.last_name as biker_lastname','v.name as vendor_name','v.mobile_no','v.primary_address','v.landmark','v.city','v.state','v.pin_code','sh.receiver_sign','sh.service_description','p.product_name','v.company_name','sh.service_action','a.end_date','a.atype','sh.order_time','sh.created_type','sh.service_type','sh.remark','sh.sign_date','sh.created_by','sh.vendor_id','sh.priority','sh.created_at','sh.mobno','biker_id','sh.expense','sh.expense_description','sh.awb_no')
                //->where('sh.awb_no', '=',$awb_no) 
                ->where('sh.id', '=',$shipment_id) 
                ->orWhere('a.vendor_id','=','sh.vendor_id')
                ->first();
      return view('managerma.create')->with(compact('delivery_details'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     * @return Response
     */
    public function store(Request $request) {
     // echo "hello";  die();
     // echo "store"."<pre>"; print_r($request->all()); 
        $this->validate($request, [
            'product_name' => 'required',
            'model_no' => 'required', 
            'serial_no' => 'required', 
            'product_descp' => 'required', 
            'issue' => 'required',  
            'warranty' => 'required', 
            'recieved_product_date' => 'required', 
            'date_of_repairing' => 'required', 
            //'no_of_days' => 'required', 
            'challan_no' => 'required', 
            'status' => 'required',
            'rma_type' => 'required',
            'remark' => 'required', 
           /* 'email' => 'required|email|unique:vendor',*/
        ]);

       
            $input = $request->all();
            
            if(isset($input['standbydeviceweb'])) {}
            else { $input['standbydeviceweb'] = "0"; }

            if(isset($input['no_of_days'])) {}
            else { $input['no_of_days'] = "0"; }
        

            $input['recieved_product_date'] = date('Y-m-d', strtotime($input['recieved_product_date']));
            $input['date_of_repairing'] = date('Y-m-d', strtotime($input['date_of_repairing']));
           
            $vendor_id = Rma_service::create($input);

          
            $request->session()->flash('flash_message', 'RMA Created Successfully !!!');
            //return redirect('managevendor');
            return back();
       
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
       // $img_dir = "uploads/images/vendor/".$id."/";
       //$vendor = $this->Vendor->findOrFail($id);
        $rma_service = DB::table('rma_service')->select('*')->where("id",'=',$id)->get();
       // echo "<pre>"; print_r($rma_service); die();
        return view('managerma.show')->withrma_service($rma_service[0]);
    }

    public function updatestatus(Request $request)
    {
       // echo "test";die();
      //  echo "TEST1<pre>"; print_r($request->all()); die();
       // $img_dir = "uploads/images/vendor/".$id."/";
       //$vendor = $this->Vendor->findOrFail($id);
        $result = DB::table('rma_service')->select('*')->where("id",'=',$request->c)->first();
        // echo $result->shipment_id."<pre>"; print_r($result); die();
       $html = '<div class="form-group">
            
            <label class="col-md-4 control-label">Recieved Product Date<span style="color:#FF0000"> *</span></label>
           
                <div class="input-group date">
                    <input type="text" id="recieved_product_date" name="recieved_product_date" data-format="DD-MM-YYYY" value="'.$result->recieved_product_date.'" class="form-control">
                    <span class="input-group-btn">
                        <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                    </span>
                </div>
           
        </div>

        <div class="form-group">
            
            <label class="col-md-4 control-label">Status<span style="color:#FF0000"> *</span></label>
           
                <div class="input-group date">
                    <select id="status" name="status" class="form-control">
                        <option value="">Please Select</option>
                        <option value="Pending">Pending</option>
                        <option value="Recieved from client">Recieved from client</option>
                        <option value="Send to service center">Send to service center</option>
                        <option value="Received from service center">Received from service center</option>
                        <option value="Return to client">Return to client</option>
                        <option value="Repair at Office">Repair at Office</option>
                        <option value="Replace from Company">Replace from Company</option>
                        <option value="complete">Complete</option>
                        <option value="close">Close</option>
                    </select>
                </div>
           
        </div>
        <div class="form-group">
            
            <label class="col-md-4 control-label">Remark<span style="color:#FF0000"> *</span></label>
           
                <div class="input-group ">
                    <textarea class="form-control" id="remark" name="remark" rows="2" style="text-transform:capitalize"  placeholder="Enter Remark">'.$result->remark.'</textarea>
                    <input type="hidden" name="id" id="rmaid" value="'.$result->id.'">
                    <input type="hidden" name="shipment_id" id="shipment_id" value="'.$result->shipment_id.'">
                </div>
           
        </div>';
        echo $html;
         //echo json_encode($data);
         //echo $data;
       // return view('managerma.show')->withrma_service($rma_service[0]);
    }


 

    public function finalupdate(Request $request)
    {
        //echo "<pre>"; print_r($request->all()); die();
        $prod_dt = $request->recieved_product_date;
        $prod_dt_arr = explode("-",$prod_dt);
        $prod_dt_new = $prod_dt_arr[2].'-'.$prod_dt_arr[1].'-'.$prod_dt_arr[0];


        DB::table('rma_service')
        ->where('id',$request->rmaid)
        ->update(['remark' => $request->remark, 'status' => $request->status, 'recieved_product_date' => $prod_dt_new]);


        $update_dt = date('Y-m-d H:i:s');
        $data = array('rma_id' => $request->rmaid, 'shipment_id' => $request->shipment_id, 'remark' => $request->remark, 'status' => $request->status,'recieved_product_date' => $prod_dt_new, 'updated_at' => $update_dt);

        DB::table('rma_service_history')->insert($data);

        $request->session()->flash('flash_message', 'RMA Updated Successfully !!!');
        //return view('managerma.index');
    }

    public function edit($id)
    {
        $img_dir = "uploads/images/vendor/".$id."/";
       // $vendor = Vendor::findOrFail($id);
        $rma_service = DB::table('rma_service')->select('*')->where("id",'=',$id)->get();
        
        $states = DB::table('state')->get();
        return view('managerma.edit')->withrma_service($rma_service[0])->withStates($states)->withImgDir($img_dir);
    }

    public function updateallvendorsname()
    {
        
        echo 'reached';
        $query = DB::table('bikers')->select('*');
        //$query->where("deleted_at","=",NULL);
        $vendors = $query->get();
        $i=0;
        foreach($vendors as $vendor)
        {
            $input = array();
            //echo $i++.' '.$vendor->company_name.'<br>';
            $vendor = Bikers::findOrFail($vendor->id);
            $input['first_name'] = ucwords(strtolower($vendor->first_name));
            $input['last_name'] = ucwords(strtolower($vendor->last_name));
            $vendor->fill($input)->save();

        }
        echo 'end';
        die;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Request  $request
     * @param  int  $id
     * @return Response
     */
    public function update(Request $request, $id)
    { 
       // echo "update"."<pre>"; print_r($request->all()); die();
       // echo "update"; die();
        $this->validate($request, [
            'product_name' => 'required',
            'model_no' => 'required', 
            'serial_no' => 'required', 
            'product_descp' => 'required', 
            'issue' => 'required',  
            'warranty' => 'required', 
            'recieved_product_date' => 'required', 
            'date_of_repairing' => 'required', 
            'no_of_days' => 'required', 
            'challan_no' => 'required', 
            'status' => 'required',
            'rma_type' => 'required',
            'remark' => 'required', 
        ]);

      //  $vendor = Vendor::findOrFail($id);
         $rma_service1 = DB::table('rma_service')->select('*')->where("id",'=',$id)->get();
         $rma_service=$rma_service1[0];

        $input = $request->all(); 

        if(isset($input['standbydeviceweb'])) {}
            else { $input['standbydeviceweb'] = "0"; }

        $temp_data= $input;  
       
    unset($temp_data['_method']);
    unset($temp_data['_token']);
    // unset($temp_data['reset_password']);
     unset($temp_data['sort']);
    unset($temp_data['filter_name']);
     unset($temp_data['page']);
      unset($temp_data['order']);

        /*Vendor::where('id', $id)->update($temp_data);*/

       /* added by brijesh on 12-12-2019*/
        $temp_data['recieved_product_date'] = date('Y-m-d', strtotime($temp_data['recieved_product_date']));
        $temp_data['date_of_repairing'] = date('Y-m-d', strtotime($temp_data['date_of_repairing']));

        DB::table('rma_service')
        ->where('id',$id)
        ->update(['model_no' => $temp_data['model_no'], 'serial_no' => $temp_data['serial_no'], 'product_name' => $temp_data['product_name'], 'product_descp' => $temp_data['product_descp'], 'rma_type' => $temp_data['rma_type'],'biker_id' => $temp_data['biker_id'], 'shipment_id' => $temp_data['shipment_id'], 'client_name' => $temp_data['client_name'], 'company_name' => $temp_data['company_name'], 'biker_name' => $temp_data['biker_name'], 'quantity' => $temp_data['quantity'], 'issue' => $temp_data['issue'], 'warranty' => $temp_data['warranty'], 'brought_by' => $temp_data['brought_by'], 'recieved_product_date' => $temp_data['recieved_product_date'], 'date_of_repairing' => $temp_data['date_of_repairing'], 'no_of_days' => $temp_data['no_of_days'], 'challan_no' => $temp_data['challan_no'], 'status' => $temp_data['status'], 'remark' => $temp_data['remark'], 'standbydeviceweb' => $temp_data['standbydeviceweb'], 'standbywebserialno' => $temp_data['standbywebserialno'], 'standbywebmodelno' => $temp_data['standbywebmodelno']]);

      /* end added by brijesh on 12-12-2019 */


      $update_dt = date('Y-m-d H:i:s');
        $datahist = array('rma_id' => $id, 'shipment_id' => $temp_data['shipment_id'], 'remark' => $temp_data['remark'], 'status' => $temp_data['status'],'recieved_product_date' => $temp_data['recieved_product_date'], 'updated_at' => $update_dt);

        DB::table('rma_service_history')->insert($datahist);
        
        $rma_service1 = DB::table('rma_service')->select('*')->where("id",'=',$id)->where("deleted_at",'=','N')->get();
         $rma_service=$rma_service1[0];

        $request->session()->flash('flash_message', 'RMA details updated successfully !!!');
        return redirect("managerma?sort=".$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
      //echo $id; die();
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++){
            $vendor = DB::table('rma_service')->where('id', $ids)->delete();
        }
        //Vendor::find(explode(',', $id))->destroy();
        return redirect('managerma')->with('flash_message', 'RMA deleted successfully !!!');
    }
    public function CreateShipment() {
        $vendors = Vendor::all();
        return view('vendor.pseudo_create_shipmnet')->withVendors($vendors);
    }

}
