<?php

namespace App\Http\Controllers\ManagePermission;

use Illuminate\Http\Request;
use App\Permission;
use App\PermissionRole;
use App\Role;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;

class ManagePermissionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::all();
        $permissions = Permission::all();
        $permissionroles = PermissionRole::all();
        // dd($permissionroles);
        return view('managepermission.index')->withRoles($roles)->withPermissions($permissions)->withPermissionroles($permissionroles);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   //Added by gaurav on 18-03-20 for giving certain restriction to the users
        PermissionRole::truncate();
        $inputs = $request->all();
        foreach ($inputs['permission'] as $input) {
            $addval = $udpateval = $delval = 0;
            if(isset($inputs['add'][$input]))
            {
                $addval = $inputs['add'][$input];
            }
            if(isset($inputs['update'][$input]))
            {
                $udpateval = $inputs['update'][$input];
            }
            if(isset($inputs['delete'][$input]))
            {
                $delval = $inputs['delete'][$input];
            }
            $permirolls = explode('-', $input);
            $insert['role_id'] = $permirolls[0];
            $insert['permission_id']= $permirolls[1];
            DB::table('permission_role')->insert(['permission_id' => $insert['permission_id'], 'role_id' => $insert['role_id'], 'add' => $addval, 'update' => $udpateval, 'delete' => $delval]);
             //PermissionRole::create($insert);
        }
        $request->session()->flash('success', 'Permissions are successfully allotted !');
        return redirect("managepermission/");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function managepermissions()
    {

        // DB::table('permission_role')
        //         ->insert(
        //                 ['permission_id' => $permission_id, 'role_id' => $role_id]
        //             );

                // $roles = Role::all();
        // $permissions = Permission::all();
        //->withRoles($roles)->withPermissions($permissions);
    }
}
