<?php namespace App\Http\Controllers;
use App\Role;
use App\Permission;
use Auth;
use DB;
use Session;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use DatePeriod;
use Input;
use App\User;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;

class HomeController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
	}

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function index(Request $request)
	{
		$user = Auth::user();
		$role = DB::table('roles')
		         ->select(DB::raw('*'))
		         ->where('id', $user->role_id)
		         ->first();
		$sub_station = DB::table('sub_station')
		         ->select(DB::raw('*'))
		         ->where('user_id', $user->id)
		         ->first();
        $logindate = DB::table('users')
                 ->select(DB::raw('*'))
                 ->first();
		Session::put('user_role',$role->role_title);
		Session::put('userrid',$user->role_id);


        $url = @$_SERVER['HTTP_REFERER'];
        $test = substr($url,-10);
        if($test == "auth/login")
        {
            DB::table('apni_amc_master.client_master')
                ->where('client_email', $logindate->email)
                ->where('client_name', 'like', '%'.$logindate->first_name.'%')
                ->update(['lastlogin' => Carbon::now()->toDateTimeString()]);
        }

		if($user->role_id == 2) {
			if(!empty($sub_station)){
				Session::put('substation_name',$sub_station->name);
				Session::put('sub_station_id',$sub_station->id);
				Session::put('sub_station_cod_amt',$sub_station->cod_amount_collected);
			} else {
				//for avoiding if substation is not assiged
				Session::put('sub_station_id',999999999999);
	            Session::put('sub_station_cod_amt',0.0);
	            Session::put('substation_name','');
			}
        }

		// For landing Page
        $input =Input::all();
		$substation_id = Session::get('sub_station_id');
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $start_date = $date->format('Y-m-d 00:00:00');
        $end_date = new DateTime('NOW');
		$n11 = DB::table('vendor')
                   ->select('id')
				    ->where('deleted_at','=','N')
                   ->get();
		$total_client = count($n11);
		
        $site_settings = DB::table('site_settings')
                      ->select('*')
                      ->get();
        $settings_arr = array();

        if($site_settings)
        {
            foreach($site_settings as $val)
            {
            $settings_str = urldecode($val->settings);
            $settings_arr = unserialize($settings_str);
            }
        }
        $statuses = 0;
        if(isset($settings_arr['statuses'])) 
        {          
            if($settings_arr['statuses'] == '1') 
            {
                $statuses = 1;
            }
        }

        if ($statuses == 0) {
            $pending_status = array('Awaiting Spares', 'Work Pending', 'Client Side', 'In Progress', 'New');
            $completed_status = array('Completed', 'Closed');
        } else {
            $avl_statuses = DB::table('statuses')->select('*')->get();
            $pending_status = array();
            $completed_status = array();

            if ($avl_statuses) {
                foreach ($avl_statuses as $sts) {
                    if ($sts->NAME == 'Closed' || $sts->NAME == 'Completed') {
                        $completed_status[] = $sts->id;
                    } else {
                        $pending_status[] = $sts->id;
                    }
                }
            }
        }

        // Added by gaurav on 30-03-20 for showing status tickets in dashboard of external admin view only..
        $admintypes = Auth::user()->types;
        if($admintypes=="External"){
            $externaladmin_id = Auth::user()->id;

            $n44 = DB::table('bikers')
                       ->select('id')
                       ->whereRaw("types= 'External' AND created_by = $externaladmin_id")
                       //->whereRaw('deleted_at','=',NULL)
                       ->get();
            $total_technician = count($n44);

            $n22 = DB::table('shipment')
                   ->select('id')
                   ->whereRaw("external_admin = $externaladmin_id")
                   ->get();
            $total_service= count($n22);
            
            $n22 = DB::table('shipment')
               ->select('id')
               ->whereRaw("external_admin = $externaladmin_id")
               ->whereIn('delivery_status',$pending_status)                   
               ->get();
            $pending_service= count($n22);

            $n22 = DB::table('shipment')
                   ->select('id')
                   ->whereRaw("external_admin = $externaladmin_id")
                   ->whereIn('delivery_status',$completed_status)                       
                   ->get();
            $completed_service= count($n22);

        }
        else{
            $n44 = DB::table('bikers')
                       ->select('id')
                        ->where('deleted_at','=',NULL)
                       ->get();
            $total_technician = count($n44);

            $n22 = DB::table('shipment')
                       ->select('id')
                       ->get();
            $total_service= count($n22);

            $n22 = DB::table('shipment')
                       ->select('id')
                       ->whereIn('delivery_status',$pending_status)                   
                       ->get();
    		$pending_service= count($n22);

            $n22 = DB::table('shipment')
                       ->select('id')
                       ->whereIn('delivery_status',$completed_status)                       
                       ->get();
            $completed_service= count($n22);
        }

		$n55 = DB::table('amcs')
                   ->select('id')
                   ->get();
		$total_amc = count($n55);
        //print_r($n5);
		
		$n66 = DB::table('rating')
                   ->select('id')
                   ->where('app','>=',3)
                   ->where('technician','>=',3)
                   ->get();
		$total_good_rating = count($n66);

        $n66 = DB::table('rating')
                   ->select('id')
                   ->where('app','<',3)
                   ->where('technician','<',3)
                   ->get();
        $total_bad_rating = count($n66);

		//echo $date = new DateTime();
        //$date->sub(new DateInterval('P1D'));
        //echo $date->subWeek(); // or $date->subDays(7),  2014-03-27 13:58:25

		//echo $yesterday_date = $date->format('Y-m-d 00:00:00');
		$currentDate = Carbon::now();
		$date = new DateTime($currentDate);
		$cm = $date->format('Y-m-d ');
		
		$s1 = Carbon::now()->addDays(1);
		$date1 = new DateTime($s1);
		$s1m = $date1->format('Y-m-d ');
		$s2 = Carbon::now()->addDays(2);
		$date2 = new DateTime($s2);
		$s2m = $date2->format('Y-m-d ');
		$s3 = Carbon::now()->addDays(3);
		$date3 = new DateTime($s3);
		$s3m = $date3->format('Y-m-d ');
		$s4 = Carbon::now()->addDays(4);
		$date4 = new DateTime($s4);
		$s4m = $date4->format('Y-m-d ');
		$s5 = Carbon::now()->addDays(5);
		$date5 = new DateTime($s5);
		$s5m = $date5->format('Y-m-d ');
		$s6 = Carbon::now()->addDays(6);
		$date6 = new DateTime($s6);
		$s6m = $date6->format('Y-m-d ');
		$s7 = Carbon::now()->addDays(7);
		$date7 = new DateTime($s7);
		$s7m = $date7->format('Y-m-d ');
		
		
		$res = $res1 = $res2 = $res3 = $res4 = $res5 = $res6 = $res7 = array();
		
		$p = count($res);
		$p1 = count($res1);
		$p2 = count($res2);
		$p3 = count($res3);
		$p4 = count($res4);
		$p5 = count($res5);
		$p6 = count($res6);
		$p7 = count($res7);
		
		//services start
        $start_time = '00:00:00';
        $date_sr = new DateTime();
        $today_start_time = $date_sr->format('Y-m-d '.$start_time);
        $today_end_time = new DateTime('NOW');
			
        if ($statuses == 0) {
            $new_installation_status = 'New Installation';
        }else{
            $new_installation_status = '1';
        }
        if($statuses == 0){
            //todays count start
            $qry1 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','New')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb1 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','New')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

                    
            $qry2 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    
                    ->where('sh.delivery_status','=','In Progress')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb2 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    
                    ->where('sh.delivery_status','=','In Progress')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
                    
            $qry3 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    
                    ->where('sh.delivery_status','=','Awaiting Spares')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb3 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Awaiting Spares')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
            
            $qry4 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Work Pending')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb4 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    
                    ->where('sh.delivery_status','=','Work Pending')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
                    
            $qry5 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Client Side')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb5 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Client Side')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
                    
            $qry6 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Completed')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb6 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Completed')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
                    
            $qry7 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Closed')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb7 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Closed')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
                    
            $qry8 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Cancelled')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				 
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();

            $qryb8 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Cancelled')
                    ->where('sh.service_type','=',$new_installation_status)
                                    ->where('v.deleted_at','=','N')
                    ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                    ->get();
            //end
                            
            $query1 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','New')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				 
                    ->get();

            $queryb1 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','New')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				 
                    ->get();
                    
                    
            $query2 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','In Progress')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				  
                    ->get();

            $queryb2 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','In Progress')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				  
                    ->get();
                    
            $query3 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Awaiting Spares')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')
                    ->get();

            $queryb3 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Awaiting Spares')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				  
                    ->get();
                    
            $query4 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Work Pending')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				  
                    ->get();

            $queryb4 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Work Pending')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				  
                    ->get();
                    
            $query5 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Client Side')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				  
                    ->get();

            $queryb5 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Client Side')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				  
                    ->get();
                    
            $query6 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Completed')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				  
                    ->get();

            $queryb6 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Completed')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')				  
                    ->get();
                    
            $query7 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Closed')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')				  
                    ->get();

            $queryb7 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Closed')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')
                    ->get();
                    
            $query8 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Cancelled')
                    ->where('sh.service_type','=','Complain')
                    ->where('v.deleted_at','=','N')
                    ->get();

            $queryb8 = DB::table('shipment as sh')          
                    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                    ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                    ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                    ->where('sh.delivery_status','=','Cancelled')
                    ->where('sh.service_type','=',$new_installation_status)
                    ->where('v.deleted_at','=','N')
                    ->get();
            
            $a1 = count($query1);				
            $a2 = count($query2);				
            $a3 = count($query3);				
            $a4 = count($query4);				
            $a5 = count($query5);				
            $a6 = count($query6);				
            $a7 = count($query7);				
            $a8 = count($query8);	

            $b1 = count($queryb1);                
            $b2 = count($queryb2);             
            $b3 = count($queryb3);             
            $b4 = count($queryb4);             
            $b5 = count($queryb5);             
            $b6 = count($queryb6);             
            $b7 = count($queryb7);             
            $b8 = count($queryb8); 	

            $a9 = count($qry1);				
            $a10 = count($qry2);				
            $a11 = count($qry3);				
            $a12 = count($qry4);				
            $a13 = count($qry5);				
            $a14 = count($qry6);				
            $a15 = count($qry7);				
            $a16 = count($qry8);	

            $b9 = count($qryb1);               
            $b10 = count($qryb2);              
            $b11 = count($qryb3);              
            $b12 = count($qryb4);              
            $b13 = count($qryb5);              
            $b14 = count($qryb6);              
            $b15 = count($qryb7);              
            $b16 = count($qryb8);  
            
            $amcs =  DB::table('amcs as a')
                ->leftJoin('products as p','p.id','=','a.product_id')
                ->select('a.*','p.product_name',DB::raw('DATEDIFF(end_date,NOW()) as exp_days'))
                ->where(function ($query) {
                        $query->whereBetween('a.end_date',[date('Y-m-d') ,date('Y-m-d', strtotime('+15 days')) ])
                            ->orwhereBetween('a.end_date',[date('Y-m-d', strtotime('-30 days')),date('Y-m-d') ]);
                    })
                ->get();
                $today = Carbon::now();
                $newDate = substr($today->addDays(15),0,10);
                $i = 0;
                $array = array();

                foreach($amcs as $amc)
                {
                    $end_date = $amc->end_date;

                    $vid = $amc->vendor_id;
                    $vquery = DB::table('vendor')
                                ->select('*')
                                ->where('id','=',$vid)
                                ->where('deleted_at','=','N')
                                ->first();

                    if($vquery){
                        $vcname = $vquery->name.(!empty($vquery->company_name)?' / '.$vquery->company_name:'');
                        $vpname = $amc->product_name;
                        $exp_days = $amc->exp_days;
                    
                        $i++;
                        $array[$i]['cname'] = $vcname;
                        $array[$i]['pname'] = $vpname;
                        $array[$i]['exp_days'] = $exp_days;
                        $array[$i]['id'] = $amc->id;				
                        }
                }
                //amc end

                //registration start
                $regs = DB::table('vendor')->where('deleted_at','=','N')->where('ctype','=','Mobile')->where('created_at','>=',date('Y-m-d', strtotime('-7 days')))->where('status','=','In Active')->get();
                    
                $ttdate = Carbon::now()->format('Y-m-d');
                
                $t = 0;
                $ab = array();
            
                foreach($regs as $reg)
                {			
                        $t++;				
                        $ab[$t]['name']= $reg->name;
                        $ab[$t]['email']= $reg->email;
                        $ab[$t]['mobile_no']= $reg->mobile_no;
                        $ab[$t]['landline_no']= $reg->landline_no;
                        $ab[$t]['id']= $reg->id;
                        $ab[$t]['status']= $reg->status;
                    
                }
                //registration end
                
                return view('report.inventory_reconciliation',['total_client'=>$total_client,'total_technician'=>$total_technician,'pending_service'=>$pending_service,'completed_service'=>$completed_service,'total_service'=>$total_service,'total_amc'=>$total_amc,'total_bad_rating'=>$total_bad_rating,'total_good_rating'=>$total_good_rating,'p1'=>$p1,'p2'=>$p2,'p3'=>$p3,'p4'=>$p4,'p5'=>$p5,'p6'=>$p6,'p7'=>$p7,'p'=>$p,'a1'=>$a1,'a2'=>$a2,'a3'=>$a3,'a4'=>$a4,'a5'=>$a5,'a6'=>$a6,'a7'=>$a7,'a8'=>$a8,'a9'=>$a9,'a10'=>$a10,'a11'=>$a11,'a12'=>$a12,'a13'=>$a13,'a14'=>$a14,'a15'=>$a15,'a16'=>$a16,'b1'=>$b1,'b2'=>$b2,'b3'=>$b3,'b4'=>$b4,'b5'=>$b5,'b6'=>$b6,'b7'=>$b7,'b8'=>$b8,'b9'=>$b9,'b10'=>$b10,'b11'=>$b11,'b12'=>$b12,'b13'=>$b13,'b14'=>$b14,'b15'=>$b15,'b16'=>$b16,'statuses'=>$statuses])->withRes($res)->withRes1($res1)->withRes2($res2)->withRes3($res3)->withRes4($res4)->withRes5($res5)->withRes6($res6)->withRes7($res7)->withArray($array)->withAb($ab);
        }else{


            $statuses = DB::table('statuses')
                        ->where('STATUS' ,'1')
                        ->get();

            $today_start_time = Carbon::now()->startOfDay();
            $today_end_time = Carbon::now()->endOfDay();

            // $statuses = DB::table('statuses')->pluck('name', 'id');

            $summary_service = []; // For service_type = 1
            $summary_install = []; // For service_type = 2

            foreach ($statuses as $status_name) {
                // Today's count - Service
                $status_id = $status_name->id;
                $today_service_count = DB::table('shipment as sh')
                    ->join('vendor as v', 'v.id', '=', 'sh.vendor_id')
                    ->where('sh.delivery_status', $status_id)
                    ->where('sh.service_type', '1')
                    ->where('v.deleted_at', 'N')
                    ->whereBetween('sh.order_time', [$today_start_time, $today_end_time])
                    ->count();
                    // ->get();

                // Total count - Service
                $total_service_count = DB::table('shipment as sh')
                    ->join('vendor as v', 'v.id', '=', 'sh.vendor_id')
                    ->where('sh.delivery_status', $status_id)
                    ->where('sh.service_type', '1')
                    ->where('v.deleted_at', 'N')
                    ->count();

                // Today's count - Installation
                $today_install_count = DB::table('shipment as sh')
                    ->join('vendor as v', 'v.id', '=', 'sh.vendor_id')
                    ->where('sh.delivery_status', $status_id)
                    ->where('sh.service_type', '2')
                    ->where('v.deleted_at', 'N')
                    ->whereBetween('sh.order_time', [$today_start_time, $today_end_time])
                    ->count();

                // Total count - Installation
                $total_install_count = DB::table('shipment as sh')
                    ->join('vendor as v', 'v.id', '=', 'sh.vendor_id')
                    ->where('sh.delivery_status', $status_id)
                    ->where('sh.service_type', '2')
                    ->where('v.deleted_at', 'N')
                    ->count();

                $summary_service[] = [
                    'status' => $status_name,
                    'today' => $today_service_count,
                    'total' => $total_service_count,
                ];

                $summary_install[] = [
                    'status' => $status_name,
                    'today' => $today_install_count,
                    'total' => $total_install_count,
                ];
            }
    
            $amcs =  DB::table('amcs as a')
            ->leftJoin('products as p','p.id','=','a.product_id')
            ->select('a.*','p.product_name',DB::raw('DATEDIFF(end_date,NOW()) as exp_days'))
            ->where(function ($query) {
                    $query->whereBetween('a.end_date',[date('Y-m-d') ,date('Y-m-d', strtotime('+15 days')) ])
                        ->orwhereBetween('a.end_date',[date('Y-m-d', strtotime('-30 days')),date('Y-m-d') ]);
                })
            ->get();
            $today = Carbon::now();
            $newDate = substr($today->addDays(15),0,10);
            $i = 0;
            $array = array();

            foreach($amcs as $amc)
            {
                $end_date = $amc->end_date;

                $vid = $amc->vendor_id;
                $vquery = DB::table('vendor')
                            ->select('*')
                            ->where('id','=',$vid)
                            ->where('deleted_at','=','N')
                            ->first();

                if($vquery){
                    $vcname = $vquery->name.(!empty($vquery->company_name)?' / '.$vquery->company_name:'');
                    $vpname = $amc->product_name;
                    $exp_days = $amc->exp_days;
                
                    $i++;
                    $array[$i]['cname'] = $vcname;
                    $array[$i]['pname'] = $vpname;
                    $array[$i]['exp_days'] = $exp_days;
                    $array[$i]['id'] = $amc->id;				
                    }
            }
            //amc end

            //registration start
            $regs = DB::table('vendor')->where('deleted_at','=','N')->where('ctype','=','Mobile')->where('created_at','>=',date('Y-m-d', strtotime('-7 days')))->where('status','=','In Active')->get();
                
            $ttdate = Carbon::now()->format('Y-m-d');
            
            $t = 0;
            $ab = array();
        
            foreach($regs as $reg)
            {			
                    $t++;				
                    $ab[$t]['name']= $reg->name;
                    $ab[$t]['email']= $reg->email;
                    $ab[$t]['mobile_no']= $reg->mobile_no;
                    $ab[$t]['landline_no']= $reg->landline_no;
                    $ab[$t]['id']= $reg->id;
                    $ab[$t]['status']= $reg->status;
                
            }
            //registration end
            
            return view('report.inventory_reconciliation',['total_client'=>$total_client,'total_technician'=>$total_technician,'pending_service'=>$pending_service,'completed_service'=>$completed_service,'total_service'=>$total_service,'total_amc'=>$total_amc,'total_bad_rating'=>$total_bad_rating,'total_good_rating'=>$total_good_rating,'p1'=>$p1,'p2'=>$p2,'p3'=>$p3,'p4'=>$p4,'p5'=>$p5,'p6'=>$p6,'p7'=>$p7,'p'=>$p, 'summary_install' => $summary_install, 'summary_service'=>$summary_service,'statuses'=>$statuses])->withRes($res)->withRes1($res1)->withRes2($res2)->withRes3($res3)->withRes4($res4)->withRes5($res5)->withRes6($res6)->withRes7($res7)->withArray($array)->withAb($ab);		
        }
        
    }

	public function error()
	{
		$error_message = "You are not authorised person to access this page.";
		return view('home')->withErrorMessage($error_message);
	}

	public function resetPassword(Request $request) {
        if($request->all()){
            $input = $request->all();
            $password = bcrypt($input['password']);
            $a = User::where('id', $request->user()->id)->update(['password' => $password]);
            $request->session()->flash('success', 'Your password has been changed successfully.');
            return redirect("/manageadmin");
        } else {
            return redirect("/manageadmin");
        }
    }

    // Added a function by gaurav on 26-feb-2020 for resetting password of a client...
    public function clientresetPassword(Request $request) {
        //taking session id of particular user and then storing it in a particular variables
        $value = $request->session()->all();
        $id = $value['custid'];
    
        if($request->all()){
            $input = $request->all();
            $password = bcrypt($input['password']);
            DB::table('vendor')->where('id', $id)->update(['password' => $password]);
            // $a = Vendor::where('email', $input['id'])->update(['password' => $password]);
            $request->session()->flash('success', 'Your password has been changed successfully.');
            return redirect("service/create");
        } else {
            return redirect("service/create");
        }
    }// Comment section End

}
