<?php
namespace App\Http\Controllers\Delivery;

use App\Http\Requests;
use Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\StatusHistory;
use App\Bikers;
use App\BikerLocation;
use App\Substation;
use Mail;
use Excel;
use App\VendorShipment;
use Config;
use PDF;

class ManageDeliveryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
     // $a = Input::get('new_filter_status');
     // print_r($a);
        $substation_id = "";
        $user_id = Auth::user()->id;
        $urid = Auth::user()->role_id;
        $date = new DateTime();
        $date->sub(new DateInterval('P1D'));
        $yesterday_date = $date->format('Y-m-d 00:00:00');
        $today_end_time = new DateTime('NOW');

        $substation_query = Substation::select('id','name');
                    if(Session::get('sub_station_id')) {
                      $substation_query->where('id','<>',Session::get('sub_station_id'));
                    }
        $substations = $substation_query->get();

        // $sub = Substation::all();
        // dd($sub);

        if(!empty(Session::get('sub_station_id'))) {
          $substation_id = Session::get('sub_station_id');
        } else if(!empty(Input::get('substation_id'))) {
          $substation_id = Input::get('substation_id');
        } else {
          //$substation_id = $substations{0}->id;
        }
        // $role = DB::table('users as u')
        //       ->join('roles as r','r.id','=','u.role_id')
        //       ->select('r.role_title')
        //       ->where('u.id','=',$user_id)
        //       ->whereNull('deleted_at')
        //       ->first();

        // ->join('address as pa','pa.id','=','sh.pickup_address_id')
        // ->join('address as da','da.id','=','sh.drop_address_id')
        
          $query = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
           ->leftJoin('amcs as amc','amc.vendor_id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','sh.service_type','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.name','v.deleted_at','biker.deleted_at','amc.end_date','amc.product_id','amc.vendor_id');
          $query_forcount = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.delivery_status');


                /*  added on 6-12-2019 by brijesh for filtering data on click particular data*/
        if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('biker_id')) || !empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')) || !empty(Input::get('vendor_id')) || !empty(Input::get('filter_on_click')))
          /*if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('biker_id')) || !empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')) || !empty(Input::get('vendor_id')))*/
      {  
                          
        if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) 
        {
          $start_date = Input::get('start_date');
          $end_date = Input::get('end_date');
          $start_time = '00:00:00';
          $end_time = '23:59:59';
                              /*if(!empty(Input::get('start_time'))) {
                                $start_time = Input::get('start_time');
                                $start_time = $start_time.":00";
                              }
                              if(!empty(Input::get('end_time'))) {
                                $end_time = Input::get('end_time');
                                $end_time = $end_time.":00";
                              }*/
          $date = new DateTime($start_date);
          $start_date = $date->format('Y-m-d '.$start_time);
          $date = new DateTime($end_date);
          $end_date = $date->format('Y-m-d '.$end_time);
          $query->whereBetween('sh.order_time', array($start_date,$end_date));
          $query_forcount->whereBetween('sh.order_time', array($start_date,$end_date));
        }
        if(!empty(Input::get('biker_id'))) 
        {
            $biker_id = Input::get('biker_id');
            $query->where('sh.biker_id','=',$biker_id); 
            $query_forcount->where('sh.biker_id','=',$biker_id);              
        }
        if(!empty(Input::get('vendor_id'))) 
        {
            $vendor_id = Input::get('vendor_id');
            $query->where('sh.vendor_id','=',$vendor_id);  
            $query_forcount->where('sh.vendor_id','=',$vendor_id);             
        }
        if(!empty(Input::get('service_type'))) 
        {
            $service_type = Input::get('service_type');
            $query->where('sh.service_type','=',$service_type); 
            $query_forcount->where('sh.service_type','=',$service_type);               
        }
        if(!empty(Input::get('filter_shipment'))) {
            $shipment_id = Input::get('filter_shipment');
            $query->where('sh.awb_no','=',$shipment_id);               
        }

         //added on 6-12-2019 by brijesh for filtering data on click particular data

        if(!empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')) || !empty(Input::get('filter_on_click'))) 
        // if(!empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status'))  ) 
        {              
          if(!empty(Input::get('filter_status'))) 
          {
            $advance_filter_values = Input::get('filter_status');
            $status_output = $this->getStatus($advance_filter_values);
            $status_output = call_user_func_array('array_merge', $status_output);
            $query->whereIn('sh.delivery_status',$status_output);
            $query_forcount->whereIn('sh.delivery_status',$status_output); 
          }


          if(!empty(Input::get('new_filter_status')))
          {
            $advance_filter_values1 = Input::get('new_filter_status');
            $advance_filter_values = explode(",", $advance_filter_values1);
           //print_r($advance_filter_values);
            $status_output = $this->getStatus($advance_filter_values);
           //print_r($status_output);
            $status_output = call_user_func_array('array_merge', $status_output);
            $query->whereIn('sh.delivery_status',$status_output);
            $query_forcount->whereIn('sh.delivery_status',$status_output); 
          }  

          /* this added for filtering data click on particular data on 6-12-2019*/
          if(!empty(Input::get('filter_on_click'))) 
          {
           /* echo Input::get('filter_on_click');die();*/
            $advance_filter_values = array(Input::get('filter_on_click'));
            $status_output = $this->getStatus($advance_filter_values);
            $status_output = call_user_func_array('array_merge', $status_output);
            $query->whereIn('sh.delivery_status',$status_output);
            /*$query_forcount->whereIn('sh.delivery_status',$status_output); */
          }  
        }        
      } 
      else 
      {
                
        $start_time = '00:00:00';
        $date = new DateTime();
        $today_start_time = $date->format('Y-m-d '.$start_time);
        //$query->where('sh.delivery_status','=','New');  
        $query->where('v.deleted_at','=','N');  
        $query->where('biker.deleted_at','=',NULL);  
        $query->whereBetween('sh.order_time',array($today_start_time,$today_end_time));  

        $query_forcount->where('v.deleted_at','=','N');  
        $query_forcount->where('biker.deleted_at','=',NULL);  
        $query_forcount->whereBetween('sh.order_time',array($today_start_time,$today_end_time));  
        
      }
                      // $query->where('sh.sub_station_id','=',$substation_id);
            //dd($query->toSql());                      
      //$query->orderBy('sh.delivery_status','DESC');
      $query->orderBy('sh.id','DESC');

      if((isset($_GET['_token']) && $_GET['_token']!='') || (isset($_GET['is_filter'])))
      {
        
        $deliveries = $query->paginate(10);
        $deliveries_count = $query_forcount->get();
          //print_r($deliveries_count); die();

        //$deliveries = $query->get();
        // $deliveries = $query->toSql();
        // dd($deliveries);die;
      }
      else
      {
        //$deliveries = $query->paginate(10);
        $deliveries = $query->get();
          //print_r($deliveries); die();
      }
      


     
         // $deliveries = $query->get();
    //dd($query->toSql());
    //exit();
          // $deliveriesGrouped = array('Order Received' => [], 'Order Assigned_Cancel'=>[],'Order assigned_Pickup cancel'=>[],'Assigned' => [],'Order Assigned' => [],'Order Assigned not ready' =>[],'Order Reassigned_1' => [],'Order Reassigned_2' =>[],'At_SubStation' => [],'At_Substation_Reattempt1' =>[],'At_Substation_Reattempt2' =>[],'At_substation_rtn'=>[],'At_Substation_rtn_Reattempt1'=>[],'At_Substation_rtn_Reattempt2'=>[],' Order picked_in transit'=>[],'Order picked_weight changed'=>[],'In Transit' => [],'In transit' => [],'In transit_address changed'=>[],' In transit_Business_or_house closed'=>[],'In transit_COD amount not ready'=>[],'In transit_Customer Refused_or_Rejected'=>[],' In transit_undelivered'=>[],' In transit_Reattempt1'=>[],'In transit_Reattempt2'=>[],'In transit_delay out of our control'=>[],'In Transit_Out for Delivery'=>[],'In Transit_Out for Delivery1'=>[],' In Transit_Out for Delivery2'=>[],'In transit_Shipment Lost'=>[],'RTN Order picked_in transit'=>[],'RTN Order picked_weight changed'=>[],'RTN In transit'=>[],'RTN In transit_address changed'=>[],'RTN In transit_Business_or_house closed'=>[],'RTN In transit_COD amount not ready'=>[],'RTN In transit_Customer Refused_or_Rejected'=>[],'RTN In transit_undelivered'=>[],'RTN In transit_Reattempt1'=>[],'RTN In transit_Reattempt2'=>[],'RTN In transit_delay out of our control'=>[],'RTN In Transit_Out for Delivery'=>[],'RTN In Transit_Out for Delivery1'=>[],'RTN In Transit_Out for Delivery2'=>[],'RTN In transit_Shipment Lost'=>[],'Returned'=>[],'Delivered'=>[],'Delivered_Cash collected'=>[],'Delivered_card on delivery'=>[],'Delivered_Open box'=>[],'RTN Delivered'=>[]);

          // foreach ($data as $key => $delivery) {
          //       //$status = $this->getStatusHead($delivery->delivery_status);
          //       $deliveriesGrouped[$delivery->delivery_status][] = $delivery;
          // }
          //var_dump($deliveriesGrouped);
          //exit;
          // $deliveries = []; 
          // foreach ($deliveriesGrouped as $status => $dels) {
          //   if($dels) {
          //         $desiredTypeOrder = array('next_day_delivery' => 3, 'same_day_delivery' => 2, '4_hours_delivery' => 1);
          //         usort($dels, function($a, $b) use ($desiredTypeOrder) {
          //           return $desiredTypeOrder[$a->type] > $desiredTypeOrder[$b->type] ? 1 : -1;
          //       });
          //   }
          //      $deliveries = array_merge($deliveries, $dels);
          // }
          
      $pastorders_query = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
           ->leftJoin('amcs as amc','amc.vendor_id','=','v.id')

                  ->select('sh.*','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.name','v.deleted_at','biker.deleted_at','amc.end_date');
          
          if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('biker_id')) || !empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')))
                      {
                          if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                              $start_date = Input::get('start_date');
                              $end_date = Input::get('end_date');
                              $start_time = '00:00:00';
                              $end_time = '23:59:59';
                              /*if(!empty(Input::get('start_time'))) {
                                $start_time = Input::get('start_time');
                                $start_time = $start_time.":00";
                              }
                              if(!empty(Input::get('end_time'))) {
                                $end_time = Input::get('end_time');
                                $end_time = $end_time.":00";
                              }*/
                              $date = new DateTime($start_date);
                              $start_date = $date->format('Y-m-d '.$start_time);
                              $date = new DateTime($end_date);
                              $end_date = $date->format('Y-m-d '.$end_time);
                              $pastorders_query->whereNotBetween('sh.order_time', array($start_date,$end_date));
                          }
                          if(!empty(Input::get('biker_id'))) {
                              $biker_id = Input::get('biker_id');
                              $pastorders_query->where('sh.biker_id','=',$biker_id);               
                          }
              if(!empty(Input::get('vendor_id'))) {
                              $vendor_id = Input::get('vendor_id');
                              $pastorders_query->where('sh.vendor_id','=',$vendor_id);               
                          }
               if(!empty(Input::get('service_type'))) {
                              $service_type = Input::get('service_type');
                              $pastorders_query->where('sh.service_type','=',$service_type);               
                          }
                          /*if(!empty(Input::get('filter_shipment'))) {
                              $shipment_id = Input::get('filter_shipment');
                              $pastorders_query->where('sh.awb_no','!=',$shipment_id);               
                          }*/

                if(!empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')) )          
                {
                            if(!empty(Input::get('filter_status'))) {
                            $advance_filter_values = Input::get('filter_status');
                            $status_output = $this->getStatus($advance_filter_values);
                            $status_output = call_user_func_array('array_merge', $status_output);
                            $pastorders_query->whereIn('sh.delivery_status',$status_output);
                          } 


                          if(!empty(Input::get('new_filter_status'))) {
                            $advance_filter_values1 = Input::get('new_filter_status');
                            $advance_filter_values = explode(",", $advance_filter_values1);
                         // print_r($advance_filter_values);
                            $status_output = $this->getStatus($advance_filter_values);
                        //  print_r($status_output);
                            $status_output = call_user_func_array('array_merge', $status_output); 
                            $pastorders_query->whereIn('sh.delivery_status',$status_output);

                          }  
                }          
                          // if(!empty(Input::get('filter_status'))) {
                          //     $status = Input::get('filter_status');    
                          //     $query->whereIn('sh.delivery_status',$status);
                          // } 
                      } else {
                          $start_time = '00:00:00';
                          $date = new DateTime();
                          $today_start_time = $date->format('Y-m-d '.$start_time);
                          $pastorders_query->where('v.deleted_at','=','N');  
                          $pastorders_query->where('biker.deleted_at','=',NULL);  
                           $pastorders_query->where('sh.order_time','<',$date);  
                          $pastorders_query->whereNotBetween('sh.order_time',array($today_start_time,$today_end_time));  

                      }
              //$pastorders_query->orderBy('sh.delivery_status','DESC');
          $pastorders_query->orderBy('sh.id','DESC'); 
          $pastorders = $pastorders_query->paginate(10);
           // $pastorders = $pastorders_query->get();
          //dd($pastorders_query->toSql());
                 
/*$test = DB::table('shipment')
                    ->select('delivery_status')
                    ->where('delivery_status','=','work pending') ;
  $s = $test->paginate(200);*/
          /* $pastorders_query =  DB::table('shipment as sh')
                   ->join('address as pa','pa.id','=','sh.pickup_address_id')
                   ->join('address as da','da.id','=','sh.drop_address_id')
                   ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->select('sh.id','sh.awb_no','sh.type','sh.delivery_status','sh.delivery_type','sh.distance','sh.pickup_date','biker.id as biker_id','biker.first_name','biker.last_name','pa.latitude as pick_latitude','pa.longitude as pick_longitude','pa.landmark as pick_landmark','da.latitude as drop_latitude','da.longitude as drop_longitude','da.landmark as drop_landmark')
                   ->where('sh.delivery_status','=','At Sub Station')
                   ->where('sh.sub_station_id','=',$substation_id)
                   ->orderBy('sh.order_time','DESC');  
           $pastorders = $pastorders_query->get();
          dd($pastorders_query->toSql());*/
      

   
               // added by brijesh on 17-03-2019

                  $futureorders_query = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
           /* added on 12-12-2019*/
           ->leftJoin('amcs as amc','amc.vendor_id','=','v.id')
           ->leftJoin('amcs as amcs','amcs.product_id','=','sh.product_id')
                  ->select('sh.*','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.name','v.deleted_at','biker.deleted_at','amc.end_date');
          
          if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('biker_id')) || !empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')))
                      {
                          if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                              $start_date = Input::get('start_date');
                              $end_date = Input::get('end_date');
                              $start_time = '00:00:00';
                              $end_time = '23:59:59';
                              $date = new DateTime();
                              /*if(!empty(Input::get('start_time'))) {
                                $start_time = Input::get('start_time');
                                $start_time = $start_time.":00";
                              }
                              if(!empty(Input::get('end_time'))) {
                                $end_time = Input::get('end_time');
                                $end_time = $end_time.":00";
                              }*/
                              $date = new DateTime($start_date);
                              $start_date = $date->format('Y-m-d '.$start_time);
                              $date = new DateTime($end_date);
                              $end_date = $date->format('Y-m-d '.$end_time);
                              $futureorders_query->where('sh.order_time', '>',$end_time);
                             // $fetureorders_query->whereNotBetween('sh.order_time', array($start_date,$end_date));
                          }
                          if(!empty(Input::get('biker_id'))) {
                              $biker_id = Input::get('biker_id');
                              $futureorders_query->where('sh.biker_id','=',$biker_id);               
                          }
              if(!empty(Input::get('vendor_id'))) {
                              $vendor_id = Input::get('vendor_id');
                              $futureorders_query->where('sh.vendor_id','=',$vendor_id);               
                          }
               if(!empty(Input::get('service_type'))) {
                        // $service_type = Input::get('service_type');
                        $service_type = Input::get('service_type');
                        $todayDate = date("Y-m-d");
                      // print_r($todayDate); die();
                      if($service_type="AMC Service")
                         {

                          $pastorders_query->where('amc.end_date','>=',$todayDate);

                       }
                         else{
                              $futureorders_query->where('sh.service_type','=',$service_type);               
                          }
                        }
                          /*if(!empty(Input::get('filter_shipment'))) {
                              $shipment_id = Input::get('filter_shipment');
                              $pastorders_query->where('sh.awb_no','!=',$shipment_id);               
                          }*/

                if(!empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')) )          
                {
                            if(!empty(Input::get('filter_status'))) {
                            $advance_filter_values = Input::get('filter_status');
                            $status_output = $this->getStatus($advance_filter_values);
                            $status_output = call_user_func_array('array_merge', $status_output);
                            $futureorders_query->whereIn('sh.delivery_status',$status_output);
                          } 


                          if(!empty(Input::get('new_filter_status'))) {
                            $advance_filter_values1 = Input::get('new_filter_status');
                            $advance_filter_values = explode(",", $advance_filter_values1);
                         // print_r($advance_filter_values);
                            $status_output = $this->getStatus($advance_filter_values);
                        //  print_r($status_output);
                            $status_output = call_user_func_array('array_merge', $status_output); 
                            $futureorders_query->whereIn('sh.delivery_status',$status_output);

                          }  
                }          
                          // if(!empty(Input::get('filter_status'))) {
                          //     $status = Input::get('filter_status');    
                          //     $query->whereIn('sh.delivery_status',$status);
                          // } 
                      } else {
                          $start_time = '00:00:00';
                          $date = new DateTime();
                          $today_start_time = $date->format('Y-m-d '.$start_time);
                          $futureorders_query->where('v.deleted_at','=','N');  
                          $futureorders_query->where('biker.deleted_at','=',NULL);  
                          $futureorders_query->where('sh.order_time', '>',$date);
                          //$pastorders_query->whereNotBetween('sh.order_time',array($today_start_time,$today_end_time));  

                      }
                                if(!empty(Input::get('id_for_status')))
          {

            $vendor_id=Input::get('vendor_id');

             $date = new DateTime();
                          $start_time = '00:00:00';
                           $end_time = '23:59:59';
                           $end_date = $date->format('Y-m-d '.$end_time);
                         
                          $today_start_time = $date->format('Y-m-d '.$start_time);
                          $futureorders_query->where('v.deleted_at','=','N');  
                          $futureorders_query->where('biker.deleted_at','=',NULL); 
                          $futureorders_query->where('v.id', '=',$vendor_id); 
                          // $futureorders_query->where('sh.order_time', '>',$end_date);
                           $futureorders_query->whereBetween('order_time',[date('Y-m-d', strtotime('+1 days')) ,date('Y-m-d', strtotime('+3 days')) ]);

            $id=Input::get('id_for_status');
             $status=Input::get('status');
           // $status=1;

         // print_r($id);die();
            $data=array('future_service_status'=>$status);
            DB::table('future_sevice_notification')->where('id', $id)->update($data);
               
           // echo "hello id".$id; die();

          }
              //$pastorders_query->orderBy('sh.delivery_status','DESC');
          $futureorders_query->orderBy('sh.id','DESC'); 
          $futureorders = $futureorders_query->groupBy('sh.id')->paginate(10);

// end  added by brijesh on 17-03-2019


/*Added by gaurav on 29-feb-2020 for making 'Last 48hrs services' in index.blade.php of manage services*/  
$lastorders_query = DB::table('shipment as sh')          
              ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
              ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
              ->leftJoin('amcs as amc','amc.vendor_id','=','v.id')
              ->leftJoin('amcs as amcs','amcs.product_id','=','sh.product_id')
              ->select('sh.*','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.name','v.deleted_at','biker.deleted_at','amc.end_date');
          
if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('biker_id')) || !empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')))
{
      if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
          $start_date = Input::get('start_date');
          $end_date = Input::get('end_date');
          $start_time = '00:00:00';
          $end_time = '47:59:59';
          /*if(!empty(Input::get('start_time'))) {
            $start_time = Input::get('start_time');
            $start_time = $start_time.":00";
          }
          if(!empty(Input::get('end_time'))) {
            $end_time = Input::get('end_time');
            $end_time = $end_time.":00";
          }*/
          $date = new DateTime($start_date);
          $start_date = $date->format('Y-m-d '.$start_time);
          $date = new DateTime($end_date);
          $end_date = $date->format('Y-m-d '.$end_time);
          $lastorders_query->whereNotBetween('sh.order_time', array($start_date,$end_date));
      }
      if(!empty(Input::get('biker_id'))) {
          $biker_id = Input::get('biker_id');
          $lastorders_query->where('sh.biker_id','=',$biker_id);               
      }
      if(!empty(Input::get('vendor_id'))) {
          $vendor_id = Input::get('vendor_id');
          $lastorders_query->where('sh.vendor_id','=',$vendor_id);               
      }
      if(!empty(Input::get('service_type'))) {

              //$service_type = Input::get('service_type');
          $service_type = Input::get('service_type');
            // print_r($service_type); die();
          $todayDate = date("Y-m-d");
          // print_r($todayDate); die();
          if($service_type="AMC Service"){
            $lastorders_query->where('amc.end_date','>=',$todayDate);
          }
          else{
            $lastorders_query->where('sh.service_type','=',$service_type);               
          }
      }
                          /*if(!empty(Input::get('filter_shipment'))) {
                              $shipment_id = Input::get('filter_shipment');
                              $pastorders_query->where('sh.awb_no','!=',$shipment_id);               
                          }*/

      if(!empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')) )          
      {
          if(!empty(Input::get('filter_status'))) {
            $advance_filter_values = Input::get('filter_status');
            $status_output = $this->getStatus($advance_filter_values);
            $status_output = call_user_func_array('array_merge', $status_output);
            $lastorders_query->whereIn('sh.delivery_status',$status_output);
          } 
          if(!empty(Input::get('new_filter_status'))) {
            $advance_filter_values1 = Input::get('new_filter_status');
            $advance_filter_values = explode(",", $advance_filter_values1);
            // print_r($advance_filter_values);
            $status_output = $this->getStatus($advance_filter_values);
            //  print_r($status_output);
            $status_output = call_user_func_array('array_merge', $status_output); 
            $lastorders_query->whereIn('sh.delivery_status',$status_output);
          }  
      }          
                          // if(!empty(Input::get('filter_status'))) {
                          //     $status = Input::get('filter_status');    
                          //     $query->whereIn('sh.delivery_status',$status);
                          // } 
}
else{
    
    $lastfortyeighthours =  date('Y-m-d H:i:s', strtotime(date("Y-m-d H:i:s") . " -48 hours"));
    $start_time = '00:00:00';
    $date = new DateTime();
    $today_start_time = $date->format('Y-m-d '.$start_time);
    $lastorders_query->where('v.deleted_at','=','N');  
    $lastorders_query->where('biker.deleted_at','=',NULL);  
    //$lastorders_query->where('sh.order_time','<',$date);  
    //$lastorders_query->whereNotBetween('sh.order_time',array($today_start_time,$today_end_time)); 
    $lastorders_query->where('sh.order_time','<=',$lastfortyeighthours);  
    $lastorders_query->whereRaw("sh.delivery_status = 'New' OR sh.delivery_status = 'Work Pending'");  
    

    // $lastorders_query->whereBetween('order_time',[date('Y-m-d', strtotime('todayDate')) ,date('Y-m-d', strtotime('+1 days')) ])->whereNotBetween;

}
              //$pastorders_query->orderBy('sh.delivery_status','DESC');
$lastorders_query->orderBy('sh.id','DESC'); 
// echo date('Y-m-d H:i:s', strtotime(date("Y-m-d H:i:s") . " -48 hours"));
// dd($lastorders_query->toSql());die;
$lastorders = $lastorders_query->groupBy('sh.id')->paginate(10);

/*Ended of making 'Last 48hrs services' sections by gaurav*/


               $query1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
          ->leftjoin('products as p','p.id','=','sh.product_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','sh.service_type','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.name','p.product_name','sh.created_by','sh.created_type','sh.order_time','sh.service_description','sh.mobno','sh.remark','sh.created_at','sh.updated_at');


                  if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('biker_id')) || !empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status')))
                      {
                          if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                              $start_date = Input::get('start_date');
                              $end_date = Input::get('end_date');
                              $start_time = '00:00:00';
                              $end_time = '23:59:59';
                              /*if(!empty(Input::get('start_time'))) {
                                $start_time = Input::get('start_time');
                                $start_time = $start_time.":00";
                              }
                              if(!empty(Input::get('end_time'))) {
                                $end_time = Input::get('end_time');
                                $end_time = $end_time.":00";
                              }*/
                              $date = new DateTime($start_date);
                              $start_date = $date->format('Y-m-d '.$start_time);
                              $date = new DateTime($end_date);
                              $end_date = $date->format('Y-m-d '.$end_time);
                              $query1->whereBetween('sh.order_time', array($start_date,$end_date));
                          }
                          if(!empty(Input::get('biker_id'))) {
                              $biker_id = Input::get('biker_id');
                              $query1->where('sh.biker_id','=',$biker_id);               
                          }
              if(!empty(Input::get('vendor_id'))) {
                              $vendor_id = Input::get('vendor_id');
                              $query1->where('sh.vendor_id','=',$vendor_id);               
                          }
               if(!empty(Input::get('service_type'))) {
                              $service_type = Input::get('service_type');
                              $query1->where('sh.service_type','=',$service_type);               
                          }
                          /*if(!empty(Input::get('filter_shipment'))) {
                              $shipment_id = Input::get('filter_shipment');
                              $query->where('sh.awb_no','=',$shipment_id);               
                          }*/

              if(!empty(Input::get('filter_status')) || !empty(Input::get('new_filter_status'))) 
              {
                      $a =Input::get('filter_status'); $b =Input::get('new_filter_status');
                      //print_r($a);
                      //print_r($b);
                if(!empty(Input::get('filter_status')))
                {
                    $advance_filter_values = Input::get('filter_status');
                    $status_output = $this->getStatus($advance_filter_values);
                    //print_r($status_output); 
                }

              else  if(!empty(Input::get('new_filter_status')))
                { 
                    $advance_filter_values1 = Input::get('new_filter_status');
                    $advance_filter_values=explode(",",$advance_filter_values1);
                //  print_r($advance_filter_values);
                    $status_output = $this->getStatus($advance_filter_values);
                // print_r($status_output); 
                 
                }

                  $status_output = call_user_func_array('array_merge', $status_output);
                  $query1->whereIn('sh.delivery_status',$status_output);
                    //  print_r($status_output);
                    //exit();
              } 
                          if(!empty(Input::get('checked_id'))) {
                              $checked_id = Input::get('checked_id');
                              $query->where('sh.id','=',$checked_id);  
                              $query->where('sh.delivery_status', '=', 'Work Pending');
                              $query_forcount->where('sh.id','=',$checked_id);             
                          }
                          // if(!empty(Input::get('filter_status'))) {
                          //     $status = Input::get('filter_status');    
                          //     $query->whereIn('sh.delivery_status',$status);
                          // } 
                      } 

                      /*else {
                
                          $start_time = '00:00:00';
                          $date = new DateTime();
                          $today_start_time = $date->format('Y-m-d '.$start_time);
                //$query->where('sh.delivery_status','=','New');  
                          $query1->where('v.deleted_at','=',NULL);  
              $query1->where('biker.deleted_at','=',NULL);  
              $query1->whereBetween('sh.order_time',array($today_start_time,$today_end_time));    
              
                      }*/
          
              
      $query1->orderBy('sh.id','DESC');

          $deliveries1 = $query1->get();
    //dd($query1->toSql());
    //exit();
    //export start
     if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','SERVICES REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Client Name','Company Name', 'Technician Name','Product', 'Service Status','Type','Description','Mobile No','Created By','Complain Operator','Remark','Start Date','Closed Date'));
       foreach ($deliveries1 as $line) { 
       $date = new DateTime($line->order_time);
       $date_s = new DateTime($line->created_at);
       $date_e = new DateTime($line->updated_at);
                $data = array(
                  'name' => $line->name,
                    'company_name' => $line->company_name,
                    'tname' =>  ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
          'product' => $line->product_name,
                    'service_status' => $line->delivery_status,
                    'type' => $line->service_type,
          'description' => $line->service_description,
          'mobile_no' => $line->mobno,
          'created_by' => $line->created_by,
          'complain_operator' => $line->created_type,
          'remark' => $line->remark,
          //'date' => $date->format('d-m-Y'),
          'start_date' => $date_s->format('d-m-Y'),
          'closed_date' => ($line->delivery_status=='Closed' || $line->delivery_status=='Completed') ? $date_e->format('d-m-Y') : '',
          
                );

                $line = (array) $data;
                $csv->insertOne($line);
        
            }
      //print_r($line);
            $csv->output('services_report.csv');
            return;
    }
    //end start

          $bikers = DB::table('bikers as b')
                  ->select('*')
                  ->where('b.status','=','Active')
          ->where('b.profile_status','=','Available')
                  ->whereNull('b.deleted_at')
          ->orderBy('b.first_name','ASC')
                  ->get();
          
              $vendors = DB::table('vendor as v')
                  ->select('*')
                  ->where('v.deleted_at','=','N')
          ->orderBy('v.company_name','ASC')
                  ->get();
              
    //gajendra
            $c_id = DB::table('shipment as sh')
                    ->select('*')
                    ->where('sh.delivery_status', '=', 'Work Pending')
                    ->get();

          // $biker_location_query = DB::table('biker_location as t1')
          //                   ->select('*','b.first_name','b.last_name','b.type')
          //                   ->join('bikers as b','b.id','=','t1.biker_id')
          //                   ->Join(DB::raw('(SELECT biker_id, MAX(date_time) AS date_time FROM biker_location GROUP BY biker_id) t2'), function ($join) {
          //                         $join->on ( 't1.biker_id', '=', 't2.biker_id' )->on ( 't1.date_time', '=', 't2.date_time' );
          //                     })      
          //                   ->where('b.profile_status','=','Available')
          //                   ->where('b.substation_id','=',$substation_id)
          //                   ->whereNull('deleted_at')
          //                   ->whereNull('leaving_date');
          // $biker_location = $biker_location_query->get();


          // $biker_lat = "";
          // $biker_log = "";
          // $biker_time = "";
          // $bikers = array();
          // foreach ($biker_records as $key => $biker_record) {
          //   if($biker_location) {
          //       foreach ($biker_location as $key => $location) {
          //         if($biker_record->id == $location->biker_id) {
          //           $biker_lat = $location->latitude;
          //           $biker_log = $location->longitude;
          //           $biker_time = $location->date_time;
          //           break;
          //         } else {
          //           $biker_lat = "";
          //           $biker_log = "";
          //           $biker_time = "";
          //         }
          //       }
          //   } else {
          //           $biker_lat = "";
          //           $biker_log = "";
          //           $biker_time = "";
          //   }
          //     $bikers[$biker_record->id] = array(
          //       'id' => $biker_record->id,
          //       'first_name' =>$biker_record->first_name,
          //       'last_name' => $biker_record->last_name,
          //       'type' => $biker_record->type,
          //       'weight' => $biker_record->total_weight,
          //       'latitude' => $biker_lat,
          //       'longitude' => $biker_log,
          //       'date_time' => $biker_time
          //       );
                  
          //   } 

          if((isset($_GET['_token']) && $_GET['_token']!='') || (isset($_GET['is_filter'])))
          { 
            $main_status_cnt = array();
            if($deliveries_count)
            {
              foreach($deliveries_count as $rowc)
              {
                $main_status_cnt[$rowc->delivery_status][] = $rowc->delivery_status;
              }
            } 
                   $new_service = isset($main_status_cnt['New']) ? count($main_status_cnt['New']) : 0;
                   $progress_service = isset($main_status_cnt['In Progress']) ? count($main_status_cnt['In Progress']) : 0;
                   $awaiting_service = isset($main_status_cnt['Awaiting Spares']) ? count($main_status_cnt['Awaiting Spares']) : 0;
                   $work_pending = isset($main_status_cnt['Work Pending']) ? count($main_status_cnt['Work Pending']) : 0;
                   $client_side = isset($main_status_cnt['Client Side']) ? count($main_status_cnt['Client Side']) : 0;
                   $completed = isset($main_status_cnt['Completed']) ? count($main_status_cnt['Completed']) : 0;
                   $closed = isset($main_status_cnt['Closed']) ? count($main_status_cnt['Closed']) : 0;
                   $cancelled = isset($main_status_cnt['Cancelled']) ? count($main_status_cnt['Cancelled']) : 0;
                   
            }
            else
            {
              $new_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','New')
                   ->get();
                   $new_service = count($new_s);
                  $pro_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','In Progress')
                   ->get();
                  $progress_service = count($pro_s);
                  $aw_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','Awaiting Spares')
                   ->get();
                  $awaiting_service = count($aw_s);

                  $wr_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','Work Pending') 
                   ->get();
                   $work_pending = count($wr_s);

                  $cl_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','Client Side')
                   ->get();
                  $client_side = count($cl_s);

                  $cm_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','Completed')
                   ->get();
                  $completed = count($cm_s);
                   $c_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','Closed')
                   ->get();
                  $closed = count($c_s);
                   $cn_s = DB::table('shipment')
                   ->select('*')
                   ->where('delivery_status','=','Cancelled')
                   ->get();
                  $cancelled = count($cn_s);
            }
           //$gs  = ['New','In Progress','Awaiting Spares','Work Pending','Client Side','Completed','Closed','Cancelled']; 
          $status_filters = ['New','In Progress','Awaiting Spares','Work Pending','Client Side','Completed','Closed','Cancelled'];  
          
          $statuses = ['New','In Progress','Awaiting Spares','Work Pending','Client Side','Completed','Closed','Cancelled'];  
          //$new_filter_status = ['New','In Progress','Awaiting Spares','Work Pending','Client Side','Completed','Closed','Cancelled'];    
        return view('delivery.index',['new_service'=>$new_service,'progress_service' =>$progress_service,
                                      'awaiting_service' =>$awaiting_service,'work_pending'=>$work_pending,
                                      'client_side'=>$client_side,'completed'=>$completed,'closed'=>$closed,
                                      'cancelled'=>$cancelled, 
                                      'rid'=>$urid])->withDeliveries($deliveries)->withPastorders($pastorders)->withFutureorders($futureorders)->withLastorders($lastorders)->withBikers($bikers)->withVendors($vendors)->withSubstations($substations)->withStatuses($statuses)->withStatusFilters($status_filters);     
    }

    public function getStatus($advance_filter_values) {

      // if($status == 'Order Received') {
      //   return 'Order Received';
      // }

      // if($status == 'Assigned' || $status == 'Order Assigned' || $status == 'Order Assigned Cancel' || $status == 'Order Assigned not ready' || $status == 'Order Reassigned_1' || $status == 'Order Reassigned_2') {
      //   return 'Assigned';
      // }

      // if($status == 'At Sub Station' || $status == 'At_substation' || $status == 'At_Substation') {
      //   return 'At Sub Station';
      // }

      // if($status == 'In Transit' || $status == 'Order Picked - In Transit' || $status == 'In_transit' || $status == 'In Transit_Undelivered' || $status == 'In Transit_Reattempt1' || $status == 'In Transit_Reattempt2') {
      //   return 'In Transit';
      // }

      // if($status == 'Delivered') {
      //   return 'Delivered';
      // }

      // if($status == 'Returned' || $status == 'Return Order Reassign' || $status == 'At Substation Return' || $status == 'Return order In Transit' || $status == 'Return Order Out for Delivery' || $status == 'Return Address Correction' || $status == 'Return Order Delivered') {
      //   return 'Returned';
      // }

      // if($status == 'Out for Delivery' || $status == 'Address Correction' || $status == 'out for Delivery' || $status == 'House_or_Business Closed' || $status == 'Out for Delivery_Reattempt1' || $status == 'Out for Delivery_Reattempt2' || $status == 'Order Rejected_or_Refused') {
      //   return 'Other';
      // }

      $filter_status = array();
      //($advance_filter_values);
      //exit();
      foreach ($advance_filter_values as $key => $status) {
      
          if($status == 'New') {
            $filter_status[] = ['New','Order Received'];      
          }

          if($status == 'Cancelled') {
            $filter_status[] = ['Cancelled'];      
          }

          if($status == 'Assigned') {
            $filter_status[] = ['Order Assigned','Order Assigned not ready','Order Reassigned_1','Order Reassigned_2'];      
          }
         
          if($status == 'At Sub Station') {
            $filter_status[] = ['At Sub Station','At_substation','At_Substation_Reattempt1','At_Substation_Reattempt2'];
          }

          if($status == 'At Substation RTN') {
            $filter_status[] = ['At_substation_rtn','At_Substation_rtn_Reattempt1','At_Substation_rtn_Reattempt2'];
          }

          if($status == 'In Transit') {
            $filter_status[] = ['Order picked_in transit','Order picked_weight changed
','In transit','In transit_address changed','In transit_Business_or_house closed','In transit_COD amount not ready','In transit_Customer Refused_or_Rejected',' In transit_undelivered','In transit_Reattempt1',' In transit_Reattempt2','In transit_delay out of our control',' In Transit_Out for Delivery','In Transit_Out for Delivery1',' In Transit_Out for Delivery2',' In transit_Shipment Lost'];
          }

          if($status == 'Return In Transit') {
            $filter_status[] =['RTN Order picked_in transit','RTN Order picked_weight changed','RTN In transit','RTN In transit_address changed',' RTN In transit_Business_or_house closed','RTN In transit_COD amount not ready','RTN In transit_Customer Refused_or_Rejected','RTN In transit_undelivered','RTN In transit_Reattempt1','RTN In transit_Reattempt2','RTN In transit_delay out of our control','RTN In Transit_Out for Delivery','RTN In Transit_Out for Delivery1','RTN In Transit_Out for Delivery2','RTN In transit_Shipment Lost'];
          }
      
      if($status == 'In Progress') {
            $filter_status[] =['Order Assigned not ready','At Sub Station','At_substation','At_Substation_Reattempt1','At_Substation_Reattempt2','At_substation_rtn','At_Substation_rtn_Reattempt1','At_Substation_rtn_Reattempt2','Order picked_in transit','Order picked_weight changed',
            'In transit','In transit_address changed','In transit_Business_or_house closed','In transit_COD amount not ready','In transit_Customer Refused_or_Rejected',' In transit_undelivered','In transit_Reattempt1',' In transit_Reattempt2','In transit_delay out of our control',' In Transit_Out for Delivery','In Transit_Out for Delivery1',' In Transit_Out for Delivery2',' In transit_Shipment Lost','RTN Order picked_in transit','RTN Order picked_weight changed','RTN In transit','RTN In transit_address changed',' RTN In transit_Business_or_house closed','RTN In transit_COD amount not ready','RTN In transit_Customer Refused_or_Rejected','RTN In transit_undelivered','RTN In transit_Reattempt1','RTN In transit_Reattempt2','RTN In transit_delay out of our control','RTN In Transit_Out for Delivery','RTN In Transit_Out for Delivery1','RTN In Transit_Out for Delivery2','RTN In transit_Shipment Lost','In Progress'];
          }

          if($status == 'Completed') {
            $filter_status[] = ['Delivered','Delivered_Cash collected','Delivered_card on delivery','Delivered_Open box','RTN Delivered','Completed'];      
          }
      
       if($status == 'Closed') {
            $filter_status[] = ['Closed'];      
          }
      
         if($status == 'Client Side') {
            $filter_status[] = ['Client Side'];      
          }
      
       if($status == 'Awaiting Spares') {
            $filter_status[] = ['Awaiting Spares'];      
          }
      
       if($status == 'Work Pending') {
            $filter_status[] = ['Work Pending'];      
          }
          
      }
       return $filter_status;
    }

    public function deliverydetails()
    {
        if (Request::ajax())
        {
            $awb_no = Request::all();
            $delivery_details = DB::table('shipment as sh')
                ->leftjoin('vendor as v','v.id','=','sh.vendor_id')
                ->leftjoin('products as p','p.id','=','sh.product_id')
                ->leftjoin('amcs as a','a.vendor_id','=','sh.vendor_id')
                ->leftjoin('bikers as biker','biker.id','=','sh.biker_id')
                ->select('sh.id','sh.delivery_status','biker.mobile','biker.first_name as biker_firstname','biker.last_name as biker_lastname','v.name as vendor_name','v.mobile_no','v.primary_address','v.landmark','v.city','v.state','v.pin_code','sh.receiver_sign','sh.service_description','p.product_name','v.company_name','sh.service_action','sh.instructions','a.end_date','a.atype','sh.created_type','sh.service_type','sh.remark','sh.sign_date','sh.created_by','sh.vendor_id','sh.priority','sh.created_at','sh.order_time as order_time ','sh.mobno','biker_id','sh.awb_no')
                ->where('sh.awb_no', '=',$awb_no)
                ->orWhere('a.vendor_id','=','sh.vendor_id')
                ->first();

             // $delivery_details->remark= base64_decode($delivery_details->remark);
              
                        //->where('sh.vendor_id', '=','a.vendor_id')
            // $substations = Substation::all();
            // foreach ($substations as $key => $substation) {
            //   $substation_array = array_map('trim', explode(',', $substation->substation_pincode));          
            //   if (in_array($delivery_details->drop_pincode, $substation_array)) {
            //       $destination_substation = $substation->name;
            //       $destination_substation_mobile = $substation->mobile;
            //       break;
            //     } 
            // }

            // if(empty($destination_substation)) {
            //    $destination_substation = $substation->name;
            //    $destination_substation_mobile = $substation->mobile;
            // }
            
            // $delivery_details->destination_substation = $destination_substation;
            // $delivery_details->destination_substation_mobile = $destination_substation_mobile;

            /*$status_history = StatusHistory::leftjoin('bikers as b','b.id','=','shipment_status_history.biker_id')
               ->leftjoin('shipment as sh','sh.id','=','shipment_status_history.shipment_id')
                              ->select('shipment_status_history.*','b.first_name','b.last_name','b.mobile as biker_mobile','sh.remark')
                              ->where('shipment_id' , $delivery_details->id)->orderBy('date_time', 'desc')->get();*/
       // $service_status_history = DB::table('shipment as sh')
       //                        ->leftjoin('bikers as b','b.id','=','sh.biker_id')
       //                        ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
       //                        ->leftJoin('shipment_remark_history as rem_hist','rem_hist.shipment_status_id','=','st_hist.id')
       //                        ->select('b.first_name','b.last_name','rem_hist.remark','st_hist.date_time','rem_hist.sign','st_hist.status','st_hist.by_whom_role')
       //                        ->where('sh.id' , $delivery_details->id)->orderBy('date_time', 'desc')->get();
      
        $service_status_history = DB::table('shipment as sh')
          ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
          ->leftjoin('bikers as b','b.id','=','st_hist.biker_id')
          
          ->leftJoin('shipment_remark_history as rem_hist','rem_hist.shipment_status_id','=','st_hist.id')
          ->select('b.first_name','b.last_name','rem_hist.remark','st_hist.date_time','rem_hist.sign','st_hist.status','sh.uploaded_images','sh.uploaded_documents','sh.uploaded_audio','st_hist.by_whom_role')
          ->where('sh.awb_no','=',$awb_no)
           // ->where('sh.id' , $delivery_details->id)->orderBy('date_time', 'desc')
          ->get();
          
      foreach($service_status_history as $key=>$service_status1){       
        $service_status_history[$key]->remark=str_replace("\n", " ", $service_status1->remark);
      }

      $delivery_details->service_action= str_replace("\n", " ", $delivery_details->service_action);

      $status_history = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->get();

      foreach($status_history as $key=>$service_status1){
        if($service_status1->remark!="" && !is_null($service_status1->remark) )
        {
                
                    $status_history[$key]->remark=str_replace("\n", " ", $delivery_details->service_action);             
          }
      }

        $check_in_history = DB::table('biker_location as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.status','sh.date_time')
          ->where('sh.service_awb_no','=',Config::get('app.ticketprefix').$delivery_details->id)
          ->where('sh.biker_id','=',$delivery_details->biker_id)
          ->orderBy('sh.id','desc')
          ->get();

          $status_history_print = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->limit(2)
          ->get();

            $data = ['delivery' => $delivery_details, 'history' => $status_history,'print_history' =>$status_history_print,'service_status_history' =>$service_status_history,'checkin_out_history'=> $check_in_history];
            return response()->json($data);
        }   
    }

    //individual technician print - gajendra
    public function technician_deliverydetails($awb_no,$biker_id)
    { 
        
             $awb_no = $awb_no;
            $delivery_details = DB::table('shipment as sh')
                              ->leftjoin('vendor as v','v.id','=','sh.vendor_id')
                ->leftjoin('products as p','p.id','=','sh.product_id')
                ->leftjoin('amcs as a','a.vendor_id','=','sh.vendor_id')
                              ->leftjoin('bikers as biker','biker.id','=','sh.biker_id')
                              ->select('sh.id','sh.delivery_status','biker.mobile','biker.first_name as biker_firstname','biker.last_name as biker_lastname','v.name as vendor_name','v.mobile_no','v.primary_address','v.landmark','v.city','v.state','v.pin_code','sh.receiver_sign','sh.service_description','p.product_name','v.company_name','sh.service_action','a.end_date','a.atype','sh.created_type','sh.service_type','sh.remark','sh.sign_date','sh.created_by','sh.vendor_id','sh.priority','sh.created_at','sh.mobno','biker_id','sh.awb_no')
                              ->where('sh.awb_no', '=',$awb_no)

                              ->orWhere('a.vendor_id','=','sh.vendor_id')
                ->first();
 
       $service_status_history = DB::table('shipment as sh')
                              ->leftjoin('bikers as b','b.id','=','sh.biker_id')
                              ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
                              ->leftJoin('shipment_remark_history as rem_hist','rem_hist.shipment_status_id','=','st_hist.id')
                              ->select('b.first_name','b.last_name','rem_hist.remark','st_hist.date_time','rem_hist.sign','st_hist.status','st_hist.by_whom_role')
                              ->where('sh.id' , $delivery_details->id)
                              ->where('st_hist.biker_id' , $biker_id)
                              ->orderBy('date_time', 'desc')->get();
      //echo "<pre>";print_r($service_status_history);die;
      foreach($service_status_history as $key=>$service_status1){       
        $service_status_history[$key]->remark=str_replace("\n", " ", $service_status1->remark);
      }

      $delivery_details->service_action= str_replace("\n", " ", $delivery_details->service_action);

      $status_history = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->get();

      foreach($status_history as $key=>$service_status1){
        if($service_status1->remark!="" && !is_null($service_status1->remark) )
        {
                
                    $status_history[$key]->remark=str_replace("\n", " ", $delivery_details->service_action);             
          }
      }

        $check_in_history = DB::table('biker_location as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.status','sh.date_time')
          ->where('sh.service_awb_no','=',Config::get('app.ticketprefix').$delivery_details->id)
          ->where('sh.biker_id','=',$delivery_details->biker_id)
          ->orderBy('sh.id','desc')
          ->get();

          $status_history_print = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->limit(2)
          ->get();

            // $data = ['delivery' => $delivery_details, 'history' => $status_history,'print_history' =>$status_history_print,'service_status_history' =>$service_status_history,'checkin_out_history'=> $check_in_history];
//echo "<pre>";print_r($data);
      return view('delivery.techician_print')->withDeliveryDetails($delivery_details)->withStatusHistory($status_history)->withServiceStatusHistory($service_status_history)->withCheckInHistory($check_in_history)->withStatusHistoryPrint($status_history_print);
          
    }
    //end
   public function assignbiker1()
    {
        if (Request::ajax())
          {
            $awb_no = Request::get('awb_no');
            $biker_id = Request::get('biker_id');
            $user_id = Auth::user()->id;
            $date_time = Carbon::now()->toDateTimeString();
      $delivery_type = Request::get('delivery_type');
            $status = Request::get('status');
            $shipment_id = Request::get('shipment_id');
            
      $success = DB::table('shipment')
                    ->where('awb_no','=', $awb_no)
                    ->update(['biker_id' => NULL, 'updated_at' => $date_time]);
          //dd($success->toSql());
      //$data=['ano'=>$awb_no,'bid'=>$biker_id,'dtype'=>$delivery_type,'udt'=>$date_time];
      return response()->json($success);
    }
  }
    public function assignbiker()
    {
      
        if (Request::ajax())
          {
            $awb_no = Request::get('awb_no');
            $biker_id = Request::get('biker_id');
            $user_id = Auth::user()->id;
            $date_time = Carbon::now()->toDateTimeString();
      $delivery_type = Request::get('delivery_type');
            $status = Request::get('status');
            $shipment_id = Request::get('shipment_id');
            

      
            $success = DB::table('shipment')
                    ->where('awb_no','=', $awb_no)
                    ->update(['biker_id' => $biker_id, 'delivery_type' => $delivery_type, 'updated_at' => $date_time]);
//added on 7sep19 
     $created_at = DB::table('shipment')
        ->select('created_at')
        ->where('shipment.id','=',$shipment_id)
        ->first();
$created_at = (array)$created_at;

$role = DB::table('roles')
                        ->join('users','users.role_id','=','roles.id')
                        ->select('role_title')
                        ->where('users.id','=',$user_id)
                        ->first();
                $role = (array)$role;
            DB::table('shipment_status_history')
                  ->insert(
                        ['shipment_id' => $shipment_id, 'biker_id' => $biker_id, 'by_whom_id' => $user_id, 'by_whom_role' => $role['role_title'], 'status' =>'New','date_time' => $date_time,'created_at' => $created_at['created_at'],'updated_at' => $date_time]
                    );
//added on 7sep19                  
             $ships = DB::table('shipment')
                        ->select('*')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
            
      $itype1 = $ships->service_type;
      $itype = str_replace(' ', '%20', $itype1);
      $desc1 = $ships->service_description;
      $desc = str_replace(' ', '%20', $desc1);
      $vid = $ships->vendor_id;
      
      $vinfo = DB::table('vendor')
                        ->select('*')
                        ->where('vendor.id','=',$vid)
                        ->first();
      $cname1 = $vinfo->company_name;
      $cname = str_replace(' ', '%20', $cname1);      
      $cnm2 = $vinfo->name;
      $cnm = str_replace(' ', '%20', $cnm2);      
      $addr1 = $vinfo->primary_address;
      $addr = str_replace(' ', '%20', $addr1);

      $mob = $vinfo->mobile_no;
            if($status == 'Order Received') {
                DB::table('shipment')
                    ->where('awb_no','=', $awb_no)
                    ->update(['delivery_status' => 'New','updated_at' => $date_time]);

                $created_at = DB::table('shipment')
                        ->select('created_at')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
                $created_at = (array)$created_at;

                $role = DB::table('roles')
                        ->join('users','users.role_id','=','roles.id')
                        ->select('role_title')
                        ->where('users.id','=',$user_id)
                        ->first();
                $role = (array)$role;
              
                DB::table('shipment_status_history')
                  ->insert(
                        ['shipment_id' => $shipment_id, 'biker_id' => $biker_id, 'by_whom_id' => $user_id, 'by_whom_role' => $role['role_title'], 'status' =>'New','date_time' => $date_time,'created_at' => $created_at['created_at'],'updated_at' => $date_time]
                    );
            }
      //send sms start
      //$m1 = "9820129395";
      //$m2 = "9820129395";
      $b1 = DB::table('bikers')
                            ->where('id','=',$biker_id)
                            ->get();
      
      foreach($b1 as $b)
      {
        $bname = $b->first_name;
        $blnm = $b->last_name;
        $m1 = $b->mobile;
      }
      $u1 = DB::table('users')
                            ->where('id','=',$user_id)
                            ->get();
      foreach($u1 as $u)
      {
        $uname = $u->first_name;
        $ulnm = $u->last_name;
        $m2 = $u->mobile;
      }
       $st = str_replace(' ', '%20', $awb_no);
      $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=New%20$itype%20for%20$cname%20from%20$addr of%20$cnm(%20$mob%20)%20has%20been%20assigned%20to%20you.%20Details-$desc%20...&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
      $client1 = new \GuzzleHttp\Client();
      $this->response = $client1->get($link1)->getBody()->getContents();

      $link2 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mob&msg=Dear%20Customer,%20Your%20Complaint No.$st%20has%20been%20assigned%20to%20$bname%20$blnm.From".Config::get('app.companyname')."&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
       $client = new \GuzzleHttp\Client();
      $this->response = $client->get($link2)->getBody()->getContents();
      //send sms end
      
            //For GSM Notification
            $assined_biker = DB::table('bikers')
                              ->where('id','=',$biker_id)
                              ->first();
            if($assined_biker) {
               // $registatoin_ids = [$assined_biker->gcm_regid];
               // $message =array("message" => $awb_no);
         $msg = "Service ID : ".$awb_no;
                // Set POST variables
                $registatoin_ids[] = $assined_biker->gcm_regid;
                $registatoin_ids_ios = $assined_biker->ios_token;
                //$registatoin_ids = "APA91bH2G343ND2cNvoCnvXeOK8ilMyH6d2aLByaY-c5zhX-eCj6Ij2L7dW4A5aTaOCz9EfOr-Ty-W0aWdeqBn-F1hsSIgbVhjw7NSKzePmnYFedhLNu194k6_PXCIoM3yEg5zSZ9eEE";
               // $message1 =array("message" => "");
          $messagebody = array("title" => "New Service Assigned", "body" => $msg,"type"=>"emp","extra"=>"extra");
          $messagebody_ios = "New Service Assigned - Service ID : ".$awb_no;
                // Set POST variables
                $fields1 = array(
         'registration_ids' => $registatoin_ids,
         'data' => $messagebody,
         'priority' => 'high',
         'delay_while_idle'=> true,
          'dry_run'=> false,
          'content_available'=> true,
          'time_to_live'=> 3600
        );

          $url1 = 'https://fcm.googleapis.com/fcm/send';  
           
          //building headers for the request
          $headers1 = array(
            'Authorization: key='.Config::get('app.android_key'),
            'Content-Type: application/json'
          );
      
          //Initializing curl to open a connection
          $ch1 = curl_init();
       
          //Setting the curl url
          curl_setopt($ch1, CURLOPT_URL, $url1);
          
          //setting the method as post
          curl_setopt($ch1, CURLOPT_POST, true);
      
          //adding headers 
          curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
          curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
       
          //disabling ssl support
          curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
          
          //adding the fields in json format 
          curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode($fields1));
       
          //finally executing the curl request 
          $result1 = curl_exec($ch1);
          //print_r($result1);
          if ($result1 === FALSE) {
            die('Curl failed: ' . curl_error($ch1));
          }
          //Now close the connection
          curl_close($ch1);

           //ios app notification
          $fields1 = array(
         'registration_ids' => $registatoin_ids_ios,
         'data' => $messagebody_ios
        );
          $postData = "";
          foreach( $fields1 as $key => $val ) {
             $postData .=$key."=".$val."&";
          }
          $postData = rtrim($postData, "&");
//echo $registatoin_ids_ios; 
          $url2 = Config::get('app.pushlinkios')."simplepush.php?registration_ids=".$registatoin_ids_ios."&key=1&shipment_id=".$shipment_id."&ticketid=".$awb_no."&data=".urlencode($messagebody_ios);
//echo $url2;die;
         //Initializing curl to open a connection
          $ch2 = curl_init();
       
          //Setting the curl url
          curl_setopt($ch2, CURLOPT_URL, $url2);
          
          //setting the method as post
          curl_setopt($ch2, CURLOPT_POST, true);
      
          //adding headers 
          curl_setopt($ch2, CURLOPT_HTTPHEADER, $headers1);
          //curl_setopt( $ch2, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
          curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
       
          //disabling ssl support
          curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
          curl_setopt($ch2, CURLOPT_SSL_VERIFYHOST, false);
          
          //adding the fields in json format 
          curl_setopt($ch2, CURLOPT_POSTFIELDS, $postData);
       
          //finally executing the curl request 
          $result2 = curl_exec($ch2);

          //print_r($result1);
          if ($result2 === FALSE) {
            //die('Curl failed: ' . curl_error($ch2));
          }
          //Now close the connection
          curl_close($ch2);
          

          //ios app notification


          
    
            }
            return response()->json($success);
      
        }
    }

    public function updatestatus()
    {
        if (Request::ajax())
        {
            $awb_no = Request::get('awb_no');
            $status = Request::get('status');
            $shipment_id = Request::get('shipment_id');
            $assined_biker_id = Request::get('biker_id');
      
            $user_id = Auth::user()->id;
            $date_time = Carbon::now()->toDateTimeString();
      $sinfo = DB::table('shipment')
                       ->select('*')
                       ->where('shipment.id','=',$shipment_id)
                       ->first();
      $vid = $sinfo->vendor_id;
       $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$vid)
                       ->first();
      $vname = $vinfo->name;
      $vemail = $vinfo->email;
      if($status == 'Closed'){
        $shipment_id1 = DB::table('shipment')
               ->select('*')
               ->where('awb_no',$awb_no)
               ->first();
        $assined_biker = DB::table('vendor')
                              ->where('id','=',$shipment_id1->vendor_id)
                              ->first();
              if($assined_biker) {
          //$registatoin_ids = [$assined_biker->gcm_regid];
     
          $registatoin_ids[] = $assined_biker->gcm_regid;
          $registatoin_ids_ios = $assined_biker->ios_token;

                //$registatoin_ids = "APA91bH2G343ND2cNvoCnvXeOK8ilMyH6d2aLByaY-c5zhX-eCj6Ij2L7dW4A5aTaOCz9EfOr-Ty-W0aWdeqBn-F1hsSIgbVhjw7NSKzePmnYFedhLNu194k6_PXCIoM3yEg5zSZ9eEE";
               // $message1 =array("message" => "");
          $messagebody = array("title" => Config::get('app.companyname')." Rating", "body" => "Your Service Ticket has been Closed of Service ID : ".$awb_no.". Please rate App.","type"=>"cus");
          $messagebody_ios = Config::get('app.companyname')." - Your Service Ticket has been Closed of Service ID : ".$awb_no.". Please rate App.";
                // Set POST variables
                $fields1 = array(
         'registration_ids' => $registatoin_ids,
         'data' => $messagebody,
         'priority' => 'high',
         'delay_while_idle'=> true,
          'dry_run'=> false,
          'content_available'=> true,
          'time_to_live'=> 3600
        );

          $url1 = 'https://fcm.googleapis.com/fcm/send';
 
          //building headers for the request
          $headers1 = array(
            'Authorization: key='.Config::get('app.android_key'),
            'Content-Type: application/json'
          );
      
          //Initializing curl to open a connection
          $ch1 = curl_init();
       
          //Setting the curl url
          curl_setopt($ch1, CURLOPT_URL, $url1);
          
          //setting the method as post
          curl_setopt($ch1, CURLOPT_POST, true);
      
          //adding headers 
          curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
          curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
       
          //disabling ssl support
          curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
          
          //adding the fields in json format 
          curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode($fields1));
       
          //finally executing the curl request 
          $result1 = curl_exec($ch1);
          //print_r($result1);
          if ($result1 === FALSE) {
            die('Curl failed: ' . curl_error($ch1));
          }
          //Now close the connection
          curl_close($ch1);

          //ios app notification
          $fieldsios = array(
         'registration_ids' => $registatoin_ids_ios,
         'data' => $messagebody_ios
        );
          $postDataios = "";
          foreach( $fieldsios as $key => $val ) {
             $postDataios .=$key."=".$val."&";
          }
          $postDataios = rtrim($postDataios, "&");

          $urlios = Config::get('app.pushlinkios')."simplepush.php?registration_ids=".$registatoin_ids_ios."&key=2&shipment_id=".$shipment_id."&ticketid=".$awb_no."&data=".urlencode($messagebody_ios);
          
         //Initializing curl to open a connection
          $chios = curl_init();
       
          //Setting the curl url
          curl_setopt($chios, CURLOPT_URL, $urlios);
          
          //setting the method as post
          curl_setopt($chios, CURLOPT_POST, true);
      
          //adding headers 
          //curl_setopt($ch2, CURLOPT_HTTPHEADER, $headers1);
          curl_setopt( $chios, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
          curl_setopt($chios, CURLOPT_RETURNTRANSFER, true);
       
          //disabling ssl support
          curl_setopt($chios, CURLOPT_SSL_VERIFYPEER, false);
          curl_setopt($chios, CURLOPT_SSL_VERIFYHOST, false);
          
          //adding the fields in json format 
          curl_setopt($chios, CURLOPT_POSTFIELDS, $postDataios);
       
          //finally executing the curl request 
          $resultios = curl_exec($chios);

          //print_r($result1);
          if ($resultios === FALSE) {
            //die('Curl failed: ' . curl_error($ch2));
          }
          //Now close the connection
          curl_close($chios);
          

          //ios app notification
    
        }  
      }
      if($status == 'Closed'){
        $delivery_details = DB::table('shipment as sh')
                              ->leftjoin('vendor as v','v.id','=','sh.vendor_id')
                ->leftjoin('products as p','p.id','=','sh.product_id')
                ->leftjoin('amcs as a','a.vendor_id','=','sh.vendor_id')
                              ->leftjoin('bikers as biker','biker.id','=','sh.biker_id')
                              ->select('sh.id','sh.delivery_status','biker.mobile','biker.first_name as biker_firstname','biker.last_name as biker_lastname','v.name as vendor_name','v.mobile_no','v.primary_address','v.landmark','v.city','v.state','v.pin_code','sh.receiver_sign','sh.service_description','p.product_name','v.company_name','sh.service_action','a.end_date','a.atype','sh.created_type','sh.service_type','sh.remark','sh.sign_date','sh.created_by','sh.vendor_id','sh.priority','sh.created_at','sh.mobno','biker_id','sh.awb_no')
                              ->where('sh.awb_no', '=',$awb_no)
                              ->orWhere('a.vendor_id','=','sh.vendor_id')
                              ->first();
                       //print_r($delivery_details); 
          $service_status_history = DB::table('shipment as sh')
                              ->leftjoin('bikers as b','b.id','=','sh.biker_id')
                              ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
                              ->leftJoin('shipment_remark_history as rem_hist','rem_hist.shipment_status_id','=','st_hist.id')
                              ->select('b.first_name','b.last_name','rem_hist.remark','st_hist.date_time','rem_hist.sign','st_hist.status','st_hist.by_whom_role')
                              ->where('sh.id' , $delivery_details->id)->orderBy('date_time', 'desc')->get();

 foreach($service_status_history as $key=>$service_status1){       
        $service_status_history[$key]->remark=str_replace("\n", " ", $service_status1->remark);
      }

      $delivery_details->service_action= str_replace("\n", " ", $delivery_details->service_action);

      $status_history = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->get();

          foreach($status_history as $key=>$service_status1){
        if($service_status1->remark!="" && !is_null($service_status1->remark) )
        {
                
                    $status_history[$key]->remark=str_replace("\n", " ", $delivery_details->service_action);             
          }
      }

        $check_in_history = DB::table('biker_location as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.status','sh.date_time')
          ->where('sh.service_awb_no','=',Config::get('app.ticketprefix').$delivery_details->id)
          ->where('sh.biker_id','=',$delivery_details->biker_id)
          ->orderBy('sh.id','desc')
          ->get();

          $status_history_print = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->limit(2)
          ->get();
          //print_r($status_history_print);die;

        //pdf on status closed - gajendra
        $pdf_content = array (
                        'delivery_details' => $delivery_details,
                        'history' => $status_history,
                        'print_history' => $status_history_print,
                        'service_status_history' => $service_status_history,
                        'checkin_out_history'=> $check_in_history
                        );
        //echo "<pre>";print_r($pdf_content);echo "<br>";
        
        $pdf_name = $delivery_details->vendor_name.'-'.$awb_no.'.pdf';
                    $pdf = PDF::loadView('emails.pdf_on_close_status', $pdf_content);
                    $pdf->save(storage_path('uploads/pdf_closed_status/'.$pdf_name));
                    $pathtoinvoice = storage_path('uploads/pdf_closed_status/'.$pdf_name);
                    $emailcontent2['pathtoinvoice'] = $pathtoinvoice;
                    //echo $pathtoinvoice;echo "<br>";
        //echo "<pre>";print_r($emailcontent2);echo "<br>";
 
         $emailcontent = array (
            'cno' => $awb_no
          );
//echo "<pre>";print_r($emailcontent);echo "<br>";
        try{ 
          Mail::send('emails.closeticket', $emailcontent, function ($message) use($vemail, $pathtoinvoice) {        
         
            $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
            $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
            $message->to($vemail)->subject(Config::get('app.companyname').' - Closed Ticket Request'); 
            $message->attach($pathtoinvoice);
    
          });  
        } catch (\Exception $ex) { 
            echo "Mail not sent......";
            return "We've got errors!";
            exit;
          } 
      //pdf on status closed - gajendra
        
        $m1 = $vinfo->mobile_no;
    $st = str_replace(' ', '%20', $awb_no);
    $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20Complaint No.$st%20has%20been%20solved.For%20further%20assistance%20pls%20call%20on%20".Config::get('app.companySupport').".From".Config::get('app.companyname').".&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
      $client1 = new \GuzzleHttp\Client();
      $this->response = $client1->get($link1)->getBody()->getContents();
      }
            if($status == 'At Sub Station') {
              $success = DB::table('shipment')
                    ->where('awb_no','=', $awb_no)
                    ->update(['delivery_status' => $status,'biker_id' => NULL, 'updated_at' => $date_time]);
            } else {
              $success = DB::table('shipment')
                    ->where('awb_no','=', $awb_no)
                    ->update(['delivery_status' => $status,'updated_at' => $date_time]);
            }
            
            $created_at = DB::table('shipment')
                        ->select('created_at')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
            $created_at = (array)$created_at;
                    
            $role = DB::table('roles')
                        ->join('users','users.role_id','=','roles.id')
                        ->select('role_title')
                        ->where('users.id','=',$user_id)
                        ->first();
            $role = (array)$role;
          
            
            DB::table('shipment_status_history')
                ->insert(
                        ['shipment_id' => $shipment_id, 'biker_id' => $assined_biker_id, 'by_whom_id' => $user_id,'by_whom_role' => $role['role_title'], 'status' => $status,'date_time' => $date_time,'created_at' => $created_at['created_at'],'updated_at' => $date_time]
                    );

            return response()->json($success);
        }
    }

 public function updatestatus1()
    {
        if (Request::ajax())
        {
        $date_time = Carbon::now()->toDateTimeString();
      //Request::get('priority');
      //Request::get('sid');
      //exit();
            if(!empty(Request::get('priority'))){
      //echo "in";exit();
      $priority = Request::get('priority');
           
            $shipment_id = Request::get('sid');
       /*$ships = DB::table('shipment')
                        ->select('*')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
            
      $assined_biker_id = $ships->biker_id;*/
            
           /* DB::table('shipment_remark_history')
                ->insert(
                        ['shipment_id' => $shipment_id, 'biker_id' => $assined_biker_id, 'remark' => $remark,'date_time' => $date_time]
                    );*/
      $success = DB::table('shipment')
                    ->where('id','=', $shipment_id)
                    ->update(['priority' => $priority, 'updated_at' => $date_time]);
          //print_r($success);exit();
      }
      if(!empty(Request::get('remark'))){
      $remark = Request::get('remark');
           
            $shipment_id = Request::get('sid');
       $ships = DB::table('shipment')
                        ->select('*')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
            
      $assined_biker_id = $ships->biker_id;
            
           /* DB::table('shipment_remark_history')
                ->insert(
                        ['shipment_id' => $shipment_id, 'biker_id' => $assined_biker_id, 'remark' => $remark,'date_time' => $date_time]
                    );*/
      $success = DB::table('shipment')
                    ->where('id','=', $shipment_id)
                    ->update(['remark' => $remark, 'updated_at' => $date_time]);
          
      }

           
            return response()->json($success);
        }
    }


 public function updatepriority()
    {
        if (Request::ajax())
        {
        $date_time = Carbon::now()->toDateTimeString();
      
      $priority = Request::get('priority');
           
            $shipment_id = Request::get('sid');
       /*$ships = DB::table('shipment')
                        ->select('*')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
            
      $assined_biker_id = $ships->biker_id;*/
            
           /* DB::table('shipment_remark_history')
                ->insert(
                        ['shipment_id' => $shipment_id, 'biker_id' => $assined_biker_id, 'remark' => $remark,'date_time' => $date_time]
                    );*/
      $success = DB::table('shipment')
                    ->where('id','=', $shipment_id)
                    ->update(['priority' => $priority, 'updated_at' => $date_time]);
          //print_r($success);exit();
      
           
            return response()->json($success);
        }
    }

    public function transfersubstation()
    {
        if (Request::ajax()) {
            $substation_id = Request::get('substation_id');
            $awb_no =Request::get('awb_no');
            $substation_name =Request::get('substation_name');
            $transfer_status = 'Transferred_substation_'.$substation_name;
            $shipment_id =Request::get('shipment_id');
            $user_id = Auth::user()->id;
            $date_time = Carbon::now()->toDateTimeString();
            $assined_biker_id = Request::get('assined_biker_id');

            $created_at = DB::table('shipment')
                        ->select('created_at')
                        ->where('shipment.id','=',$shipment_id)
                        ->first();
            //$created_at = (array)$created_at;

            $role = DB::table('roles')
                        ->join('users','users.role_id','=','roles.id')
                        ->select('role_title')
                        ->where('users.id','=',$user_id)
                        ->first();
            //$role = (array)$role;

            $success = DB::table('shipment')
                    ->where('awb_no','=', $awb_no)
                    ->update(['sub_station_id' => $substation_id]);

            // For storing transfer substation status in history table
            DB::table('shipment_status_history')
                  ->insert(
                      ['shipment_id' => $shipment_id, 'biker_id' => $assined_biker_id, 'by_whom_id' => $user_id, 'by_whom_role' => $role->role_title, 'status' => $transfer_status,'date_time' => $date_time,'created_at' => $created_at->created_at,'updated_at' => $date_time]
                  );
            return response()->json($success);
        }
    }

    public function countorders()
    {
      if (Request::ajax())
      {
        $substation_id = "";
        $date = new DateTime();
        $today_start_time = $date->format('Y-m-d 00:00:00');
        $today_end_time = new DateTime('NOW');

        $substation_query = Substation::select('id','name');  
        $substations = $substation_query->get();
        
        if(!empty(Session::get('sub_station_id'))) {
          $substation_id = Session::get('sub_station_id');
        } else if(!empty(Request::get('substation_id'))) {
          $substation_id = Request::get('substation_id');
        } else {
          $substation_id = $substations{0}->id;
        }
          

        $query = DB::table('shipment as sh');
                $query->where('sh.sub_station_id','=',$substation_id);
                $query->whereBetween('sh.order_time',array($today_start_time,$today_end_time));
        $count = $query->count();
        return response()->json($count);
      }
    }

    public function countweight() {
      /*if (Request::ajax())
      { 
          $shipment_id = Request::get('shipment_id');
          $biker_id = Request::get('biker_id');
          //var_dump($shipment_id,$biker_id);

          $biker_weight = DB::table('bikers as b')
                      ->select(DB::Raw('(SELECT SUM(weight) FROM shipment_packages sp LEFT JOIN shipment s ON sp.shipment_id = s.id WHERE s.biker_id = '.$biker_id.' AND s.delivery_status NOT IN ("Delivered","At Substation")) as total_weight'))
                      ->first();
          return response()->json($biker_weight);
      }*/
    }

    public function bikerdetails() {
      if (Request::ajax())
      { 
          $substation_id = "";
         /* $substation_query = Substation::select('id','name');  
          $substations = $substation_query->get();
              
          if(!empty(Session::get('sub_station_id'))) {
            $substation_id = Session::get('sub_station_id');
          } else if(!empty(Request::get('substation_id'))) {
            $substation_id = Request::get('substation_id');
          } else {
            $substation_id = $substations{0}->id;
          }*/
              
          $biker_query= DB::table('bikers as b')
                      ->select('*','b.id as total_weight')
                      ->where('b.profile_status','=','Available')
                      ->where('b.status','=','Active')
                      //->where('b.substation_id','=',$substation_id)
                      ->groupby('b.id')
                      ->whereNull('b.deleted_at');
          $biker_records = $biker_query->get();

          $data = ['biker_details' => $biker_records];
     
         
          return response()->json($data);
      }
    }
  
   public function mailcheck() {
  /*    $start_time = '00:00:00';
        $date = new DateTime();
        $today_start_time = $date->format('Y-m-d '.$start_time);
    $today_end_time = new DateTime('NOW');
      
    
  
        $qry1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','New')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
         
         $qry2 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','In Progress')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
         
         $qry3 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','Awaiting Spares')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
    
        $qry4 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','Work Pending')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
         
         $qry5 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','Client Side')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
         
         $qry6 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','Completed')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
         
         $qry7 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','Closed')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
         
         $qry8 = DB::table('shipment as sh')          

                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','Cancelled')
         ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
         ->get();
    //end
             
        $query1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          
           ->where('sh.delivery_status','=','New')
         ->get();
          
          
  $query2 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          ->where('sh.delivery_status','=','In Progress')
          ->get();

          $query3 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          ->where('sh.delivery_status','=','Awaiting Spares')
          ->get();
           
          $query4 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          ->where('sh.delivery_status','=','Work Pending')
          ->get();
          
          $query5 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          ->where('sh.delivery_status','=','Client Side')
          ->get();
          
          $query6 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          ->where('sh.delivery_status','=','Completed')
          ->get();
          
          $query7 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
          ->where('sh.delivery_status','=','Closed')
          ->get();
          
          $query8 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name')
         ->where('sh.delivery_status','=','Cancelled')
          ->get();
          

    
            $n1 = count($query1);       
          $n2 = count($query2);       
          $n3 = count($query3);       
          $n4 = count($query4);       
          $n5 = count($query5);       
          $n6 = count($query6);       
          $n7 = count($query7);       
          $n8 = count($query8);       
          $n9 = count($qry1);       
          $n10 = count($qry2);        
          $n11 = count($qry3);        
          $n12 = count($qry4);        
          $n13 = count($qry5);        
          $n14 = count($qry6);        
          $n15 = count($qry7);        
          $n16 = count($qry8);        
     
     $emailcontent = array (
            'n1' => $n1,
      'n2' => $n2,
      'n3' => $n3,
      'n4' => $n4,
      'n5' => $n5,
      'n6' => $n6,
      'n7' => $n7,
            'n8' => $n8,
      'n9' => $n9,
      'n10' => $n10,
      'n11' => $n11,
      'n12' => $n12,
      'n13' => $n13,
      'n14' => $n14,
      'n15' => $n15,
      'n16' => $n16
            );
      print_r($emailcontent);
     Mail::send('emails.amcs', $emailcontent, function ($message) {        
            //$message->to('vishal@mukesoft.com')->subject('Service Ticket Request Report');
 $message->from(Config::get('app.fromemail'), Config::get('app.companyname'));

$message->to(Config::get('app.adminemail'))->subject(Config::get('app.companyname').'Request Report');
$message->cc('vishal@mukesoft.com');
        });
*/
  $m1 = "9820129395";
  $awb_no = "SUPP27122016134745PA";
    $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20complaint%20has%20been%20registered,Complaint No.$awb_no,%20Your%20Complaint%20Will%20Shortly.For%20further%20assistance%20pls%20call%208080922970.&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
      $client1 = new \GuzzleHttp\Client();
      //$this->response = $client1->get($link1)->getBody()->getContents();
    //end
   
   }


public function fetchtechname(){
   if (Request::ajax())
        {
       
      $vid = Request::get('tid');
      /*$result = DB::table('shipment as sh')
            ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
            ->select('biker.id,biker.first_name,biker.last_name');
            $result->where('sh.vendor_id','=',$vid);
            $result->groupBy('sh.biker_id');
            $result->orderBy('sh.id', 'DESC');
            $result->get();
            dd($result->toSql());*/
        $result = DB::table('shipment')
                ->select('*')
                ->where('vendor_id','=',$vid)
                ->orderBy('id', 'DESC')
                ->get();
  
            //print_r($result);exit();
      $data = ['result' => $result];
      return response()->json($data);
        }
  }

 public function assignbiker3(Request $request)
    {
           // $tid = Request::get('tid');
       $input = $request->all();
       $vendor_id = $input['vendor_id'];
           //return response()->json(['success' => '0']);
       $result = DB::table('shipment')
                ->select('*')
                ->where('vendor_id','=',$vendor_id)
                ->orderBy('id', 'DESC')
                ->get();
  
            //print_r($result);exit();
      $data = ['result' => $result];
      return response()->json($data);
    
  }

/*
author : gajendra;
*/
  public function show( ) 
  { 
    $awb_no =  Config::get('app.ticketprefix').$_GET['id'] ;
            $delivery_details = DB::table('shipment as sh')
                              ->leftjoin('vendor as v','v.id','=','sh.vendor_id')
                              ->leftjoin('products as p','p.id','=','sh.product_id')
                              ->leftjoin('amcs as a','a.vendor_id','=','sh.vendor_id')
                              ->leftjoin('bikers as biker','biker.id','=','sh.biker_id')
                              ->select('sh.id','sh.delivery_status','biker.mobile','biker.first_name as biker_firstname','biker.last_name as biker_lastname','v.name as vendor_name','v.mobile_no','v.primary_address','v.landmark','v.city','v.state','v.pin_code','sh.receiver_sign','sh.service_description','p.product_name','v.company_name','sh.service_action','sh.instructions','a.end_date','a.atype','sh.created_type','sh.service_type','sh.remark','sh.sign_date','sh.created_by','sh.vendor_id','sh.priority','sh.created_at','sh.order_time as order_time','sh.mobno','biker_id','sh.expense','sh.expense_description','sh.awb_no')
                              ->where('sh.awb_no', '=',$awb_no) 
                              ->orWhere('a.vendor_id','=','sh.vendor_id')
                              ->first(); 
       // $service_status_history = DB::table('shipment as sh')
       //                        ->leftjoin('bikers as b','b.id','=','sh.biker_id')
       //                        ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
       //                        ->leftJoin('shipment_remark_history as rem_hist','rem_hist.shipment_status_id','=','st_hist.id')
       //                        ->select('b.first_name','b.last_name','rem_hist.remark','st_hist.date_time','rem_hist.sign','st_hist.status','sh.uploaded_images','sh.uploaded_documents','sh.uploaded_audio')
       //                        ->where('sh.id' , $delivery_details->id)->orderBy('date_time', 'desc')->get();

          $service_status_history = DB::table('shipment as sh')
          ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
          ->leftjoin('bikers as b','b.id','=','st_hist.biker_id')
          
          ->leftJoin('shipment_remark_history as rem_hist','rem_hist.shipment_status_id','=','st_hist.id')
          ->select('b.first_name','b.last_name','rem_hist.remark','st_hist.date_time','rem_hist.sign','st_hist.status','sh.uploaded_images','sh.uploaded_documents','sh.uploaded_audio' )
          ->where('sh.awb_no','=',$awb_no)
           // ->where('sh.id' , $delivery_details->id)->orderBy('date_time', 'desc')
          ->get();
       
      foreach($service_status_history as $key=>$service_status1){       
        $service_status_history[$key]->remark=str_replace("\n", " ", $service_status1->remark);
      }

      $delivery_details->service_action= str_replace("\n", " ", $delivery_details->service_action);
      // changes to see status of previous history...by gaurav on 18-03-20...
      $status_history = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  // added the shipment_status_history table to show status of it...By Gaurav on 26-feb-20
                  ->leftJoin('shipment_status_history as st_hist','st_hist.shipment_id','=','sh.id')
                  ->select('biker.first_name','biker.last_name','sh.awb_no','sh.remark','sh.order_time','st_hist.status')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          ->get();

      foreach($status_history as $key=>$service_status1){
        /*if($service_status1->remark!="" && !is_null($service_status1->remark) )
        {
                
                    $status_history[$key]->remark=str_replace("\n", " ", $delivery_details->service_action);             
          }*/
      }
 
        $checkin_out_history = DB::table('biker_location as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.status','sh.date_time')
                  ->where('sh.service_awb_no','=',$delivery_details->awb_no)
                  //->where('sh.biker_id','=', $delivery_details->biker_id)
                  ->orderBy('sh.id','desc')
                  ->get();
           
 
          $status_history_print = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                  ->select('biker.first_name','biker.last_name','sh.remark','sh.order_time')
          ->where('sh.id','<>',$delivery_details->id)
          ->where('sh.vendor_id','=',$delivery_details->vendor_id)
          ->orderBy('sh.id','desc')
          //->limit(2)
          ->get();

$inventory_history = DB::table('inventory_store as inst')
              ->Join('inventory as ins','ins.id','=','inst.inventory_id')
                  ->select('ins.name','inst.quantity')
      ->where('inst.awb_no','=',$awb_no)  
       ->get();  
 
//echo "<pre>"; print_r($inventory_history);
//echo "<pre>"; print_r($checkin_out_history);
//echo "<pre>"; print_r($service_status_history);
//echo "<pre>"; print_r($status_history);
//echo "<pre>"; print_r($delivery_details);



      // die;
           // $data = ['delivery' => $delivery_details, 'history' => $status_history,'print_history' =>$status_history_print,'service_status_history' =>$service_status_history,'checkin_out_history'=> $check_in_history];
             
             return view('delivery.service_detail')->withDeliveryDetails($delivery_details)->withStatusHistory($status_history)->withServiceStatusHistory($service_status_history)->withCheckinOutHistory($checkin_out_history)->withInventoryHistory($inventory_history);
  }   
//gajendra 

  //vickey 9dec19
public function cronjobs_eveningemails()
{
  
  //first check if daily service report is enabled 
  $send_daily_report = false;
  $send_daily_report_emailto = '';
  $site_settings = DB::table('site_settings')
                        ->select('*')
                        ->get();
  $settings_arr = array();
  if($site_settings)
  {
    foreach($site_settings as $val)
    {
      $settings_str = urldecode($val->settings);
      $settings_arr = unserialize($settings_str);
    }
  }

  if(isset($settings_arr['daily_email'])) 
    { 
      if($settings_arr['daily_email']=='1') 
        { 
          $send_daily_report = true;
          $send_daily_report_emailto = $settings_arr['daily_email_to'];
        } 
    }
  //first check if daily service report is enabled

  if($send_daily_report && ($send_daily_report_emailto != ''))
  {

  $query1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
          ->leftjoin('products as p','p.id','=','sh.product_id')
           ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','sh.service_type','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.name','p.product_name','sh.created_by','sh.created_type','sh.order_time','sh.service_description','sh.mobno','sh.remark','sh.created_at','sh.updated_at');

  $start_date = $end_date = date("d-m-Y");
  $start_time = '00:00:00';
  $end_time = '23:59:59';

  $date = new DateTime($start_date);
  $start_date = $date->format('Y-m-d '.$start_time);
  $date = new DateTime($end_date);
  $end_date = $date->format('Y-m-d '.$end_time);
  $query1->whereBetween('sh.order_time', array($start_date,$end_date));

  $query1->orderBy('sh.id','DESC');

  //dd($query1->toSql());
  $deliveries1 = $query1->get();
  
  $filename = "Daily_Service_Report_".date("d-m-Y").".csv";
  $filepath = public_path()."/uploads/".$filename;
  $company_name = Config::get('app.companyname');
  $company_email = Config::get('app.companyemail');
  $ticketprefix = Config::get('app.ticketprefix');
  if($company_name=='') {$company_name = 'Apniamc';}

   //$csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
        $csv = \League\Csv\Writer::createFromPath($filepath, "w");
             $csv->insertOne(array(' ','DAILY SERVICES REPORT - '.date("d F Y")));
            $csv->insertOne(array());

        if($deliveries1)
        {

        $csv->insertOne(array('Service ID','Client Name','Company Name', 'Technician Name','Product', 'Service Status','Type','Description','Created By','Remark'));

        

       foreach ($deliveries1 as $line) 
       { 
       $date = new DateTime($line->order_time);
       $date_s = new DateTime($line->created_at);
       $date_e = new DateTime($line->updated_at);
       $technician_name = 'No Technician Assigned';
       if($line->first_name=='' && $line->last_name==''){}
       else
       {
          $technician_name = ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name));
       }
                $data = array(
                  'id' => $ticketprefix.$line->id,
                  'name' => $line->name,
                    'company_name' => $line->company_name,
                    'tname' =>  $technician_name,
          'product' => $line->product_name,
                    'service_status' => $line->delivery_status,
                    'type' => $line->service_type,
          'description' => $line->service_description,
          'created_by' => $line->created_by,
          'remark' => $line->remark
          
                );

                $line = (array) $data;
                $csv->insertOne($line);
        
        }
      }
      else
      {
        
        $csv->insertOne(array(' ',' NO RECORD FOUND'));
        
      }
        

        try{ 
        Mail::send('emails.daily_service_report', [], function($message) use($send_daily_report_emailto,$company_name,$company_email, $filepath)
        {
            $message->to($send_daily_report_emailto)
                    ->bcc('vickey@mukesoft.com')
                    ->from($company_email,$company_name)
                    ->subject('Daily Service Report');
            $message->attach($filepath);
        });
          
        } catch (\Exception $ex) { 
            echo "Mail not sent......";
            return "We've got errors!";
            exit;
          } 
        
    echo 'Mail sent';
}
else
{
  echo 'Daily Report not set';
}

die;
}
//vickey 9dec19 

}
