<?php

namespace App\Http\Controllers\Auth;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;
use App\User;
use Mail;
use Config;

class PasswordController extends Controller
{

    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Create a new password controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }
    public function forgotPassword(Request $request) {
       $this->validate($request, [
                'email' => 'required|email|max:255',
            ]);
        $input = $request->all();
        $user = User::select('*')
             ->where('email', $input['email'])
             ->first();
        if($user) {  
            $data['email'] = $input['email'];
            $data['name'] = ucfirst($user->first_name);
             $data['link'] = Config::get('app.loginurl');
            $data['password'] = substr(md5($input['email'].time()), 5, 15);
            Mail::send('emails.forgot_admin_email', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
                $message->to($data['email'])->subject('Forgot Password');
            });

            $input['password'] = bcrypt($data['password']);
            User::where('email', $input['email'])->update(['password' => $input['password']]); //print_r($data['password']); die;
            $request->session()->flash('success', 'Your password has been changed successfully. Please check your mail box.');
            return redirect("/auth/login");
        } else {
            session()->flash('error', 'This is not valid user email. Please Contact Admin.');
            return redirect('/password/email');
        }
    }

}
