<?php

namespace App\Http\Controllers\Auth;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;
use App\User;
use Mail;
use Config;
use DB;

class PasswordController extends Controller
{

    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Create a new password controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }
    public function forgotPassword(Request $request) {
       $this->validate($request, [
                'email' => 'required|email|max:255',
            ]);
        $input = $request->all();
        $user = User::select('*')
             ->where('email', $input['email'])
             ->first();
        if($user) {  
            $data['email'] = $input['email'];
            $data['name'] = ucfirst($user->first_name);
             $data['link'] = Config::get('app.loginurl');
            $data['password'] = substr(md5($input['email'].time()), 5, 15);
            Mail::send('emails.forgot_admin_email', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
                $message->to($data['email'])->subject('Forgot Password');
            });

            $input['password'] = bcrypt($data['password']);
            User::where('email', $input['email'])->update(['password' => $input['password']]); //print_r($data['password']); die;
            $request->session()->flash('success', 'Your password has been changed successfully. Please check your mail box.');
            return redirect("/auth/login");
        } else {
            session()->flash('error', 'This is not valid user email. Please Contact Admin.');
            return redirect('/password/email');
        }
    }

    // Added by Gaurav on 26-feb-22 by client forgot password
    public function forgotPasswordClient(Request $request) {
       $this->validate($request, [
                'email' => 'required|email|max:255',
            ]);
        // echo $request; die();
        $input = $request->all();
        // echo $input->email; die();
        // $user = Vendor::select('*')
        //      ->where('email', $input['email'])
        //      ->first();

        $user = DB::table('vendor')->where('email', $input['email'])->first();
        // echo $user; die();
        
        if($user) {  
            $data['email'] = $input['email'];
            // echo $input['email']; die();
            $data['name'] = ucfirst($user->name);
            $data['link'] = Config::get('app.loginurl');
            $data['password'] = substr(md5($input['email'].time()), 5, 15);
            Mail::send('emails.forgot_admin_email', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
                $message->to($data['email'])->subject('Forgot Password');
        });

            $input['password'] = bcrypt($data['password']);
            // echo $input['password']; die();
            // changes by gaurav to update the forgot password.
            DB::table('vendor')->where('email', $input['email'])->update(['password' => $input['password']]);

            // Vendor::where('email', $input['email'])->update(['password' => $input['password']]); //print_r($data['password']); die;
            $request->session()->flash('success', 'Your password has been changed successfully. Please check your mail box.');
            return redirect("client/loginpage");
        } else {
            session()->flash('error', 'This is not valid user email. Please Contact Admin.');
            return redirect('client/password/clientemail');
        }
    }

}