<?php

namespace App\Http\Controllers\Api1_0;

use Illuminate\Http\Request;
use App\Http\Requests;
use DB;
use App\Http\Controllers\Controller;
use App\VendorShipment;
use App\StatusHistory;
use Hash;
use Carbon\Carbon;
use DateTime;
use Mail;
use Config;

class ApiController extends Controller
{
      
      public function delivery($id)
      {
        
        $input = $_REQUEST;

        $end_limit=(isset($input['end_limit'])?$input['end_limit']:0);
        $start_limit=(isset($input['start_limit'])?$input['start_limit']:0);
        $status=(isset($input['status'])?$input['status']:"");
        $keyword=(isset($input['keyword'])?urldecode($input['keyword']):"");
        
        if($status!="")  
        {
           $new_status[]=urldecode($status);
        }
        else{
          $new_status=array('Completed','Awaiting Spares','Work Pending','Client Side','In Progress','New');
        }
 	      
        global $where1,$where2,$where3,$wherevalue1,$wherevalue2,$wherevalue3;
        if($keyword!=""){
          $where1="ven.company_name";
          $where2="pr.product_name";
          $where3="shipment.awb_no";

          $wherevalue1='%'.$keyword.'%';
          $wherevalue2='%'.$keyword.'%';
          $wherevalue3='%'.$keyword.'%';
        }
        else{
          $where1="ven.company_name";
          $where2="pr.product_name";
          $where3="shipment.awb_no";

          $wherevalue1='%%';
          $wherevalue2='%%';
          $wherevalue3='%%';
        }

        if($end_limit!=0){
          $shipment_details = DB::table('shipment')
                                 // ->select('shipment.awb_no')
                                 ->select('shipment.*','shipment.contact_no','ven.name','ven.mobile_no','pr.product_name','ven.primary_address','ven.landmark','ven.company_name','pi.name as prioriy_name','pi.value as priority_value','pi.priority_color',DB::raw('date_format(shipment.updated_at,"%d-%c-%Y") as updated_modified')
                                  ,DB::raw('date_format(shipment.updated_at,"%d %b,%Y | %h:%i %p") as updated_modified_time'))
                                 ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id')
                                 //->join('address as da', 'da.id', '=', 'shipment.drop_address_id')
                                 ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                 ->join('priority as pi','pi.id','=','shipment.new_priority')
                                 ->where('shipment.biker_id',$id)
                                 ->where('shipment.delivery_status','<>','Closed')
                                 ->where('shipment.delivery_status','<>','Cancelled')
                                 ->Where(function ($query) {
                                              global $where1,$where2,$where3,$wherevalue1,$wherevalue2,$wherevalue3;
                                                $query->orWhere($where1,'like',$wherevalue1)
                                                       ->orWhere($where2,'like',$wherevalue2)
                                                       ->orWhere($where3,'like',$wherevalue3);
                                            })                                                                                                                            
                                 ->whereIn('shipment.delivery_status',$new_status)
                                // ->where('shipment.delivery_status','<>','Delivered_Open box')
                                // ->where('shipment.delivery_status','<>','Delivered_card on delivery')
                                 //->where('shipment.delivery_status','<>','RTN Delivered')
                                 ->orderBy('pi.value')
                                 ->orderBy('updated_at', 'DESC')
                                 ->skip($start_limit)->take($end_limit)

                                 //->join('shipment_packages as sp','sp.shipment_id', '=', 'shipment.id')
                                 
                                 ->get();

                                 // dd($shipment_details);die();
      }
      else{
          $shipment_details = DB::table('shipment')
                                 // ->select('shipment.awb_no')
                                 ->select('shipment.*','shipment.contact_no','ven.name','ven.mobile_no','pr.product_name','ven.primary_address','ven.landmark','ven.company_name')
                                 ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id')
                                 //->join('address as da', 'da.id', '=', 'shipment.drop_address_id')
                                 ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                 ->where('shipment.biker_id',$id)
                                 ->where('shipment.delivery_status','<>','Closed')
                                 ->where('shipment.delivery_status','<>','Cancelled')
                                // ->where('shipment.delivery_status','<>','Delivered_Open box')
                                // ->where('shipment.delivery_status','<>','Delivered_card on delivery')
                                 //->where('shipment.delivery_status','<>','RTN Delivered')
                                 ->orderBy('updated_at', 'DESC')
                                 

                                 //->join('shipment_packages as sp','sp.shipment_id', '=', 'shipment.id')
                                 
                                 ->get();        
      }                           
     
                             /* foreach ($shipment_details as $key => $value) {
                                   $item=$value;
                                    $item2=$value;
                                   foreach ($item as $key1 => $value1) {
                                         $newval=addslashes($value1);
                                          $item2->$key1=$newval;
                                   }
                                    $new_shipment_details[]=$item2;
                               } 
                              */
                               return response()->json($shipment_details);
    }     

//gj
  public function getallservicehistory($id)
      {
        
        $input = $_REQUEST;  
        $shipment_details = DB::table('shipment')
                               
                               ->select('shipment.awb_no','shipment.delivery_status','shipment.service_description','shipment.priority','shipment.service_type','shipment.remark','shipment.updated_at','shipment.contact_no','ven.name','ven.mobile_no','pr.product_name','ven.primary_address','ven.landmark','ven.company_name','bk.id as tech_id','bk.first_name as tech_firstname','bk.last_name as tech_lastname','bk.mobile as tech_mobile','r.app','r.technician','r.desc'
                                ,DB::raw('date_format(shipment.updated_at,"%d-%c-%Y") as updated_modified') 
                               // ,DB::raw('date_format(shipment.updated_at,"%d-%c-%Y")')
                                // ,DB::raw('date_format(shipment.updated_at,"%d %b,%Y | %h:%i %p") as updated_modified_time')
                                )
                               ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id') 
                               ->join('products as pr','pr.id', '=', 'shipment.product_id')
                               ->leftJoin('bikers as bk','bk.id','=','shipment.biker_id')
                               ->leftjoin('rating as r','r.awd', '=', 'shipment.awb_no')
                               ->where('shipment.biker_id',$id)   
                               ->orderBy('updated_at', 'DESC') 
                               //->limit(20)
                               ->get(); 

                               return response()->json($shipment_details);
    }       
//gj 
  
  public function profilestatus($id){
    $bikers = DB::table('bikers')
                               ->select('*')
                 ->where('id','=',$id)
                               ->first();
                 
      //$n = count($shipment_details);        
      $status = $bikers->profile_status;
      
                return response()->json($status);
  }

    public function getTechnicianStatus($id)
    {
	$technicianDetails = DB::table('shipment')
                               
                               ->select(DB::raw('COUNT(delivery_status) as cntStatus'),'shipment.delivery_status')
                               ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id')                               
                               ->join('products as pr','pr.id', '=', 'shipment.product_id')
                               ->where('shipment.biker_id',$id)
                               ->where('delivery_status','!=','"Cancelled"')
								->where('delivery_status','!=','"Closed"')
							   ->groupBy('delivery_status')                               
                               
                               ->get();
							   		
            return response()->json($technicianDetails);
    }   
    
  public function prevLocationUpdate(Request $request)
      {
  
         $input = $request->all();
         
         $tmp_str_bikerid=$input['bikerid'];
         
         $tmp_arr_latitude=explode(",",$input['latitude']);
         $tmp_arr_longitude=explode(",",$input['longitude']);
         $tmp_arr_time=explode(",",$input['time']);
        
         $cnt=count($tmp_arr_latitude);
   
                 //   $file = fopen('/var/www/html/apniAMC-website/demo/public_html/app/Http/Controllers/Api/apitext.txt', 'a+');
                //   fwrite($file,"count is ".$cnt);
         for($i=0;$i<$cnt;$i++)
         {
            $id=$tmp_str_bikerid;
            $currlat=$tmp_arr_latitude[$i];
            $currlng=$tmp_arr_longitude[$i];
            $date_time=$tmp_arr_time[$i];
  // fwrite($file,"innnnnn".$currlat);    
  if($currlat!='')
  {                      
                   //  fwrite($file,"doneeee");     
                 $Location_Update = DB::table('biker_location')
                           ->insert(['biker_id' => $id,'latitude' => $currlat,'longitude' => $currlng,'date_time'=>urldecode($date_time)]);
                           

  
        }
        
      }
     // fclose($file);
       return response()->json(['success' => 0]);
      //  return response()->json(['success' => 1]);
    }
   public function LocationUpdate($id,$currlat,$currlng,$date_time,$service_reqID="",$service_status="")
    {
      
      $Location_Update = DB::table('biker_location')
                         ->insert(['biker_id' => $id,'latitude' => $currlat,'longitude' => $currlng,'date_time'=>$date_time,'service_awb_no'=>$service_reqID,'status'=>$service_status]);
      return response()->json(['success' => 0]);
    }

   public function storesign1(Request $request)
   { 
    $input = $request->all(); 
$insertImageSQL = $insertDocumentSQL = $insertAudioSQL = '';
     
if ($input['uploaded_images'] !='')
{
$uploaded_images = explode(',',$input['uploaded_images']);
}
$allowImageTypes = array('jpg','png','jpeg','gif');

if ($input['uploaded_documents'] !='')
{
$uploaded_documents = explode(',',$input['uploaded_documents']);
}
$allowDocumentTypes = array('doc','docx','pdf');

if ($input['uploaded_audio'] != '')
{//echo $input['uploaded_audio']; 
$uploaded_audio = explode(',',$input['uploaded_audio']);
} //echo "<pre>";print_r($uploaded_audio);die;
$allowAudioTypes = array('mp3');


 
    $binary = base64_decode($input['base64']);
     
    header('Content-Type: bitmap; charset=utf-8');
    $filename = time().'_'.$input['ImageName'];
    $path = 'uploads/images/'.$filename;
    $file = fopen('uploads/images/'.$filename, 'w');
    $sdate = Carbon::now();
    fwrite($file, $binary);
    if (fclose($file)) {

//upload image to database 

if ( !empty($uploaded_images) )
{  
		//echo $uploaded_images_path = $input['uploaded_images'];
$c_uploaded_images = count($uploaded_images);
foreach( $uploaded_images as $key=>$value)
{
  $file_path = $value; 
$fileType = pathinfo($file_path,PATHINFO_EXTENSION);

if(in_array($fileType, $allowImageTypes))
{
	if ($c_uploaded_images == 1 || $key+1 == $c_uploaded_images)  
	{
		$insertImageSQL .= $file_path;
	}
	else
	{
		$insertImageSQL .= $file_path.",";
	}
  

}
}
   
}
//echo $insertImageSQL;die;
if(!empty($insertImageSQL))
{  
            // Insert image file name into database
            $insertImageSQL = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.uploaded_images'=>$insertImageSQL]);
}
//upload image to database

//upload documnet t database
if ( !empty($uploaded_documents) )
{  
		//echo $uploaded_images_path = $input['uploaded_images'];
foreach( $uploaded_documents as $key=>$value)
{
$file_path = $value; 
$fileType = pathinfo($file_path,PATHINFO_EXTENSION);
if(in_array($fileType, $allowDocumentTypes))
{
  $insertDocumentSQL .= $file_path;

}
}
   
}
if(!empty($insertDocumentSQL))
{  
            // Insert document file name into database
            $insertDocumentSQL = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.uploaded_documents'=>$insertDocumentSQL]);
}
//upload documnet to database

//upload audio to database
if ( !empty($uploaded_audio) )
{  
		//echo $uploaded_images_path = $input['uploaded_images'];
foreach( $uploaded_audio as $key=>$value)
{
$file_path = $value; 
$fileType = pathinfo($file_path,PATHINFO_EXTENSION);
if(in_array($fileType, $allowAudioTypes))
{
  $insertAudioSQL .= $file_path;

}
}
   
}
//Checklist code start

    if($input['checklist']!='[]'){
      
      // return response()->json(['success' => 'inn']);

      $checklist = $input['checklist'];

      $checklist1 = json_decode($checklist);


      $today = Carbon::now();
      $ab = '';
      $abc = '';

     foreach ($checklist1 as $value) {
       # code...
      foreach ($value as $key => $value1) {
        # code...
        if($key == 'id')
          $check_list_id = $value1;

        if($key == 'value')
           $abc = $value1;
        
      }
      $ab .= ','.$abc;
     }
     $ab = substr($ab, 2);
      $array_checklist = array(
                          "biker_id" => $input['id'],
                          "awb_no" => $input['awb'],
                          "checklist_id" => $check_list_id,
                          "selected_checklist" => $ab,
                          "created_at" => $today,
                          "status" => 'Active',
      );
      $checklist_update = DB::table('checklist_update')               
                      ->insert($array_checklist);     

    }
      // return response()->json(['success' => 'out']);

    //End Checklist code

if(!empty($insertAudioSQL))
{   
            // Insert audio file name into database
            $insertAudioSQL = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.uploaded_audio'=>$insertAudioSQL]);
}
//upload audio to database

      $status = $input['status'];
      $remark = ($input['remark']); 
      $expense = $input['expense'];  
      $expense_description = $input['expense_description'];  
      $ImagePath = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      //->update(['shipment.receiver_sign'=>$path,'shipment.sign_date'=>$sdate,'shipment.delivery_status'=>$status,'shipment.service_action'=>$remark]);
			->update(['shipment.receiver_sign'=>$path,'shipment.sign_date'=>$sdate,'shipment.delivery_status'=>$status,'shipment.service_action'=>$remark,'shipment.expense'=>$expense,'shipment.expense_description'=>$expense_description]);

        $shipment_id = DB::table('shipment')
                         ->select('shipment.id')
                         ->where('awb_no',$input['awb'])
                         ->first();  

        $updateshipment_history_id = DB::table('shipment_status_history')               
                      ->insertGetId(['shipment_id' => $shipment_id->id,'biker_id' => $input['id'],'by_whom_id' => $input['id'],'by_whom_role' => "bikers",'status' => $status,'date_time' => $sdate,'created_at'=>$sdate,'updated_at'=>$sdate]);           

        $updateshipment_history = DB::table('shipment_remark_history')               
                      ->insert(['shipment_status_id'=>$updateshipment_history_id,'shipment_id' => $shipment_id->id,'biker_id' => $input['id'],'remark' => $remark,'date_time' => $sdate,'sign'=>$path]);     

        $updateremarkmehul = DB::table('shipment')
                            ->where('id',$shipment_id->id)
                            ->update(['remark' =>$remark]);

$quantity = explode(",", $input['quantity']);
$inventory_id = explode(",", $input['inventory_id']);
$combine_array = array_combine($inventory_id,$quantity);
foreach($combine_array as $key=>$value) 
{   
  $inventory_store = DB::table('inventory_store')               
                      ->insert(['awb_no'=>$input['awb'],'inventory_id' => $key,'biker_id' => $input['id'],'quantity' => $value]);
}     
	return response()->json(['success' => 0]);

    } else {
      return response()->json('failure');
    }
}

   public function storesign(Request $request)
   { 
    $input = $request->all(); 
$insertImageSQL = $insertDocumentSQL = $insertAudioSQL = '';
     
if ($input['uploaded_images'] !='')
{
$uploaded_images = explode(',',$input['uploaded_images']);
}
$allowImageTypes = array('jpg','png','jpeg','gif');

if ($input['uploaded_documents'] !='')
{
$uploaded_documents = explode(',',$input['uploaded_documents']);
}
$allowDocumentTypes = array('doc','docx','pdf');

if ($input['uploaded_audio'] != '')
{//echo $input['uploaded_audio']; 
$uploaded_audio = explode(',',$input['uploaded_audio']);
} //echo "<pre>";print_r($uploaded_audio);die;
$allowAudioTypes = array('mp3');


 
    $binary = base64_decode($input['base64']);
     
    header('Content-Type: bitmap; charset=utf-8');
    $filename = time().'_'.$input['ImageName'];
    $path = 'uploads/images/'.$filename;
    $file = fopen('uploads/images/'.$filename, 'w');
    $sdate = Carbon::now();
    fwrite($file, $binary);
    if (fclose($file)) {

//upload image to database 

if ( !empty($uploaded_images) )
{  
    //echo $uploaded_images_path = $input['uploaded_images'];
$c_uploaded_images = count($uploaded_images);
foreach( $uploaded_images as $key=>$value)
{
  $file_path = $value; 
$fileType = pathinfo($file_path,PATHINFO_EXTENSION);

if(in_array($fileType, $allowImageTypes))
{
  if ($c_uploaded_images == 1 || $key+1 == $c_uploaded_images)  
  {
    $insertImageSQL .= $file_path;
  }
  else
  {
    $insertImageSQL .= $file_path.",";
  }
  

}
}
   
}
//echo $insertImageSQL;die;
if(!empty($insertImageSQL))
{  
            // Insert image file name into database
            $insertImageSQL = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.uploaded_images'=>$insertImageSQL]);
}
//upload image to database

//upload documnet t database
if ( !empty($uploaded_documents) )
{  
    //echo $uploaded_images_path = $input['uploaded_images'];
foreach( $uploaded_documents as $key=>$value)
{
$file_path = $value; 
$fileType = pathinfo($file_path,PATHINFO_EXTENSION);
if(in_array($fileType, $allowDocumentTypes))
{
  $insertDocumentSQL .= $file_path;

}
}
   
}
if(!empty($insertDocumentSQL))
{  
            // Insert document file name into database
            $insertDocumentSQL = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.uploaded_documents'=>$insertDocumentSQL]);
}
//upload documnet to database

//upload audio to database
if ( !empty($uploaded_audio) )
{  
    //echo $uploaded_images_path = $input['uploaded_images'];
foreach( $uploaded_audio as $key=>$value)
{
$file_path = $value; 
$fileType = pathinfo($file_path,PATHINFO_EXTENSION);
if(in_array($fileType, $allowAudioTypes))
{
  $insertAudioSQL .= $file_path;

}
}
   
}
if(!empty($insertAudioSQL))
{   
            // Insert audio file name into database
            $insertAudioSQL = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.uploaded_audio'=>$insertAudioSQL]);
}
//upload audio to database

      $status = $input['status'];
      $remark = ($input['remark']); 
      $expense = $input['expense'];  
      $expense_description = $input['expense_description'];  
      $ImagePath = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      //->update(['shipment.receiver_sign'=>$path,'shipment.sign_date'=>$sdate,'shipment.delivery_status'=>$status,'shipment.service_action'=>$remark]);
      ->update(['shipment.receiver_sign'=>$path,'shipment.sign_date'=>$sdate,'shipment.delivery_status'=>$status,'shipment.service_action'=>$remark,'shipment.expense'=>$expense,'shipment.expense_description'=>$expense_description]);

        $shipment_id = DB::table('shipment')
                         ->select('shipment.id')
                         ->where('awb_no',$input['awb'])
                         ->first();  

        $updateshipment_history_id = DB::table('shipment_status_history')               
                      ->insertGetId(['shipment_id' => $shipment_id->id,'biker_id' => $input['id'],'by_whom_id' => $input['id'],'by_whom_role' => "bikers",'status' => $status,'date_time' => $sdate,'created_at'=>$sdate,'updated_at'=>$sdate]);           

        $updateshipment_history = DB::table('shipment_remark_history')               
                      ->insert(['shipment_status_id'=>$updateshipment_history_id,'shipment_id' => $shipment_id->id,'biker_id' => $input['id'],'remark' => $remark,'date_time' => $sdate,'sign'=>$path]);     

        $updateremarkmehul = DB::table('shipment')
                            ->where('id',$shipment_id->id)
                            ->update(['remark' =>$remark]);

$quantity = explode(",", $input['quantity']);
$inventory_id = explode(",", $input['inventory_id']);
$combine_array = array_combine($inventory_id,$quantity);
foreach($combine_array as $key=>$value) 
{   
  $inventory_store = DB::table('inventory_store')               
                      ->insert(['awb_no'=>$input['awb'],'inventory_id' => $key,'biker_id' => $input['id'],'quantity' => $value]);
}     
  return response()->json(['success' => 0]);

    } else {
      return response()->json('failure');
    }
}

 public function storesignios(Request $request)
  {
    $input = $request->all();
    $binary = base64_decode($input['base64']);
    header('Content-Type: bitmap; charset=utf-8');
    $filename = time().'_'.$input['ImageName'];
    $path = 'uploads/images/'.$filename;
    $file = fopen('uploads/images/'.$filename, 'w');
    $sdate = Carbon::now();
    fwrite($file, $binary);
    if (fclose($file)) {
      $status = $input['status'];
      $remark = $input['remark'];
      $ImagePath = DB::table('shipment')
                      ->where('awb_no',$input['awb'])               
                      ->update(['shipment.receiver_sign'=>$path,'shipment.sign_date'=>$sdate,'shipment.delivery_status'=>$status,'shipment.remark'=>$remark]);
                       return response()->json(['success' => 1]);

    } else {
      return response()->json('failure');
    }
}

     public function gcmregid(Request $request)
  {
    $input = $request->all();
    

    //New code
       $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
        //$ios_token = ($is_ios) ? $regId : '';

        if($is_ios)
        {
          
          $ios_token=(isset($input['regId'])?$input['regId']:'');
          
          $gcm_regid = DB::table('bikers')
                 ->where('bikers.id',$input['id'])
                 ->update(['bikers.ios_token' => $ios_token]);
                 return response()->json(['success' => 0]);
        }
        else
        {
          $regid = $input['regId'];
          $gcm_regid = DB::table('bikers')
                 ->where('bikers.id',$input['id'])
                 ->update(['bikers.gcm_regid' => $regid]);
                 return response()->json(['success' => 0]);
        }
    //New code
        //148.66.155.98
        //sadhna 173.201.96.1
        //error_reporting(E_ALL);
        //ini_set('display_errors', 1);

  }

  public function gcmregidvendor(Request $request)
  {
    $input = $request->all();
    

    //New code
       $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
        //$ios_token = ($is_ios) ? $regId : '';

        if($is_ios)
        {
          
          $ios_token=(isset($input['regId'])?$input['regId']:'');
          
          $gcm_regid = DB::table('vendor')
                 ->where('vendor.id',$input['id'])
                 ->update(['vendor.ios_token' => $ios_token]);
                 return response()->json(['success' => 0]);
        }
        else
        {
          $regid = $input['regId'];
          $gcm_regid = DB::table('vendor')
                 ->where('vendor.id',$input['id'])
                 ->update(['vendor.gcm_regid' => $regid]);
                 return response()->json(['success' => 0]);
        }
  }


public function resetpassword($bikerid,$password){


   $resetpassword = DB::table('bikers')
                     ->where('bikers.id',$bikerid)
                         ->update(['bikers.password' => bcrypt($password)]);
                          return response()->json(['success' => 0]);

}




public function resetpassword1($bikerid,$password){

     $resetpassword = DB::table('vendor')
                     ->where('vendor.id',$bikerid)
                         ->update(['vendor.password' => bcrypt($password)]);
                          return response()->json(['success' => 0]);
}



public function apiforgetpassword($email){

    //echo $email;

    $vendor = DB::table('vendor')
             ->select ('*')
       ->where('email',$email)
       ->where('deleted_at','=','N')
             ->get();
       //print_r($vendor);
      $n = count($vendor);
       if($n == 0){
       return response()->json(['success' => 0]);
       }else{
       
       //echo $email;
       
       foreach($vendor as $v){
        $name = $v->email;
        $id = $v->id;
        $client_type = $v->client_type;
       }
       $emailcontent = array (
            'email' => $email,
            'password' => substr(md5($email.time()), 5, 10),
            'name' => $name,
            'client_type' => $client_type
            );
      
      // print_r($emailcontent);
      // $cname = config('constants.company_name');
      // $sb = "Welcome to ".$cname."!";
                 
            Mail::send('emails.vendorwelcomereset', $emailcontent, function ($message) use ($email) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
//$message->from('support@vallabhenterprises.com', 'Vallabh Enterprises');
                $message->to($email)->subject(Config::get('app.companyname').'Reset Password');
            });
            //$pwd = bcrypt(substr(md5($email.time()), 5, 15));
            $plain = substr(md5($email.time()), 5, 10);
            $pwdnew = Hash::make($plain);
      $resetpassword = DB::table('vendor')
                     ->where('vendor.id',$id)
                           ->update(['vendor.password' => $pwdnew,'vendor.plain_password'=>$plain,'vendor.pwd'=>$plain]);
                          //return response()->json(['success' => 0]);
                          return response()->json(['success' => 1]);
    }
}



public function VendorRegistration(Request $request)
    {
      $input = $request->all();
      //var_dump($input);exit;
      $mobile_no = DB::table('vendor')
                         ->select('mobile_no')
             ->where('deleted_at','=','N')
                         ->get();

      $email_check = DB::table('vendor')
                         ->select('email')
             ->where('deleted_at','=','N')
                         ->get();
       $today = Carbon::now();   
         //Email array          
      $email_array = array();
      foreach ($email_check as $key => $value) {
        //$email_array[] = $value->email;
      }
        //Mobile array   
      $mobile_array = array();
      foreach ($mobile_no as $key => $value) {
        $mobile_array[] = $value->mobile_no;
      }
          
      if (in_array($input['mobile'], $mobile_array))
      {
        return response()->json(['success' => 0]);
      }
      else {
        if (in_array($input['email'], $email_array)) {
          return response()->json(['success' => 1]);
        }
        else{
          $vendor_regis = DB::table('vendor')
          ->insert(['name' => $input ['username'],'email'=>$input ['email'],'password'=>bcrypt($input ['pass']),'mobile_no'=>$input ['mobile'],'landline_no'=>$input ['landline'],'status'=> "In Active",'ctype'=>'Mobile','created_at'=>$today,'updated_at'=>$today,'company_name'=>$input['cname'],'landmark'=>$input['landmark'],'city'=>$input['city'],'pin_code'=>$input['pincode'],'primary_address'=>$input['address'],'gcm_regid'=>$input['regid']]);
      $emailcontent = array (
            'email' => $input ['email'],
            'name' => $input ['cname']
            );
    $cname = config('constants.company_name');
    $sb = 'Welcome to '.$cname.'!';
        Mail::send('emails.vendorwelcome1', $emailcontent, function ($message) {  
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
            $message->to(Config::get('app.toemail'))->subject(Config::get('app.companyname').' New Customer Registration');
           
        });

          return response()->json(['success' => 2]);
        }
      }
    }

    public function storerma(Request $request)
    {
      $input = $request->all();
      //var_dump($input);exit;
      if($input)
      {
        $today = Carbon::now();   

        foreach($input as $key=>$val)
        {
          $newval = str_replace("'", "\'", $val);
          $input[$key] = $newval;
        }
         
          $vendor_regis = DB::table('rma_service')
          ->insert(['model_no' => $input ['model_no'],'serial_no'=>$input ['serial_no'],'product_name'=>$input ['product_name'],'product_descp'=>$input ['product_descp'],'rma_type'=>$input ['rma_type'],'created_at'=>$today,'updated_at'=>$today,'biker_id'=>$input['biker_id'],'shipment_id'=>$input['shipment_id'],'biker_name'=>$input['biker_name'],'client_name'=>$input['client_name'],'status'=>$input['status'],'standbydevice'=>$input['standbydevice'],'standbyserialno'=>$input['standbyserialno'],'standbymodelno'=>$input['standbymodelno']]);

          return response()->json(['success' => 1]);
      }
      else
      {
        return response()->json(['success' => 0]);
      }
       

    //   $emailcontent = array (
    //         'email' => $input ['email'],
    //         'name' => $input ['cname']
    //         );
    // $cname = config('constants.company_name');
    // $sb = 'Welcome to '.$cname.'!';
    //     Mail::send('emails.vendorwelcome1', $emailcontent, function ($message) {  
    //             $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
    //             $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
    //         $message->to(Config::get('app.toemail'))->subject(Config::get('app.companyname').' New Customer Registration');
           
    //     });

          
        
      
    }

    public function getrma($sid)
    {
      //$input = $request->all();
      //var_dump($input);exit;
      //$biker_id = isset($_REQUEST['bid']) ? $_REQUEST['bid'] : 0;
      //$shipment_id = isset($_REQUEST['sid']) ? $_REQUEST['sid'] : '';

      $shipment_id = isset($sid) ? $sid : '';
      
      
      $today = Carbon::now();   
        
      $rma_details = DB::table('rma_service')
                               
                               ->select('rma_service.model_no','rma_service.serial_no','rma_service.product_name','rma_service.product_descp','rma_service.rma_type','rma_service.shipment_id'
                                ,DB::raw('date_format(rma_service.updated_at,"%d-%c-%Y") as updated_at')
                              )
                               ->where('rma_service.shipment_id',$shipment_id)   
                               ->orderBy('rma_service.updated_at', 'DESC') 
                               //->limit(20)
                               ->get(); 

        
        if($rma_details)
        {
          foreach($rma_details as $keymain=>$valmain)
          {
            foreach($valmain as $key=>$val)
            {
               $newval = str_replace("\'","'",$val);
               $valmain->$key = $newval;
            }
          }
        }
        // $resp = response()->json($rma_details);
        // echo $resp;
        // die;
        return response()->json($rma_details);

      
    }


      public function getSupportNo()
      {
       // return Config::get('app.companySupport');
        return response()->json(['success' => 1, 'number' => Config::get('app.companySupport')]);
      }


public function getVendorDetailApi($id)
    {  
       $vendor = DB::table('vendor')
             ->select ('company_name','landline_no','primary_address','secondary_address','landmark','city','state','pin_code','name')
              ->where('id',$id)
              ->first();
              
              return response()->json(['success' => 1, 'vendor' => $vendor]);
              
    }

     public function VendorApiUpdateRegistration(Request $request)
    {
      $input = $request->all();
      $vendor_id  =  $input['id'];  

       $states = DB::table('state')
                 ->select('*')
               ->where("name",'=',$input['state'])
                ->get();   

    if($states)
    {              
      $vendor_regis = DB::table('vendor')
                      ->where('id',$input['id']) 
                      ->update(['name' => $input ['username'],'landline_no'=>$input['landline'], 'company_name'=>$input['cname'],'landmark'=>$input['landmark'],'city'=>$input['city'],'pin_code'=>$input['pincode'],'primary_address'=>$input['primary_address'],'secondary_address'=>$input['secondary_address'],'state'=>$input['state']]);
                     
                    // return response()->json(['success' => 1, 'vendor' => $vendor_regis]);
                      return response()->json(['success' => 1]);
    }     
     else 
     {
       return response()->json(['success' => 2]);
     }            
              // $vendors = DB::table('vendor')
              // ->select('*')
              // ->where("id",'=',$input['id'])
              // ->get();   
        //echo "<pre>"; print_r($vendor);die;
        // $states = DB::table('state')->get();
        // foreach($states as $state) {
        //   if($state->name == $input['state'])
        //     {
        //          return response()->json(['success' => 1]);
        //      }
        //      else 
        //      {
        //        return response()->json(['success' => 2]);
        //      }
        // }
    } 
//gj

    public function testemail()
    {

       
        echo "done";
    }

    public function ValidateVendor(Request $request)
     {
        //echo '<pre>'; print_r("hii"); exit;
        $input = $request->all();
        

    //echo $input['username'];die;
        $vendor = DB::table('vendor')
             ->select ('*')
             ->where('email', $input['username'])
             //->where('status','=','Active')
       ->where('client_type','=','C')
       ->where('deleted_at','=','N')
             ->first();
    //print_r($vendor);
        //die;
    if($vendor) {
    //echo Hash::make($input['password']);die;
          if (Hash::check($input['password'], $vendor->password)){
      //echo "in";die;
        //    if(!empty($input['regId'])){
          //  $update_regid = DB::table('vendor')
     //                     ->where('id',$vendor->id)
     //                     ->update(['gcm_regid' => $input['regId']]);
          // }
if($vendor->status == 'In Active') {  
                  return response()->json(['success' => 2]); 
                }

             $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
                  //$ios_token = ($is_ios) ? $regId : '';

              if($is_ios)
              {
                $ios_token=(isset($input['ios_token'])?$input['ios_token']:'');
                $update_regid = DB::table('vendor')
                         ->where('id',$vendor->id)
                         ->update(['ios_token'=>$ios_token]);
                     
                     return response()->json(['success' => 1, 'vendor' => $vendor]);
                     die;
              }
              else
              {
                $regId=(isset($input['regId'])?$input['regId']:'');
                $update_regid = DB::table('vendor')
                         ->where('id',$vendor->id)
                         ->update(['gcm_regid' => $regId]);
                     return response()->json(['success' => 1, 'vendor' => $vendor]);
                     die;
              }
                   
                        
            
            }


else{
      //echo "out";die;
              return response()->json(['success' => 0]);   // if password is incorrect or biker is deactive 
             }
         }else{
     //echo "out1";die;
     return response()->json(['success' => 0]);
     }  

     }

     public function getproductlist(){
       $products = DB::table('products')
       ->select('*')
       ->get();
        return response()->json($products);
       }
     
     public function getvendorlist(){
       $products = DB::table('vendor')
             ->where('deleted_at','=','N')
          ->orderBy('company_name','asc')
                    ->get(); 
        return response()->json($products);
       }

    public function servicerequest(Request $request)
       {
        $input = $request->all();

       // print_r($input);

    $vid = $input['vendor_id'];
    if($vid != ""){
    $product_code = DB::table('products')
                       ->select('products.product_code','products.id')
                       ->where('products.product_name','=',$input['product'])
                       ->first();
               
       $awb_date = Carbon::now()->format('dmYHis');
       $date = Carbon::now();

       $awb_no = "SUPP".$awb_date.$product_code->product_code;

            $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$input['vendor_id'])
                       ->first();
      $vname = $vinfo->name;
      $vemail = $vinfo->email;
      $vmob = $vinfo->mobile_no;
      $vpwd = $vinfo->plain_password;
      $ctype = "Mobile App - ".$vname;
      //send sms
    $m1 = $vinfo->mobile_no;

    $service = DB::table('shipment')
          ->insertGetId(['vendor_id' => $input['vendor_id'],'product_id'=>$product_code->id,'nature_issue'=>$input['issue'],'service_description'=>base64_decode($input['description']),'awb_no'=>$awb_no,'created_at'=>$date,'updated_at'=>$date,'delivery_status'=>"New",'order_time'=>$date,'created_type'=>$ctype,'created_by'=>'Customer','service_type'=>'Complain','mobno'=>$vmob]);
    //update ticket no
        $serviceid = $service;
        //update ticket no
        $awb_no = Config::get('app.ticketprefix').$serviceid;
        $servicelist = VendorShipment::find($serviceid);
        $servicelist->awb_no = $awb_no;
        $servicelist->save();
        //update ticket no
    
    $st = str_replace(' ', '%20', $awb_no);
    $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20complaint%20has%20been%20registered,Complaint No.$st,%20Your%20Complaint%20Will%20Attend%20Shortly.For%20further%20assistance%20pls%20call%208080922970.&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
      $client1 = new \GuzzleHttp\Client();
      //$this->response = $client1->get($link1)->getBody()->getContents();
    //end
       
     
    //mail start

      $enquiry_message = $input['issue']." For Product ".$input['product']." with complain( ".base64_decode($input['description']).").";
       $emailcontent = array (
           'email'=>$vemail,
         'password'=>$vpwd,
        'cno' => $awb_no
            );
      Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
         
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

      $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

        });
    //mail end
                return response()->json(['success' => 2]);
    }else{
    
    $product_code = DB::table('products')
                       ->select('products.product_code','products.id')
                       ->where('products.product_name','=',$input['product'])
                       ->first();
     $vendor_code = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.company_name','=',$input['issue'])
                       ->first();
          
    if(!empty($input['biker_id'])){
      $biker_code = DB::table('bikers')
                       ->select('*')
                       ->where('bikers.id','=',$input['biker_id'])
                       ->first();
      $bname = $biker_code->first_name." ".$biker_code->last_name;
    }
    
          $ctype = "Mobile App - ".$bname;     
       $awb_date = Carbon::now()->format('dmYHis');
       $date = Carbon::now();
    $vendorid = $vendor_code->id;
    $vendormob = $vendor_code->mobile_no;
       $awb_no = "SUPP".$awb_date.$product_code->product_code;

       //save
       $service = DB::table('shipment')
          ->insertGetId(['vendor_id' => $vendorid,'product_id'=>$product_code->id,'service_description'=>base64_decode($input['description']),'awb_no'=>$awb_no,'created_at'=>$date,'updated_at'=>$date,'delivery_status'=>"New",'order_time'=>$date,'created_type'=>$ctype,'created_by'=>'Technician','service_type'=>'Complain','mobno'=>$vendormob]);
      $serviceid = $service;
        //update ticket no
        $awb_no = Config::get('app.ticketprefix').$serviceid;
        $servicelist = VendorShipment::find($serviceid);
        $servicelist->awb_no = $awb_no;
        $servicelist->save();

       //save

     //send sms
    $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$vendorid)
                       ->first();
    $m1 = $vinfo->mobile_no;
    $st = str_replace(' ', '%20', $awb_no);
    $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20complaint%20has%20been%20registered,Complaint No.$st,%20Your%20Complaint%20Will%20Attend%20Shortly.For%20further%20assistance%20pls%20call%208080922970.&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
      $client1 = new \GuzzleHttp\Client();
      //$this->response = $client1->get($link1)->getBody()->getContents();
    //end
    
        //update ticket no
      //mail start
      
      $vname = $vinfo->name;
      $vemail = $vinfo->email;
      $enquiry_message = Config::get('app.companyname')." Technician(".$bname.") created ticket for you with the complain ".base64_decode($input['description'])." For Product ".$input['product'].".";
       $emailcontent = array (
           'cno' => $awb_no,
       'biker' =>$bname
            );
      Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

      $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

        });
    //mail end
          return response()->json(['success' => 2]);
      //        return response()->json(['product' => $input['product'],'cname'=>$input['issue'],'desc'=>$input['description'],'vid'=>$vendorid]);
    }

        

       }
    
    
          
 public function requesthistory(Request $request)
      {

        $input = $request->all();    

        $end_limit=(isset($input['end_limit'])?$input['end_limit']:0);
        $start_limit=(isset($input['start_limit'])?$input['start_limit']:0);
        $show_feedback=(isset($input['show_feedback'])?$input['show_feedback']:0);

        if($end_limit!=0){

            if($show_feedback==1){
              
              $service_details = DB::table('shipment')
                                     // ->select('shipment.awb_no')
                            ->select('shipment.id','priority','shipment.updated_at','shipment.awb_no','shipment.delivery_status',DB::raw('date_format(shipment.updated_at,"%d-%c-%Y") as updated_modified'),'shipment.service_description','pr.product_name','r.app')
                       ->join('products as pr','pr.id', '=', 'shipment.product_id')
                       ->leftjoin('rating as r','r.awd', '=', 'shipment.awb_no')
                                     ->where('shipment.vendor_id',$input['id'])
                                     ->where('shipment.delivery_status','Closed')
                                     ->whereNUll('r.app')
                                     ->orderBy('updated_at', 'DESC')
                                     ->skip($start_limit)->take($end_limit)
                                     ->get();
                                 return response()->json($service_details);
            }
            else{
              $service_details = DB::table('shipment')
                                   // ->select('shipment.awb_no')
                          ->select('shipment.id','priority','shipment.updated_at','shipment.awb_no','shipment.delivery_status',DB::raw('date_format(shipment.updated_at,"%d-%c-%Y") as updated_modified'),'shipment.service_description','pr.product_name','r.app')
                     ->join('products as pr','pr.id', '=', 'shipment.product_id')
                     ->leftjoin('rating as r','r.awd', '=', 'shipment.awb_no')
                                   ->where('shipment.vendor_id',$input['id'])
                                   ->orderBy('updated_at', 'DESC')
                                   ->skip($start_limit)->take($end_limit)
                                   ->get();
                               return response()->json($service_details);
            }
        }
        else{
            $service_details = DB::table('shipment')
                                   // ->select('shipment.awb_no')
                          ->select('shipment.id','shipment.updated_at','shipment.awb_no','shipment.delivery_status',DB::raw('date_format(shipment.updated_at,"%d-%c-%Y") as updated_modified'),'shipment.service_description','pr.product_name','r.app')
                                  ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                  ->leftjoin('rating as r','r.awd', '=', 'shipment.awb_no')
                                   ->where('shipment.vendor_id',$input['id'])
                                   ->orderBy('updated_at', 'DESC')
                                   ->get();
                               return response()->json($service_details);          

        }
    }       
 
  
      public function getServiceDetails($serviceId)
      {
        
        $remark = DB::table('shipment_remark_history')
                  ->select('remark')
                  ->where('shipment_id', $serviceId)
                  ->orderBy('date_time', 'DESC')->get();

        $remark1 =  $remark[0]->remark;  
        
        $shipment_details = DB::table('shipment')
                         ->select('shipment.*','shipment.contact_no','ven.name','ven.mobile_no','pr.product_name','ven.primary_address','ven.landmark','ven.company_name','bk.first_name as tech_firstname','bk.last_name as tech_lastname','bk.mobile as tech_mobile')
                         ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id')
                         
                         ->join('products as pr','pr.id', '=', 'shipment.product_id')
                         ->leftJoin('bikers as bk','bk.id','=','shipment.biker_id')
                         ->where('shipment.id',$serviceId)                                                                                                                                        
                         ->get();
        foreach ($shipment_details as $shipmentremark) 
        {
          $shipmentremark->remark=$remark1;
        }                 
        return response()->json($shipment_details);
    }
	public function amchistory($vendor_id)

      {

       // $vid = "73";
        //$input = $request->all();       
	$amc_details = DB::table('amcs')
                               ->select('amcs.start_date','amcs.end_date','amcs.service','pr.product_name')
                                ->join('products as pr','pr.id', '=', 'amcs.product_id')
                               ->where('amcs.vendor_id',$vendor_id)
                               ->get();							   
         $n = count($amc_details);

	return response()->json($amc_details);


		//return $vendor_id;
 
    }
  public function ValidateBiker(Request $request)
           {
             //echo '<pre>'; print_r("hii"); exit;
              $input = $request->all();
              //echo $input['username']; die;
              $biker = DB::table('bikers')
                   ->select ('*')
                   ->where('email', $input['username'])
        ->where('deleted_at','=',NULL)
                   ->first();
              if($biker) {
      
                  if ((Hash::check($input['password'], $biker->password)) && ($biker->status == 'Active')){
                          
               //  print_r($input);die;
      //$app_type=(isset($input['app_type'])?$input['app_type']:'A');
                
                  
                        $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
                        //$ios_token = ($is_ios) ? $regId : '';
      
                        if($is_ios)
                        {
                          $ios_token=(isset($input['ios_token'])?$input['ios_token']:'');
                          $update_status = DB::table('bikers')
                               ->where('id',$biker->id)
                               ->update(['profile_status' => "Available",'gcm_regid'=>'','ios_token'=>$ios_token]);
                               return response()->json(['success' => 1, 'biker' => $biker]);
                               die;
                        }
                        else
                        {
                          $regId=(isset($input['regId'])?$input['regId']:'');
                          $update_status = DB::table('bikers')
                               ->where('id',$biker->id)
                               ->update(['profile_status' => "Available",'gcm_regid'=>$regId]);
                               return response()->json(['success' => 1, 'biker' => $biker]);
                               die;
                        }
      
                          
                  
                  }else{
                    return response()->json(['success' => 0]);   // if password is incorrect or biker is deactive 
                   }       
              
                } else {
                  // if username is not find in Biker table. 
                    $substation = DB::table('users')
                            ->select ('*')
                            ->where('email', $input['username'])
                            ->where('role_id','2')
                            ->whereNull('deleted_at')
                            ->first();
                          
      
                      if($substation) {
                      $substation_id = DB::table('sub_station')
                            ->select ('*')
                            ->where('user_id', $substation->id)
                            ->whereNull('deleted_at')
                            ->first();
      
                        if ((Hash::check($input['password'], $substation->password))){
                          $shipment_all = DB::table('shipment')
                              ->select('shipment.*', 'pa.address as pickup_address','pa.city as pickup_city','pa.state as pickup_state','pa.pincode as pickup_pincode','pa.landmark as pick_landmark','da.address as drop_address','da.pincode as drop_pincode','da.city as drop_city','da.state as drop_state','da.landmark as drop_landmark','bu.contact_no as contact_drp','shipment.contact_no')
                              ->join('address as pa', 'pa.id', '=', 'shipment.pickup_address_id')
                              ->join('address as da', 'da.id', '=', 'shipment.drop_address_id')
                              ->join('buyer as bu','bu.id', '=', 'shipment.buyer_id')
                              ->where('sub_station_id', $substation_id->id)            
                              ->get();
      
                              return response()->json(['success' => 2, 'substation' => $shipment_all]);
                          }else{
                          return response()->json(['success' => 0]);   // if password is incorrect or biker is deactive
                          } 
                         } else {
                          return response()->json(['success' => 0]);  // if username does not exist in biker and substation both.
                          }
                         
                        }
    }

    public function ValidateBikerTest(Request $request)
      {
             //echo '<pre>'; print_r("hii"); exit;
              $input = $request->all();
              //echo $input['username']; die;
              $biker = DB::table('bikers')
                   ->select ('*')
                   ->where('email', $input['username'])
        ->where('deleted_at','=',NULL)
                   ->first();
              if($biker) {
      
                  if ((Hash::check($input['password'], $biker->password)) && ($biker->status == 'Active')){
                          
               //  print_r($input);die;
      //$app_type=(isset($input['app_type'])?$input['app_type']:'A');
                
                  
                        $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
                        //$ios_token = ($is_ios) ? $regId : '';
      
                        if($is_ios)
                        {
                          $ios_token=(isset($input['ios_token'])?$input['ios_token']:'');
                          $update_status = DB::table('bikers')
                               ->where('id',$biker->id)
                               ->update(['profile_status' => "Available",'gcm_regid'=>'','ios_token'=>$ios_token]);
                               return response()->json(['success' => 1, 'biker' => $biker]);
                               die;
                        }
                        else
                        {
                          $regId=(isset($input['regId'])?$input['regId']:'');
                          $update_status = DB::table('bikers')
                               ->where('id',$biker->id)
                               ->update(['profile_status' => "Available",'gcm_regid'=>$regId]);
                               return response()->json(['success' => 1, 'biker' => $biker]);
                               die;
                        }
      
                          
                  
                  }else{
                    return response()->json(['success' => 0]);   // if password is incorrect or biker is deactive 
                   }       
              
                } else {
                  // if username is not find in Biker table. 
                    $substation = DB::table('users')
                            ->select ('*')
                            ->where('email', $input['username'])
                            ->where('role_id','2')
                            ->whereNull('deleted_at')
                            ->first();
                          
      
                      if($substation) {
                      $substation_id = DB::table('sub_station')
                            ->select ('*')
                            ->where('user_id', $substation->id)
                            ->whereNull('deleted_at')
                            ->first();
      
                        if ((Hash::check($input['password'], $substation->password))){
                          $shipment_all = DB::table('shipment')
                              ->select('shipment.*', 'pa.address as pickup_address','pa.city as pickup_city','pa.state as pickup_state','pa.pincode as pickup_pincode','pa.landmark as pick_landmark','da.address as drop_address','da.pincode as drop_pincode','da.city as drop_city','da.state as drop_state','da.landmark as drop_landmark','bu.contact_no as contact_drp','shipment.contact_no')
                              ->join('address as pa', 'pa.id', '=', 'shipment.pickup_address_id')
                              ->join('address as da', 'da.id', '=', 'shipment.drop_address_id')
                              ->join('buyer as bu','bu.id', '=', 'shipment.buyer_id')
                              ->where('sub_station_id', $substation_id->id)            
                              ->get();
      
                              return response()->json(['success' => 2, 'substation' => $shipment_all]);
                          }else{
                          return response()->json(['success' => 0]);   // if password is incorrect or biker is deactive
                          } 
                         } else {
                          return response()->json(['success' => 0]);  // if username does not exist in biker and substation both.
                          }
                         
                        }
    }
    

         public function StatusUpdate($id,$status,$date_time)
    {
     
      $update_status = DB::table('bikers')
              ->where('id',$id)
              ->update(['profile_status' => $status,'updated_at' => $date_time]);
        
      return response()->json(['success' => 0]);
    }
           
           
  // for ios
  public function requesthistorynumber1($vendor_id,$tech_id)
  {
    
    $rating = DB::table('rating')
                               ->select('rating.app','rating.technician')
                               ->where('rating.vendor_id',$vendor_id)
                               ->where('rating.tech_id',$tech_id)
                               ->get();
      //$arr = array('app'=>$rating->app,'tech'=>$rating->technician);
      return response()->json($rating);
  }
    public function requesthistorynumber2(Request $request)
          {
            $input = $request->all();
    
    		if(!empty($input['rating1'])){
    			$rating = DB::table('rating')
    								   ->select('*')
    								   ->where('rating.awd',$input['awd'])
    								   ->get();
    			$vinfo = DB::table('vendor')
                           ->select('*')
                           ->where('vendor.id','=',$input['vendor_id'])
                           ->first();
    			$vname = $vinfo->name;
    			$ctype = "Mobile App - ".$vname;
    			//$today = Carbon::today();
          $today = date('Y-m-d H:i:s');
    			//$today1 = substr($today,0,10);
          $today1 = date('Y-m-d');
    		   $n = count($rating);
    		   
    		   $notification = DB::table('rating')               
    						  ->insert(['vendor_id' => $input['vendor_id'],'app'=>$input['rating1'],'technician'=>$input['rating2'],'tech_id'=>$input['tech_id'],'awd'=>$input['awd'],'created_by'=>$ctype,'cdate'=>$today1,'desc'=>base64_decode($input['remark']),'created_at'=>$today,'updated_at'=>$today]);   
    		   	
    			
    			return response()->json(['success' => 1]);
    		}else{
    		$rating_details =  DB::table('rating')
                                   ->select('rating.app','rating.technician','rating.desc')
                                   ->where('rating.awd',$input['service_number'])
                                   ->get();
    		$service_id = DB::table('shipment')
                                   ->select('shipment.*','pr.product_name')
                                    ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                   ->where('shipment.awb_no',$input['service_number'])
                                   ->orderBy('updated_at', 'DESC')
                                   ->get();
    	
          /*  $service_details = DB::table('shipment')
                                   ->select('*')
                                   ->where('shipment.awb_no',$input['service_number'])
                                   ->orderBy('updated_at', 'DESC')
                                   ->first();*/
    
             foreach($service_id as $service)
             {
               $biker_id = $service->biker_id;
                $vendor_id = $service->vendor_id;
               //echo "remarks are".$service->remark;
               $service->remark = base64_encode($service->remark);
             }
            
            //Checklist Code start
               foreach ($service_id as $value1) {
                  $checklist_id = $value1->checklist; 
                  $checklist_status = $value1->checklist_status;        

                  if($checklist_id=='')      
                    $checklist_id = 0;   
                }
                // echo $checklist_id;
                $checklistdata1 = DB::table('check_list')
                                             ->select('*')
                                             ->where('id',$checklist_id)
                                             ->get();
              if($checklistdata1){

                  $array_checklist = explode(',', $checklistdata1[0]->checklist);
                  $array_checklist103 = array();
                  $i = 0;
                  foreach ($array_checklist as $value) {
                    $i++;
                    $array_checklist103[]['value'] = $value;
                  }
                  $array_checklist1 = json_encode($array_checklist103);

                  $array_checklist101 = json_decode($array_checklist1);
                  // $array_checklist108 = json_encode($array_checklist101);


                  $checklistdata2 = array(

                                          'id' => $checklistdata1[0]->id,
                                          'force_update' => $checklistdata1[0]->force_update,
                                          'checklist' => $array_checklist101,
                  );
              }else{
                $checklistdata2 = [];
              }                             
            //End checklist code
            $biker_details = DB::table('bikers')
                                  ->select('*')
                                  ->where('id',$biker_id)
                                  ->get();
    
             foreach($rating_details as $r1)
             {
             	$r1->desc = base64_encode($r1->desc);
             }
             
             $vinfo = DB::table('vendor')
                           ->select('*')
                           ->where('vendor.id','=',$vendor_id)
                           ->get();      
            return response()->json(['service'=>$service_id,'tech'=>$biker_details,'rating'=>$rating_details,'vendor'=>$vinfo,'checklist'=>$checklistdata2,'checklist_status'=>$checklist_status]);
    
                                    
    
    		}
             
      }
         
      
      public function requesthistorynumber(Request $request)
          {
            $input = $request->all();
    
        if(!empty($input['rating1'])){
          $rating = DB::table('rating')
                       ->select('*')
                       ->where('rating.awd',$input['awd'])
                       ->get();
          $vinfo = DB::table('vendor')
                           ->select('*')
                           ->where('vendor.id','=',$input['vendor_id'])
                           ->first();
          $vname = $vinfo->name;
          $ctype = "Mobile App - ".$vname;
          //$today = Carbon::today();
          $today = date('Y-m-d H:i:s');
          //$today1 = substr($today,0,10);
          $today1 = date('Y-m-d');
           $n = count($rating);
           
           $notification = DB::table('rating')               
                  ->insert(['vendor_id' => $input['vendor_id'],'app'=>$input['rating1'],'technician'=>$input['rating2'],'tech_id'=>$input['tech_id'],'awd'=>$input['awd'],'created_by'=>$ctype,'cdate'=>$today1,'desc'=>base64_decode($input['remark']),'created_at'=>$today,'updated_at'=>$today]);   
            
          
          return response()->json(['success' => 1]);
        }else{
        $rating_details =  DB::table('rating')
                                   ->select('rating.app','rating.technician','rating.desc')
                                   ->where('rating.awd',$input['service_number'])
                                   ->get();
        $service_id = DB::table('shipment')
                                   ->select('shipment.*','pr.product_name')
                                    ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                   ->where('shipment.awb_no',$input['service_number'])
                                   ->orderBy('updated_at', 'DESC')
                                   ->get();
      
          /*  $service_details = DB::table('shipment')
                                   ->select('*')
                                   ->where('shipment.awb_no',$input['service_number'])
                                   ->orderBy('updated_at', 'DESC')
                                   ->first();*/
    
             foreach($service_id as $service)
             {
               $biker_id = $service->biker_id;
                $vendor_id = $service->vendor_id;
               //echo "remarks are".$service->remark;
               $service->remark = base64_encode($service->remark);
             }
    
            $biker_details = DB::table('bikers')
                                  ->select('*')
                                  ->where('id',$biker_id)
                                  ->get();
    
             foreach($rating_details as $r1)
             {
              $r1->desc = base64_encode($r1->desc);
             }
             
             $vinfo = DB::table('vendor')
                           ->select('*')
                           ->where('vendor.id','=',$vendor_id)
                           ->get();      
            return response()->json(['service'=>$service_id,'tech'=>$biker_details,'rating'=>$rating_details,'vendor'=>$vinfo]);
    
                                    
    
        }
             
      }
      
  public function requesthistoryEmptype($vid,$type)
      {
    $start_time = '00:00:00';
        $date = new DateTime();
        $today_start_time = $date->format('Y-m-d '.$start_time);
     $today_end_time = new DateTime('NOW');
        
    if($type == "today"){
    $service_details = DB::table('shipment')
                                   // ->select('shipment.awb_no')
                     ->select('shipment.*','ven.name','ven.mobile_no','pr.product_name','ven.primary_address','ven.landmark','ven.company_name')
                      ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id')
                      ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                   ->where('shipment.biker_id',$vid)
                                   ->orderBy('updated_at', 'DESC')
                   ->whereBetween('shipment.order_time',array($today_start_time,$today_end_time)) 
                                   ->get();
    }
    if($type == "past"){
    $service_details = DB::table('shipment')
                                   // ->select('shipment.awb_no')
                     ->select('shipment.*','ven.name','ven.mobile_no','pr.product_name','ven.primary_address','ven.landmark','ven.company_name')
                      ->join('vendor as ven', 'ven.id', '=', 'shipment.vendor_id')
                      ->join('products as pr','pr.id', '=', 'shipment.product_id')
                                   ->where('shipment.biker_id',$vid)
                                   ->orderBy('updated_at', 'DESC')
                   ->whereNotBetween('shipment.order_time',array($today_start_time,$today_end_time)) 
                                   ->get();
    }
        return response()->json($service_details);
        
    }


//for ios
     public function ValidateVendorlogout($id,$is_ios)
    {
      
      // $input = $request->all();
      // $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
      // $id = isset($input['id']) ? $input['id'] : 0;
                  //$ios_token = ($is_ios) ? $regId : '';
      $id = (int) $id;
      $is_ios = (int) $is_ios;
        if($is_ios && $id)
        {
          $ios_token='';
          $update_status = DB::table('vendor')
               ->where('id',$id)
               ->update(['ios_token'=>$ios_token]);
               
        }
        return response()->json(['success' => 1]);
               
    }

 public function ValidateBikerlogout($id,$is_ios)
    {
    	
      // $input = $request->all();
      // $is_ios = isset($input['is_ios']) ? $input['is_ios'] : 0;
      // $id = isset($input['id']) ? $input['id'] : 0;
                  //$ios_token = ($is_ios) ? $regId : '';
    	$id = (int) $id;
    	$is_ios = (int) $is_ios;
        if($is_ios && $id)
        {
          $ios_token='';
          $update_status = DB::table('bikers')
               ->where('id',$id)
               ->update(['ios_token'=>$ios_token]);
               
        }
        return response()->json(['success' => 1]);
               
    }

//by gajendra
public function store_attachment(Request $request)
{  
  $input = $request->all();
 // print_r($input); die;
  $binary = base64_decode($input['attachments']);  
  header('Content-Type: bitmap; charset=utf-8');
  $filename = time().'_'.$input['ImageName'];
  $path = 'uploads/images/'.$filename;
  $file = fopen('uploads/images/'.$filename, 'w');
  fwrite($file, $binary);
  if (fclose($file)) 
  {
	return response()->json(['success' => 1, 'file_path' => $path]);
  } 
  else 
  {
      return response()->json(['success' => 0]);
  }  
}

public function delete_attachment(Request $request)
{
  $input = $request->all();
  //print_r($input); die;
  $saved_path = $input['file_path'];
  if ($saved_path)
  {
	unlink($saved_path);
	return response()->json(['success' => 1]);
  }
  else
  {
	return response()->json(['success' => 0]);
  }
   
}

public function getinventorylist() {
       $inventory = DB::table('inventory')
       ->select('*')
	->where('deleted_at', 'N')
       ->get();
//echo "<pre>";print_r($inventory);die;
        return response()->json(['inventory_array' => $inventory]);
       }


}  
    

                               

                              
                               


                         
                              
                               
