<?php

namespace App\Http\Controllers\Api;

use App\Helpers\Shipment;
use Illuminate\Http\Request;
use App\Http\Requests;
use DB;
use App\Http\Controllers\Controller;
use Hash;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Substation;
use App\VendorShipment;
use App\VendorShipmentPackage;
use App\VendorAddress;
use App\VendorBuyer;
use App\StatusHistory; 

class WebApiController extends Controller
{
		/**
		 * Sends awb details in json format using api/secret_key
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function status($domain, $tld, $api_key = null, $secret_key = null, $awb_no = null)
		{

			if(empty($api_key)) {
				return response()->json(['success' => 0,'error' => ['code' =>  '101', 'message' => 'Please insert API KEY']]);
			}

			if(empty($secret_key)) {
				return response()->json(['success' => 0,'error' => ['code' =>  '102', 'message' => 'Please insert SECRET KEY']]);
			}

			if(empty($awb_no)) {
				return response()->json(['success' => 0,'error' => ['code' =>  '103', 'message' => 'Please insert AWB NUMBER']]);
			}

			$vendor = $this->validateApiSecretKey($api_key, $secret_key);

			if($vendor) {
				$shipment = DB::table('shipment')
					->select('*')
					->where('awb_no',$awb_no)
					->first();
				if($shipment) {
					$status_history = DB::table('shipment_status_history')
						->select('*')
						->where('shipment_id', $shipment->id)
						->get();
					$history = array();
					foreach ($status_history as $key => $row) {
						$history[] = array('date_time' => $row->date_time, 'status' => $row->status);
					}
					return response()->json(['success' => 1, 'status' => $shipment->delivery_status, 'status_history' => $history]);;
				} else {
					return response()->json(['success' => 0,'error' => ['code' =>  '104', 'message' => 'Invalid AWB NUMBER']]);
				}
			} else {
				return response()->json(['success' => 0,'error' => ['code' =>  '105', 'message' => 'Unauthorized']]);
			}
		}

		private function validateApiSecretKey($api_key, $secret_key) {
			return DB::table('vendor')
				->select('*')
				->where('api_key',$api_key)
				->where('secret_key',$secret_key)
				->first();
		}

		public function createshipment(Request $request, $domain, $tld, $api_key = null, $secret_key = null) {
			
			if(empty($api_key)) {
				return response()->json(['success' => 0,'error' => ['code' =>  '101', 'message' => 'Please insert API KEY']]);
			} else if(empty($secret_key)) {
				return response()->json(['success' => 0,'error' => ['code' =>  '102', 'message' => 'Please insert SECRET KEY']]);
			}

			$vendor = $this->validateApiSecretKey($api_key, $secret_key);
			
			if($vendor) {
				$input = $request->all();
				foreach ($input['shipment']['length'] as $key => $value) {
		            $input['packages'][] = array(
		                    'length' => $input['shipment']['length'][$key],
		                    'breadth' => $input['shipment']['breadth'][$key],
		                    'height' => $input['shipment']['height'][$key],
		                    'weight' => $input['shipment']['weight'][$key],
		                    'content' => $input['shipment']['content'][$key],
		                    'value' => $input['shipment']['value'][$key]
		                );
		            }
			$shipment_errors =  Shipment::validateShipment($input);
			if($shipment_errors['validate'] == true) {
				//echo "<pre>"; print_r($shipment_errors['data']['total_invoice_amt']); exit;
				$substations = Substation::all();
				$pickup_date = new DateTime($input['pickup_date']);
                $pickup_date = $pickup_date->format('Y-m-d');
                $cod_cost = 0;
                if(strtolower($input['payment_mode']) == 'cash on delivery') {
                    $payment_mode = 'cod';
                    $cod_cost = max(((1/100)*$shipment_errors['data']['total_invoice_amt']), 50);
                } else {
                    $payment_mode = 'online';
                }
                $insurance_cost = 0;
                if(strtolower($input['insurance']) == "yes"){
                    $insurance_cost = max(((0.5/100)*$shipment_errors['data']['total_invoice_amt']), 10);
                }
                if(strtolower($input['shipment_type']) == "4 hours delivery") {
                    $awb_type = "4HD";
                    $shipment_type = "4_hours_delivery";
                    $total_cost = max($shipment_errors['data']['tatal_cal_weight']* 99, 99 ) + $cod_cost + $insurance_cost;
                } elseif(strtolower($input['shipment_type']) == "same day delivery") {
                    $awb_type = "SDD";
                    $shipment_type = "same_day_delivery";
                    $total_cost = max($shipment_errors['data']['tatal_cal_weight']* 69, 69 ) + $cod_cost + $insurance_cost;
                } else {
                    $awb_type = "NXD";
                    $shipment_type = "next_day_delivery";
                    $total_cost = max($shipment_errors['data']['tatal_cal_weight']* 39, 39 ) + $cod_cost + $insurance_cost;
                }

                $awb_city = substr(strtoupper($input['drop_city']),0,3);
                $today_date = Carbon::now()->format('Y-m-d')."%";
                $awb_date = Carbon::now()->format('dmY');
                $total_orders = DB::table('shipment')
                                ->select(DB::raw('count(*) as total'))
                                ->where('order_time', 'LIKE', $today_date)
                                ->first();
                $awb_total_order_day = $total_orders->total;
                $awb_total_order_day = $awb_total_order_day + 1;
                $awb_total_order_day = str_pad($awb_total_order_day,6,0,STR_PAD_LEFT);
                $awb_no = $awb_type.$awb_date.$awb_total_order_day.$awb_city;

                $addresses = array(
                        'pickup' => urlencode($input['pickup_address'].', '.', '.$input['pickup_city'].', '.$input['pickup_state'].', '.$input['pickup_country'].' '.$input['pickup_pincode']),
                        'delivery' => urlencode($input['drop_address'].', '.', '.$input['drop_city'].', '.$input['drop_state'].', '.$input['drop_country'].' '.$input['drop_pincode'])
                    );
                foreach ($addresses as $key => $address) {
                    $request_url = "http://maps.googleapis.com/maps/api/geocode/xml?address=".$address."&sensor=true";
                    $xml = simplexml_load_file($request_url) or die("url not loading");
                    $status = $xml->status;
                    if ($status=="OK") {
                      $lat = $xml->result->geometry->location->lat;
                      $lon = $xml->result->geometry->location->lng;
                      $latitude[$key] = "$lat";
                      $longitude[$key] = "$lon";
                    }
                }
                $distance = Shipment::distanceCalculation((double)$latitude['pickup'],(double)$longitude['pickup'],(double)$latitude['delivery'],(double)$longitude['delivery']);
                $total_distance = round($distance, 2);
                $pickup_address = VendorAddress::create([
                    'address' => $input['pickup_address'],
                    'city' => $input['pickup_city'],
                    'state' => $input['pickup_state'],
                    'country' => $input['pickup_country'],
                    'pincode' => $input['pickup_pincode'],
                    'latitude' =>  $latitude['pickup'],
                    'longitude' => $longitude['pickup'],
                    'landmark' => $input['pickup_landmark'],
                ]);
                $pickup_address_id = $pickup_address->id;
                DB::table('vendor_pickup_address')->insert([
                    ['pick_up_address_id' => $pickup_address_id, 'vendor_id' => $vendor->id]
                ]);

                $drop_address = VendorAddress::create([
                    'address' => $input['drop_address'],
                    'city' => $input['drop_city'],
                    'state' => $input['drop_state'],
                    'country' => $input['drop_country'],
                    'pincode' => $input['drop_pincode'],
                    'latitude' =>  $latitude['delivery'],
                    'longitude' => $longitude['delivery'],
                    'landmark' => $input['drop_landmark'],
                ]);
                $buyer = VendorBuyer::create([
                    'vendor_id' => $vendor->id,
                    'drop_address_id' => $drop_address->id,
                    'name' => $input['buyer_name'],
                    'contact_no' => $input['buyer_contact_no'],
                    'email' => $input['buyer_email'],
                ]);
                foreach ($substations as $key => $substation) {
                  $substation_array = array_map('trim', explode(',', $substation->substation_pincode));          
                  if (in_array($input['pickup_pincode'], $substation_array)) {
                      $sub_station_id = $substation->id;
                      break;
                    }
                }
                //If there is no matching pin code available.
                //Assign the delivery to last substation in the list.
                if(!$sub_station_id) {
                  $sub_station_id = $substation->id;
                }
                $shipment = VendorShipment::create([
                            'vendor_id' => $vendor->id,
                            'drop_address_id' => $drop_address->id,
                            'buyer_id' => $buyer->id,
                            'sub_station_id' => $sub_station_id,
                            'name' => $input['pickup_name'],
                            'contact_no' => $input['pickup_contact_no'],
                            'email' => $input['pickup_email'],
                            'pickup_date' => $pickup_date,
                            'order_id' => $input['order_id'],
                            'pickup_address_id' => $pickup_address_id,
                            'type' => $shipment_type,
                            'payment_mode' => $payment_mode,
                            'cost' => $total_cost,
                            'invoice_amount' => $shipment_errors['data']['total_invoice_amt'],
                            'distance' => $total_distance,
                            'insurance' => ucwords(strtolower($input['insurance'])),
                            'awb_no' => $awb_no,
                            'delivery_status' => "Order Received",
                            'order_time' => Carbon::now()->toDateTimeString(),
                    ]);
                foreach ($input['packages'] as $key_package => $package) {        
                    $input['shipment_data'] = array(
                            'length' => $package['length'],
                            'breadth' => $package['breadth'],
                            'height' => $package['height'],
                            'weight' => max($package['weight'],(ceil(($package['length']*$package['breadth']*$package['height'])/5000))),
                            'content' => $package['content'],
                            'value' => $package['value'],
                            'shipment_id' => $shipment->id,
                    );
                    VendorShipmentPackage::create($input['shipment_data']);
                }
                $input['by_whom_role'] = "Admin";
                $input['by_whom_id'] = $vendor->id;
                $input['date_time'] = Carbon::now()->toDateTimeString();
                $input['shipment_id'] = $shipment->id;
                $input['status'] = "Order Received";
                StatusHistory::create($input);
                return response()->json(['success' => 1,'message' => "Shipment created successfully",'awb_no' => $awb_no]);
			} else {
				return response()->json(['success' => 0,'error' => $shipment_errors['errors']]);
			}
		} else {
			return response()->json(['success' => 0,'error' => ['code' =>  '105', 'message' => 'Unauthorized']]);
		}
	}
}    
