<?php // Code within app\Helpers\Helper.php

namespace App\Helpers;

use App\Substation;
use DateTime;
use Carbon\Carbon;
use DateInterval;

class Shipment
    {
        public static function validateShipment($row) {
            $cities = array('Mumbai', 'Navi Mumbai',"Thane");
           	$payment_mode = array("cash on delivery", "prepaid");
           	$insurance = array("yes", "no");
            $shipment_type = array("4 hours delivery", "same day delivery", "next day delivery");
            $date = new DateTime('tomorrow');
            $tomorrow_date = $date->format('Y-m-d');
            $today_date = new DateTime('NOW');
            $today_date = $today_date->format('Y-m-d');
            $substations = Substation::all();
            $serviceable_pincodes = array();
            foreach ($substations as $key => $substation) {
                $serviceable_pincodes = array_merge($serviceable_pincodes, array_map('trim', explode(',', $substation->substation_pincode)));
            }
            $pincodes = self::getServiceablePincodes();

            //Pick Up date
            if(gettype($row['pickup_date']) != "object") {
                if(empty($row['pickup_date'])) {
                    $errors['shipment_errors'][] = ['code' => '201','message' => "Pick up date is empty."];
                }
                if(!empty($row['pickup_date'])) {

                    try {
                        $pickup_date = new DateTime($row['pickup_date']);
                        $pickup_date = $pickup_date->format('Y-m-d');
                        $date_array = [$tomorrow_date,$today_date];
                        if(!in_array($pickup_date, $date_array)) {
                            $errors['shipment_errors'][] = ['code' => '202','message' => "Pick up date is Invalid."];
                        }
                    } catch (\Exception $e) {
                        $errors['shipment_errors'][] = ['code' => '202','message' => "Pick up date is Invalid."];
                    }
                } 
            } else {
                if(empty($row['pickup_date'])) {
                    $errors['shipment_errors'][] = ['code' => '201','message' => "Pick up date is empty."];
                }
                if(!empty($row['pickup_date'])) {    
                    try {
                        $pickup_date = new DateTime($row['pickup_date']);
                        $pickup_date = $pickup_date->format('Y-m-d');
                        $date_array = [$tomorrow_date,$today_date];
                        //var_dump($date_array,$pickup_date);
                        if(!in_array($pickup_date, $date_array)) {
                            $errors['shipment_errors'][] = ['code' => '202','message' => "Pick up date is Invalid."];
                        }
                    } catch (\Exception $e) {
                        $errors['shipment_errors'][] = ['code' => '202','message' => "Pick up date is Invalid."];
                    }
                } 
            }

            
           //For Order ID
            if(empty($row['order_id'])) {
                $errors['shipment_errors'][] = ['code' => '203','message' => "Order ID is invalid."];
            } 
            
            //For Payment Mode
            $payment_mode_found = false;
            if(!empty($row['payment_mode']) && in_array(strtolower($row['payment_mode']), $payment_mode)) {
                $payment_mode_found = true;
            }
            if(!$payment_mode_found) {
                $errors['shipment_errors'][] = ['code' => '204','message' => "Payment mode is invalid."];
            }

            //For Insurance
            $insurance_found = false;
            if(!empty($row['insurance']) && in_array(strtolower($row['insurance']), $insurance)) {
                $insurance_found = true;
            }
            if(!$insurance_found) {
                $errors['shipment_errors'][] = ['code' => '205','message' => "Insurance option is invalid."];
            }

            //For Shipment Type
            $shipment_type_found = false;
            if(!empty($row['shipment_type']) && in_array(strtolower($row['shipment_type']), $shipment_type)) {
                $shipment_type_found = true;
            }
            if(!$shipment_type_found) {
                $errors['shipment_errors'][] = ['code' => '206','message' => "Shipment type is invalid."];
            }

            //Pickup Name
            if(empty($row['pickup_name'])) {
                $errors['shipment_errors'][] = ['code' => '207','message' => "Pickup person name is invalid."];
            }
            //Pickup Contact No.
            if(empty($row['pickup_contact_no']) || !preg_match('/^[0-9]{10}$/', $row['pickup_contact_no'])) {
                $errors['shipment_errors'][] = ['code' => '208','message' => "Pickup contact number is invalid."];
            }
            //Pickup Email
            if (empty($row['pickup_email']) || (($row['pickup_email'] > 96) || !filter_var(trim($row['pickup_email']), FILTER_VALIDATE_EMAIL))) {
                $errors['shipment_errors'][] = ['code' => '209','message' => "Pickup email is invalid."];
            }
            //Pickup Address
            if(empty($row['pickup_primary_address'])) {
                $errors['shipment_errors'][] = ['code' => '210','message' => "Pickup primary address is invalid."];
            }

            //Pickup Secondary Address
            if(empty($row['pickup_secondary_address'])) {
                $errors['shipment_errors'][] = ['code' => '211','message' => "Pickup secondary address is invalid."];
            }

            //Pickup Landmark
            if(empty($row['pickup_landmark'])) {
                $errors['shipment_errors'][] = ['code' => '212','message' => "Pickup landmark is invalid."];
            }
            //Pickup City
            $pickup_city_found = false;
            if (!empty($row['pickup_city']) && in_array(ucwords(strtolower($row['pickup_city'])), $cities)) {
                $pickup_city_found = true;
            }
            if(!$pickup_city_found) {
                $errors['shipment_errors'][] = ['code' => '213','message' => "In pickup, we are providing service for Mumbai, Navi Mumbai and Thane."];
            }
            //Pickup Pin code
            $found = false;
            if (!empty($row['pickup_pincode']) && in_array((string) $row['pickup_pincode'], $pincodes)) {
                $found = true;
            }
            if(!$found) {
                $errors['shipment_errors'][] = ['code' => '214','message' => "In pickup, we are not providing service for this pin code."];
            }
            //For Pickup State
            if(empty($row['pickup_state']) || strtolower($row['pickup_state']) != "maharashtra") {
                $errors['shipment_errors'][] = ['code' => '215','message' => "In pickup, we are providing service only for Maharashtra."];
            }
            //For Pickup Country
            if(empty($row['pickup_country']) || strtolower($row['pickup_country']) != "india") {
                $errors['shipment_errors'][] = ['code' => '216','message' => "In pickup, we are providing service only for India."];
            }
            
            //Buyer Name
            if(empty($row['buyer_name'])) {
                $errors['shipment_errors'][] = ['code' => '217','message' => "Buyer name is invalid."];
            }
            //Buyer Contact No.
            if(empty($row['buyer_contact_no']) || !preg_match('/^[0-9]{10}$/', $row['buyer_contact_no'])) {
                $errors['shipment_errors'][] = ['code' => '218','message' => "Buyer contact number is invalid."];
            }
            //Buyer Email
            if (empty($row['buyer_email']) || (($row['buyer_email'] > 96) || !filter_var(trim($row['buyer_email']), FILTER_VALIDATE_EMAIL))) {
                $errors['shipment_errors'][] = ['code' => '219','message' => "Buyer email is invalid."];
            }
            //Buyer Address
            if(empty($row['drop_primary_address'])) {
                $errors['shipment_errors'][] = ['code' => '220','message' => "Buyer primary address is invalid."];
            }
            //Buyer Secondary Address
            if(empty($row['drop_secondary_address'])) {
                $errors['shipment_errors'][] = ['code' => '221','message' => "Buyer secondary address is invalid."];
            }
            //Drop Landmark
            if(empty($row['drop_landmark'])) {
                $errors['shipment_errors'][] = ['code' => '222','message' => "Drop landmark is invalid."];
            }
            //Drop City
            $drop_city_found = false;
            if (!empty($row['drop_city']) && in_array(ucwords(strtolower($row['drop_city'])), $cities)) {
                $drop_city_found = true;
            }
            if(!$drop_city_found) {
                $errors['shipment_errors'][] = ['code' => '223','message' => "In drop, we are providing service for Mumbai, Navi Mumbai and Thane."];
            }
            //Drop Pin code
            $drop_pincode_found = false;
            if (!empty($row['drop_pincode']) && in_array((string) $row['drop_pincode'], $pincodes)) {
                $drop_pincode_found = true;
            }
            if(!$drop_pincode_found) {
                $errors['shipment_errors'][] = ['code' => '224','message' => "In drop, we are not providing service for this pin code."];
            }
            //For Drop State
            if(empty($row['drop_state']) || strtolower($row['drop_state']) != "maharashtra") {
                $errors['shipment_errors'][] = ['code' => '225','message' => "In drop, we are providing service only for Maharashtra."];
            }
            //For Drop Country
            if(empty($row['drop_country']) || strtolower($row['drop_country']) != "india") {
                $errors['shipment_errors'][] = ['code' => '226','message' => "In drop, we are providing service only for India."];
            }
            //shipment packages validation
            $invoice_amt = 0;
            $total_cal_wt = 0;
            $total_weight = 0;
            if(!empty($row['packages'])) {
                foreach ($row['packages'] as $key_package => $package) {
                    $errors['packages_errors'][$key_package] = array();
                    if(empty($package['weight']) || !preg_match('/^[0-9]*\.?[0-9]*$/', $package['weight'])) {
                        $errors['packages_errors'][$key_package][] =  ['code' => '227','message' => "Invalid weight value."];
                    }
                    if(empty($package['length']) || !preg_match('/^[0-9]*\.?[0-9]*$/', $package['length'])) {
                        $errors['packages_errors'][$key_package][] =  ['code' => '228','message' => "Invalid length value."];
                    }
                    if(empty($package['breadth']) || !preg_match('/^[0-9]*\.?[0-9]*$/', $package['breadth'])) {
                        $errors['packages_errors'][$key_package][] =  ['code' => '229','message' => "Invalid breadth value."];
                    }
                    if(empty($package['height']) || !preg_match('/^[0-9]*\.?[0-9]*$/', $package['height'])) {
                        $errors['packages_errors'][$key_package][] =  ['code' => '230','message' => "Invalid height value."];
                    }
                    if(empty($package['value']) || !preg_match('/^[0-9]*\.?[0-9]*$/', $package['value'])) {
                        $errors['packages_errors'][$key_package][] =  ['code' => '231','message' => "Invalid cost value."];
                    }
                    if(empty($package['content'])) {
                        $errors['packages_errors'][$key_package][] =  ['code' => '232','message' => "Invalid content."];
                    }
                    if(!$errors['packages_errors'][$key_package]) {
                        unset($errors['packages_errors'][$key_package]);
                    }
                    $shipmentsheet['packages'][$key_package]['total_weight'] = max($package['weight'],(ceil(($package['length']*$package['breadth']*$package['height'])/5000)));
                    $total_weight = $total_weight + $shipmentsheet['packages'][$key_package]['total_weight'];
                    $invoice_amt = $invoice_amt + $package['value'];
                    $total_cal_wt = $total_cal_wt + $shipmentsheet['packages'][$key_package]['total_weight'];
                }
                $shipmentsheet['total_invoice_amt'] = $invoice_amt;
                $shipmentsheet['total_cal_weight'] = $total_cal_wt;
                if(!$errors['packages_errors']) {
                    unset($errors['packages_errors']);
                }
            } else {
                $errors['packages_errors'][][] = ['code' => '233','message' => "Please fill package info. for this order."];
            }
            
            $addresses = array(
                'pickup' => urlencode($row['pickup_primary_address'].$row['pickup_secondary_address'].', '.', '.$row['pickup_city'].', '.$row['pickup_state'].', '.$row['pickup_country'].' '.$row['pickup_pincode']),
                'delivery' => urlencode($row['drop_primary_address'].$row['drop_secondary_address'].', '.', '.$row['drop_city'].', '.$row['drop_state'].', '.$row['drop_country'].' '.$row['drop_pincode'])
                             );
            
            //$addresses = array(
            //    'pickup' => urlencode($row['pickup_landmark']),
            //    'delivery' => urlencode($row['drop_landmark'])
            //);
            $found = array();
            $error_found = 0;
            foreach ($addresses as $key => $address) {
                $request_url = "http://maps.googleapis.com/maps/api/geocode/xml?address=".$address."&sensor=true";
                $xml = simplexml_load_file($request_url) or die("url not loading");
                $status = $xml->status;
                if ($status=="OK") {
                  $lat = $xml->result->geometry->location->lat;
                  $lon = $xml->result->geometry->location->lng;
                  $shipmentsheet['latitude'][$key] = "$lat";
                  $shipmentsheet['longitude'][$key] = "$lon";
                } 
                if($status == "ZERO_RESULTS") {
                    $error_found = 1;
                    $found[] = $key;
                    $errors['landmark_errors'][] = ['code' => '236','message' => "$key address is not found in google map."];
                }
            }
            //echo '<pre>'; print_r($errors); exit;
            if(!$error_found) {
                $total_distance = self::distanceCalculation((double)$shipmentsheet['latitude']['pickup'],(double)$shipmentsheet['longitude']['pickup'],(double)$shipmentsheet['latitude']['delivery'],(double)$shipmentsheet['longitude']['delivery']);
                $shipmentsheet['total_distance'] = $total_distance;
                if(($total_distance <= 15 && $total_cal_wt > 10 && strtolower($row['shipment_type']) == '4 hours delivery') || ($total_distance > 15 && $total_distance <= 50 && strtolower($row['shipment_type']) == '4 hours delivery')) {
                    $errors['shipment_errors'][] = ['code' => '234','message' => "Distance is more than 15Kms and/or weight more than 10Kgs. Cannot available 4 hours delivery."];
                }
                if($total_cal_wt > 20 && strtolower($row['shipment_type']) == 'same day delivery') {
                    $errors['shipment_errors'][] = ['code' => '235','message' => "Distance is more than 50Kms and/or weight more than 20Kgs. Cannot available same day delivery."];
                }
                if($total_distance > 50 && strtolower($row['shipment_type']) == '4 hours delivery') {
                    $errors['shipment_errors'][] = ['code' => '234','message' => "Distance is more than 15Kms and/or weight more than 10Kgs. Cannot available 4 hours delivery."];
                }
                if($total_distance > 50 && strtolower($row['shipment_type']) == 'same day delivery') {
                    $errors['shipment_errors'][] = ['code' => '235','message' => "Distance is more than 50Kms and/or weight more than 20Kgs. Cannot available same day delivery."];
                }
            }
            if(empty($errors))  {
                return ['validate' => true, 'data' => $shipmentsheet];
            } else {
                return ['validate' => false, 'errors' => $errors];
            }
        }

        public static function distanceCalculation($point1_lat, $point1_long, $point2_lat, $point2_long, $unit = 'km', $decimals = 2) {
            // Calculate the distance in degrees
            $start  = urlencode($point1_lat.','.$point1_long);
            $finish = urlencode($point2_lat.','.$point2_long);

            $distance   = '0';
            $time       = '0';
            $raw = false;


            $url = 'http://maps.googleapis.com/maps/api/directions/xml?origin='.$start.'&destination='.$finish.'&sensor=false';
            if($data = file_get_contents($url))
            {
                $xml = new \SimpleXMLElement($data);

                if(isset($xml->route->leg->duration->value) AND (int)$xml->route->leg->duration->value > 0)
                {
                    if($raw)
                    {
                        $distance = (string)$xml->route->leg->distance->text;
                        $time     = (string)$xml->route->leg->duration->text;
                    }
                    else
                    {
                        $distance = (int)$xml->route->leg->distance->value / 1000 / 1.609344; 
                        $time     = (int)$xml->route->leg->duration->value;
                    }
                }
                else
                {
                    echo ('Could not find that route');
                }

                return $distance * 1.60934; //convert to kms 
            }
            else
            {
                echo('Could not resolve URL');
            }

            $final_distance = $distance * 1.60934; //convert to kms  
            return round($final_distance, $decimals);
        }

        public static function getServiceablePincodes(){
            $pincodes = array_map('trim', file(base_path()  . '/serviceable_pincodes.txt'));
            return  $pincodes;
        }
    }