<?php

namespace App\Http\Middleware;

use Closure;
use Auth;
use App;
use DB;
use Carbon\Carbon;
use Session;
use Illuminate\Http\Request;

class PlanCheckerMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (App::environment('local')) {}

        //echo $_SERVER['SERVER_NAME'];die;

        //fetch data from uat db  - apniamc_master whose plan is free trial    
        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->where('client_plan', 'F')
                    ->first();
        

        //fetch data from uat to get end date except free trial
        $master_client = DB::connection('apniamc_master')
                        ->table('client_master')
                        ->where('domain_name',$_SERVER['SERVER_NAME'])
                        ->where('is_active','Y')
                        //->where('client_plan', '<>', 'BA')
                        ->where('client_plan', '<>', 'F')
                        ->first();
//echo "<pre>";print_r($master_client);exit;
        $todays_date = Date('Y-m-d');
        $str_todays_date = strtotime($todays_date);
                       
        //to check that user is loggined           
        if(!empty(Auth::User()->id)) {
            
            //if it is free plan- update it to basic plan on end date condition.
            //if there is data in $clients Array
            if(!empty($clients)) {
                if($clients->end_date != '') {
                    $clients_end_date = $clients->end_date;
                } else {
                    $clients_end_date = '';
                }
                
                $str_clients_end_date = strtotime($clients_end_date);

                //to check that free trial is ended
                if($str_todays_date > $str_clients_end_date) {

                    //update uat db apniamc_master with BASIC PLAN as BA 
                    $client_update = DB::connection('apniamc_master')
                                    ->table('client_master')
                                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                                    ->where('is_active','Y')
                                    ->update(['client_plan' => 'BA']);
                    
                    //update main db table-bikers - first inactive all bikers
                    $technician_update = DB::table('bikers')
                                         ->update(['status' => 'Inactive']);

                    //update main db table-bikers to set only 1 technician active
                    $technician_update = DB::table('bikers')
                                        ->where('deleted_at','=',NULL)
                                        ->orderBy('id','ASC')
                                        ->take(1)
                                        ->update(['status' => 'Active']);
                    
                    
                } 
            }

            //check condition for bronze, silver, gold.
            if(!empty($master_client)) {
                if($master_client->end_date != '') {
                    $clients_end_date = strtotime($master_client->end_date);
                } else {
                    $clients_end_date = '';
                }

                //to check that subsription  is ended
                if($str_todays_date > $clients_end_date) {
                    session::flash('subscription_mesg', 'Your Subscription Expired. Please contact Apniamc at sales@apniamc.com or call us at 9137858155.');
                    Auth::logout();
                    return redirect('/');
                }

                //if it is BASIC plan
                if($master_client->client_plan == 'BA') {

                    //update main db table-users - first inactive all users
                    $user_update = DB::table('users')
                                    ->update(['status' => 'Inactive']);

                    //update main db table-users to set only 1 admin active
                    $user_update = DB::table('users')
                                        ->where('deleted_at','=',NULL)
                                        ->orderBy('id','ASC')
                                        ->take(1)
                                        ->update(['status' => 'Active']);
                    
                    //update main db table-bikers - first inactive all bikers
                    $technician_update = DB::table('bikers')
                                         ->update(['status' => 'Inactive']);
                    
                    //update main db table-bikers to set only 1 bikers active
                    $technician_lm_upd = DB::table('bikers')
                                        ->where('deleted_at','=',NULL)
                                        ->orderBy('id','ASC')
                                        ->take(1)
                                        ->update(['status' => 'Active']);
                } 
                
                //if it is BRONZE plan
                if($master_client->client_plan == 'BR') {
                    //update main db table-bikers - first inactive all bikers
                    $technician_update = DB::table('bikers')
                                         ->update(['status' => 'Inactive']);
                    
                    //update main db table-bikers to set only 5 bikers active
                    $technician_lm_upd = DB::table('bikers')
                                        ->where('deleted_at','=',NULL)
                                        ->orderBy('id','ASC')
                                        ->take(5)
                                        ->update(['status' => 'Active']);
                } 

                //if it is Silver plan
                if($master_client->client_plan == 'S') {
                   //update main db table-bikers - first inactive all bikers
                    $technician_update = DB::table('bikers')
                                         ->update(['status' => 'Inactive']);
                    //update main db table-bikers to set only 10 bikers active
                    
                    $technician_lm_upd = DB::table('bikers')
                                        ->where('deleted_at','=',NULL)
                                        ->orderBy('id','ASC')
                                        ->take(10)
                                        ->update(['status' => 'Active']);
                } 

                //if it is Gold plan
                if($master_client->client_plan == 'G') {
                    //update main db table-bikers - first inactive all bikers
                    $technician_update = DB::table('bikers')
                                         ->update(['status' => 'Inactive']);

                    //update main db table-bikers to set only 20 bikers active
                    
                    $technician_lm_upd = DB::table('bikers')
                                        ->where('deleted_at','=',NULL)
                                        ->orderBy('id','ASC')
                                        ->take(20)
                                        ->update(['status' => 'Active']);
                } 

            }
           
        }
        return $next($request);
    }
}
