<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Contracts\Auth\Guard;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Session;

class Authenticate
{
    /**
     * The Guard implementation.
     *
     * @var Guard
     */
    protected $auth;

    /**
     * Create a new filter instance.
     *
     * @param  Guard  $auth
     * @return void
     */
    public function __construct(Guard $auth)
    {
        $this->auth = $auth;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $custid = Session::get('custid');
        $currentPath= Route::getFacadeRoot()->current()->uri();
        
        if ($this->auth->guest()) {
            if ($request->ajax()) {
                return response('Unauthorized.', 401);
            } else {
                if($currentPath == 'service/createautoservice') {}
                elseif(strpos($currentPath, 'cronjobs-', 0)) {}
                elseif(isset($custid) && $custid ){}
                else
                {
                    return redirect()->guest('auth/login');
                }
                
			   //echo "in";
            }
        }
        return $next($request);
    }
}
