<?php

namespace App\Http\Controllers\VendorLogin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\VendorShipment;
use App\VendorShipmentPackage;
use App\VendorAddress;
use App\VendorBuyer;
use App\StatusHistory;
use App\Vendor;
use Carbon\Carbon;
use Session;
use DateTime;
use App\Substation;
use App\Helpers\Shipment;

class ShipmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if((Session::has('vendor_id'))) {
            $states = DB::table('state')->get();
            $vendor_id = Session::get('vendor_id');
            $addresses = DB::table('address')->join('vendor_pickup_address','vendor_pickup_address.pick_up_address_id', '=', 'address.id')
                                            ->select('address.*')
                                            ->where('vendor_id',  $vendor_id)
                                            ->get();
            $vendor_details = Vendor::all()->where('id', Session::get('vendor_id'))->first();
            $servicable_pincodes = Shipment::getServiceablePincodes();
            return view('vendorlogin.shipment')->withAddresses($addresses)->withStates($states)->withVendorDetails($vendor_details)->With('servicable_pincodes', $servicable_pincodes);
          } else {
             return redirect("login/");
          }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      if((Session::has('vendor_id'))) {
        $vendor_id = Session::get('vendor_id');
        $input = $request->all();
        //For featching pincode if pincode field is disabled
        $pickup_address_id = 0;
        if($input['old_addresses']) {
            $pickup_address_id = $input['old_addresses'];
            $old_address = DB::table('address')
                          ->select('*')
                          ->where('id',  $input['old_addresses'])
                          ->first();
            $input['pick_up_pin_code'] = $old_address->pincode;
            $input['pick_up_city'] = $old_address->city;
        }
        $pickup_date = new DateTime($input['pickup_date']);
        $input['pickup_date'] = $pickup_date->format('Y-m-d');
        if($input['delivery_type'] == "fhd") {
            $awb_type = "4HD";
            $delivery_type = "4_hours_delivery";
        } elseif($input['delivery_type'] == "sdd") {
            $awb_type = "SDD";
            $delivery_type = "same_day_delivery";
        } else{
            $awb_type = "NXD";
            $delivery_type = "next_day_delivery";
        }
        if($input['insurance'] == 1){
            $insurance = 'Yes';
        } else {
          $insurance = 'No';
        }
        $awb_city = substr(strtoupper($input['pick_up_city']),0,3);
        $today_date = Carbon::now()->format('Y-m-d')."%";
        $awb_date = Carbon::now()->format('dmY');
        $total_orders = DB::table('shipment')
                    ->select(DB::raw('count(*) as total'))
                    ->where('order_time', 'LIKE', $today_date)
                    ->first();
        
        $awb_total_order_day = $total_orders->total;
        $awb_total_order_day = $awb_total_order_day + 1;
        $awb_total_order_day = str_pad($awb_total_order_day,6,0,STR_PAD_LEFT);
        $awb_no = $awb_type.$awb_date.$awb_total_order_day.$awb_city;

        $addresses = array(
            'delivery' => urlencode($input['delivery_address'].', '.', '.$input['delivery_city'].', '.$input['delivery_state'].', '.$input['delivery_country'].' '.$input['delivery_pin_code'])
        );

        if(!$pickup_address_id) {
            $addresses['pickup'] = urlencode($input['pick_up_address'].', '.', '.$input['pick_up_city'].', '.$input['pick_up_state'].', '.$input['pick_up_country'].' '.$input['pick_up_pin_code']);
        }

        foreach ($addresses as $key => $address) {
            $request_url = "http://maps.googleapis.com/maps/api/geocode/xml?address=".$address."&sensor=true";
            $xml = simplexml_load_file($request_url) or die("url not loading");
            $status = $xml->status;
            if ($status=="OK") {
              $lat = $xml->result->geometry->location->lat;
              $lon = $xml->result->geometry->location->lng;
              $latitude[$key] = "$lat";
              $longitude[$key] = "$lon";
            }
        }

        if(!$pickup_address_id) {
            $pickup_address = VendorAddress::create([
                'address' => $input['pick_up_address'],
                'address_1' => $input['pick_up_address_1'],
                'city' => $input['pick_up_city'],
                'state' => $input['pick_up_state'],
                'country' => $input['pick_up_country'],
                'pincode' => $input['pick_up_pin_code'],
                'latitude' =>  $latitude['pickup'],
                'longitude' => $longitude['pickup'],
                'landmark' => $input['pick_up_landmark'],
            ]);
            $pickup_address_id = $pickup_address->id;
            DB::table('vendor_pickup_address')->insert([
                ['pick_up_address_id' => $pickup_address_id, 'vendor_id' => $vendor_id]
            ]);
        }
        $substations = Substation::all();
        $sub_station_id = 0;
        $drop_substation_id = 0;
        foreach ($substations as $key => $substation) {
            $substation_array = array_map('trim', explode(',', $substation->substation_pincode));          
            if (in_array($input['pick_up_pin_code'], $substation_array)) {
                $sub_station_id = $substation->id;
            }
            if (in_array($input['delivery_pin_code'], $substation_array)) {
                $drop_substation_id = $substation->id;
            }
        }
        
        //If there is no matching pin code available.
        //Assign the delivery to last substation in the list for pick up substation.
        if(!$sub_station_id) {
          $sub_station_id = $substation->id;
        }
        
        //If there is no matching pin code available.
        //Assign the delivery to last substation in the list for drop Substation id
        if(!$drop_substation_id) {
          $drop_substation_id = $substation->id;
        }
        $drop_address = VendorAddress::create([
            'address' => $input['delivery_address'],
            'address_1' => $input['delivery_address_1'],
            'city' => $input['delivery_city'],
            'state' => $input['delivery_state'],
            'country' => $input['delivery_country'],
            'pincode' => $input['delivery_pin_code'],
            'latitude' =>  $latitude['delivery'],
            'longitude' => $longitude['delivery'],
            'landmark' => $input['delivery_landmark'],
        ]);
        $buyer = VendorBuyer::create([
            'vendor_id' => $vendor_id,
            'drop_address_id' => $drop_address->id,
            'name' => $input['delivery_name'],
            'contact_no' => $input['delivery_contact_no'],
            'email' => $input['delivery_email'],
        ]);
        $shipment = VendorShipment::create([
            'vendor_id' => $vendor_id,
            'drop_address_id' => $drop_address->id,
            'buyer_id' => $buyer->id,
            'sub_station_id' => $sub_station_id,
            'drop_substation_id' => $drop_substation_id,
            'name' => $input['pick_up_name'],
            'contact_no' => $input['pick_up_contact_no'],
            'email' => $input['pick_up_email'],
            'pickup_date' => $input['pickup_date'],
            'order_id' => $input['order_id'],
            'pickup_address_id' => $pickup_address_id,
            'type' => $delivery_type,
            'payment_mode' => $input['payment_mode'],
            'cost' => $input['total_cost'],
            'shipping_fee' => $input['shipping_fee'],
            'insurance_fee' => $input['insurance_fee'],
            'payment_mode_charge' => $input['payment_mode_charge'],
            'invoice_amount' => $input['total_invoice'],
            'distance' => $input['distance'],
            'insurance' => $insurance,
            'awb_no' => $awb_no,
            'delivery_status' => "Order Received",
            'order_time' => Carbon::now()->toDateTimeString(),
        ]);
        // foreach ($input['shipment']['length'] as $key => $value) {
        //     $input['shipment_data'] = array(
        //             'length' => $input['shipment']['length'][$key],
        //             'breadth' => $input['shipment']['breadth'][$key],
        //             'height' => $input['shipment']['height'][$key],
        //             'weight' => $input['shipment']['weight'][$key],
        //             'content' => $input['shipment']['content'][$key],
        //             'value' => $input['shipment']['value'][$key],
        //             'shipment_id' => $shipment->id,
        //           );
        //     VendorShipmentPackage::create($input['shipment_data']);
        // }
        for($i=0; $i<$input['package_count']; $i++) {
          $key = $i;
          if($input['package_type'] == 'identical') {
            $key = 0;
          } 
          $input['shipment_data'] = array(
                  'length' => $input['shipment']['length'][$key],
                  'breadth' => $input['shipment']['breadth'][$key],
                  'height' => $input['shipment']['height'][$key],
                  'weight' => max($input['shipment']['weight'][$key],(ceil(($input['shipment']['length'][$key]*$input['shipment']['breadth'][$key]*$input['shipment']['height'][$key])/5000))), 
                  'content' => $input['shipment']['content'][$key],
                  'value' => $input['shipment']['value'][$key],
                  'shipment_id' => $shipment->id,
                );
          VendorShipmentPackage::create($input['shipment_data']);
        }

        $input['by_whom_role'] = "Admin";
        $input['by_whom_id'] = $vendor_id;
        $input['date_time'] = Carbon::now()->toDateTimeString();
        $input['shipment_id'] = $shipment->id;
        $input['status'] = "Order Received";
        StatusHistory::create($input);
        $request->session()->flash('success', 'Order is created successfully!');
        return redirect("order/");
      } else {
            return redirect("login/");
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
