<?php

namespace App\Http\Controllers\VendorLogin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Hash;
use Session;
use App\Vendor;
use Mail;
use Carbon\Carbon;     

class LoginController extends Controller
{
    public function login()
    {
        if((Session::has('vendor_id'))) { 
            return redirect('/order'); 
        } else{
            return view('vendorlogin.login');
        }
    }


        public function webclientlogin(Request $request)
    {
        
        if(!empty($request->email) && !empty($request->password))
        {
            $login = DB::table('vendor')
                    ->select('*')
                    ->where('email', $request->email)
                    ->where('status','!=','In Active')
                    ->first();
                    
            if(!empty($login))
            {      
                if(Hash::check($request->password, $login->password))
                {
                    Session::set('custid', $login->id);
                    Session::set('custname', $login->name);
                   
                    return redirect('/service/create')->with('status', $login->id);
                }
                else
                {
                    session()->flash('error', 'Username or password is wrong.');
                    return redirect('client/loginpage');
                }
            }
            else
            {
                session()->flash('error', 'Your account has not been activated. Please contact admin.');
                return redirect('client/loginpage');
            }

        }
        elseif (empty($request->email) && !empty($request->password)) {

            session()->flash('error', 'Email is required');
            return redirect('client/loginpage');
        }
        elseif(!empty($request->email) && empty($request->password))
        {
            session()->flash('error', 'Password is required');
            return redirect('client/loginpage');
        }
        elseif($request->email == '' && $request->password == '')
        {
            session()->flash('error', 'Email And Password is required');
            return redirect('client/loginpage');
        }
        
    }

    public function validateVendor(Request $request)
    {
        if((Session::has('vendor_id'))) { 
            return redirect('/order'); 
        } else {
            $this->validate($request, [
                'email' => 'required|email|max:255',
                'password' => 'required|min:6',
            ]);
            $input = $request->all();
            $vendor = DB::table('vendor')
                 ->select(DB::raw('password, id,status,name,api_key,secret_key'))
                 ->where('email', $input['email'])
                 ->where('status','!=','In Active')
                 ->whereNull('deleted_at')
                 ->first();

            if($vendor){
                if (Hash::check($input['password'], $vendor->password)) {
                    Session::put('vendor_id', $vendor->id);
                    Session::put('vendor_name', $vendor->name);
                    Session::put('status',$vendor->status);
                    Session::put('api_key', $vendor->api_key);
                    Session::put('secret_key',$vendor->secret_key);
                    $now = Carbon::now();
                    $a = Vendor::where('id', Session::get('vendor_id'))->update(['last_login_at' => $now]);
                    if(isset($_COOKIE['create_shipment'])) {
                        return redirect('/shipment');
                    } else {
                        return redirect('order');
                    }
                } else {
                    session()->flash('error', 'Username or password is wrong.');
                    return redirect('/login'); 
                }
                } else {
                    session()->flash('error', 'Your account has not been activated. Please contact admin.');
                    return redirect('/login'); 
            }
        }
    }
    public function forgotPasswordIndex() {
        return view('vendorlogin.reset_password_index');
    }
    public function forgotPassword(Request $request) {
        if(empty(Session::has('vendor_id'))) {
            $this->validate($request, [
                    'email' => 'required|email|max:255',
                ]);
            $input = $request->all();
            $vendor = Vendor::select('*')
                 ->where('email', $input['email'])
                 ->where('status','!=','In Active')
                 ->first();
            if($vendor){
                $data['email'] = $input['email'];
                $data['name'] = $vendor->name;
                $data['password'] = substr(md5($input['email'].time()), 5, 15);
                Mail::send('emails.reset_password', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
                    $message->to($data['email'])->subject('Forgotten Apniamc Password');;
                });
                $input['password'] = bcrypt($data['password']);
                Vendor::where('email', $input['email'])->where('status','!=','In Active')->update(
                    ['password' => $input['password'],'plain_password' => $data['password']]
                    );
                $request->session()->flash('success', 'Your password has been changed successfully. Please check your mail box.');
                return redirect("/login");
            } else {
                session()->flash('error', 'Your account has not been activated. Please contact admin.');
                return redirect('/login');
            }
        } else{
            return redirect('order');
        }
    }

    // Changes to show view of email by gaurav on 26-feb-2020
    public function forgotPasswordClient(){
        
        return view('vendorlogin.password');
    }

    public function resetPassword(Request $request) {
        if(Session::has('vendor_id')) {
            if($request->all()){
                $input = $request->all();
                $password = bcrypt($input['password']);
                $a = Vendor::where('id', Session::get('vendor_id'))->update(
                    ['password' => $password, 'plain_password' => $input['password']]
                    );
                $request->session()->flash('success', 'Your password has been changed successfully.');
                return redirect("/order");
            } else {
                return redirect("/order");
            }
        } else {
            return view('vendorlogin.login');
        }
    }
    public function logout() {
        Session::forget('vendor_id');
        Session::forget('vendor_name');
        Session::forget('status');
        if(isset($_COOKIE['create_shipment'])) {
            setcookie('create_shipment', '', time()-7000000, '/');
        }
        return redirect('/login'); 
    }
    public function getInTouch(Request $request)
    {
        $input = $request->all();
        $data['email'] = $input['contact_email'];
        $data['name'] = $input['name'];
        $data['phone'] = $input['phone'];
        $data['enquiry_message'] = $input['message'];
        $emailcontent = array (
            'email' => $data['email'],
            'name' => $data['name'],
            'phone' => $data['phone'],
            'enquiry_message' => $data['enquiry_message'],
            );

        Mail::send('emails.getintouch', $emailcontent, function ($message) use ($data) {        
            $message->to('erunnerz.in@gmail.com')->bcc('pravinkhot.mukesoft@gmail.com')->subject('Enquiry at Erunnerz');
        });
        $request->session()->flash('success', 'Thanks For Your Interest.');
        return redirect("/");
    }

    public function autoLogin($domain, $tld, $url) {
        $decode_url = explode('|__|', base64_decode($url));
        if(!empty($decode_url)) {
            $diff_time = time() - $decode_url[2];
            if($diff_time) {
                if($diff_time <= 3600) {
                    $vendor = Vendor::select('*')
                                 ->where('email', $decode_url[0])
                                 ->where('status','!=','In Active')
                                 ->first();
                    if($vendor) {
                        Session::put('vendor_id', $vendor->id);
                        Session::put('vendor_name', $vendor->name);
                        Session::put('status',$vendor->status);
                        return redirect('shipment');
                    } else {
                        session()->flash('error', 'Your account has not been activated. Please contact admin.');
                        return redirect('/login'); 
                    }

                } else {
                    session()->flash('error', 'Your Session has been expired. Please login to admin and again click on create shipment button.');
                    return redirect('/login'); 
                    Session::forget('vendor_id');
                    Session::forget('vendor_name');
                    Session::forget('status');
                    Session::forget('api_key');
                    Session::forget('secret_key');
                }
            }
        }
    }

    //For Landing page
    public function LandingPage() {
        return view('landing_page');
    }
    //For Landing page Email
    public function LandingPageEmail(Request $request) {
        $input = $request->all();
        $data['email'] = $input['email'];
        $data['name'] = $input['name'];
        $data['phone'] = $input['phone'];
        $data['enquiry_message'] = $input['message'];
        $emailcontent = array (
            'email' => $data['email'],
            'name' => $data['name'],
            'phone' => $data['phone'],
            'enquiry_message' => $data['enquiry_message'],
            );

        Mail::send('emails.landing_page_email_admin', $emailcontent, function ($message) use ($data) {        
            $message->to('pravinkhot.mukesoft@gmail.com')->subject('Enquiry at Erunnerz');
        });
        Mail::send('emails.landing_page_email', $emailcontent, function ($message) use ($data) {        
            $message->to($data['email'])->subject('Enquiry at Erunnerz');
        });
        $request->session()->flash('success', 'Thanks For Your Interest.');
        return redirect("/eliminate_logistics_challenges");
    }
}
