<?php

namespace App\Http\Controllers\Vendor;

use App\Vendor;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Mail;
use DB;
use Input;
use Config;

class VendorController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        if (!empty(Input::get('sort'))) {
                $sort = Input::get('sort');
        } else {
                $sort = 'vendor.name';
        }
        if (!empty(Input::get('order'))) {
                $order = Input::get('order');
        } else {
                $order = 'ASC';
        }

        if ($order == 'ASC') {
                $url = '?order=DESC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
                $url = '?order=ASC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        }
        if(!empty(Input::get('order'))) {
       //     $url .= "?order=".Input::get('order');
        }
       
       if(!empty(Input::get('sort'))) {
         //   $url .= "&sort=".Input::get('sort');
        }

        $sort_data = array(
            'vendor.company_name',
            'vendor.name',
            'vendor.primary_address',
            'vendor.mobile_no',
            'vendor.landline_no',
            'vendor.email',
            'vendor.status',
            'vendor.plain_password',
             'vendor.client_type'
        );
        //$query = Vendor::select();
        $query = DB::table('vendor')->select('*')->where("deleted_at","=",'N');
       // $query;
                    if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "vendor.name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query->orderby($sort_col_name,'desc');
                    } else {
                        $query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        
                        $query->whereRaw("(vendor.company_name LIKE '%".trim(Input::get('filter_name'))."%' OR  vendor.name LIKE '%".trim(Input::get('filter_name'))."%' OR  vendor.primary_address LIKE '%".trim(Input::get('filter_name'))."%' OR vendor.email LIKE '%".trim(Input::get('filter_name'))."%' OR vendor.status LIKE '%".trim(Input::get('filter_name'))."%'  OR vendor.mobile_no LIKE '%".trim(Input::get('filter_name'))."%'  OR vendor.landline_no LIKE '%".trim(Input::get('filter_name'))."%')");
                           
                    }
                    //$myModelsPaginator->appends($input);

        $vendors = $query->paginate(10);            
//echo $url;exit();
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
        //export start
        
              
         
         if(Input::get('report') == 1) {


             $query1tmp = DB::table('vendor')          
                  ->select('*')
                  ->where('deleted_at','=','N');

            if(!empty(Input::get('filter_name'))) {

                        
                    $query1tmp->whereRaw("(vendor.company_name LIKE '%".trim(Input::get('filter_name'))."%' OR  vendor.name LIKE '%".trim(Input::get('filter_name'))."%' OR  vendor.primary_address LIKE '%".trim(Input::get('filter_name'))."%' OR vendor.email LIKE '%".trim(Input::get('filter_name'))."%' OR vendor.status LIKE '%".trim(Input::get('filter_name'))."%' OR vendor.mobile_no LIKE '%".trim(Input::get('filter_name'))."%'  OR vendor.landline_no LIKE '%".trim(Input::get('filter_name'))."%')");
                       
                    }

            if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(vendor.id IN (".$selectedval.") )");
            }

                if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "vendor.name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query1tmp->orderby($sort_col_name,'desc');
                    } else {
                        $query1tmp->orderby($sort_col_name,'asc');
                    }

                  $query1 =   $query1tmp->get();

            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array(' ','CLIENTS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Name','Company Name', 'Address1', 'Address2', 'Email','MobileNo','LandlineNo', 'Landmark','Country', 'State','City','Pincode','Status',"Client Type"));
             foreach ($query1 as $line) { 
                $data = array(
                    'name' => $line->name,
                    'company_name' => $line->company_name,
                    'address1' => $line->primary_address,
                    'address2' => $line->secondary_address,
                    
                    'email' => $line->email,
                    'mobileno' => $line->mobile_no,
                    'landlineno' => $line->landline_no,
                    'landmark' => $line->landmark,
                    'country' => $line->country,
                    'state' => $line->state,
                    'city' => $line->city,
                    'pincode' => $line->pin_code,
                    'status' => $line->status,
                    'client_type' => (($line->client_type=="C")?"Normal Client":"Supplier")
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('clients_report.csv');
            die;
            return;
        }
        //end start
        return view('vendor.index')->withVendors($vendors)->withFilter($filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create() {
         $states = DB::table('state')->get();
         return view('vendor.create')->withStates($states);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     * @return Response
     */
    public function store(Request $request) {
        $this->validate($request, [
            'url' => 'regex:/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/',
            //'company_name' => 'required',
            'name' => 'required',
            'email' => 'required|email|unique:vendor',
            'primary_address' => 'required',
            'city' => 'required|regex:/^[\pL\s\-\']+$/u',
            
            // 'email' => 'required|unique:vendor|email',
             
            'status' => 'required',
            'client_type' => 'required',
            // 'landmark' => 'required'            
        ]);

        try
        {
            $generateKey = function($length = 10) {
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $charactersLength = strlen($characters);
                $randomString = '';
                for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, $charactersLength - 1)];
                }
                return ($randomString);
            };
            $input = $request->all();
            $input['company_name'] = ucwords($input['company_name']);
            $input['name'] = ucwords(strtolower($input['name']));
            $data['email'] = $input['email'];
            $data['name'] = $input['name'];
            $data['api_key'] = $generateKey(8) . stristr(md5($input['email'].time()), 3, 7);
            $data['secret_key'] = substr(md5($input['name'].time()), 5, 9) . $generateKey(6);
            $data['password'] = substr(md5($input['email'].time()), 5, 10);
            // var_dump($data);
            // exit;
            $emailcontent = array (
                'email' => $data['email'],
                'password' => $data['password'],
                'name' => $data['name'],
                'client_type' => ($input['client_type']=="S"?'1':'2')
                );
            $cname = config('constants.company_name');
            $sb = 'Welcome to '.$cname.'!';
            Mail::send('emails.vendorwelcome', $emailcontent, function ($message) use ($data) {  
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
                $message->to($data['email'])->subject(Config::get('app.companyname').' New Customer Registration');
            });
            /*bhawna */

            $input['password'] = bcrypt($data['password']);
            $input['api_key'] = $data['api_key'];
            $input['secret_key'] = $data['secret_key'];
            $input['plain_password'] = $data['password'];
            $input['pwd'] = $data['password'];
            //$input['client_type'] = $input['client_type'];

            $fields = array('identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5');
            foreach ($fields as $key => $field) {
            if (!empty($request[$field])) {
                $identity_proof_name = Input::file($field)->getClientOriginalName();
                $identity_proof_name = time().$identity_proof_name;
                $file = $request->file($field);
                if ($request->file($field)->isValid()) {
                    //$request->file($field)->move($img_dir, $identity_proof_name);
                    $input[$field] = $identity_proof_name;
                    }
                }
            }
            //var_dump($input);exit;
            $vendor_id = Vendor::create($input);

            // image upload and directory creation for vendor
            $img_dir = "uploads/images/vendor/".$vendor_id->id."/";
            if (!file_exists($img_dir)) {
                mkdir($img_dir, 0777, true);
            }
            foreach ($fields as $key => $field) {
            if (!empty($request[$field])) {
                //$identity_proof_name = Input::file($field)->getClientOriginalName();
                //$identity_proof_name = time().$identity_proof_name;
                $file = $request->file($field);
                if ($request->file($field)->isValid()) {
                    $request->file($field)->move($img_dir, $input[$field]);
                    }
                }
            }
            $request->session()->flash('flash_message', 'Client added successfully !!!');
            return redirect('managevendor');
        }
        catch (\Illuminate\Database\QueryException $e){
            $errorCode = $e->errorInfo[1];
            if($errorCode == 1062){
                return 'Client already exists. Please try again !!!';
            }        
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
       // $img_dir = "uploads/images/vendor/".$id."/";
       //$vendor = $this->Vendor->findOrFail($id);
        $vendor = DB::table('vendor')->select('*')->where("id",'=',$id)->get();
        return view('vendor.show')->withVendor($vendor[0]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $img_dir = "uploads/images/vendor/".$id."/";
       // $vendor = Vendor::findOrFail($id);
        $vendor = DB::table('vendor')->select('*')->where("id",'=',$id)->get();
      
        $states = DB::table('state')->get();
        return view('vendor.edit')->withVendor($vendor[0])->withStates($states)->withImgDir($img_dir);
    }

    public function updateallvendorsname()
    {
        echo 'reached';
        $query = DB::table('bikers')->select('*');
        //$query->where("deleted_at","=",NULL);
        $vendors = $query->get();
        $i=0;
        foreach($vendors as $vendor)
        {
            $input = array();
            //echo $i++.' '.$vendor->company_name.'<br>';
            $vendor = Bikers::findOrFail($vendor->id);
            $input['first_name'] = ucwords(strtolower($vendor->first_name));
            $input['last_name'] = ucwords(strtolower($vendor->last_name));
            $vendor->fill($input)->save();

        }
        echo 'end';
        die;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Request  $request
     * @param  int  $id
     * @return Response
     */
    public function update(Request $request, $id)
    { 
        $this->validate($request, [
            'url' => 'regex:/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/',
            
            'primary_address' => 'required',
            'city' => 'required|regex:/^[\pL\s\-\']+$/u',
            'name' => 'required',
            'email' => 'required|email',
            'status' => 'required',
             'client_type' => 'required',
        ]);

      //  $vendor = Vendor::findOrFail($id);
         $vendor1 = DB::table('vendor')->select('*')->where("id",'=',$id)->get();
         $vendor=$vendor1[0];

        $input = $request->all(); 
 // echo "test";

 // print_r($input);
 // exit;
        $input['company_name'] = ucwords($input['company_name']);
        $input['name'] = ucwords(strtolower($input['name']));
 

        if(isset($_POST['reset_password'])) {  
            $data['email'] = $input['email'];
            $data['name'] = $input['name'];
            $data['password'] = substr(md5($input['email'].time()), 5, 10);
             $data['client_type'] = ($input['client_type']=="S"?'1':'2');
            $cname = config('constants.company_name');
            $sb = "Welcome to ".$cname."!";
               
               // password is useful only for supplier client type. So login credetials mail will be sent to only suppliers
               if($input['client_type']=="S")    
               {    
                    Mail::send('emails.vendorwelcomereset', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
                        $message->to($data['email'])->subject(Config::get('app.companyname').' Reset Password');
                
                    }); 
            }
            
            $input['password'] = bcrypt($data['password']);
            $input['plain_password'] = $data['password'];
            $input['pwd'] = $data['password'];
        }
        $temp_data= $input;  
         // image upload and directory creation for vendor
        $img_dir = "uploads/images/vendor/".$id."/";
        if (!file_exists($img_dir)) {
            mkdir($img_dir, 0777, true);
        }
        $fields = array('identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5');
        foreach ($fields as $key => $field) {
            if (!empty($request[$field])) {
                $identity_proof_name = Input::file($field)->getClientOriginalName();
                $identity_proof_name = time().$identity_proof_name;
                $file = $request->file($field);
                if ($request->file($field)->isValid())
                    {
                    $request->file($field)->move($img_dir, $identity_proof_name);
                    $input[$field] = $identity_proof_name;
                    }
                }
            else {
                $input['field'] = $request['field_old'];
            }
        }
    unset($temp_data['_method']);
    unset($temp_data['_token']);
     unset($temp_data['reset_password']);
     unset($temp_data['sort']);
    unset($temp_data['filter_name']);
     unset($temp_data['page']);
      unset($temp_data['order']);

        Vendor::where('id', $id)->update($temp_data);
        
        $vendor1 = DB::table('vendor')->select('*')->where("id",'=',$id)->where("deleted_at",'=','N')->get();
         $vendor=$vendor1[0];

       // $vendor->fill($temp_data)->save();
        if($vendor->status == "Active" && $vendor->ctype=="Mobile"){
        //notification start
        $registatoin_ids[] = $vendor->gcm_regid;
                //$registatoin_ids = "APA91bH2G343ND2cNvoCnvXeOK8ilMyH6d2aLByaY-c5zhX-eCj6Ij2L7dW4A5aTaOCz9EfOr-Ty-W0aWdeqBn-F1hsSIgbVhjw7NSKzePmnYFedhLNu194k6_PXCIoM3yEg5zSZ9eEE";
               // $message1 =array("message" => "");
                $messagebody = array("title" => Config::get('app.companyname')." Registration Approval", "body" => "Start with ".Config::get('app.companyname'),"type"=>"cus","param1"=>"","param2"=>"login");
                // Set POST variables
                $fields1 = array(
                 'registration_ids' => $registatoin_ids,
                 'data' => $messagebody,
                 'priority' => 'high',
                 'delay_while_idle'=> true,
                  'dry_run'=> false,
                  'content_available'=> true,
                  'time_to_live'=> 3600
                );

                    $url1 = 'https://fcm.googleapis.com/fcm/send';
 
                    //building headers for the request
                    $headers1 = array(
                        'Authorization: key=AAAAqPo2z5U:APA91bHYvdVnx6ZC4MznPfGx6-1PZR7Pgcb4WVWlqS6I5NUNLBLddq3ZHSWbu8LwJ_aqv3qSiz1ijwLdKSn5NcxiG-6ojiCkXNp_NZsN1g4h9f5veV9-rys6_rp9Bm_keH8bZsQkvx4u',
                        'Content-Type: application/json'
                    );
            
                    //Initializing curl to open a connection
                    $ch1 = curl_init();
             
                    //Setting the curl url
                    curl_setopt($ch1, CURLOPT_URL, $url1);
                    
                    //setting the method as post
                    curl_setopt($ch1, CURLOPT_POST, true);
            
                    //adding headers 
                    curl_setopt($ch1, CURLOPT_HTTPHEADER, $headers1);
                    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
             
                    //disabling ssl support
                    curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
                    
                    //adding the fields in json format 
                    curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode($fields1));
             
                    //finally executing the curl request 
                    $result1 = curl_exec($ch1);
                    //print_r($result1);
                    if ($result1 === FALSE) {
                      //  die('Curl failed: ' . curl_error($ch1));
                    }
                    //Now close the connection
                    curl_close($ch1);
        
        //notification end
        //activation mail start
         $emailcontent = array (
            'email' => $vendor->email,
            'name' => $vendor->name,
             'client_type' => ($vendor->client_type=="S"?'1':'2')

            );
            $emaildata = $vendor->email;
         
        // echo "updated vendor".$vendor->email;
        $cname = config('constants.company_name');
        $sb = 'Welcome to '.$cname.'!';
          Mail::send('emails.vendorwelcomeactivation', $emailcontent, function ($message) use ($emaildata) {  
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
            $message->to($emaildata)->subject(Config::get('app.companyname').' Confirm Activation');
            
        }); /*bhawna */
        }
        //end
        $request->session()->flash('flash_message', 'Client details updated successfully !!!');
        return redirect("managevendor?sort=".$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        // $vendor = Vendor::findOrFail($id);
        // $vendor->delete();
        
        $ids = explode(',', $id)    ;
        for($i=0;$i<count($ids);$i++){
            $vendor = Vendor::destroy($ids[$i]);
        }
        //Vendor::find(explode(',', $id))->destroy();
        return redirect('managevendor')->with('flash_message', 'Client deleted successfully !!!');
    }
    public function CreateShipment() {
        $vendors = Vendor::all();
        return view('vendor.pseudo_create_shipmnet')->withVendors($vendors);
    }

}
