<?php

namespace App\Http\Controllers\Shipment;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use DateTime;
use Session;

class GenerateReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('shipment.downloadreport');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $input = $request->all();
        $start_date = new DateTime($input['start_date']);
        $start_date = $start_date->format('Y-m-d 00:00:00');
        $end_date = new DateTime($input['end_date']);
        $end_date = $end_date->format('Y-m-d 23:59:59');
        $query = DB::table('shipment')
                    ->join('bikers','bikers.id','=','shipment.biker_id')
                    ->join('vendor','vendor.id','=','shipment.vendor_id')
                   
                   // ->join('sub_station', 'shipment.sub_station_id', '=', 'sub_station.id')
                    ->select(
                        'shipment.order_time','shipment.awb_no','shipment.delivery_status','vendor.company_name','vendor.name'
                        ,'vendor.email',
                        'vendor.mobile_no','bikers.first_name','bikers.mobile','bikers.email as bikeremail')
                       
                    ->whereBetween('shipment.order_time', array($start_date,$end_date));
                    
                    $query->orderBy('shipment.order_time', 'DESC');
        $data = $query->get();
		//print_r();
		//die;
        $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
        $csv->insertOne(array('Service Date & Time','Technician ID','Service Status','Company Name','Client Name','Client Email','Client Contact No','Technician Name','Technician Contact','Technician Email'));
        foreach ($data as $line) { 
            $line = (array) $line;
            $order_time = new DateTime($line['order_time']);
            $line['order_time'] = $order_time->format('d/m/Y H:i:s');
            $csv->insertOne($line);
        }
        $csv->output('download_report.csv');
       redirect('/downloadreport');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
