<?php

namespace App\Http\Controllers\ManageAdmin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\User;
use Mail;
use DB;
use Input;
use Config;
use Session;


class ManageAdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'users.first_name';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if(!empty(Input::get('filter_name'))) {
                $url .= "&filter_name=".Input::get('filter_name');
        }

        $sort_data = array(
            'users.first_name',
            'users.mobile',
            'users.email',
            'users.role_id'
        );
        $query = User::select('users.*','ss.name as sub_station_name')
                        ->leftjoin('sub_station as ss', 'users.id','=','ss.user_id');
                    if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "users.first_name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query->orderby($sort_col_name,'desc');
                    } else {
                        $query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        $query->where(function($query) {
                             $query->where('users.first_name', 'LIKE', "%".Input::get('filter_name')."%")
                                    ->orWhere('users.last_name', 'LIKE', "%".Input::get('filter_name')."%")
                                    ->orWhere('ss.name', 'LIKE', "%".Input::get('filter_name')."%")
                                    ->orWhere('users.mobile', 'LIKE', "%".Input::get('filter_name')."%")
                                    ->orWhere('users.email', 'LIKE', "%".Input::get('filter_name')."%");
                        });
                        //$query->whereRaw("(users.first_name LIKE '%".Input::get('filter_name')."%' OR  users.last_name LIKE '%".Input::get('filter_name')."%' OR  ss.name LIKE '%".Input::get('filter_name')."%' OR vendor.email LIKE '%".Input::get('filter_name')."%' OR users.mobile LIKE '%".Input::get('filter_name')."%'  OR users.email LIKE '%".Input::get('filter_name')."%'  )");
                    }
        $users = $query->paginate(10);
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
		//export start
		 if(Input::get('report') == 1) {

        $query1 = DB::table('users as u') 
          ->leftJoin('roles as r','r.id','=','u.role_id')         
                  ->select('u.first_name','u.last_name','u.mobile','u.email','r.role_title')
               ->where('u.deleted_at','=','N')
               ->orderBy('u.id','DESC')
               ->get();


            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','USERS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Name', 'Mobile', 'Email', 'Role'));
			 foreach ($query1 as $line) { 
                $data = array(
                    'name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'mobile' => $line->mobile,
                    'email' => $line->email,
                    'role' => $line->role_title
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('users_report.csv');
            return;
		}

        $users_number = '';
        $client_plan       = '';

        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
                    //echo "<pre>";print_r($clients);die;    
        if(!empty($clients)) {
            $users_number = 1;
            $client_plan = $clients->client_plan;
        }            
        $users_data= DB::table('users')->where('deleted_at','=',NULL)->get();
        $users_count = count($users_data);

		//end start
        return view('manage_admin.index')->withUsers($users)->withFilter($filter)->withUsersNumber($users_number)->withClientPlan($client_plan)->withUsersCount($users_count);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $states = DB::table('state')->get();
        $roles = DB::table('roles')
                     ->select(DB::raw('id, role_title'))
                     ->where('is_active', 'Y')
                     ->get();
        return view('manage_admin.create')->withRoles($roles)->withStates($states);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //get user have which plan from apniamc_master db
        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
        $client_plan = ''; 
        $number_of_users = 1;

        if(!empty($clients)) {
            $client_plan = $clients->client_plan;
        } 

        $all_users = DB::table('users')->where('deleted_at','=',NULL)->get();
        $count_users = count($all_users);

        //if user has BASIC plan then check and restrict it to make only 1 user
        if($client_plan == 'BA') {
            if($count_users >= $number_of_users) {
                session::flash('unable_create_user_mesg', 'Please upgrade your plan to make more Users. Please contact on this number 9137858155.');
                return redirect('/manageadmin/create');
            } else {
                return  $this->finalStoreAdmin($request);
            }
        }

        else {
          return  $this->finalStoreAdmin($request);
        } 
      
    }

    public function finalStoreAdmin(Request $request) {
        $this->validate($request, [
            'first_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'last_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'email' => 'required|email|unique:users,email,NULL,id,deleted_at,NULL',
            'mobile' => 'required|digits:10|numeric',
            'address' => 'required',
            'landmark' => 'required',
            'city' => 'required|regex:/^[\pL\s\-\']+$/u',
            'state' => 'required|regex:/^[\pL\s\-\']+$/u',
            'pincode' => 'required|digits:6|numeric',
            'role_id' => 'required'
        ]);
        $input = $request->all();

        $input['first_name']=trim($input['first_name']);
        $data['email'] = trim($input['email']);
        $data['status'] = trim($input['status']);
        $input['first_name'] = ucwords(strtolower($input['first_name']));
        $input['last_name'] = ucwords(strtolower($input['last_name']));
        $data['email'] = $input['email'];
        $data['first_name'] = $input['first_name'];
        $data['last_name'] = $input['last_name'];
        $data['password'] = substr(md5($input['email'].time()), 5, 15);
        $emailcontent = array (
            'email' => $data['email'],
            'password' => $data['password'],
            'first_name' => $data['first_name']
            );
     
        Mail::send('emails.admin', $emailcontent, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));   
            $message->to($data['email'])->subject('Welcome to '.Config::get('app.companyname'));
        });
  //exit();
        $input['password'] = bcrypt($data['password']);
        User::create($input);
        $request->session()->flash('success', 'User added successfully. Login details are sent on the Email Address. !!!');

        return redirect("manageadmin/");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::findOrFail($id);
        $role = DB::table('roles')
                     ->select(DB::raw('id, role_title'))
                     ->where('id', $user['role_id'])
                     ->first();
        $user['role'] = $role->role_title;
        return view('manage_admin.show')->withUser($user);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::findOrfail($id);
        $roles = DB::table('roles')
                     ->select(DB::raw('id, role_title'))
                     ->where('is_active', 'Y')
                     ->get();
        return view('manage_admin.edit')->withUser($user)->withRoles($roles);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'first_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'last_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'email' => 'required|email|max:255',
            'mobile' => 'required|digits:10|numeric',
            'address' => 'required',
            'landmark' => 'required',
            'city' => 'required|regex:/^[\pL\s\-\']+$/u',
            'state' => 'required|regex:/^[\pL\s\-\']+$/u',
            'pincode' => 'required|digits:6|numeric',
            'role_id' => 'required'
        ]);
        $user = User::findOrfail($id);
        $input = $request->all();
        $input['first_name'] = ucwords(strtolower($input['first_name']));
            $input['last_name'] = ucwords(strtolower($input['last_name']));
        if($input['role_id'] != 2) {
            $substation_list = DB::table('sub_station')
                                ->where('sub_station.user_id','=',$id)
                                ->first();
            if(!empty($substation_list)) {
                $substation_list_update = DB::table('sub_station')
                                            ->where('sub_station.user_id','=',$id)
                                            ->update(array('sub_station.user_id' => NULL));                         
            }
        }
         if(isset($_POST['reset_password'])) {
            $data['email'] = $input['email'];
            $data['first_name'] = $input['first_name'];
            $data['password'] = substr(md5($input['email'].time()), 5, 15);
            Mail::send('emails.adminreset', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
            $message->to($data['email'])->subject(Config::get('app.companyname').' Reset Password');
            });
            $input['password'] = bcrypt($data['password']);
        }
        $user->fill($input)->save();
        $request->session()->flash('success', 'User updated successfully !!!');
        return redirect('manageadmin/?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
    //     $users = User::destroy($id);
    //     session()->flash('success', 'Admin deleted successfully.');
    //     return redirect('manageadmin/');
    // }
        $ids = explode(',', $id)    ;
                for($i=0;$i<count($ids);$i++){
                    $user = user::destroy($ids[$i]);
        }
             session()->flash('success', 'Admin deleted successfully !!!');
             return redirect('manageadmin/');
    }
}
