<?php

namespace App\Http\Controllers\Invoice;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Input;
use App\Bikers;
use DB;
use DateTime;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
          return view('invoice.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function bikerReport() {
        $bikers_list = Bikers::all();
        $input =Input::all();
        $bikers_list = Bikers::all();
        if(!empty($input)) {
            $selected_parameter = array(
                                    'biker_id' => $input['biker_id'], 
                                    'biker_type' => $input['biker_type'],
                                    'start_date' => $input['start_date'],
                                    'end_date' => $input['end_date']
                                    );
        } else {
            $selected_parameter = false;
        }
        $query = Bikers::leftjoin('cod_collected as cc','Bikers.id','=','cc.biker_id')
                ->leftjoin('bikers_reading as br', function($join) {
                    $join->on('Bikers.id','=','br.bikers_id');
                    $join->on('cc.date', '=', 'br.reading_date');
                    })
                ->select('*', DB::Raw('sum(amount) as cod_collected'), 'cc.date AS RD_date');
                if(!empty($input['biker_id']) || !empty($input['biker_type']) || !empty($input['start_date']) && !empty($input['end_date'])){
                        if(!empty($input['biker_id'])) {
                            $query->where('Bikers.id', $input['biker_id']);
                        }
                        if(!empty($input['biker_type'])) {
                            $query->where('Bikers.type', $input['biker_type']);
                        }
                        $date = new DateTime($input['start_date']);
                        $start_date = $date->format('Y-m-d');
                        $date = new DateTime($input['end_date']);
                        $end_date = $date->format('Y-m-d');
                        if(!empty($input['start_date']) && !empty($input['end_date'])){
                            $query->whereBetween('cc.date', array($start_date,$end_date));
                        }
                    }
                $query->groupBy('cc.date');
                $query->orderBy('cc.date', 'DESC');
        $bikers = $query->get();

        return view('report.bikers_report')->withBikers($bikers)->withBikersList($bikers_list)->withSelectedParameter($selected_parameter);
        // echo '<pre>'; print_r($bikers); exit;
        

        // $bikers = Bikers::leftjoin('bikers_reading as br','Bikers.id','=','br.bikers_id')
        //                 ->leftjoin('cod_collected as cc','cc.biker_id','=','br.bikers_id')
        //                 ->select('*','cc.date as RD_date', DB::Raw('(SELECT SUM(amount) FROM cod_collected cc WHERE cc.date = br.reading_date) as cod_collected'))
        //                 ->groupBy('cc.date')
        //                 ->orderBy('cc.date', 'DESC')
        //                 ->get();
    }

    public function bikerReportFilter() {
        $input =Input::all();
        $bikers_list = Bikers::all();
        if(!empty($input)) {
            $selected_parameter = array(
                                    'biker_id' => $input['biker_id'], 
                                    'biker_type' => $input['biker_type'],
                                    'start_date' => $input['start_date'],
                                    'end_date' => $input['end_date']
                                    );
        } else {
            $selected_parameter = false;
        }
        $query = Bikers::leftjoin('bikers_reading as br','Bikers.id','=','br.bikers_id')
                    ->leftjoin('cod_collected as cc','cc.biker_id','=','br.bikers_id')
                    ->select('*','cc.date as RD_date', DB::Raw('(SELECT SUM(amount) FROM cod_collected cc WHERE cc.date = br.reading_date) as cod_collected'));
                    if(!empty($input['biker_id']) || !empty($input['biker_type']) || !empty($input['start_date']) && !empty($input['end_date'])){
                        if(!empty($input['biker_id'])) {
                            $query->where('Bikers.id', $input['biker_id']);
                        }
                        if(!empty($input['biker_type'])) {
                            $query->where('Bikers.type', $input['biker_type']);
                        }
                        $date = new DateTime($input['start_date']);
                        $start_date = $date->format('Y-m-d');
                        $date = new DateTime($input['end_date']);
                        $end_date = $date->format('Y-m-d');
                        if(!empty($input['start_date']) && !empty($input['end_date'])){
                            $query->whereBetween('cc.date', array($start_date,$end_date));
                        }
                    }
                    $query->groupBy('cc.date');
                    $query->orderBy('cc.date', 'DESC');
        $bikers = $query->get();
        //echo '<pre>'; print_r($bikers ); exit;
        return view('report.bikers_report')->withBikers($bikers)->withBikersList($bikers_list)->withSelectedParameter($selected_parameter);
    }
}
