<?php namespace App\Http\Controllers;
use App\Role;
use App\Permission;
use Auth;
use DB;
use Session;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use DatePeriod;
use Input;
use App\User;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;

class HomeController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
	}

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		$user = Auth::user();
		$role = DB::table('roles')
		         ->select(DB::raw('*'))
		         ->where('id', $user->role_id)
		         ->first();
		$sub_station = DB::table('sub_station')
		         ->select(DB::raw('*'))
		         ->where('user_id', $user->id)
		         ->first();
                //echo "<pre>"; print_r($sub_station); exit;
		Session::put('user_role',$role->role_title);
		Session::put('userrid',$user->role_id);
		if($user->role_id == 2) {
			if(!empty($sub_station)){
				Session::put('substation_name',$sub_station->name);
				Session::put('sub_station_id',$sub_station->id);
				Session::put('sub_station_cod_amt',$sub_station->cod_amount_collected);
			} else {
				//for avoiding if substation is not assiged
				Session::put('sub_station_id',999999999999);
	            Session::put('sub_station_cod_amt',0.0);
	            Session::put('substation_name','');
			}
		}
		// $roles = Role::all();
		// $permissions = Permission::all();
		//->withRoles($roles)->withPermissions($permissions);

		// For landing Page
        $input =Input::all();
		$substation_id = Session::get('sub_station_id');
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $start_date = $date->format('Y-m-d 00:00:00');
        $end_date = new DateTime('NOW');
        /*$substation_list = DB::table('sub_station')
                            ->select('id','name','deleted_at')
                            ->get();
        $query = DB::table('shipment as sh')
                        ->select('sh.order_time',DB::raw('COUNT(*) AS total_order'));
                        if(!empty($substation_id) || !empty(Input::get('substation_list'))|| !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query->whereBetween('sh.order_time', array($start_date,$end_date));
        $total_order = $query->first();

        $query_assign = DB::table('shipment as sh')
                        ->select(DB::raw('COUNT(*) AS total_assigned'));
                        if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query_assign->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query_assign->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query_assign->whereIn('sh.delivery_status',['Assigned','Order Assigned','Order Reassigned_1','Order Reassigned_2','Order Assigned not ready','Order Received']);
                        $query_assign->whereBetween('sh.order_time', array($start_date,$end_date));
        $order_assigned = $query_assign->first();

        $query_cancelled = DB::table('shipment as sh')
                        ->select(DB::raw('COUNT(*) AS total_cancelled'));
                        if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query_cancelled->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query_cancelled->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query_cancelled->whereIn('sh.delivery_status',['Order Assigned_Cancel','Order assigned_Pickup cancel']);
                        $query_cancelled->whereBetween('sh.order_time', array($start_date,$end_date));
        $order_cancelled = $query_cancelled->first();
                    
        $query_delivered = DB::table('shipment as sh')
                        ->select(DB::raw('COUNT(*) AS total_delivered'));
                        if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query_delivered->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query_delivered->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query_delivered->whereIn('sh.delivery_status',['Delivered','Delivered_Cash collected','Delivered_card on delivery','Delivered_Open box','RTN Delivered']);
                        $query_delivered->whereBetween('sh.order_time', array($start_date,$end_date));
        $order_delivered = $query_delivered->first();

        $query_in_substation = DB::table('shipment as sh')
                        ->select(DB::raw('COUNT(*) AS total_in_substation'));
                        if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query_in_substation->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query_in_substation->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query_in_substation->whereIn('sh.delivery_status',['At Sub Station','At_substation','At_Substation_Reattempt1','At_Substation_Reattempt2','At_substation_rtn','At_Substation_rtn_Reattempt1','At_Substation_rtn_Reattempt2']);
                        $query_in_substation->whereBetween('sh.order_time', array($start_date,$end_date));
        $order_in_substation = $query_in_substation->first();

        $query_in_transit = DB::table('shipment as sh')
                        ->select(DB::raw('COUNT(*) AS total_in_transit'));
                        if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query_in_transit->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query_in_transit->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query_in_transit->whereIn('sh.delivery_status',['In Transit','In transit','In transit_address changed','In transit_Business_or_house closed','In transit_COD amount not ready','In transit_Customer Refused_or_Rejected','In transit_undelivered','In transit_Reattempt1','In transit_Reattempt2','In transit_delay out of our control','In Transit_Out for Delivery','In Transit_Out for Delivery1','In Transit_Out for Delivery2','In transit_Shipment Lost','RTN Order picked_in transit','RTN Order picked_weight changed','RTN In transit','RTN In transit_address changed','RTN In transit_Business_or_house closed','RTN In transit_COD amount not ready','RTN In transit_Customer Refused_or_Rejected','RTN In transit_undelivered','RTN In transit_Reattempt1','RTN In transit_Reattempt2','RTN In transit_delay out of our control','RTN In Transit_Out for Delivery','RTN In Transit_Out for Delivery1','RTN In Transit_Out for Delivery2','RTN In transit_Shipment Lost']);
                        $query_in_transit->whereBetween('sh.order_time', array($start_date,$end_date));
         $order_in_transit = $query_in_transit->first();


        $query_cod_amount = DB::table('shipment as sh')
                        ->select('sh.order_time',DB::raw('SUM(invoice_amount) AS total_cod_amount'))
                        ->where('sh.payment_mode','=','cod');
                        if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
                            if(!empty($substation_id)) {
                                $query_cod_amount->where('sh.sub_station_id','=',$substation_id);
                            }
                            if(!empty(Input::get('substation_list'))) {
                                $query_cod_amount->where('sh.sub_station_id','=',Input::get('substation_list'));
                            }
                            if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                $date = new DateTime($input['start_date']);
                                $start_date = $date->format('Y-m-d');
                                $date = new DateTime($input['end_date']);
                                $end_date = $date->format('Y-m-d');
                            }
                        }
                        $query_cod_amount->whereBetween('sh.order_time', array($start_date,$end_date));
                        //->groupby(DB::raw('CAST(sh.order_time AS DATE)'))
                        //->orderby('sh.order_time','desc')
        $total_cod_amount = $query_cod_amount->first();
        //echo '<pre>'; print_r($total_cod_amount); exit;

        $query_cod_collected = DB::table('cod_collected as cc')
                        ->select('cc.date',DB::raw('SUM(cc.amount) AS cod_collected'))
                        ->join('shipment as sh','sh.id',' = ','cc.shipment_id');
                            if(!empty($substation_id) || !empty(Input::get('substation_list'))) {
                                if(!empty($substation_id)) {
                                    $query_cod_collected->where('sh.sub_station_id','=',$substation_id);
                                }
                                if(!empty(Input::get('substation_list'))) {
                                    $query_cod_collected->where('sh.sub_station_id','=',Input::get('substation_list'));
                                }
                                if(!empty($input['start_date']) && !empty($input['end_date'])) {
                                    $date = new DateTime($input['start_date']);
                                    $start_date = $date->format('Y-m-d');
                                    $date = new DateTime($input['end_date']);
                                    $end_date = $date->format('Y-m-d');
                                }
                            }
                        $query_cod_collected->where('cc.payment_mode','=','cash');
                        $query_cod_collected->whereBetween('sh.order_time', array($start_date,$end_date));
                        //->groupby('cc.date')
        $cod_collected = $query_cod_collected->first();
*/        
		$n11 = DB::table('vendor')
                   ->select('id')
				    ->where('deleted_at','=','N')
                   ->get();
		$total_client = count($n11);
		
        $pending_status=array('Awaiting Spares','Work Pending','Client Side','In Progress','New');

        $completed_status=array('Completed','Closed');

        $n22 = DB::table('shipment')
                   ->select('id')
                   ->whereIn('delivery_status',$pending_status)                   
                   ->get();
		$pending_service= count($n22);

        $n22 = DB::table('shipment')
                   ->select('id')
                   ->whereIn('delivery_status',$completed_status)                       
                   ->get();
        $completed_service= count($n22);
        

        $n22 = DB::table('shipment')
                   ->select('id')
                   ->get();
        $total_service= count($n22);

		$n44 = DB::table('bikers')
                   ->select('id')
				    ->where('deleted_at','=',NULL)
                   ->get();
		$total_technician = count($n44);

		$n55 = DB::table('amcs')
                   ->select('id')
                   ->get();
		$total_amc = count($n55);
        //print_r($n5);
		
		$n66 = DB::table('rating')
                   ->select('id')
                   ->where('app','>=',3)
                   ->where('technician','>=',3)
                   ->get();
		$total_good_rating = count($n66);

        $n66 = DB::table('rating')
                   ->select('id')
                   ->where('app','<',3)
                   ->where('technician','<',3)
                   ->get();
        $total_bad_rating = count($n66);

		//echo $date = new DateTime();
        //$date->sub(new DateInterval('P1D'));
        //echo $date->subWeek(); // or $date->subDays(7),  2014-03-27 13:58:25

		//echo $yesterday_date = $date->format('Y-m-d 00:00:00');
		$currentDate = Carbon::now();
		$date = new DateTime($currentDate);
		$cm = $date->format('Y-m-d ');
		
		$s1 = Carbon::now()->addDays(1);
		$date1 = new DateTime($s1);
		$s1m = $date1->format('Y-m-d ');
		$s2 = Carbon::now()->addDays(2);
		$date2 = new DateTime($s2);
		$s2m = $date2->format('Y-m-d ');
		$s3 = Carbon::now()->addDays(3);
		$date3 = new DateTime($s3);
		$s3m = $date3->format('Y-m-d ');
		$s4 = Carbon::now()->addDays(4);
		$date4 = new DateTime($s4);
		$s4m = $date4->format('Y-m-d ');
		$s5 = Carbon::now()->addDays(5);
		$date5 = new DateTime($s5);
		$s5m = $date5->format('Y-m-d ');
		$s6 = Carbon::now()->addDays(6);
		$date6 = new DateTime($s6);
		$s6m = $date6->format('Y-m-d ');
		$s7 = Carbon::now()->addDays(7);
		$date7 = new DateTime($s7);
		$s7m = $date7->format('Y-m-d ');
		
		
		$res = $res1 = $res2 = $res3 = $res4 = $res5 = $res6 = $res7 = array();
		
		$p = count($res);
		$p1 = count($res1);
		$p2 = count($res2);
		$p3 = count($res3);
		$p4 = count($res4);
		$p5 = count($res5);
		$p6 = count($res6);
		$p7 = count($res7);
		
		//services start
			$start_time = '00:00:00';
			$date_sr = new DateTime();
			$today_start_time = $date_sr->format('Y-m-d '.$start_time);
			$today_end_time = new DateTime('NOW');
			
			
		//todays count start
				$qry1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','New')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','New')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();

				 
				 $qry2 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','In Progress')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb2 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','In Progress')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
				 
				 $qry3 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','Awaiting Spares')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb3 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','Awaiting Spares')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
		
				$qry4 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','Work Pending')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb4 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','Work Pending')
                 ->where('sh.service_type','=','New Installation')
                 ->where('v.deleted_at','=','N')
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
				 
				 $qry5 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','Client Side')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				 
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                  $qryb5 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','Client Side')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				 
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
				 
				 $qry6 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','Completed')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				 
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb6 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','Completed')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				 
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
				 
				 $qry7 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','Closed')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				 
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb7 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','Closed')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				 
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
				 
				 $qry8 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','Cancelled')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				 
				 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
				 ->get();

                 $qryb8 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','Cancelled')
                 ->where('sh.service_type','=','New Installation')
				 				 ->where('v.deleted_at','=','N')
                 ->whereBetween('sh.order_time',array($today_start_time,$today_end_time))
                 ->get();
		//end
						 
				$query1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  
    			 ->where('sh.delivery_status','=','New')
                 ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				 
				 ->get();

                 $queryb1 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  
                 ->where('sh.delivery_status','=','New')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				 
                 ->get();
				  
				  
	$query2 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  ->where('sh.delivery_status','=','In Progress')
                  ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				  
				  ->get();

                  $queryb2 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  ->where('sh.delivery_status','=','In Progress')
                  ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				  
                  ->get();
				  
				  $query3 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  ->where('sh.delivery_status','=','Awaiting Spares')
                  ->where('sh.service_type','=','Complain')
				  				 ->where('v.deleted_at','=','N')
				  ->get();

                   $queryb3 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  ->where('sh.delivery_status','=','Awaiting Spares')
                  ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				  
                  ->get();
				  
				  $query4 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  ->where('sh.delivery_status','=','Work Pending')
                  ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				  
				  ->get();

                  $queryb4 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  ->where('sh.delivery_status','=','Work Pending')
                  ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				  
                  ->get();
				  
				  $query5 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  ->where('sh.delivery_status','=','Client Side')
                  ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				  
				  ->get();

                   $queryb5 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  ->where('sh.delivery_status','=','Client Side')
                  ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				  
                  ->get();
				  
				  $query6 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  ->where('sh.delivery_status','=','Completed')
                  ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				  
				  ->get();

                   $queryb6 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  ->where('sh.delivery_status','=','Completed')
                  ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')				  
                  ->get();
				  
				  $query7 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				  ->where('sh.delivery_status','=','Closed')
                  ->where('sh.service_type','=','Complain')
				 ->where('v.deleted_at','=','N')				  
				  ->get();

                  $queryb7 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                  ->where('sh.delivery_status','=','Closed')
                  ->where('sh.service_type','=','New Installation')
				  				 ->where('v.deleted_at','=','N')
                  ->get();
				  
				  $query8 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
				   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
				 ->where('sh.delivery_status','=','Cancelled')
                 ->where('sh.service_type','=','Complain')
				  ->where('v.deleted_at','=','N')
				  ->get();

                  $queryb8 = DB::table('shipment as sh')          
                  ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                   ->leftJoin('vendor as v','v.id','=','sh.vendor_id')
                  ->select('sh.id','sh.awb_no','sh.order_time','sh.delivery_status','biker.id as biker_id','biker.first_name','biker.last_name','biker.type as biker_type','v.company_name','v.deleted_at')
                 ->where('sh.delivery_status','=','Cancelled')
                 ->where('sh.service_type','=','New Installation')
				 ->where('v.deleted_at','=','N')
                  ->get();
		
		    	  $a1 = count($query1);				
				  $a2 = count($query2);				
				  $a3 = count($query3);				
				  $a4 = count($query4);				
				  $a5 = count($query5);				
				  $a6 = count($query6);				
				  $a7 = count($query7);				
				  $a8 = count($query8);	

                  $b1 = count($queryb1);                
                  $b2 = count($queryb2);             
                  $b3 = count($queryb3);             
                  $b4 = count($queryb4);             
                  $b5 = count($queryb5);             
                  $b6 = count($queryb6);             
                  $b7 = count($queryb7);             
                  $b8 = count($queryb8); 	

				  $a9 = count($qry1);				
				  $a10 = count($qry2);				
				  $a11 = count($qry3);				
				  $a12 = count($qry4);				
				  $a13 = count($qry5);				
				  $a14 = count($qry6);				
				  $a15 = count($qry7);				
				  $a16 = count($qry8);	

                  $b9 = count($qryb1);               
                  $b10 = count($qryb2);              
                  $b11 = count($qryb3);              
                  $b12 = count($qryb4);              
                  $b13 = count($qryb5);              
                  $b14 = count($qryb6);              
                  $b15 = count($qryb7);              
                  $b16 = count($qryb8);  			
	   
		//services end
		
		//amcs  start
		//$amcs = DB::table('amcs')->get();
        $amcs =  DB::table('amcs as a')
        ->leftJoin('products as p','p.id','=','a.product_id')
        ->select('a.*','p.product_name',DB::raw('DATEDIFF(end_date,NOW()) as exp_days'))
       /* ->where('a.end_date','>=',date('Y-m-d', strtotime('-15 days')))
        ->where('a.end_date','>=',DB::raw('NOW()'))
        ->where(DB::raw('DATEDIFF(end_date,NOW())'),'<=',15)
        */
         
        ->where(function ($query) {
                $query->whereBetween('a.end_date',[date('Y-m-d') ,date('Y-m-d', strtotime('+15 days')) ])
                      ->orwhereBetween('a.end_date',[date('Y-m-d', strtotime('-30 days')),date('Y-m-d') ]);
            })
        ->get();
		$today = Carbon::now();
		$newDate = substr($today->addDays(15),0,10);
        $i = 0;
        $array = array();
    //echo "<pre>";   print_r($amcs);exit();
		foreach($amcs as $amc)
		{
			
			//$newDate1 = $newDate->format('Y-m-d');
			$end_date = $amc->end_date;
			//echo $amc->id."-".$newDate."-".$end_date."<br/>";
			$vid = $amc->vendor_id;
			$vquery = DB::table('vendor')
                        ->select('*')
                        ->where('id','=',$vid)
						->where('deleted_at','=','N')
                        ->first();

			if($vquery){
    			$vcname = $vquery->name.(!empty($vquery->company_name)?' / '.$vquery->company_name:'');
                $vpname = $amc->product_name;
                $exp_days = $amc->exp_days;
			
			//if($end_date == $newDate){
				$i++;
				$array[$i]['cname'] = $vcname;
                $array[$i]['pname'] = $vpname;
                $array[$i]['exp_days'] = $exp_days;
                $array[$i]['id'] = $amc->id;				
				}
			//}
		}
		//print_r($array);exit();
		//amc end

//registration start
		$regs = DB::table('vendor')->where('deleted_at','=','N')->where('ctype','=','Mobile')->where('created_at','>=',date('Y-m-d', strtotime('-7 days')))->where('status','=','In Active')->get();
            // ->toSql();
            // dd($regs);die;
            
		$ttdate = Carbon::now()->format('Y-m-d');
		//print_r($regs);
		
		$t = 0;
		//$a1[] = "";
		//$array[] = "";
		$ab = array();
        //echo "<pre>";   print_r($regs);exit();
		foreach($regs as $reg)
		{			
				$t++;
				//$ab[$t]= $rgid;
                $ab[$t]['name']= $reg->name;
                $ab[$t]['email']= $reg->email;
                $ab[$t]['mobile_no']= $reg->mobile_no;
                $ab[$t]['landline_no']= $reg->landline_no;
				$ab[$t]['id']= $reg->id;
                $ab[$t]['status']= $reg->status;
			
		}
		//print_r($a1);
		//exit();
		//registration end
         
        return view('report.inventory_reconciliation',['total_client'=>$total_client,'total_technician'=>$total_technician,'pending_service'=>$pending_service,'completed_service'=>$completed_service,'total_service'=>$total_service,'total_amc'=>$total_amc,'total_bad_rating'=>$total_bad_rating,'total_good_rating'=>$total_good_rating,'p1'=>$p1,'p2'=>$p2,'p3'=>$p3,'p4'=>$p4,'p5'=>$p5,'p6'=>$p6,'p7'=>$p7,'p'=>$p,'a1'=>$a1,'a2'=>$a2,'a3'=>$a3,'a4'=>$a4,'a5'=>$a5,'a6'=>$a6,'a7'=>$a7,'a8'=>$a8,'a9'=>$a9,'a10'=>$a10,'a11'=>$a11,'a12'=>$a12,'a13'=>$a13,'a14'=>$a14,'a15'=>$a15,'a16'=>$a16,'b1'=>$b1,'b2'=>$b2,'b3'=>$b3,'b4'=>$b4,'b5'=>$b5,'b6'=>$b6,'b7'=>$b7,'b8'=>$b8,'b9'=>$b9,'b10'=>$b10,'b11'=>$b11,'b12'=>$b12,'b13'=>$b13,'b14'=>$b14,'b15'=>$b15,'b16'=>$b16])->withRes($res)->withRes1($res1)->withRes2($res2)->withRes3($res3)->withRes4($res4)->withRes5($res5)->withRes6($res6)->withRes7($res7)->withArray($array)->withAb($ab);
		
		//return view('home');
	}

	public function error()
	{
		$error_message = "You are not authorised person to access this page.";
		return view('home')->withErrorMessage($error_message);
	}

	public function resetPassword(Request $request) {
        if($request->all()){
            $input = $request->all();
            $password = bcrypt($input['password']);
            $a = User::where('id', $request->user()->id)->update(['password' => $password]);
            $request->session()->flash('success', 'Your password has been changed successfully.');
            return redirect("/manageadmin");
        } else {
            return redirect("/manageadmin");
        }
    }

    // Added a function by gaurav on 26-feb-2020 for resetting password of a client...
    public function clientresetPassword(Request $request) {
        //taking session id of particular user and then storing it in a particular variables
        $value = $request->session()->all();
        $id = $value['custid'];
    
        if($request->all()){
            $input = $request->all();
            $password = bcrypt($input['password']);
            DB::table('vendor')->where('id', $id)->update(['password' => $password]);
            // $a = Vendor::where('email', $input['id'])->update(['password' => $password]);
            $request->session()->flash('success', 'Your password has been changed successfully.');
            return redirect("service/create");
        } else {
            return redirect("service/create");
        }
    }// Comment section End

}
