<?php

namespace App\Http\Controllers\Bikers;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Bikers;
use Input;
use DB;
use DateTime;
use Carbon\Carbon;

class CalculateDistanceController extends Controller
{

	public function calculate_distance()
    {
        $date_time = Carbon::now()->toDateTimeString();
        $records = DB::table('biker_location as bl')
                    ->where('bl.distance_calculated','=',0)
                    ->orderby('bl.date_time','ASC')
                    ->get();
        		            
        $data = array();
              
        foreach ($records as $key => $row) {
            $date = new DateTime($row->date_time);
            $row->date = $date->format('Y-m-d');
            $data[$row->biker_id][$row->date][] = $row;
        }
               
        foreach($data as $biker_id => $value) {
            foreach ($value as $date => $distance) {
                            //echo "<pre>"; print_r($biker_id);print_r($date);print_r(count($distance));
                $km = 0;
                 for ($i=1; $i < count($distance); $i++) {
                        usleep(500000);
                        //echo "<pre>"; print_r($distance[$i-1]->latitude);   
                        $km += $this->distanceCalculation((double)$distance[$i-1]->latitude, (double)$distance[$i-1]->longitude, (double)$distance[$i]->latitude, (double)$distance[$i]->longitude);
                    }
                $biker = DB::table('bikers_reading')
                        ->where('bikers_id','=',$biker_id)
                        ->where('reading_date','=',$date)
                        ->first();

                if($biker) {
                    DB::table('bikers_reading')
                        ->where('bikers_id','=',$biker_id)
                        ->where('reading_date','=',$date)
                        ->update(['distance_m_to_e' => $km,'updated_at' => $date_time]);
                } else {
                    DB::table('bikers_reading')
                        ->insert(['bikers_id'=> $biker_id,'reading_date' => $date,'distance_m_to_e' => $km,'created_at'=> $date_time,'updated_at'=> $date_time]);
                }

                DB::table('biker_location')
                    ->where('biker_id','=',$biker_id)
                    ->wherebetween('date_time',array($date.' 00:00:00',$date.' 23:59:59'))
                    ->update(['distance_calculated' => 1]);
            }
        }
        echo 'done';
    }

    public function distanceCalculation($point1_lat, $point1_long, $point2_lat, $point2_long, $unit = 'km', $decimals = 2) {
        // Calculate the distance in degrees
        $start  = urlencode($point1_lat.','.$point1_long);
        $finish = urlencode($point2_lat.','.$point2_long);

        $distance   = '0';
        $time       = '0';
        $raw = false;


        $url = 'http://maps.googleapis.com/maps/api/directions/xml?origin='.$start.'&destination='.$finish.'&sensor=false';
        if($data = file_get_contents($url))
        {
            $xml = new \SimpleXMLElement($data);

            if(isset($xml->route->leg->duration->value) AND (int)$xml->route->leg->duration->value >= 0)
            {
                if($raw)
                {
                    $distance = (string)$xml->route->leg->distance->text;
                    $time     = (string)$xml->route->leg->duration->text;
                }
                else
                {
                    $distance = (int)$xml->route->leg->distance->value / 1000 / 1.609344; 
                    $time     = (int)$xml->route->leg->duration->value;
                }
            }
            else
            { 
                var_dump($xml);
                echo ('Could not find that route');
            }

            return $distance * 1.60934; //convert to kms 
        }
        else
        {
            echo('Could not resolve URL');
        }

        return $distance * 1.60934; //convert to kms  
        round($distance, $decimals);
    }

}