<?php 
namespace App;
use App\Vendor;

use Illuminate\Database\Eloquent\Model;

class Warranty extends Model
{
    protected $table = 'warranties';
    protected $fillable = [
        'client_id',
        'product_id',
        'warranty_start_date',
        'warranty_end_date',
        'part_replacement_start_date',
        'part_replacement_end_date',
        'notes',
    ];

public function client()
{
    return $this->belongsTo(Vendor::class, 'client_id')
        ->where('vendor.deleted_at', 'N');
}

    public function product()
    {
        return $this->belongsTo(Products::class);
    }
}
