<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use DB;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
                // ✅ Share dynamic setting to all views
        View::composer('*', function ($view) {
            $raw = DB::table('site_settings')->value('settings');
            $settings = $raw ? unserialize(urldecode($raw)) : [];

            $clientManageUrl = isset($settings['location']) && $settings['location'] === '1'
                ? '/vendormultipleaddresses'
                : '/managevendor';

               $menuUrls = [
            'statuses'      => route('statuses.index'),
            'service_types' => route('service-types.index'),
        ];

            

             $view->with([
            'clientManageUrl' => $clientManageUrl,
            'menuUrls' => $menuUrls,
            'settings' => $settings,
        ]);
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
