<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Vendor;

class ManageVendorAddress extends Model
{
    protected $table = 'managevendoraddress';

    protected $fillable = [
        'vendor_id',
        'address_line1',
        'address_line2',
        'landmark',
        'city',
        'state',
        'country',
        'pin_code',
        'contact_number',
        'title_address'
    ];

    public $timestamps = false;

    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id');
    }
}



// app/ManageVendorAddress.php

