<?php

namespace App\Jobs;

use App\User;
use App\Jobs\Job;
use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Bus\SelfHandling;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendEmailJob extends Job implements SelfHandling, ShouldQueue
{
    use InteractsWithQueue, SerializesModels;

    private $details;
    private $detailemail;

    /**
     * Create a new job instance.
     *
     * @param  User  $user
     * @return void
     */
    public function __construct($details,$detailemail)
    {
        $this->details = $details;
        $this->detailemail = $detailemail;
    }

    /**
     * Execute the job.
     *
     * @param  Mailer  $mailer
     * @return void
     */
    public function handle(Mailer $mailer)
    {
        $data = $this->details;
        $emailcontent = $this->detailemail;
        Mail::send('emails.vendorwelcome', $emailcontent, function ($message) use ($data) {  
            $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
            $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
            $message->to($data['email'])->subject(Config::get('app.companyname').' New Customer Registration');
        });

    }
}