<?php
use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

//Route::group(array('domain' => 'seller.{domain}.{tld}'), function()
//{
Route::get('cron/schedule_amc_service', 'Amcs\AmcSchedulerController@schedule_amc_service');
    Route::get('/', 'VendorLogin\LoginController@login');
    Route::get('login', 'VendorLogin\LoginController@login');
    Route::post('login', 'VendorLogin\LoginController@login');
    Route::get('logout', 'VendorLogin\LoginController@logout');
    Route::post('logout', 'VendorLogin\LoginController@logout');
    Route::get('ValidateVendor', 'VendorLogin\LoginController@ValidateVendor');
    Route::post('ValidateVendor', 'VendorLogin\LoginController@ValidateVendor');
    Route::resource('shipment', 'VendorLogin\ShipmentController');
    Route::resource('/shipment_report', 'VendorLogin\OrderController@ShipmentReport');
    //Route::resource('invoice/', 'VendorLogin\InvoiceController');
    Route::get('order', 'VendorLogin\OrderController@index');
    Route::get('order/filter/{status}', 'VendorLogin\OrderController@index');
    Route::get('order/downloadExel', 'VendorLogin\OrderController@DownloadExel');
    // Route::get('order', 'VendorLogin\OrderController@index');
    //Route::get('invoice/{id}', 'VendorLogin\OrderController@show');
    Route::get('invoice/{id}', ['uses' =>'VendorLogin\OrderController@printinvoice']);
    Route::get('forgotpassword', 'VendorLogin\LoginController@forgotPassword');
    Route::post('forgotpassword', 'VendorLogin\LoginController@forgotPassword');
    Route::get('forgotpasswordindex', 'VendorLogin\LoginController@forgotPasswordIndex');

    Route::get('resetpassword', 'VendorLogin\LoginController@resetPassword');
    Route::post('resetpassword', 'VendorLogin\LoginController@resetPassword');
    Route::get('resetpasswordindex', 'VendorLogin\LoginController@resetPasswordIndex');

    //Sudo login for vendor
    Route::get('autologin/{url}', ['uses' =>'VendorLogin\LoginController@autoLogin']);
    //for bulk upload
    Route::get('bulkupload', 'VendorLogin\BulkUploadController@bulkupload');
    Route::get('upload', 'VendorLogin\BulkUploadController@bulkupload');
    Route::post('upload', 'VendorLogin\BulkUploadController@upload');
    Route::get('bulkuploaderror', 'VendorLogin\BulkUploadController@BulkUploadError');

//});
    //APIs For Showing Vendor Details using api_key/secret_key
Route::group(array('domain' => 'api.{domain}.{tld}'), function(){
    Route::get('status/{api_key?}/{secret_key?}/{awb_no?}', 'Api\WebApiController@status');
    Route::post('createshipment/{api_key?}/{secret_key?}', 'Api\WebApiController@createshipment');
});


Route::post('client/weblogin', 'VendorLogin\LoginController@webclientlogin');

Route::post('getintouch', 'VendorLogin\LoginController@getInTouch');
Route::get('getintouch', 'VendorLogin\LoginController@getInTouch');
Route::post('eliminate_logistics_challenges', 'VendorLogin\LoginController@LandingPage');
Route::get('eliminate_logistics_challenges', 'VendorLogin\LoginController@LandingPage');
Route::post('landing_page_email', 'VendorLogin\LoginController@LandingPageEmail');
Route::get('landing_page_email', 'VendorLogin\LoginController@LandingPageEmail');

Route::get('/', function () {
    
   /* $handle = @fopen(app_path()."/../counter.txt", "r");
    $counter = 0; 
    if($handle) { 
        $counter = (int) fread($handle,20); 
        fclose ($handle); 
    } 
        
    if(!Session::has('counted')) {
        Session::put('counted', 1);
        $counter++; 
        $handle = fopen(app_path()."/../counter.txt", "w" ); 
        fwrite($handle, $counter); 
        fclose($handle); 
    }*/
     $counter = 0;
    return view('welcome')->withCounter($counter);
});




/* api routting starts for version 1.0 */

Route::get('api1_0/awb/{awb}', 'Api1_0\ApiController@awb');
Route::get('api1_0/testemail', 'Api1_0\ApiController@testemail');
Route::get('api1_0/getTickets/{vendorid}', 'Api1_0\ApiController@getTickets');
Route::get('api1_0/delivery/{id}', 'Api1_0\ApiController@delivery');
Route::get('api1_0/delivery1/{id}', 'Api1_0\ApiController@delivery1');
Route::get('api1_0/delivery2/{id}', 'Api1_0\ApiController@delivery2');
Route::get('api1_0/getallservicehistory/{id}', 'Api1_0\ApiController@getallservicehistory');
Route::get('api1_0/getTechnicianStatus/{id}', 'Api1_0\ApiController@getTechnicianStatus');
Route::get('api1_0/getServiceDetails/{serviceId}', 'Api1_0\ApiController@getServiceDetails');
Route::get('api1_0/profilestatus/{id}', 'Api1_0\ApiController@profilestatus');
Route::get('api1_0/bikerstatus/{id}/{status}/{date_time}','Api1_0\ApiController@StatusUpdate');
Route::get('api1_0/deliverystatus/{id}/{awb_no}/{status}/{mode}/{date_time}/{service_action}','Api1_0\ApiController@DeliveryUpdate');
Route::get('api1_0/LocationUpdate/{id}/{currlat}/{currlng}/{date_time}','Api1_0\ApiController@LocationUpdate');
Route::get('api1_0/LocationUpdate/{id}/{currlat}/{currlng}/{date_time}/{awb_no}/{status}','Api1_0\ApiController@LocationUpdate');

Route::get('api1_0/bikerlogin', 'Api1_0\ApiController@ValidateBiker');
Route::post('api1_0/bikerlogin', 'Api1_0\ApiController@ValidateBiker');
Route::get('api1_0/bikerlogin1', 'Api1_0\ApiController@ValidateBikerTest');
Route::post('api1_0/bikerlogin1', 'Api1_0\ApiController@ValidateBikerTest');
Route::get('api1_0/bikerlogout/{id}/{is_ios}', 'Api1_0\ApiController@ValidateBikerlogout');
Route::get('api1_0/vendorlogout/{id}/{is_ios}', 'Api1_0\ApiController@ValidateVendorlogout');
Route::post('api1_0/servicerequest', 'Api1_0\ApiController@servicerequest');
Route::post('api1_0/servicerequestnew', 'Api1_0\ApiController@servicerequestnew');
Route::post('api1_0/requesthistory', 'Api1_0\ApiController@requesthistory');
Route::get('api1_0/amchistory/{vendor_id}', 'Api1_0\ApiController@amchistory');
Route::post('api1_0/requesthistorynumber', 'Api1_0\ApiController@requesthistorynumber');
Route::post('api1_0/requesthistorynumber2', 'Api1_0\ApiController@requesthistorynumber2');
Route::get('api1_0/requesthistorynumber1/{vendor_id}/{tech_id}', 'Api1_0\ApiController@requesthistorynumber1');
Route::post('api1_0/ValidateVendor', 'Api1_0\ApiController@ValidateVendor');
Route::get('api1_0/ValidateVendor', 'Api1_0\ApiController@ValidateVendor');
Route::post('api1_0/resetpasswordnew', 'Api1_0\ApiController@resetpasswordnew');
Route::get('api1_0/storesign', 'Api1_0\ApiController@storesign');
Route::post('api1_0/storesign', 'Api1_0\ApiController@storesign');
Route::post('api1_0/storesignios', 'Api1_0\ApiController@storesignios');
Route::post('api1_0/gcmregid', 'Api1_0\ApiController@gcmregid');
Route::post('api1_0/gcmregidvendor', 'Api1_0\ApiController@gcmregidvendor');
Route::get('api1_0/transactionNumber/{id}/{awb_no}/{mode}/{date_time}/{transactionNumber}','Api1_0\ApiController@transactionNumber');
Route::get('api1_0/resetpassword/{bikerid}/{password}', 'Api1_0\ApiController@resetpassword');
Route::get('api1_0/requesthistoryfilter/{vid}/{status}', 'Api1_0\ApiController@requesthistoryfilter');
Route::get('api1_0/requesthistoryEmpfilter/{vid}/{status}', 'Api1_0\ApiController@requesthistoryEmpfilter');
Route::get('api1_0/requesthistorytype/{vid}/{type}', 'Api1_0\ApiController@requesthistorytype');
Route::get('api1_0/requesthistoryEmptype/{vid}/{type}', 'Api1_0\ApiController@requesthistoryEmptype');
Route::get('api1_0/requesthistoryEmpsearchfilter/{vid}/{searchtxt}', 'Api1_0\ApiController@requesthistoryEmpsearchfilter');
Route::get('api1_0/requesthistorysearchfilter/{vid}/{searchtxt}', 'Api1_0\ApiController@requesthistorysearchfilter');
Route::get('api1_0/apiforgetpassword/{email}', 'Api1_0\ApiController@apiforgetpassword');
Route::get('api1_0/resetgcm/{vid}/{gcmid}', 'Api1_0\ApiController@resetgcm');
Route::get('api1_0/resetpassword1/{bikerid}/{password}', 'Api1_0\ApiController@resetpassword1');
Route::get('api1_0/dropdown', 'Api1_0\ApiController@drop_down_list');
Route::post('api1_0/VendorRegistration', 'Api1_0\ApiController@VendorRegistration'); 
Route::get('api1_0/getVendorDetailApi/{id}', 'Api1_0\ApiController@getVendorDetailApi');
Route::post('api1_0/VendorApiUpdateRegistration', 'Api1_0\ApiController@VendorApiUpdateRegistration');
Route::get('api1_0/getproductlist', 'Api1_0\ApiController@getproductlist');
Route::get('api1_0/getproductlist1', 'Api1_0\ApiController@getproductlist1');
Route::get('api1_0/getvendorlist', 'Api1_0\ApiController@getvendorlist');
Route::post('api1_0/prevLocationUpdate', 'Api1_0\ApiController@prevLocationUpdate');
Route::get('api1_0/getSupportNo', 'Api1_0\ApiController@getSupportNo');
//by gajendra
Route::post('api1_0/store_attachment', 'Api1_0\ApiController@store_attachment');
Route::post('api1_0/delete_attachment', 'Api1_0\ApiController@delete_attachment');
Route::get('api1_0/getinventorylist', 'Api1_0\ApiController@getinventorylist');
//vickey
Route::post('api1_0/storerma', 'Api1_0\ApiController@storerma'); 
Route::get('api1_0/getrma/{sid}', 'Api1_0\ApiController@getrma'); 

Route::post('api1_0/checklistdata', 'Api1_0\ApiController@checklistdata'); 
Route::post('api1_0/storesign1', 'Api1_0\ApiController@storesign1');
Route::post('api1_0/generatotp', 'Api1_0\ApiController@generatotp'); 
Route::post('api1_0/verifyotp', 'Api1_0\ApiController@verifyotp'); 
Route::post('api1_0/start_end_image_upload', 'Api1_0\ApiController@start_end_image_upload'); 
Route::post('api1_0/imageUpload', 'Api1_0\ApiController@imageUpload'); 
Route::post('api1_0/getsignature_otp_status', 'Api1_0\ApiController@getsignature_otp_status');
//vickey


/* api routing ends */
Route::get('client/loginpage', function () {
if(Session::get('custid'))
{
    Session::flush();
}
    return view('auth/login');
});
Route::get('auth/login', 'Auth\AuthController@getLogin');
Route::get('admin', 'Auth\AuthController@getLogin');
Route::post('auth/login', 'Auth\AuthController@postLogin');
Route::get('auth/logout', 'Auth\AuthController@getLogout');
Route::post('auth/forgotpassword', 'Auth\PasswordController@forgotPassword');
Route::get('auth/register', 'Auth\AuthController@getRegister');
Route::post('auth/register', 'Auth\AuthController@postRegister');
Route::get('calculatedistance','Bikers\CalculateDistanceController@calculate_distance');
// Changes by gaurav to make forgot password for client on 26-feb-2020..
Route::get('client/password/clientemail','VendorLogin\LoginController@forgotPasswordClient');
Route::post('client/password/forgotpassword','Auth\PasswordController@forgotPasswordClient');

Route::controllers([
    'auth' => 'Auth\AuthController',
    'password' => 'Auth\PasswordController',
]);


Route::get('home', 'HomeController@index');
Route::get('home/error', 'HomeController@error');

// Priority Routes

Route::resource('managepriority', 'Priority\PriorityController');
Route::get('priority','Priority\PriorityController@index');
Route::get('managepriority/create', 'Priority\PriorityController@create');
Route::post('managepriority/store', 'Priority\PriorityController@store');
Route::get('managepriority/edit/{id}', 'Priority\PriorityController@edit');
Route::post('managepriority/update/{id}', 'Priority\PriorityController@update');
Route::post('managepriority/show', 'Priority\PriorityController@show');
Route::get('managepriority/destroy/{id}', 'Priority\PriorityController@destroy');






Route::get('resetpassword', 'HomeController@resetPassword');
Route::post('resetpassword', 'HomeController@resetPassword');
// Added by gaurav on 26-feb-20 for changing client password url
Route::post('changePassword', 'HomeController@clientresetPassword');

Route::group(['middleware' => 'acl:manage_vendor'], function () {
    Route::resource('managevendor', 'Vendor\VendorController');
    Route::get('/csvcreate', 'Vendor\VendorController@csvcreate');
    Route::get('/clientcsvsample', 'Vendor\VendorController@csvsampledownload');
    Route::post('/bulkimport', 'Vendor\VendorController@bulkimport');
    //Route::get('managevendor/{id}/edit', 'Vendor\VendorController@edit');
           // ✅ New: Full resource routes for VendorMultipleAddress
    Route::resource('vendormultipleaddresses', 'VendorMultipleAddress\VendorMultipleAddressController');
});
//added by sundaram on 14-06-2021 for service provider start
Route::resource('serviceprovider', 'ServiceProvider\ServiceproviderController');
//added by sundaram on 14-06-2021 for service provider end

/*added by brijesh on 24-07-2020*/
Route::group(['middleware' => 'acl:manage_rma'], function () {
    Route::resource('managerma', 'ManageRma\RmaController@index');
});

Route::get('/managerma/create','ManageRma\RmaController@create');
Route::post('managerma/store','ManageRma\RmaController@store');
Route::get('managerma/delete/{id}','ManageRma\RmaController@destroy');
Route::get('managerma/edit/{id}','ManageRma\RmaController@edit');
Route::get('managerma/update/{id}','ManageRma\RmaController@update');
Route::get('managerma/show/{id}','ManageRma\RmaController@show');
Route::post('managerma/updatestatus','ManageRma\RmaController@updatestatus');
Route::POST('managerma/finalupdate','ManageRma\RmaController@finalupdate');

/*
Route::get('players', 'PlayerController@index');
Route::get('player/add', 'PlayerController@add')->middleware('auth'); // move this above player/{player}
Route::get('player/{player}', 'PlayerController@view'); // move this below player/add
Route::post('players', 'PlayerController@search');
*/
Route::group(['middleware' => 'acl:manage_admin'], function () {
    Route::resource('manageadmin', 'ManageAdmin\ManageAdminController');
});

Route::group(['middleware' => 'acl:manage_product'], function () {
    Route::resource('manageproduct', 'ManageProduct\ManageProductController');

    Route::get('/product-release','ManageProduct\ManageProductController@release')->name('product.release');




});



Route::group(['middleware' => 'acl:manage_biker'], function () {

    //Route::get('get_all_bikers', 'Bikers\BikersController@getAllBikers');

  
    Route::get('bikers', 'Bikers\BikersController@index');
     Route::get('bikers/{id}/edit', 'Bikers\BikersController@edit'); // move this below player/add
       Route::post('bikers/{id}/update', 'Bikers\BikersController@update'); // move this below player/add
    Route::resource('bikers_reading', 'Bikers\Bikers_readingController');
    Route::get('add_cod_details', 'Bikers\BikersController@add_cod_details');
    Route::post('add_cod_details', 'Bikers\BikersController@add_cod_details');

    Route::get('addReading', 'Bikers\BikersController@addReading');
    Route::post('addReading', 'Bikers\BikersController@addReading');
    Route::get('fetch_reading', 'Bikers\Bikers_readingController@fetch_reading');
    Route::post('fetch_reading', 'Bikers\Bikers_readingController@fetch_reading');
    Route::get('bikers/{id}/bikermapdetails', 'Bikers\BikersController@bikermapdetails');
      Route::resource('bikers', 'Bikers\BikersController');
});

Route::group(['middleware' => 'acl:manage_amc'], function () {
//  Route::get('amcs/indexnew', 'Amcs\AmcsController@indexnew');

 Route::get('amcs/indexnew', 'Amcs\AmcsController@indexnew')->name('amcs.indexnew');
 
 Route::get('/amcs/indexrequest', 'Amcs\AmcsController@indexrequest');
//  Route::get('amcs/show', 'Amcs\AmcsController@show');
 Route::get('amcs/updateallvendorsname', 'Vendor\VendorController@updateallvendorsname');
    Route::get('amcs/amcservice', 'Amcs\AmcsController@amcservice');
Route::get('amcs/amcmail', 'Amcs\AmcsController@amcmail');
Route::resource('amcs', 'Amcs\AmcsController');
});

// Route::group(['middleware' => 'acl:manage_checklist'], function () {

 Route::get('checklist/indexnew', 'Checklist\ChecklistController@indexnew');
 Route::get('checklist/create', 'Checklist\ChecklistController@create');
 Route::post('checklist/insert', 'Checklist\ChecklistController@insert');
Route::resource('checklist', 'Checklist\ChecklistController');

Route::post('managedelivery/updatechecklist1','Delivery\ManageDeliveryController@updatechecklist1');


 Route::get('emailcredential/indexnew', 'Emailcredetial\EmailcredetialController@indexnew');
 Route::get('emailcredential/create', 'Emailcredetial\EmailcredetialController@create');
 Route::post('emailcredential/insert', 'Emailcredetial\EmailcredetialController@insert');
Route::resource('emailcredential', 'Emailcredetial\EmailcredetialController');

// });
//Route::group(['middleware' => 'acl:manage_rating'], function () {

//Route::post('ratings/selectshipment','Ratings\RatingsController@selectshipment');
Route::get('ratings/create1/{cname}/{tno}/{vid}', 'Ratings\RatingsController@create1');
Route::get('ratings/indexnew', 'Ratings\RatingsController@indexnew');
Route::post('ratings/showgraph','Ratings\RatingsController@showgraph');
Route::get('ratings/graph','Ratings\RatingsController@graph');
Route::get('ratings/ajax','Ratings\RatingsController@ajax');
Route::post('ratings/ajax1','Ratings\RatingsController@ajax1');
Route::get('ratings/ajax2','Ratings\RatingsController@ajax2');
Route::get('ratings/getmsg','Ratings\RatingsController@getmsg');

Route::post('ratings/fetchtechname','Ratings\RatingsController@fetchtechname');
Route::resource('ratings', 'Ratings\RatingsController');


//});
//Route::get('ratings/create','Ratings\RatingsController@create');
//Route::post('ratings/store','Ratings\RatingsController@store');
//Route::get('ratings/index','Ratings\RatingsController@index');

Route::get('tat','sla_tat_controller@tat');
Route::get('sla_setting/sla_form','SLA_Setting\SLA_SettingController@sla_form');
Route::post('sla_setting/sla_formUpdate','SLA_Setting\SLA_SettingController@sla_formUpdate');

Route::group(['middleware' => 'acl:manage_substation'], function () {
    Route::resource('substation', 'Substation\SubstationController');
});

Route::group(['middleware' => 'acl:bank_cod_collected'], function () {
    Route::post('bank_cod_deposit', 'Substation\SubstationController@bank_cod_deposit');
    Route::get('bankdeposit', 'Substation\SubstationController@bankdeposit');
});

Route::group(['middleware' => 'acl:update_status'], function () {
    Route::resource('updatestatus', 'Shipment\UpdateStatusController');
});



Route::group(['middleware' => 'acl:download_deliveries'], function () {
    Route::resource('downloadreport', 'Shipment\GenerateReportController');
});

//vickey 9dec19
 Route::get('managedelivery/cronjobs-eveningemails','Delivery\ManageDeliveryController@cronjobs_eveningemails');
 Route::get('settings/featuresettings','Settings\SettingsController@featuresettings');
 Route::post('settings/storefeaturesettings','Settings\SettingsController@savefeaturesettings');
 //vickey 9dec19
//mehul 30dec19
 Route::get('badratings/cronjobs-badratingsemails','Ratings\RatingsController@cronjobs_badratingsemails'); 
//mehul 30dec19
Route::group(['middleware' => 'acl:manage_delivery'], function () {
    Route::get('managedelivery/updateBikerList','Delivery\ManageDeliveryController@updateBikerList'); //08-04-2025

    Route::resource('managedelivery', 'Delivery\ManageDeliveryController');
    Route::post('managedelivery/deliverydetails','Delivery\ManageDeliveryController@deliverydetails');
    Route::get('managedelivery/technician_deliverydetails/{awb_no}/{biker_id}','Delivery\ManageDeliveryController@technician_deliverydetails');
        Route::post('managedelivery/bikermapdetails','Delivery\ManageDeliveryController@bikermapdetails');
//mehul 3/1/2020        
Route::post('uploaddoc','Delivery\ManageDeliveryController@uploaddoc');
//mehul 3/1/2020         
    Route::post('managedelivery/assignbiker','Delivery\ManageDeliveryController@assignbiker');
    Route::post('managedelivery/assignbiker1','Delivery\ManageDeliveryController@assignbiker1');
    Route::post('managedelivery/assignbiker3','Delivery\ManageDeliveryController@assignbiker3');
    Route::post('managedelivery/updatestatus','Delivery\ManageDeliveryController@updatestatus');
Route::post('managedelivery/updatestatus1','Delivery\ManageDeliveryController@updatestatus1');
Route::post('managedelivery/updatepriority','Delivery\ManageDeliveryController@updatepriority');
    Route::post('managedelivery/transfersubstation','Delivery\ManageDeliveryController@transfersubstation');
    Route::post('managedelivery/advancesearch','Delivery\ManageDeliveryController@advancesearch');
    Route::post('managedelivery/countorders','Delivery\ManageDeliveryController@countorders');
    Route::post('managedelivery/countweight','Delivery\ManageDeliveryController@countweight');
    Route::post('managedelivery/bikerdetails','Delivery\ManageDeliveryController@bikerdetails');

    Route::post('managedelivery/testnotification','Delivery\ManageDeliveryController@testnotification');

    Route::post('managedelivery/updatepriority1','Delivery\ManageDeliveryController@updatepriority1');

    //Route::post('managedelivery/fetchtechname','Delivery\ManageDeliveryController@fetchtechname');
 Route::get('mailcheck','Delivery\ManageDeliveryController@mailcheck');
});
Route::group(['middleware' => 'acl:manage_permission'], function () {
    Route::resource('managepermission', 'ManagePermission\ManagePermissionController');
    // Route::post('managepermission/managepermissions','ManagePermission\ManagePermissionController@managepermissions');
});

Route::group(['middleware' => 'acl:report'], function () {
    Route::get('report', 'Report\ReportController@index');
    Route::post('report/orderdetails','Delivery\ManageDeliveryController@deliverydetails');
    
});
Route::group(['middleware' => 'acl:inventory_reconciliation'], function () {
    Route::get('/inventoryreconciliation','Report\ReportController@inventoryreconciliation');
});  
Route::group(['middleware' => 'acl:billing_n_accounting_report'], function () {
    Route::get('/billing_n_acc_report','Report\ReportController@billingAccountingReport');
    Route::post('/billing_n_acc_report','Report\ReportController@billingAccountingReport');
});
Route::group(['middleware' => 'acl:biker_report'], function () {
    Route::get('/bikers_report','Report\ReportController@bikerReport');
    Route::post('/bikers_report','Report\ReportController@bikerReport');
     Route::get('/amc_report','Report\ReportController@amcReport');
    Route::post('/amc_report','Report\ReportController@amcReport');
    Route::get('/customer_report','Report\ReportController@vendorReport');
    Route::post('/customer_report','Report\ReportController@vendorReport');
    Route::get('/bikercodreport','Report\ReportController@bikercodreport');
    Route::get('/rma_report','Report\ReportController@rmaReport');
    Route::post('/rma_report','Report\ReportController@rmaReport');
    Route::get('/rma_statics','Report\ReportController@rmastatics');
    Route::post('/rma_statics','Report\ReportController@rmastatics');
    //Route::get('/biker_report_download','Report\ReportController@bikerReportDownload');


});

//add route for SAMPLE DOWNLOAD
Route::get('/vendor-address/sample-download', 'ManageVendorAddress\ManageVendorAddressController@csvSampleDownload')->name('vendoraddress.sampledownload');


Route::group(['middleware' => 'acl:create_shipment'], function () {
    Route::get('/create_shipment','Vendor\VendorController@CreateShipment');
});

//gajendra 31-12-2018
Route::group(['middleware' => 'acl:manage_product'], function () {
    Route::resource('manageproduct', 'ManageProduct\ManageProductController');
});

Route::group(['middleware' => 'acl:manage_inventory'], function () {
    Route::resource('manageinventory', 'ManageInventory\ManageInventoryController');
});
//gajendra 31-12-2018

Route::get('service/create','Service\ServiceController@create');
Route::post('service/store','Service\ServiceController@store');
Route::get('service/smscheck','Service\ServiceController@smscheck');
Route::get('service/createautoservice','Service\ServiceController@createautoservice');
Route::get('amc/createautoservice','Amcs\AmcSchedulerController@createautoserviceamc');
Route::post('service/spclient', 'Service\ServiceController@spclientselect');
//Route::get('service/auto','Service\ServiceController@auto');
//Route::get('service/autocomplete', 'Service\ServiceController@autocomplete');
Route::get('service/getcheklistdata','Service\ServiceController@getcheklistdata');

Route::get('/admin/vendor/status/{vendor_id}', 'Service\ServiceController@getVendorStatus');

Route::get('/admin/vendor/getRequestDetails/{vendor_id}', 'Service\ServiceController@getRequestDetails');


// Route::resource('vendor', 'Vendor\VendorController');

// Route::get('/admin/vendor/locations/{vendor_id}', 'Vendor\VendorController@getVendorLocations');
Route::get('/admin/vendor/locations/{vendor_id}', 'Vendor\VendorController@getVendorLocations');
Route::get('service/getpriorities','Service\ServiceController@getpriorities');




Route::get('autocomplete',array('as'=>'autocomplete','uses'=>'AutoCompleteController@index'));
Route::post('store',array('as'=>'store','uses'=>'AutoCompleteController@store'));
Route::get('searchajax',array('as'=>'searchajax','uses'=>'AutoCompleteController@autoComplete'));

// Event::listen('illuminate.query', function($query)
// {
//     var_dump($query);
// });

// Changes by gaurav to make forgot password for client on 26-feb-2020..
Route::get('password/clientemail','VendorLogin\LoginController@forgotPasswordClient');
Route::post('/techniciancitystatedetails','Bikers\BikersController@techniciancitystatedetails');



      Route::get('bikers/{id}/status', 'Bikers\BikersController@currentStatus')->name('bikers.status');
//vatsal code
      Route::get('manageskill/create', 'ManageSkill\ManageSkillController@create')->name('manageskill.create');
Route::post('manageskill/store', 'ManageSkill\ManageSkillController@store')->name('manageskill.store');

Route::get('manageskill', 'ManageSkill\ManageSkillController@index')->name('manageskill.index');
Route::get('manageskill/{id}/edit', 'ManageSkill\ManageSkillController@edit')->name('manageskill.edit');
Route::put('manageskill/{id}', 'ManageSkill\ManageSkillController@update')->name('manageskill.update');
Route::delete('manageskill/{id}', 'ManageSkill\ManageSkillController@destroy')->name('manageskill.destroy');

Route::post('manageskill/bulk-delete', 'ManageSkill\ManageSkillController@bulkDelete')->name('manageskill.bulkDelete');
//vatsal end

//hari

 Route::post('/admin/request/update', 'Amcs\AmcsController@updateStatus')->name('admin.request.update');
Route::post('/send-whatsapp-on-assign', 'Delivery\ManageDeliveryController@sendWhatsappOnAssign');

Route::get('/request-service', 'Service\ServiceController@requestServiceForm');

Route::post('/services/request', 'Service\ServiceController@submitRequestService')->name('submit.request.service');




//<<<<<<<<<<<<<<<<<<<<<<<<<___FOR MULTIPLE LOCATION___>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

Route::get('/vendormultipleaddresses/vendor/{vendor_id}', 'ManageVendorAddress\ManageVendorAddressController@indexByVendor')->name('vendormultipleaddresses.byvendor');

Route::get('/vendormultipleaddresses/vendor/edit_address/{vendor_id}/{id}', 'ManageVendorAddress\ManageVendorAddressController@bulkEditForm')->name('vendormultipleaddresses.customEdit');

// Show the create form for a specific vendor
Route::get('/vendormultipleaddresses/vendor/{vendor_id}/create', 'ManageVendorAddress\ManageVendorAddressController@create')->name('vendormultipleaddresses.create');
Route::post('/vendormultiplevendors/store', 'VendorMultipleAddress\VendorMultipleAddressController@store')->name('vendormultiplevendors.store');
// Show edit form
Route::get('/vendormultiplevendors/{id}/edit', 'VendorMultipleAddress\VendorMultipleAddressController@edit')->name('vendormultiplevendors.edit');

// Update vendor
Route::post('/vendormultiplevendors/{id}/update', 'VendorMultipleAddress\VendorMultipleAddressController@update')->name('vendormultiplevendors.update');

//<<<<<<<<<<<<<<<<<<<<<<<<__Manage ADDRESS__>>>>>>>>>>>>>>>>>>>>
// ✅ CORRECT
Route::post('/vendormultipleaddresses/store', 'ManageVendorAddress\ManageVendorAddressController@store')->name('vendormultipleaddresses.store');

Route::post('/vendormultipleaddresses/bulk-action', 'ManageVendorAddress\ManageVendorAddressController@bulkAction')->name('vendormultipleaddresses.bulkAction');

Route::get('/vendormultipleaddresses/vendor/{vendor_id}/edit/{address_id}', 'ManageVendorAddress\ManageVendorAddressController@edit')->name('vendormultipleaddresses.edit');





// ✅ Bulk Import: show import form
Route::get('/vendormultipleaddresses/import', 'VendorMultipleAddress\VendorMultipleAddressController@show')->name('vendormultipleaddresses.import.form');

// ✅ Bulk Import: handle file upload
Route::post('/vendormultipleaddresses/import', 'VendorMultipleAddress\VendorMultipleAddressController@import')->name('vendormultipleaddresses.import');
Route::get('/vendormultipleaddresses/import/sample', 'VendorMultipleAddress\VendorMultipleAddressController@csvsampledownload')->name('vendormultipleaddresses.import.sample');


// Route::put('/vendormultipleaddresses/update/{id}', 'ManageVendorAddress\ManageVendorAddressController@update')->name('vendormultipleaddresses.update');
// Route::match(['put', 'post'], '/vendormultipleaddresses/update/{id}', 'ManageVendorAddress\ManageVendorAddressController@update')->name('vendormultipleaddresses.update');
Route::match(['put', 'post'], '/vendormultipleaddresses/update/{id}', 'ManageVendorAddress\ManageVendorAddressController@update')->name('vendormultipleaddresses.update');


// hari
Route::group(['middleware' => 'acl:manage_statuses'], function () {
Route::resource('statuses', 'Status\StatusController');
Route::patch('/statuses/{id}/toggle', 'Status\StatusController@toggle')->name('statuses.toggle');
});


Route::group(['middleware' => 'acl:manage_service_type'], function () {
Route::resource('service-types', 'Status\ServiceTypeController');
Route::patch('/service-types/{id}/toggle','Status\ServiceTypeController@toggle')->name('service-types.toggle');
});

Route::group(['middleware' => 'acl:manage_warranty'], function () {

    Route::resource('warranties', 'WarrantyController');
});




Route::get('/amcs/quotation/send/{id}/auto', 'Amcs\AmcsController@sendAutoQuotation')
    ->name('amcs.sendQuotation.auto');

// Manual Generate Quotation
Route::get('/amcs/quotation/send/{id}/manual', 'Amcs\AmcsController@sendManualQuotation')
    ->name('amcs.sendQuotation.manual');

Route::post('/amcs/quotation/send/{id}/auto/store', 'Amcs\AmcsController@autoQuotationStore')->name('amcs.autoQuotation.store');


Route::post('/amcs/quotation/send/{id}/manual/store', 'Amcs\AmcsController@manualQuotationStore')->name('amcs.manualQuotation.store');



Route::get('/vendormultipleaddresses/vendor/{vendor_id}/import', 'ManageVendorAddress\ManageVendorAddressController@showImportPage')
    ->name('vendormultipleaddresses.importPage');

// Handle import form submission
Route::post('/vendormultipleaddresses/vendor/{vendor_id}/import', 'ManageVendorAddress\ManageVendorAddressController@importCsv')
    ->name('vendormultipleaddresses.importCsv');

    //add route for SAMPLE DOWNLOAD
Route::get('/vendor-address/sample-download', 'ManageVendorAddress\ManageVendorAddressController@csvSampleDownload')->name('vendoraddress.sampledownload');
// hari end 


Route::get('/product/serial-entry', 'ProductSerialNo\SerialController@index')->name('product.serialEntry');
Route::post('/product/serial-entry/save', 'ProductSerialNo\SerialController@store')->name('product.serialStore');


// NEW: Show saved records list
Route::get('/product/serial-entry/list', 'ProductSerialNo\SerialController@listData')->name('product.serialEntryList');
// Edit Flow
Route::get('/product/serial-entry/edit/{id}', 'ProductSerialNo\SerialController@edit')->name('product.serialEntryEdit');
Route::post('/product/serial-entry/update/{id}', 'ProductSerialNo\SerialController@update')->name('product.serialEntryUpdate');

// Route::get('/product/product_list', 'Product_list\Product_listController@index')->name('product.serialEntry');
// Route::post('/product/serial-entry/save', 'ProductSerialNo\Product_listController@store')->name('product.serialStore');

Route::get('/delivery/view-reports/{awb}', 'Delivery\ManageDeliveryController@viewReport')->name('delivery.viewReports');
Route::get('/get-awb', 'Delivery\ManageDeliveryController@getAwb');
