<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Request;
use App\Http\Controllers\Controller;
use DB;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Bikers;
use Mail;
use App\VendorShipment;
use Config;


class sla_tat_controller extends Controller
{

    public function tat_backup(){
      /*
      * When create a tickit that time no assign any techinians and status is New and find the 
      * difference between the current date and created date 
      * if it is grater then sent mail with tickit id to the esc mail
      */
        $today_datetime = date('Y-m-d H:i:s');
        $shipment = DB::table('shipment')
                        ->select('id','biker_id','created_at')
                        ->where('delivery_status','New')
                        ->get();
        $sla_setting = DB::table('sla_setting')
                        ->select('sla_turn_around_time','esc_email')
                        ->get();
        $id = "";

        foreach ( $shipment as $value ) {

            if( $value->biker_id == null ){
                $start_datetime = strtotime($today_datetime); 
                $end_datetime = strtotime($value->created_at);
            
                (int) $hour = abs($start_datetime - $end_datetime)/(60*60);
                if($hour > $sla_setting[0]->sla_turn_around_time){          
                    $id .= $value->id.",";
                }
            }
        }

        if($id!=""){
            $id = substr($id, 0, -1);

            $subject = "Apniamc - SLA Turn Around Time";
            $to = $sla_setting[0]->esc_email;
            $from = 'monika.mukesoft@gmail.com';
            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the SLA Turn Around Time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';

            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                    $message->to($to)
                    ->subject($subject)
                    ->from($from)
                    ->setBody($html, 'text/html');
            });
        }

        /*
        *   Get the data which delivery status is not completed or closed and technicians are assigned to the *   service and find the difference between the current date and created date 
        *   if it is grater then sent mail with tickit id to the esc mail
        */

        $shipment = DB::table('shipment')
                        ->select('id','biker_id','created_at','delivery_status')
                        ->where('delivery_status','!=','Closed')
                        ->where('delivery_status','!=','Completed')
                        ->where('biker_id','!=','')->get();
        $sla_setting = DB::table('sla_setting')
                    ->select('sla_close_time','esc_email')
                    ->get();

        $id = "";
        foreach ( $shipment as $value ) {
            $start_datetime = new DateTime($today_datetime); 
            $diff = $start_datetime->diff(new DateTime($value->created_at)); 
            $hours = $diff->h;
            $hours = $hours + ($diff->days*24);

            if($hours > $sla_setting[0]->sla_close_time){          
                $id .= $value->id.",";
            }
        }
        
        if($id!=""){
            $id = substr($id, 0, -1);

            $subject = "Apniamc - SLA Close Time";
            $to = $sla_setting[0]->esc_email;
            $from = 'monika.mukesoft@gmail.com';
            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the  SLA Close Time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';

            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                    $message->to($to)
                    ->subject($subject)
                    ->from($from)
                    ->setBody($html, 'text/html');
            });
        }

        /*
        * When assign any techinians to the tickit and status is New and find the 
        * difference between the current date and technician assign date & time
        * if it is grater then sent mail with tickit id to the service esc mail
        */
        $today_datetime = date('Y-m-d H:i:s');
        $shipment = DB::table('shipment')
                        ->select('id','biker_id','technician_assign_datetime')
                        ->where('delivery_status','New')
                        ->where('biker_id','!=','')
                        ->get();
        $sla_setting = DB::table('sla_setting')
                        ->select('service_turn_around_time','sla_esc_email')
                        ->get();
        $id = "";

        foreach ( $shipment as $value ) {

            $start_datetime = strtotime($today_datetime); 
            $end_datetime = strtotime($value->technician_assign_datetime);
        
            (int) $hour = abs($start_datetime - $end_datetime)/(60*60);
            if($hour > $sla_setting[0]->service_turn_around_time){          
                $id .= $value->id.",";
            }
        }

        if($id!=""){
            $id = substr($id, 0, -1);

            $subject = "Apniamc - Service Turn Around Time";
            $to = $sla_setting[0]->sla_esc_email;
            $from = 'monika.mukesoft@gmail.com';
            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the Service Turn around time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';
            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                    $message->to($to)
                    ->subject($subject)
                    ->from($from)
                    ->setBody($html, 'text/html');
            });
        }

        /*
        *   Get the data which delivery status is not completed or closed and technicians are assigned to the *   service and find the difference between the current date and techinican assign date & time
        *   if it is grater then sent mail with tickit id to the service esc mail
        */

        $shipment = DB::table('shipment')
                        ->select('id','biker_id','technician_assign_datetime','delivery_status')
                        ->where('delivery_status','!=','Closed')
                        ->where('delivery_status','!=','Completed')
                        ->where('biker_id','!=','')->get();
        $sla_setting = DB::table('sla_setting')
                    ->select('service_close_time','sla_esc_email')
                    ->get();

        $id = "";
        foreach ( $shipment as $value ) {
            $start_datetime = new DateTime($today_datetime); 
            $diff = $start_datetime->diff(new DateTime($value->technician_assign_datetime)); 
            $hours = $diff->h;
            $hours = $hours + ($diff->days*24);

            if($hours > $sla_setting[0]->service_close_time){          
                $id .= $value->id.",";
            }
        }
        
        if($id!=""){
            $id = substr($id, 0, -1);

            $subject = "Apniamc - Service Close Time";
            $to = $sla_setting[0]->sla_esc_email;
            $from = 'monika.mukesoft@gmail.com';
            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the Service Close Time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';
            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                    $message->to($to)
                    ->subject($subject)
                    ->from($from)
                    ->setBody($html, 'text/html');
            });
        }

    }
    public function tat(){
      
      
        $site_settings = DB::table('site_settings')
                ->select('*')
                ->get();
        $settings_arr = array();
        if($site_settings)
        {
            foreach($site_settings as $val)
            {
                $settings_str = urldecode($val->settings);
                $settings_arr = unserialize($settings_str);
            }
        }
        if(isset($settings_arr)){
            if(isset($settings_arr['sla_setting'])){
                if($settings_arr['sla_setting'] == 1)
                {
                    try{ 
                        /*
                        * When create a tickit that time no assign any techinians and status is New and find the 
                        * difference between the current date and created date 
                        * if it is grater then sent mail with tickit id to the esc mail
                        */
                        $today_datetime = date('Y-m-d H:i:s');
                        $shipment = DB::table('shipment')
                                        ->select('id','biker_id','created_at')
                                        ->where('delivery_status','New')
                                        ->get();
                        $sla_setting = DB::table('sla_setting')
                                        ->select('sla_turn_around_time','esc_email')
                                        ->get();
                        $id = "";

                        foreach ( $shipment as $value ) {

                            if( $value->biker_id == null ){
                                $start_datetime = strtotime($today_datetime); 
                                $end_datetime = strtotime($value->created_at);
                            
                                (int) $hour = abs($start_datetime - $end_datetime)/(60*60);
                                if($hour > $sla_setting[0]->sla_turn_around_time){          
                                    $id .= $value->id.",";
                                }
                            }
                        }

                        if($id!=""){
                            $id = substr($id, 0, -1);

                            $subject = "Apniamc - SLA Turn Around Time";
                            $to = $sla_setting[0]->esc_email;
                            $from = 'monika.mukesoft@gmail.com';
                            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the SLA Turn Around Time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';

                            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                                    $message->to($to)
                                    ->subject($subject)
                                    ->from($from)
                                    ->setBody($html, 'text/html');
                            });
                        }

                        /*
                        *   Get the data which delivery status is not completed or closed and technicians are assigned to the *   service and find the difference between the current date and created date 
                        *   if it is grater then sent mail with tickit id to the esc mail
                        */

                        $shipment = DB::table('shipment')
                                        ->select('id','biker_id','created_at','delivery_status')
                                        ->where('delivery_status','!=','Closed')
                                        ->where('delivery_status','!=','Completed')
                                        ->where('biker_id','!=','')->get();
                        $sla_setting = DB::table('sla_setting')
                                    ->select('sla_close_time','esc_email')
                                    ->get();

                        $id = "";
                        foreach ( $shipment as $value ) {
                            $start_datetime = new DateTime($today_datetime); 
                            $diff = $start_datetime->diff(new DateTime($value->created_at)); 
                            $hours = $diff->h;
                            $hours = $hours + ($diff->days*24);

                            if($hours > $sla_setting[0]->sla_close_time){          
                                $id .= $value->id.",";
                            }
                        }
                        
                        if($id!=""){
                            $id = substr($id, 0, -1);

                            $subject = "Apniamc - SLA Close Time";
                            $to = $sla_setting[0]->esc_email;
                            $from = 'monika.mukesoft@gmail.com';
                            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the  SLA Close Time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';

                            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                                    $message->to($to)
                                    ->subject($subject)
                                    ->from($from)
                                    ->setBody($html, 'text/html');
                            });
                        }

                        /*
                        * When assign any techinians to the tickit and status is New and find the 
                        * difference between the current date and technician assign date & time
                        * if it is grater then sent mail with tickit id to the service esc mail
                        */
                        $today_datetime = date('Y-m-d H:i:s');
                        $shipment = DB::table('shipment')
                                        ->select('id','biker_id','technician_assign_datetime')
                                        ->where('delivery_status','New')
                                        ->where('biker_id','!=','')
                                        ->get();
                        $sla_setting = DB::table('sla_setting')
                                        ->select('service_turn_around_time','sla_esc_email')
                                        ->get();
                        $id = "";

                        foreach ( $shipment as $value ) {

                            $start_datetime = strtotime($today_datetime); 
                            $end_datetime = strtotime($value->technician_assign_datetime);
                        
                            (int) $hour = abs($start_datetime - $end_datetime)/(60*60);
                            if($hour > $sla_setting[0]->service_turn_around_time){          
                                $id .= $value->id.",";
                            }
                        }

                        if($id!=""){
                            $id = substr($id, 0, -1);

                            $subject = "Apniamc - Service Turn Around Time";
                            $to = $sla_setting[0]->sla_esc_email;
                            $from = 'monika.mukesoft@gmail.com';
                            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the Service Turn around time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';
                            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                                    $message->to($to)
                                    ->subject($subject)
                                    ->from($from)
                                    ->setBody($html, 'text/html');
                            });
                        }

                        /*
                        *   Get the data which delivery status is not completed or closed and technicians are assigned to the *   service and find the difference between the current date and techinican assign date & time
                        *   if it is grater then sent mail with tickit id to the service esc mail
                        */

                        $shipment = DB::table('shipment')
                                        ->select('id','biker_id','technician_assign_datetime','delivery_status')
                                        ->where('delivery_status','!=','Closed')
                                        ->where('delivery_status','!=','Completed')
                                        ->where('biker_id','!=','')->get();
                        $sla_setting = DB::table('sla_setting')
                                    ->select('service_close_time','sla_esc_email')
                                    ->get();

                        $id = "";
                        foreach ( $shipment as $value ) {
                            $start_datetime = new DateTime($today_datetime); 
                            $diff = $start_datetime->diff(new DateTime($value->technician_assign_datetime)); 
                            $hours = $diff->h;
                            $hours = $hours + ($diff->days*24);

                            if($hours > $sla_setting[0]->service_close_time){          
                                $id .= $value->id.",";
                            }
                        }
                        
                        if($id!=""){
                            $id = substr($id, 0, -1);

                            $subject = "Apniamc - Service Close Time";
                            $to = $sla_setting[0]->sla_esc_email;
                            $from = 'monika.mukesoft@gmail.com';
                            $html = '<b>Dear Administrator,</b><br><br>The below are the Tickets has reached the Service Close Time Warning ('.$id.').<br><br>Please take action to resolve this request as soon as possible.<br><br>For further assistance please call on 91-22-6995-0000 or Email us at sales@apniamc.com<br><br><b>Thanks & Regards,<br>Apniamc</b>';
                            Mail::send([], [], function ($message) use ($to,$subject,$from,$html) {
                                    $message->to($to)
                                    ->subject($subject)
                                    ->from($from)
                                    ->setBody($html, 'text/html');
                            });
                        }
                    } catch (\Exception $ex) { 
                        echo "Mail not sent......";
                        return "We've got errors!";
                        exit;
                    } 
                }
            }
        } 

    }
}
?>