<?php

namespace App\Http\Controllers;

use App\Warranty;
use App\Vendor;
use DB;
use App\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Http\Controllers\Controller;


class WarrantyController extends Controller
{
    public function index()
    {
        $warranties = DB::table('warranties as w')
            ->leftJoin('vendor as v', 'v.id', '=', 'w.client_id')
            ->leftJoin('products as p', 'p.id', '=', 'w.product_id')
            ->select(
                'w.*',
                'v.name as vname',
                'v.company_name as client_name',  // adjust if it's just 'name'
                'p.product_name'
            )
            ->get();

        return view('warranties.index', compact('warranties'));
    }

    public function create()
    {
        $clients = DB::table('vendor')
            ->where('deleted_at', '=', 'N')
            ->where('status', '=', 'Active')
            ->orderBy('name', 'asc')
            ->get();

        $products = Products::all();
        return view('warranties.create', compact('clients', 'products'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'client_id' => 'required|exists:vendor,id',
            'product_id' => 'required|exists:products,id',
            'warranty_start_date' => 'required|date',
            'warranty_end_date' => 'required|date',
        ]);

        // Manually validate: warranty_end_date >= warranty_start_date
        if (strtotime($request->warranty_end_date) < strtotime($request->warranty_start_date)) {
            $validator->after(function ($validator) {
                $validator->errors()->add('warranty_end_date', 'The warranty end date must be after or equal to the start date.');
            });
        }

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        Warranty::create($request->all());
        return redirect()->route('warranties.index')->with('success', 'Warranty added successfully.');
    }

    public function edit($id)
    {
        $warranty = Warranty::findOrFail($id);
        // $clients = Vendor::where('status', 'Active')->get();
        $clients = DB::table('vendor')
            ->where('deleted_at', '=', 'N')
            ->where('status', '=', 'Active')
            ->orderBy('name', 'asc')
            ->get();
        $products = Products::all();
        return view('warranties.edit', compact('warranty', 'clients', 'products'));
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'client_id' => 'required|exists:vendor,id',
            'product_id' => 'required|exists:products,id',
            'warranty_start_date' => 'required|date',
            'warranty_end_date' => 'required|date',
        ]);

        // Manually validate: warranty_end_date >= warranty_start_date
        if (strtotime($request->warranty_end_date) < strtotime($request->warranty_start_date)) {
            $validator->after(function ($validator) {
                $validator->errors()->add('warranty_end_date', 'The warranty end date must be after or equal to the start date.');
            });
        }

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $warranty = Warranty::findOrFail($id);
        $warranty->update($request->all());

        return redirect()->route('warranties.index')->with('success', 'Warranty updated successfully.');
    }

    public function destroy($id)
{
    $warranty = Warranty::findOrFail($id);
    $warranty->delete();

    return redirect()->route('warranties.index')->with('success', 'Warranty deleted successfully.');
}
}
