<?php

namespace App\Http\Controllers\VendorLogin;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Input;
use Excel;
use DB;
use DateTime;
use Carbon\Carbon;
use Session;
use App\Substation;
use App\VendorShipment;
use App\VendorShipmentPackage;
use App\VendorAddress;
use App\VendorBuyer;
use App\StatusHistory;
use App\Helpers\Shipment;

class BulkUploadController extends Controller
{
    public function bulkupload() {
        if(Session::get('vendor_id')) {
            return view('vendorlogin.bulkupload');
        } else {
            return redirect("login/");
        }
    }
    public function upload(Request $request) {
        if(Session::get('vendor_id')) {
            $this->validate($request, [
            'bulk_upload' => 'required|mimes:xlsx,XLSX,xls,XLS',
            ]);
            $img_dir = "uploads/bulk_upload/";
            $input = $request->all();
            $bulk_upload_name = Input::file('bulk_upload')->getClientOriginalName();
            $file = $request->file('bulk_upload');
            if ($request->file('bulk_upload')->isValid())
                {
                    $i = $request->file('bulk_upload')->move($img_dir, $bulk_upload_name);
                    $input['bulk_upload'] = $img_dir.$bulk_upload_name;
                }
            $errors = array();
            Excel::load($input['bulk_upload'], function($reader) use (&$errors) {
                $substations = Substation::all();
                $errors = array();
                $sheets = $reader->toArray();
                $shipmentsheet = $sheets[0];
                $packagesheets = $sheets[1];
                if(!empty($shipmentsheet[0]['order_id'])) {
                    foreach ($packagesheets as $key => $package) {
                        $index = $package['shipment_mapping_id'] - 2;
                        if(isset($shipmentsheet[$index])) {
                            if(!isset($shipmentsheet[$index]['packages'])) {
                                $shipmentsheet[$index]['packages'] = array();
                            }
                            $shipmentsheet[$index]['packages'][] = $package;
                        }
                    }
                    foreach ($shipmentsheet as $key => $row) {
                        usleep(500000);
                        $shipment_errors =  Shipment::validateShipment($row);
                        if(!empty($shipment_errors['errors'])) {
                            $errors[$key] = $shipment_errors['errors'];  
                        } else {
                            $shipmentsheet[$key]['total_invoice_amt'] = $shipment_errors['data']['total_invoice_amt'];
                            $shipmentsheet[$key]['total_cal_weight'] = $shipment_errors['data']['total_cal_weight'];
                            $shipmentsheet[$key]['latitude'] = $shipment_errors['data']['latitude'];
                            $shipmentsheet[$key]['longitude'] = $shipment_errors['data']['longitude'];
                            $shipmentsheet[$key]['total_distance'] = $shipment_errors['data']['total_distance'];
                        }
                    } 
                } else {
                    $errors['other_error'] = array();
                    $errors['other_error'][] = "Please Select Valid File.";
                } 
                if(empty($errors)) {
                    foreach ($shipmentsheet as $key => $row) {
                        $pickup_date = new DateTime($row['pickup_date']);
                        $pickup_date = $pickup_date->format('Y-m-d');
                        $cod_cost = 0;
                        if(strtolower($row['payment_mode']) == 'cash on delivery') {
                            $payment_mode = 'cod';
                            $cod_cost = max(((1/100)*$row['total_invoice_amt']), 50);
                        } else {
                            $payment_mode = 'online';
                        }
                        $insurance_cost = 0;
                        if(strtolower($row['insurance']) == "yes") {
                            $insurance_cost = max(((0.5/100)*$row['total_invoice_amt']), 10);
                        }
                        if(strtolower($row['shipment_type']) == "4 hours delivery") {
                            $awb_type = "4HD";
                            $shipment_type = "4_hours_delivery";
                            $shipping_fee = round(max($row['total_cal_weight'] * 99, 99 ), 2);
                            $total_cost = max($row['total_cal_weight'] * 99, 99 ) + $cod_cost + $insurance_cost;
                            $total_tax = round(($total_cost * 14.5)/100, 2);
                            $total_cost = $total_cost + $total_tax;
                        } elseif(strtolower($row['shipment_type']) == "same day delivery") {
                            $awb_type = "SDD";
                            $shipment_type = "same_day_delivery";
                            $shipping_fee = round(max($row['total_cal_weight'] * 69, 69 ), 2);
                            $total_cost = max($row['total_cal_weight'] * 69, 69 ) + $cod_cost + $insurance_cost;
                            $total_tax = round(($total_cost * 14.5)/100, 2);
                            $total_cost = $total_cost + $total_tax;
                        } else {
                            $awb_type = "NXD";
                            $shipment_type = "next_day_delivery";
                            $shipping_fee = round(max($row['total_cal_weight'] * 39, 39 ), 2);
                            $total_cost = max($row['total_cal_weight'] * 39, 39 ) + $cod_cost + $insurance_cost;
                            $total_tax = round(($total_cost * 14.5)/100, 2);
                            $total_cost = $total_cost + $total_tax;
                        }

                        $awb_city = substr(strtoupper($row['pickup_city']),0,3);
                        $today_date = Carbon::now()->format('Y-m-d')."%";
                        $awb_date = Carbon::now()->format('dmY');
                        $total_orders = DB::table('shipment')
                                        ->select(DB::raw('count(*) as total'))
                                        ->where('order_time', 'LIKE', $today_date)
                                        ->first();
                        $awb_total_order_day = $total_orders->total;
                        $awb_total_order_day = $awb_total_order_day + 1;
                        $awb_total_order_day = str_pad($awb_total_order_day,6,0,STR_PAD_LEFT);
                        $awb_no = $awb_type.$awb_date.$awb_total_order_day.$awb_city;
                        // $addresses = array(
                        //         'pickup' => urlencode($row['pickup_primary_address'].', '.', '.$row['pickup_city'].', '.$row['pickup_state'].', '.$row['pickup_country'].' '.$row['pickup_pincode']),
                        //         'delivery' => urlencode($row['drop_primary_address'].', '.', '.$row['drop_city'].', '.$row['drop_state'].', '.$row['drop_country'].' '.$row['drop_pincode'])
                        //     );
                        // foreach ($addresses as $key => $address) {
                        //     $request_url = "http://maps.googleapis.com/maps/api/geocode/xml?address=".$address."&sensor=true";
                        //     $xml = simplexml_load_file($request_url) or die("url not loading");
                        //     $status = $xml->status;
                        //     if ($status=="OK") {
                        //       $lat = $xml->result->geometry->location->lat;
                        //       $lon = $xml->result->geometry->location->lng;
                        //       $latitude[$key] = "$lat";
                        //       $longitude[$key] = "$lon";
                        //     }
                        // }
                        // $distance = Shipment::distanceCalculation((double)$latitude['pickup'],(double)$longitude['pickup'],(double)$latitude['delivery'],(double)$longitude['delivery']);
                        // $total_distance = round($distance, 2);
                        $pickup_address = VendorAddress::create([
                            'address' => $row['pickup_primary_address'],
                            'address_1' => $row['pickup_secondary_address'],
                            'city' => $row['pickup_city'],
                            'state' => $row['pickup_state'],
                            'country' => $row['pickup_country'],
                            'pincode' => $row['pickup_pincode'],
                            'latitude' =>  $row['latitude']['pickup'],
                            'longitude' => $row['longitude']['pickup'],
                            'landmark' => $row['pickup_landmark'],
                        ]);
                        $pickup_address_id = $pickup_address->id;
                        DB::table('vendor_pickup_address')->insert([
                            ['pick_up_address_id' => $pickup_address_id, 'vendor_id' => Session::get('vendor_id')]
                        ]);

                        $drop_address = VendorAddress::create([
                            'address' => $row['drop_primary_address'],
                            'address_1' => $row['drop_secondary_address'],
                            'city' => $row['drop_city'],
                            'state' => $row['drop_state'],
                            'country' => $row['drop_country'],
                            'pincode' => $row['drop_pincode'],
                            'latitude' =>  $row['latitude']['delivery'],
                            'longitude' => $row['longitude']['delivery'],
                            'landmark' => $row['drop_landmark'],
                        ]);
                        $buyer = VendorBuyer::create([
                            'vendor_id' => Session::get('vendor_id'),
                            'drop_address_id' => $drop_address->id,
                            'name' => $row['buyer_name'],
                            'contact_no' => $row['buyer_contact_no'],
                            'email' => $row['buyer_email'],
                        ]);
                        $sub_station_id = 0;
                        $drop_substation_id = 0;
                        foreach ($substations as $key => $substation) {
                          $substation_array = array_map('trim', explode(',', $substation->substation_pincode));          
                          if (in_array($row['pickup_pincode'], $substation_array)) {
                              $sub_station_id = $substation->id;
                            }
                          if (in_array($row['drop_pincode'], $substation_array)) {
                              $drop_substation_id = $substation->id;
                            }
                        }

                        //If there is no matching pin code available.
                        //Assign the delivery to last substation in the list.
                        if(!$sub_station_id) {
                          $sub_station_id = $substation->id;
                        }
                        //If there is no matching pin code available.
                        //Assign the delivery to last substation in the list for drop Substation id
                        if(!$drop_substation_id) {
                          $drop_substation_id = $substation->id;
                        }

                        $shipment = VendorShipment::create([
                                    'vendor_id' => Session::get('vendor_id'),
                                    'drop_address_id' => $drop_address->id,
                                    'buyer_id' => $buyer->id,
                                    'sub_station_id' => $sub_station_id,
                                    'drop_substation_id' => $drop_substation_id,
                                    'name' => $row['pickup_name'],
                                    'contact_no' => $row['pickup_contact_no'],
                                    'email' => $row['pickup_email'],
                                    'pickup_date' => $pickup_date,
                                    'order_id' => $row['order_id'],
                                    'pickup_address_id' => $pickup_address_id,
                                    'type' => $shipment_type,
                                    'payment_mode' => $payment_mode,
                                    'cost' => $total_cost,
                                    'shipping_fee' => $shipping_fee,
                                    'insurance_fee' => $insurance_cost,
                                    'payment_mode_charge' => $cod_cost,
                                    'invoice_amount' => $row['total_invoice_amt'],
                                    'distance' => round($row['total_distance'], 2),
                                    'insurance' => ucwords(strtolower($row['insurance'])),
                                    'awb_no' => $awb_no,
                                    'delivery_status' => "Order Received",
                                    'order_time' => Carbon::now()->toDateTimeString(),
                            ]);
                        foreach ($row['packages'] as $key_package => $package) {
                            $input['shipment_data'] = array(
                                    'length' => $package['length'],
                                    'breadth' => $package['breadth'],
                                    'height' => $package['height'],
                                    'weight' => max($package['weight'],(ceil(($package['length']*$package['breadth']*$package['height'])/5000))),
                                    'content' => $package['content'],
                                    'value' => $package['value'],
                                    'shipment_id' => $shipment->id,
                            );
                            VendorShipmentPackage::create($input['shipment_data']);
                        }
                        $input['by_whom_role'] = "Admin";
                        $input['by_whom_id'] = Session::get('vendor_id');
                        $input['date_time'] = Carbon::now()->toDateTimeString();
                        $input['shipment_id'] = $shipment->id;
                        $input['status'] = "Order Received";
                        StatusHistory::create($input);
                        Session::flash('success','Orders was created successfully!');
                        //$request->session()->flash('success', 'Order is created successfully!');
                    }
                }
            });
            if(!empty($errors)) {
                //echo '<pre>'; print_r($errors); echo "</pre>";
                $validation_errors = $errors;
                return view('vendorlogin.bulkuploaderror')->withValidationErrors($validation_errors);
            } 
            return redirect("/bulkupload");
        } else {
            return redirect("login/");
        }
    }
    
    public function BulkUploadError()
    {
        return view('vendorlogin.bulkuploaderror');
        //echo '<pre>'; print_r($errors); exit;
    }
}
