<?php
namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;
use Response;
use Mail;
use Config;

class SettingsController extends Controller {

	public function __construct()
	{
		$this->middleware('auth');
	}

	public function featuresettings(Request $request)
	{
		$site_settings = DB::table('site_settings')
                        ->select('*')
                        ->get();
        $settings_arr = array();
        if($site_settings)
        {
        	foreach($site_settings as $val)
        	{
        		$settings_str = urldecode($val->settings);
        		$settings_arr = unserialize($settings_str);
        	}
        }
        // print_r($settings_arr); die;
        
		return view('settings.featuresettings')->with("settings",$settings_arr);
	}

	public function savefeaturesettings(Request $request)
	{
		$input = $request->all();
		// echo "<pre>"; print_r($input); die();
		if(isset($input['daily_email']))
		{
			if($input['daily_email']=='1')
			{
				$this->validate($request, [
            		'daily_email_to' => 'required',
            ]);
			}
		}
		//mehul 30dec2019
		if(isset($input['bad_rating_email']))
		{
			if($input['bad_rating_email']=='1')
			{
				$this->validate($request, [
            		'bad_rating_email_to' => 'required',
            ]);
			}
		}
		//mehul 30dec2019
		
		// added by gaurav on 2-mar-2020
		if(isset($input['support_email_to']))
		{
			if($input['support_email_to']=='1')
			{
				$this->validate($request, [
            		'support_email_to' => 'required',
            ]);
			}
		}// gaurav on 2-mar-2020

		$save_values = serialize($input);
		$save_values_final = urlencode($save_values); 
		$data = array("settings"=>$save_values_final);
			// echo "<pre>"; print_r($data); die();
		DB::table('site_settings')->truncate();
		DB::table('site_settings')->insert($data);

		$request->session()->flash('flash_message','Settings saved successfully !!!');

		return redirect('settings/featuresettings');
       
		//return view('settings.featuresettings');
	}

}

?>