<?php

namespace App\Http\Controllers\Service;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;
use Response;
use Mail;
use Config;

class ServiceController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function create(Request $request)
    {   

         /* added by brijesh on 13-12-2019*/
         $input=$request->all();
        if(!empty($input) || !empty($product_id))
        {
        $vendor_id=$input['vendor'];
         $product_id=$input['product_id'];
        }
        if(!empty($vendor_id))
        {
            
           // $today = Carbon::now();
            $end_date = DB::table('amcs')
                        ->select('end_date')
                        ->where('vendor_id','=',$vendor_id)
                        ->where('product_id','=',$product_id)
                        ->first();


            return Response::json($end_date);         
            
        }
        //added by sundaram on 14-06-2021 for service provider start
        $serviceenable_value = 0;
        $serviceenable = false;
        $site_settings = DB::table('site_settings')
                        ->select('*')
                        ->get();
          $settings_arr = array();
          if($site_settings)
          {
            foreach($site_settings as $val)
            {
              $settings_str = urldecode($val->settings);
              $settings_arr = unserialize($settings_str);
            }
          }

          if(isset($settings_arr['serviceprovider'])) 
            { 
              if($settings_arr['serviceprovider']=='1') 
                { 
                  $serviceenable = true;
                  $serviceenable_value = $settings_arr['serviceprovider'];
                } 
            }

            //added by sundaram on 14-06-2021 for service provider end
        //$vendors = Vendor::all();
		$vendors = DB::table('vendor')
					->where('deleted_at','=','N')
                    ->where('status','=','Active')
					->orderBy('name','asc')
                    ->get(); 
        $products = DB::table('products')
                    ->orderBy('product_name','asc')
                    ->get(); 
        //added by sundaram on 14-06-2021 for service provider start
        $service_pros = DB::table('service_providers')
                        ->where('deleted_at','=','N')
                        ->where('status','=','Active')
                        ->orderBy('name','asc')
                        ->get();

        $checklists = DB::table('check_list')
                        ->where('deleted_at','=','0000-00-00')
                        ->get();
        //added by sundaram on 14-06-2021 for service provider end                             
    	return view('services.create')->withVendors($vendors)->withProducts($products)->withServiceenable_value($serviceenable_value)->withservice_pros($service_pros)->withchecklists($checklists);
    }
    
   public function auto()
    {
        $vendors = Vendor::all();
        $products = DB::table('products')
                    ->get();  
    	return view('services.auto')->withVendors($vendors)->withProducts($products);
    }
	
	public function autocomplete($name){
	
	$queries = DB::table('bikers')
		->where('first_name', 'LIKE', '%'.$name.'%')
		->orWhere('last_name', 'LIKE', '%'.$name.'%')
		->take(5)->get();
	
	foreach ($queries as $query)
	{
	    $results[] = [ 'id' => $query->id, 'value' => $query->first_name.' '.$query->last_name ];
	}
	return Response::json($results);


	}

    public function store(Request $request)
    { 
        $month = date('m');
        $year = date('Y');

    //code added on 23 oct 2019
        //get count of services created monthly
        $monthly_services_count = DB::table('shipment')
                                    ->whereMonth('created_at', '=', $month)
                                    ->whereYear('created_at', '=', $year)
                                    ->count();     
        //get user have which plan from apniamc_master db
        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
        $client_plan = '';              
        if(!empty($clients)) {
            $client_plan = $clients->client_plan;
        } 
        $limit_sevices = 50;

        //if user has BASIC plan then check and restrict it to make only 50 services 
        if($client_plan == 'BA') {
            if($monthly_services_count >= $limit_sevices) {
                session::flash('unable_create_serv_mesg', 'Please upgrade your plan to make more Services. Please contact on this number 9137858155.');
                return redirect('/service/create');
            } else {
                return  $this->finalStoreServices($request);
            }
        }  

        else {
            return  $this->finalStoreServices($request);
        }    
    }
 //code added on 23 oct 2019
    //this function will be called to create the services
    public function finalStoreServices(Request $request) {

        $serviceenable_value = 0;
        $serviceenable = false;
        $site_settings = DB::table('site_settings')
                        ->select('*')
                        ->get();
          $settings_arr = array();
          if($site_settings)
          {
            foreach($site_settings as $val)
            {
              $settings_str = urldecode($val->settings);
              $settings_arr = unserialize($settings_str);
            }
          }

          if(isset($settings_arr['serviceprovider'])) 
            { 
              if($settings_arr['serviceprovider']=='1') 
                { 
                  $serviceenable = true;
                  $serviceenable_value = $settings_arr['serviceprovider'];
                } 
            }

        if ($serviceenable_value==1)
        {
           // echo "ddf"; die();
        //echo "<pre>";print_r($request->all());die;
            $this->validate($request, [
                'vendor_id' => 'required',
                'product_id' => 'required',
                'service_id' => 'required',
                'service_description' => 'required',
                'service_type' => 'required',
                // 'checklist' => 'required',
                // 'mobileno' => 'required|regex:/^[0-9]+$/',
            ]);
        }
        else
        {      //  echo "else"; die();
            //echo "<pre>";print_r($request->all());die;
            $this->validate($request, [
                'vendor_id' => 'required',
                'product_id' => 'required',
                'service_description' => 'required',
                'service_type' => 'required'
                // 'mobileno' => 'required|regex:/^[0-9]+$/',
            ]);
        }

            //added on 17-03-2019

        if(!empty($request->input('service_date'))) 
         {
            $this->validate($request, [

                'future_date' => 'required',


       ]);
        }

        // end

        $input = $request->all();
        $product_code = DB::table('products')
                        ->select('*')
                        ->where('products.id','=',$input['product_id'])
                        ->first();
         $custid = Session::get('custid');
        $custname = Session::get('custname');
        if(isset($custid) && $custid)
        {
            $user =  $custname;  
            $typ = "Desktop - ".$user; 
            $username =  "Customer - " .$user; 
            $awb_date = Carbon::now()->format('dmYHis');
            $awb_no = "SUPP".$awb_date.$product_code->product_code;
            $admin = $user;
        } 
        else 
        {                
            $user = Auth::user();   
            $typ = "Desktop - ".$user->first_name." ".$user->last_name; 
            $username =  "Admin - " .$user->first_name." ".$user->last_name; 
            $awb_date = Carbon::now()->format('dmYHis');
            $awb_no = "SUPP".$awb_date.$product_code->product_code;
            
            $admin = $user->first_name." ".$user->last_name;
        }
    //if ($input['set_priority'] == '') {
    //  $input['set_priority'] = 0; 
    //}
    if($_SERVER['REMOTE_ADDR']=='1.146.221.120') 
    {
         //    //update ticket no
         //    $awb_no = Config::get('app.ticketprefix')."12";
         //    //$servicelist = VendorShipment::find($service->id);
         //    //$servicelist->awb_no = $awb_no;
         //    //$servicelist->save();
         //    //update ticket no

         //    $vinfo = DB::table('vendor')
         //               ->select('*')
         //               ->where('vendor.id','=',$input['vendor_id'])
         //               ->first();

         //              // print_r($vinfo);exit();
         //    $vname = $vinfo->name;
         //    $vemail = "vickey@mukesoft.com";
         //    $vpwd = $vinfo->plain_password;

         //    $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$input['service_description']." For Product ".$product_code->product_name.".";
         //   $emailcontent = array (
         //    'email'=>$vemail,
         //       'password'=>$vpwd,
         //        'cno' => $awb_no
         //    );

         //   $mobno = $input['mobileno'];   
         //    $st = str_replace(' ', '%20', $awb_no);
         //    $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";

         //   // echo $link3;die;
        
         //    $client3 = new \GuzzleHttp\Client();
         //    $this->response = $client3->get($link3)->getBody()->getContents(); 
         // //print_r($this->response); exit();

         //    $m1 = "7666333422";

         //    $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
         //        $client1 = new \GuzzleHttp\Client();
         //        $this->response = $client1->get($link1)->getBody()->getContents();
         //    //end

         //        Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
         //        $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
         //        $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

         //    $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

         //    }); 

    }
    else
    {

            // added by brijesh on 25-07-2020
            if(isset($input['rmarefticketno'])) {}
            else { $input['rmarefticketno'] = ""; }
            // end
              
             /* added by brijesh on 17-03-2020  future service*/
               
        if($input['checklist']==0)
            $status_checklist = 0;
          else
            $status_checklist =1;
          
        if($input['service_date'])
        {

              $users = DB::table('users')
                         ->select('id')
                         ->get();

             foreach($users as $user)
            {

            // $user_id = Auth::user()->id;
               $user_id=$user->id;
           // $order_time = $input['order_time'];
            $data=array('user_id'=>$user_id,'vendor_id' => $input['vendor_id'],'order_time'=>$input['future_date']);
            DB::table('future_sevice_notification')->insert($data);
          }
           // $service_sate=date('Y-m-d', strtotime($input['service_date2']));
             //echo "hello1".$service_sate;die();
          
            
          if (!empty($input['service_id'])){
          
            //echo $awb_no;die;
            $service = VendorShipment::create([
            'vendor_id' => $input['vendor_id'],
            
            'product_id' => $input['product_id'],
            'service_description' => $input['service_description'],
            'awb_no' => $awb_no,
            'order_time' => $input['future_date'],
            'service_provider_id' => $input['service_id'],
            'delivery_status' => "New",
            'created_type'=> $typ,
            'created_by'=> $username,
             //created_by'=>$username,
            'service_type'=> $input['service_type'],
            //uncommment this 'amc_option', incase if popping is there in create services
            //'amc_option' => (isset($input['amc_option'])),
            'instructions'=> $input['instructions'],
            'mobileno'=> $input['mobileno'],

            'new_priority' =>$input['set_priority'],
            'rmaref' =>$input['rmaref'],
            'rmarefticketno' =>$input['rmarefticketno'],
            'clientticketno' =>$input['clientticketno'],
            'checklist' => $input['checklist'],
            'checklist_status' => $status_checklist,

            ]);
 
            //update ticket no
            $awb_no = Config::get('app.ticketprefix').$service->id;
            $servicelist = VendorShipment::find($service->id);
            $servicelist->awb_no = $awb_no;
            $servicelist->save();

            //update ticket no
             //end  added by brijesh on 21-12-2019 
        }

        else
            {
          
            //echo $awb_no;die;
            $service = VendorShipment::create([
            'vendor_id' => $input['vendor_id'],
            
            'product_id' => $input['product_id'],
            'service_description' => $input['service_description'],
            'awb_no' => $awb_no,
            'order_time' => $input['future_date'],
            //'service_provider_id' => $input['service_id'],
            'delivery_status' => "New",
            'created_type'=> $typ,
            'created_by'=> $username,
             //created_by'=>$username,
            'service_type'=> $input['service_type'],
            //uncommment this 'amc_option', incase if popping is there in create services
            //'amc_option' => (isset($input['amc_option'])),
            'instructions'=> $input['instructions'],
            'mobileno'=> $input['mobileno'],

            'new_priority' =>$input['set_priority'],
            'rmaref' =>$input['rmaref'],
            'rmarefticketno' =>$input['rmarefticketno'],
            'clientticketno' =>$input['clientticketno'],
            'checklist' => $input['checklist'],
            'checklist_status' => $status_checklist,


            ]);
 
            //update ticket no
            $awb_no = Config::get('app.ticketprefix').$service->id;
            $servicelist = VendorShipment::find($service->id);
            $servicelist->awb_no = $awb_no;
            $servicelist->save();

            //update ticket no
             //end  added by brijesh on 21-12-2019 
        }

        }

             /*end brijesh 17-03-2020*/
        else
        {

        if (!empty($input['service_id'])){
            // echo $input['service_id'];die;
        $service = VendorShipment::create([
            'vendor_id' => $input['vendor_id'],
            'product_id' => $input['product_id'],
            'service_description' => $input['service_description'],
            
            'awb_no' => $awb_no,
            'order_time' => Carbon::now()->toDateTimeString(),
            'delivery_status' => "New",
            'created_type'=> $typ,
            'created_by'=> $username,
             //created_by'=>$username,
            'service_type'=> $input['service_type'],
            'instructions'=> $input['instructions'],
            'mobno'=> $input['mobileno'],
            'new_priority' =>$input['set_priority'],
             'rmaref' =>$input['rmaref'],
            'rmarefticketno' =>$input['rmarefticketno'],
            'clientticketno' =>$input['clientticketno'],
            'service_provider_id' => $input['service_id'],
            'checklist' => $input['checklist'],
            'checklist_status' => $status_checklist,


            ]);
            //update ticket no
            $awb_no = Config::get('app.ticketprefix').$service->id;
            $servicelist = VendorShipment::find($service->id);
            $servicelist->awb_no = $awb_no;
            $servicelist->save();
            //update ticket no
            }
            else 
                {

            // echo $input['service_id'];die;
        $service = VendorShipment::create([
            'vendor_id' => $input['vendor_id'],
            'product_id' => $input['product_id'],
            'service_description' => $input['service_description'],
            
            'awb_no' => $awb_no,
            'order_time' => Carbon::now()->toDateTimeString(),
            'delivery_status' => "New",
            'created_type'=> $typ,
            'created_by'=> $username,
             //created_by'=>$username,
            'service_type'=> $input['service_type'],
            'instructions'=> $input['instructions'],
            'mobileno'=> $input['mobileno'],
            'new_priority' =>$input['set_priority'],
             'rmaref' =>$input['rmaref'],
            'rmarefticketno' =>$input['rmarefticketno'],
            'clientticketno' =>$input['clientticketno'],
            //'service_provider_id' => $input['service_id'],
            'checklist' => $input['checklist'],
            'checklist_status' => $status_checklist,

            ]);

            //update ticket no
            $awb_no = Config::get('app.ticketprefix').$service->id;
            $servicelist = VendorShipment::find($service->id);
            $servicelist->awb_no = $awb_no;
            $servicelist->save();
            //update ticket no
            }
        }

        $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$input['vendor_id'])
                       ->first();
        // code by mehul sir to fetch 'setting' column and decode it from site_settings table                
        $supportemail = DB::table('site_settings')
                ->select('settings')
                ->get();
        $settings_arr = array();
        if($supportemail)
        {
            foreach($supportemail as $val)
            {
                $settings_str = urldecode($val->settings);
                $settings_arr = unserialize($settings_str);
            }
        }// code by mehul sir
        $servicedesc = $input['service_description'];
        //echo "<pre>"; print_r($settings_arr); die();
        // added this variable to get support emial in this '$semail'
        if(!empty($settings_arr)){ 
            $support_mail = str_replace(' ', '', $settings_arr['support_email_to']);
            $semail = explode(',' ,$support_mail);
            $mails = array();
            for($i=0; $i<=count($semail)-1; $i++){
                array_push($mails, $semail[$i]);
            }
        }
            $vname = $vinfo->name;
            $vemail = $vinfo->email;
            $vpwd = $vinfo->plain_password;
            
            $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$input['service_description']." For Product ".$product_code->product_name.".";
            $emailcontent = array (
                'email'=>$vemail,
                'password'=>$vpwd,
                'cno' => $awb_no
            );
            //code by gaurav to send mail to multiple recepients one to the customer and to support system 
            
            $emailcontent1 = array(
                'email'=>$vemail,
                'password'=>$vpwd,
                'cno' => $awb_no,
                'productname' => $product_code->product_name,
                'servicedesc' => $servicedesc,
                'vendorcompany' => $vinfo->company_name,
                'vendorname' => $vinfo->name
            );
            $mobno = $input['mobileno'];   
            $st = str_replace(' ', '%20', $awb_no);
            $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
        
            $client3 = new \GuzzleHttp\Client();
            $this->response = $client3->get($link3)->getBody()->getContents(); 
         //print_r($this->response); exit();
            //send sms
        $m1 = $vinfo->mobile_no;

        $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client1 = new \GuzzleHttp\Client();
            $this->response = $client1->get($link1)->getBody()->getContents();
        //end
        
        
        //temp comment
       /* StatusHistory::create([
            'by_whom_role' => "Vendor", 
            'by_whom_id' => $input['vendor_id'],
            'date_time' => Carbon::now()->toDateTimeString(),
            'shipment_id' => $service->id,
            'status' => "New",
            ]);*/
        
        /* Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

            $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

        });*/


        //Added by gaurav on 26-08-20 for sending mail while creating tickets 
        if(!empty($support_mail)){
            Mail::send('emails.createticketsupport', $emailcontent1, function ($message) use($mails) {
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
                // changes by gaurav on 3-march-2020 for sending mail to multiple recepients 
                foreach ($mails as $mail) {
                    $message->to($mail); 
                }
                $message->subject(Config::get('app.companyname').' Create Ticket Request');
            });
        }//Ended here 
    } //else
        if(isset($custid) && $custid)
        {
            $request->session()->flash('flash_message','Service added successfully !!!');
            return back();
        }
        else
        {
            if($input['future_date'])
            {
                $request->session()->flash('flash_message','Service added successfully !!!');
                return redirect('managedelivery?type=future'); 
            }
            else
            {
                $request->session()->flash('flash_message','Service added successfully !!!');
                return redirect('managedelivery?type=today');
            }

        }
    }

	 public function smscheck() {
	 $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=','75')
                       ->first();
        $product_code = DB::table('products')
                        ->select('*')
                        ->where('products.id','=','4')
                        ->first();					   
	$m1 = $vinfo->mobile_no;
	 $awb_date = Carbon::now()->format('dmYHis');
        $awb_no = Config::get('app.ticketprefix').$service->id;
		$st = str_replace(' ', '%20', $awb_no);
		$link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20complaint%20has%20been%20registered,Complaint No.$st,%20Your%20Complaint%20Will%20Attend%20Shortly.For%20further%20assistance%20pls%20call%208080922970.&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client1 = new \GuzzleHttp\Client();
			$this->response = $client1->get($link1)->getBody()->getContents();
			}

    public function createautoservice(Request $request)
    {
        echo "dads"; die();
        $amcs = DB::table('amcs')
                ->select('*')
                ->where('end_date','>=',date('Y-m-d'))
                ->where('next_service_date','=',date('Y-m-d'))
                ->get();
        echo "<pre>"; print_r($amcs); die();
        if($amcs)
        {
            foreach($amcs as $amc)
            {

                $product_id = $amc->product_id;
                $vendor_id = $amc->vendor_id;
        
                $product_code = DB::table('products')
                                ->select('*')
                                ->where('products.id','=',$product_id)
                                ->first();

                $user = Auth::user();   

                $username =  "Admin - " .$user->first_name." ".$user->last_name; 
                 
                $typ = "Desktop - Auto Generate Service";     
                $awb_date = Carbon::now()->format('dmYHis');
                $awb_no = "SUPP".$awb_date.$product_code->product_code;

                $admin = "Auto Generated";

                $service_description = 'auto generated ticket';
                $service_type = 'Complain';
                $mobno = '';

                $service = VendorShipment::create([
                    'vendor_id' => $vendor_id,
                    'product_id' => $product_id,
                    'service_description' => $service_description,
                    'awb_no' => $awb_no,
                    'order_time' => Carbon::now()->toDateTimeString(),
                    'delivery_status' => "New",
                    'created_type'=> $typ,
                    // 'created_by'=>"Admin",
                    'created_by'=> $username,
                    'service_type'=> $service_type,
                    'mobno'=> $mobno,
                    ]);

                //update ticket no
                $awb_no = Config::get('app.ticketprefix').$service->id;
                $servicelist = VendorShipment::find($service->id);
                $servicelist->awb_no = $awb_no;
                $servicelist->save();
                //update ticket no
        
         

                $vinfo = DB::table('vendor')
                        ->select('*')
                        ->where('vendor.id','=',$vendor_id)
                        ->first();
                $vname = $vinfo->name;
                $vemail = $vinfo->email;
                $vpwd = $vinfo->plain_password;
                $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$service_description." For Product ".$product_code->product_name.".";
                $emailcontent = array (
                                    'email'=>$vemail,
                                    'password'=>$vpwd,
                                    'cno' => $awb_no
                                );
          
                $st = str_replace(' ', '%20', $awb_no);
                $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
                $client3 = new \GuzzleHttp\Client();
                $this->response = $client3->get($link3)->getBody()->getContents(); 
                //print_r($this->response); exit();
                //send sms
                $m1 = $vinfo->mobile_no;

        
                $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
                $client1 = new \GuzzleHttp\Client();
                $this->response = $client1->get($link1)->getBody()->getContents();
                //end
        
                StatusHistory::create([
                    'by_whom_role' => "Vendor",
                    'by_whom_id' => $vendor_id,
                    'date_time' => Carbon::now()->toDateTimeString(),
                    'shipment_id' => $service->id,
                    'status' => "New",
                ]);

                //update
                $service_timeframe = '';
                $next_service_date = '';

                if($amc->service_timeframe!='')
                {
                    $service_timeframe = $amc->service_timeframe;
                    switch($service_timeframe)
                    {
                        case '15 Days' :

                            $daystoadd = 15;
                            $next_service_date = date('Y-m-d', strtotime("+15 days",strtotime($amc->next_service_date)));
                            break;

                        case 'Monthly' :
                            $next_service_date = date('Y-m-d', strtotime("+1 month",strtotime($amc->next_service_date)));
                            break;

                        case 'Quaterly' :
                            $next_service_date = date('Y-m-d', strtotime("+3 months",strtotime($amc->next_service_date)));
                            break;
                    }
                }  

                DB::table('amcs')
                ->where('id', $amc->id)
                ->update(['next_service_date' => $next_service_date]);

                //update
                //Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
                //$message->from(Config::get('app.fromemail'), Config::get('app.companyname'));

                //$message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');
            

                //}); 
                //$request->session()->flash('flash_message','Service successfully added');
                //return redirect('service/create');
            } //foreach
        }
    }
    public function spclientselect(Request $request)
    {

       // echo "<pre>" ; print_r($request-> all()); die;
      // echo "ppp1"; echo "<pre>";print_r($request->all());

        $selected_sp = DB::table('vendor')
                        ->leftjoin('service_providers','vendor.service_provider_id','=','service_providers.id')
                        ->select('service_providers.id')
                        ->where('vendor.id','=',$request->clientsec_id)
                        ->get();


                        $count = count($selected_sp);

                         // echo "<pre>"; print_r($selectedbranch); die; 
                        if ($count > 0){
                             return json_encode($selected_sp);
                        }
                        else {
                            return json_encode(0);

                        }


        //return json_encode($selected_sp);
      //  echo "<pre>"; print_r($selected_sp); die;   
    }
}
