<?php

namespace App\Http\Controllers\Service;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Input;
use Session;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;
use Response;
use Mail;
use Illuminate\Support\Str;
use Config;
use Illuminate\Support\Facades\Validator;

class ServiceController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function create(Request $request)
    {

        /* added by brijesh on 13-12-2019*/
        $input = $request->all();
        if (!empty($input) || !empty($product_id)) {
            $vendor_id = $input['vendor'];
            $product_id = $input['product_id'];
        }
        if (!empty($vendor_id)) {

            // $today = Carbon::now();
            $end_date = DB::table('amcs')
                ->select('end_date')
                ->where('vendor_id', '=', $vendor_id)
                ->where('product_id', '=', $product_id)
                ->first();


            return Response::json($end_date);
        }

        $amc_expiry_messages = [];
        $expired_products = collect();

        $user = Auth::user(); // For admin check
        $isAdmin = Auth::check();
        $custid = Session::get('custid'); // Vendor ID stored in session

        if ((!isset($user) || !$user) && isset($custid)) {
            $today = Carbon::now();

            $expired_products = DB::table('amcs')
                ->join('products', 'amcs.product_id', '=', 'products.id')
                ->leftJoin('service_requests', function ($join) {
                    $join->on('amcs.id', '=', 'service_requests.amc_id');
                })
                ->where('amcs.vendor_id', $custid)
                ->whereDate('amcs.end_date', '<', $today)
                ->select(
                    'products.id',
                    'products.product_name',
                    'products.product_code',
                    DB::raw('COALESCE(service_requests.request_done, 0) as request_done')
                )
                ->groupBy(
                    'products.id',
                    'products.product_name',
                    'products.product_code',
                    'service_requests.request_done'
                )
                ->get();


            // AMCs expiring within next 15 days (including today)
            $amcs = DB::table('amcs')
                ->select('id', 'product_id', 'vendor_id', 'end_date')
                ->where('vendor_id', $custid)
                ->whereDate('end_date', '>=', $today)
                ->whereDate('end_date', '<=', $today->copy()->addDays(15))
                ->get();

            foreach ($amcs as $amc) {
                $product = DB::table('products')->where('id', $amc->product_id)->first();
                $vendor = DB::table('vendor')->where('id', $amc->vendor_id)->first();

                if ($product && $vendor) {
                    $days_left = Carbon::parse($amc->end_date)->diffInDays($today);
                    $amc_expiry_messages[] = "AMC for product '{$product->product_name}'  is expiring in {$days_left} day(s) on " . Carbon::parse($amc->end_date)->format('d-m-Y');
                }
            }

            // AMCs already expired (end_date < today)
            $expired_amcs = DB::table('amcs')
                ->select('id', 'product_id', 'vendor_id', 'end_date')
                ->where('vendor_id', $custid)
                ->whereDate('end_date', '<', $today)
                ->get();

            foreach ($expired_amcs as $amc) {
                $product = DB::table('products')->where('id', $amc->product_id)->first();

                if ($product) {
                    $amc_expiry_messages[] = "AMC expired for product '{$product->product_name}'.";
                }
            }
        }
        //added by sundaram on 14-06-2021 for service provider start


        $serviceenable_value = 0;
        $serviceenable = false;
        $site_settings = DB::table('site_settings')->select('*')->get();

        $settings_arr = array();
        if ($site_settings) {
            foreach ($site_settings as $val) {
                $settings_str = urldecode($val->settings);
                $settings_arr = unserialize($settings_str);
            }
        }

        if (isset($settings_arr['serviceprovider'])) {
            if ($settings_arr['serviceprovider'] == '1') {
                $serviceenable = true;
                $serviceenable_value = $settings_arr['serviceprovider'];
            }
        }

        // $vendors = Vendor::all();
        $vendors = DB::table('vendor')
            ->where('deleted_at', '=', 'N')
            ->where('status', '=', 'Active')
            ->orderBy('name', 'asc')
            ->get();
            
        // $products = DB::table('products as p')
        //     ->leftJoin('amcs as a', function ($join) use ($custid) {
        //         $join->on('p.id', '=', 'a.product_id')
        //             ->where('a.vendor_id', '=', $custid);
        //     })
        //     ->leftJoin('service_requests as sr', function ($join) use ($custid) {
        //         $join->on('a.id', '=', 'sr.amc_id')
        //             ->where('sr.request_by_id', '=', $custid)
        //             ->where('sr.status', '=', 1);
        //     })
        //     ->select(
        //         'p.*',
        //         DB::raw("CASE WHEN a.end_date < CURDATE() THEN 'expired' ELSE 'active' END as amc_status"),
        //         DB::raw("CASE WHEN sr.id IS NOT NULL THEN 'true' ELSE 'false' END as is_allowed")
        //     )
        //     ->orderBy('p.product_name', 'asc')
        //     ->get();

        $new_vendor_id = '';

        if(isset($vendor_id))
            $new_vendor_id = $vendor_id;

        if(isset($custid))
            $new_vendor_id = $custid;
        // else
        //     $new_vendor_id = $vendor_id;

        // echo $new_vendor_id;die;
        $products = DB::table('products as p')
                    ->leftJoin('amcs as a', function ($join) use ($new_vendor_id) {
                        $join->on('p.id', '=', 'a.product_id')
                            ->where('a.vendor_id', '=', $new_vendor_id);
                    })
                    ->leftJoin('service_requests as sr', function ($join) use ($new_vendor_id) {
                        $join->on('a.id', '=', 'sr.amc_id')
                            // ->where('sr.request_by_id', '=', $new_vendor_id)
                            ->where('sr.status', '=', 1);
                            // ->where('active_status','=',0);
                    })
                    ->select(
                        'p.*','sr.id as service_requested_id',
                        DB::raw("
                            CASE 
                                WHEN a.id IS NULL THEN 'not_created'
                                WHEN a.end_date < CURDATE() THEN 'expired'
                                ELSE 'active'
                            END as amc_status
                        "),
                        // DB::raw("CASE WHEN sr.id IS NOT NULL THEN 'true' ELSE 'false' END as is_allowed")
                        DB::raw("
                            CASE 
                                WHEN sr.id IS NOT NULL AND sr.active_status = 0 THEN 'true'
                                ELSE 'false'
                            END as is_allowed
                        ")
                    )
                    ->orderBy('p.product_name', 'asc')
                    ->get();

        //added by sundaram on 14-06-2021 for service provider start
        $service_pros = DB::table('service_providers')
            ->where('deleted_at', '=', 'N')
            ->where('status', '=', 'Active')
            ->orderBy('name', 'asc')
            ->get();

        $checklists = DB::table('check_list')
            ->where('deleted_at', '=', '0000-00-00')
            ->get();

        $clientticketno = $this->generateUniqueTicketNo();



        $requests = DB::table('service_requests')
            ->join('amcs', 'service_requests.amc_id', '=', 'amcs.id')
            ->join('vendor', 'amcs.vendor_id', '=', 'vendor.id')
            ->join('products', 'amcs.product_id', '=', 'products.id')
            ->where('service_requests.request_done', 1)
            ->where('service_requests.request_by_id', Session::get('custid')) // Filter by logged-in user
            ->orderBy('service_requests.updated_date', 'desc')
            ->select(
                'service_requests.*',
                'vendor.company_name',
                'vendor.name as vendor_name',
                'products.product_name',
                'amcs.end_date',
                'amcs.start_date'
            )
            ->get();

        if (Session::has('custid')) {
            // Vendor
            $user_id = Session::get('custid');
            $user_role = 'vendor';
        } elseif (Auth::check()) {
            // Admin (assuming Laravel Auth is used for admin)
            $user_id = Auth::id();
            $user_role = 'admin';
        } else {
            return redirect()->back()->with('error', 'User not authenticated.');
        }


        $alreadyRequested = DB::table('service_requests')
            ->where('request_by_id', Session::get('custid'))
            ->where('user_role', $user_role)
            ->where('amc_id')
            ->exists();

        foreach ($requests as $index => $request) {
            $request->serial = $index + 1;
        }
        
        $isAdmin = Auth::check();
    
        $site_setting = DB::table('site_settings')->first();

        $settings = [];

        if ($site_setting && $site_setting->settings) {
            $settings = unserialize(urldecode($site_setting->settings));
        }
        $locations = DB::table('managevendoraddress') // replace with your actual table name
            ->where('vendor_id', Session::get('custid')) // or 'client_id' — match your schema
            ->select('id', 'address_line1', 'city')
            ->get();

        $addresses = DB::table('managevendoraddress')->get();

        $vendorAddresses = [];
        foreach ($addresses as $address) {
            $vendorAddresses[$address->vendor_id][] = [
                'id' => $address->id,
                'text' => trim(
                    ($address->address_line1 ?? '') . ', ' .
                        ($address->city ?? '') . ', ' .
                        ($address->state ?? '') . ' - ' .
                        ($address->pin_code ?? '')
                )
            ];
        }

        //added by sundaram on 14-06-2021 for service provider end                             
        return view('services.create')
            ->withVendors($vendors)
            ->withlocations($locations)
            ->withProducts($products)
            ->withsettings($settings)
            ->withvendorAddresses($vendorAddresses)
            ->withServiceenable_value($serviceenable_value)
            ->with('expired_products', $expired_products) // pass expiry products only ,hari
            ->withservice_pros($service_pros)
            ->withchecklists($checklists)
            ->withclientticketno($clientticketno)
            ->withrequests($requests)
            ->with('isAdmin', $isAdmin)
            ->withalreadyRequested($alreadyRequested)
            ->with('amc_expiry_messages', $amc_expiry_messages); // ✅ pass expiry messages to view
    }
    public function getVendorStatus($vendor_id)
    {
        $vendor = DB::table('vendor')
            ->where('id', $vendor_id)
            ->select('vendor_address_status')
            ->first();

        return response()->json([
            'vendor_address_status' => $vendor ? $vendor->vendor_address_status : 0
        ]);
    }
    public function getRequestDetails($vendor_id)
    {
        $requests = $expired_products = collect();

        $requests = DB::table('service_requests')
            ->join('amcs', 'service_requests.amc_id', '=', 'amcs.id')
            ->join('vendor', 'amcs.vendor_id', '=', 'vendor.id')
            ->join('products', 'amcs.product_id', '=', 'products.id')
            ->where('service_requests.request_done', 1)
            ->where('service_requests.request_by_id', $vendor_id ) // Filter by logged-in user
            ->orderBy('service_requests.updated_date', 'desc')
            ->select(
                'service_requests.*',
                'vendor.company_name',
                'vendor.name as vendor_name',
                'products.product_name',
                'amcs.end_date',
                'amcs.start_date'
            )
            ->get();

        
        $today = Carbon::now();

        $expired_products = DB::table('amcs')
                ->join('products', 'amcs.product_id', '=', 'products.id')
                ->leftJoin('service_requests', function ($join) {
                    $join->on('amcs.id', '=', 'service_requests.amc_id');
                })
                ->where('amcs.vendor_id', $vendor_id)
                ->whereDate('amcs.end_date', '<', $today)
                ->select(
                    'products.id',
                    'products.product_name',
                    'products.product_code',
                    DB::raw('COALESCE(service_requests.request_done, 0) as request_done')
                )
                ->groupBy(
                    'products.id',
                    'products.product_name',
                    'products.product_code',
                    'service_requests.request_done'
                )
                ->get();


        return response()->json([
            'requests' => $requests,
            'expired_products' => $expired_products
        ]);
    }
    private function generateUniqueTicketNo($length = 3)
    {
        $prefix = Config::get('app.ticketprefix'); // example: "TKT"
        $date = date('Ymd'); // format: 20250410
        $time = date('His'); // format: 145305

        do {
            $randomPart = strtoupper(Str::random($length)); // example: A1B2C3
            $ticketNo = $prefix . $date . $time . $randomPart;
            $exists = DB::table('shipment')->where('clientticketno', $ticketNo)->exists();
        } while ($exists);

        return $ticketNo;
    }


    public function submitRequestService(Request $request)
    {
        $input = $request->all();

        $validator = Validator::make($request->all(), [
            'product_id' => 'required|integer',
            'message' => 'required|string|max:255',
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        // $vendor_id = Auth::id();
        // $vendor_id = Session::get('custid'); // or use Auth::id() if applicable
        $vendor_id = Session::get('custid');
        if(isset($input['vendor_ids']))
        {
            $vendor_id = $input['vendor_ids'];
        }
        
        // print_r($request->all());die;
        $product_id = $request->input('product_id');

        if (Session::has('custid')) {
            // Vendor
            $user_id = Session::get('custid');
            $user_role = 'vendor';
        } elseif (Auth::check()) {
            // Admin (assuming Laravel Auth is used for admin)
            $user_id = Auth::id();
            $user_role = 'admin';
        } else {
            return redirect()->back()->with('error', 'User not authenticated.');
        }

        // dd("this is vender id = ".$vendor_id."-->this is products id = ".$product_id);
        // dd("this is products id = ".$product_id);
        $amc = DB::table('amcs')
            ->where('vendor_id', $vendor_id)
            ->where('product_id', $product_id)
            ->whereDate('end_date', '<', Carbon::now())
            ->first();

        $alreadyRequested = DB::table('service_requests')
            ->where('request_by_id', $user_id)
            ->where('user_role', $user_role)
            ->where('amc_id', $amc->id)
            ->exists();

        if ($alreadyRequested) {
            // return redirect()->back()->with('error', 'You have already submitted a renewal request for this product.');
            return redirect()->back()->withInput()->with('error', 'You have already submitted a service request for this product.');
        }
        //  dd($amc);


        // DB::table('service_requests')->insert([
        //     'request_by_id' => $user_id,
        //     'user_role' => $user_role,
        //     'amc_id' => $amc->id,
        //     'message' => $request->input('message'),
        //     'status' => 0,
        //     'request_done' => 1,
        //     'created_date' => Carbon::now(),
        //     'updated_date' => Carbon::now(),
        //     'active_status' => 0,
        // ]);

        $serviceRequestId = DB::table('service_requests')->insertGetId([
            'request_by_id' => $user_id,
            'user_role' => $user_role,
            'amc_id' => $amc->id,
            'message' => $request->input('message'),
            'status' => 0,
            'request_done' => 1,
            'created_date' => Carbon::now(),
            'updated_date' => Carbon::now(),
            'active_status' => 0,
        ]);

        // DB::table('shipment')
        //     ->where('service_requested_id', $serviceRequestId)
        //     ->where('product_id', $amc->product_id)
        //     ->update(['service_request_type' => 3]);

        DB::table('shipment')
            ->where('vendor_id', $user_id) // or your matching key
            ->where('product_id', $amc->product_id)
            ->whereNull('service_requested_id') // look for rows that haven’t been linked yet
            ->update([
                'service_requested_id' => $serviceRequestId,
                'service_request_type' => 3
            ]);

        return redirect()->back()->with('success', 'Your request has been submitted successfully.');
    }


    public function auto()
    {
        $vendors = Vendor::all();
        $products = DB::table('products')
            ->get();
        return view('services.auto')->withVendors($vendors)->withProducts($products);
    }

    public function autocomplete($name)
    {

        $queries = DB::table('bikers')
            ->where('first_name', 'LIKE', '%' . $name . '%')
            ->orWhere('last_name', 'LIKE', '%' . $name . '%')
            ->take(5)->get();

        foreach ($queries as $query) {
            $results[] = ['id' => $query->id, 'value' => $query->first_name . ' ' . $query->last_name];
        }
        return Response::json($results);
    }

    public function store(Request $request)
    {
        $month = date('m');
        $year = date('Y');

        //code added on 23 oct 2019
        //get count of services created monthly
        $monthly_services_count = DB::table('shipment')
            ->whereMonth('created_at', '=', $month)
            ->whereYear('created_at', '=', $year)
            ->count();
        //get user have which plan from apniamc_master db
        $clients = DB::connection('apniamc_master')
            ->table('client_master')
            ->where('domain_name', $_SERVER['SERVER_NAME'])
            ->where('is_active', 'Y')
            ->first();
        $client_plan = '';
        if (!empty($clients)) {
            $client_plan = $clients->client_plan;
        }
        $limit_sevices = 50;

        //if user has BASIC plan then check and restrict it to make only 50 services 
        if ($client_plan == 'BA') {
            if ($monthly_services_count >= $limit_sevices) {
                session::flash('unable_create_serv_mesg', 'Please upgrade your plan to make more Services. Please contact on this number 9137858155.');
                return redirect('/service/create');
            } else {
                return  $this->finalStoreServices($request);
            }
        } else {
            return  $this->finalStoreServices($request);
        }
    }
    //code added on 23 oct 2019
    //this function will be called to create the services
    public function finalStoreServices(Request $request)
    {
        $serviceenable_value = 0;
        $serviceenable = false;
        $site_settings = DB::table('site_settings')
            ->select('*')
            ->get();
        $settings_arr = array();
        if ($site_settings) {
            foreach ($site_settings as $val) {
                $settings_str = urldecode($val->settings);
                $settings_arr = unserialize($settings_str);
            }
        }

        if (isset($settings_arr['serviceprovider'])) {
            if ($settings_arr['serviceprovider'] == '1') {
                $serviceenable = true;
                $serviceenable_value = $settings_arr['serviceprovider'];
            }
        }
        
        
        //Code for multiple location by AMI END

        if ($serviceenable_value == 1) {
            // echo "ddf"; die();
            //echo "<pre>";print_r($request->all());die;
            $this->validate($request, [
                'vendor_id' => 'required',
                'product_id' => 'required',
                'service_id' => 'required',
                'service_description' => 'required|min:15|max:255',
                'service_type' => 'required',

                'instructions' => 'min:15|max:255',
                // 'checklist' => 'required',
                'mobileno' => 'required|regex:/^[0-9]+$/',

            ]);
        } else {      //  echo "else"; die();
            //echo "<pre>";print_r($request->all());die;
            $this->validate($request, [
                'vendor_id' => 'required',
                'product_id' => 'required',
                'service_description' => 'required|min:15|max:255',
                'instructions' => 'min:15|max:255',
                'service_type' => 'required',

                'mobileno' => 'required|regex:/^[0-9]+$/',

            ]);
        }
        //added on 17-03-2019

        if (!empty($request->input('service_date'))) {
            $this->validate($request, [
                'future_date' => 'required',
            ]);
        }
        // end

        $input = $request->all();

        if($input['service_requested_id'] != '0')
            $service_requested_id = $input['service_requested_id'];
        else
            $service_requested_id = null;


        $product_code = DB::table('products')
            ->select('*')
            ->where('products.id', '=', $input['product_id'])
            ->first();
        $custid = Session::get('custid');
        $custname = Session::get('custname');
        if (isset($custid) && $custid) {
            $user =  $custname;
            $typ = "Desktop - " . $user;
            $username =  "Customer - " . $user;
            $awb_date = Carbon::now()->format('dmYHis');
            $awb_no = "SUPP" . $awb_date . $product_code->product_code;
            $admin = $user;
            $request_by_id = Session::get('custid');
            $service_request_type = 2;
        } else {
            $user = Auth::user();
            $typ = "Desktop - " . $user->first_name . " " . $user->last_name;
            $username =  "Admin - " . $user->first_name . " " . $user->last_name;
            $awb_date = Carbon::now()->format('dmYHis');
            $awb_no = "SUPP" . $awb_date . $product_code->product_code;

            $admin = $user->first_name . " " . $user->last_name;
            $request_by_id = Auth::id();
            $service_request_type = 0;
        }
        //if ($input['set_priority'] == '') {
        //  $input['set_priority'] = 0; 
        //}
        
        if ($_SERVER['REMOTE_ADDR'] == '1.146.221.120') {
        } else {

            // $hasServiceType3 = VendorShipment::where('vendor_id', $input['vendor_id'])
            //     ->where('product_id', $input['product_id'])
            //     // ->where('service_requested_id', $request_by_id)
            //     ->where('service_request_type', 3)
            //     ->exists();
            $hasServiceType3 = DB::table('service_requests')
                            ->where('id',$service_requested_id)
                            ->exists();

            $requestStatus = $hasServiceType3 ? 1 : 0;
            
            // $isAdmin = Auth::id();
            // if (!$isAdmin) {
            //     $alreadyRequested = DB::table('shipment')
            //         ->where('product_id', $request->input('product_id'))
            //         ->where('request_status', 1)
            //         ->exists();

            //     if ($alreadyRequested) {
            //         return redirect()->back()->withInput()->with('error', 'You have already submitted a request for this product. ⚠️ However, your AMC has expired. You can renew your AMC to request again.');
            //     }
            // }
            // print_r($request->all());die;


            // $vendorAddress = DB::table('managevendoraddress')
            //     ->where('id', $input['vendor_location'])
            //     ->first();

            // $fullAddress = '';
            // if ($vendorAddress) {
            //     $fullAddress = $vendorAddress->address_line1;
            //     if (!empty($vendorAddress->city)) {
            //         $fullAddress .= ', ' . $vendorAddress->city;
            //     }
            // }

            // if (!empty($settings['location']) && $settings['location'] == 1 && isset($input['vendor_location'])) {
            //     $vendorAddress = DB::table('managevendoraddress')
            //         ->where('id', $input['vendor_location'])
            //         ->first();

            //     $fullAddress = '';
            //     if ($vendorAddress) {
            //         $fullAddress = $vendorAddress->address_line1;
            //         if (!empty($vendorAddress->city)) {
            //             $fullAddress .= ', ' . $vendorAddress->city;
            //         }
            //     }
            // } else {
            //     $fullAddress = '';
            // }
        // dd($input);

            $fullAddress = '';
            if(isset($input['vendor_location']))
                $fullAddress = $input['vendor_location']; //Code for multiple location by AMI

            // added by brijesh on 25-07-2020
            if (isset($input['rmarefticketno'])) {
            } else {
                $input['rmarefticketno'] = "";
            }
            // end

            /* added by brijesh on 17-03-2020  future service*/

            if ($input['checklist'] == 0)
                $status_checklist = 0;
            else
                $status_checklist = 1;

            if ($input['service_date']) {

                $users = DB::table('users')
                    ->select('id')
                    ->get();

                foreach ($users as $user) {

                    // $user_id = Auth::user()->id;
                    $user_id = $user->id;
                    // $order_time = $input['order_time'];
                    $data = array('user_id' => $user_id, 'vendor_id' => $input['vendor_id'], 'order_time' => $input['future_date']);
                    DB::table('future_sevice_notification')->insert($data);
                }
                // $service_sate=date('Y-m-d', strtotime($input['service_date2']));
                //echo "hello1".$service_sate;die();


                if (!empty($input['service_id'])) {

                    $service = VendorShipment::create([
                        'vendor_id' => $input['vendor_id'],

                        'product_id' => $input['product_id'],
                        'service_description' => $input['service_description'],
                        'awb_no' => $awb_no,
                        'order_time' => $input['future_date'],
                        'target_date' => $input['target_date'],
                        'service_provider_id' => $input['service_id'],
                        'delivery_status' => "New",
                        'created_type' => $typ,
                        'created_by' => $username,
                        //created_by'=>$username,
                        'service_type' => $input['service_type'],
                        //uncommment this 'amc_option', incase if popping is there in create services
                        //'amc_option' => (isset($input['amc_option'])),
                        'instructions' => $input['instructions'],
                        'mobileno' => $input['mobileno'],

                        'new_priority' => $input['new_priority'],
                        'rmaref' => $input['rmaref'],
                        'rmarefticketno' => $input['rmarefticketno'],
                        'clientticketno' => $input['clientticketno'],
                        'checklist' => $input['checklist'],
                        'checklist_status' => $status_checklist,
                        'service_requested_id' => $service_requested_id,
                        'service_request_type' => $service_request_type,
                        'request_status' => $requestStatus,
                        'vendor_address' => $fullAddress
                    ]);


                    if ($requestStatus === 1) {
                        DB::table('service_requests')
                            ->where('id',$service_requested_id)
                            // ->where('product_id', $input['product_id'])
                            ->where('request_by_id', $request_by_id)
                            ->update(['active_status' => 1]);
                    }

                    //update ticket no
                    $awb_no = Config::get('app.ticketprefix') . $service->id;
                    $servicelist = VendorShipment::find($service->id);
                    $servicelist->awb_no = $awb_no;
                    $servicelist->save();

                    //update ticket no
                    //end  added by brijesh on 21-12-2019 
                } else {

                    //echo $awb_no;die;
                    $service = VendorShipment::create([
                        'vendor_id' => $input['vendor_id'],

                        'product_id' => $input['product_id'],
                        'service_description' => $input['service_description'],
                        'awb_no' => $awb_no,
                        'order_time' => $input['future_date'],
                        'target_date' => $input['target_date'],
                        //'service_provider_id' => $input['service_id'],
                        'delivery_status' => "New",
                        'created_type' => $typ,
                        'created_by' => $username,
                        //created_by'=>$username,
                        'service_type' => $input['service_type'],
                        //uncommment this 'amc_option', incase if popping is there in create services
                        //'amc_option' => (isset($input['amc_option'])),
                        'instructions' => $input['instructions'],
                        'mobileno' => $input['mobileno'],

                        'new_priority' => $input['new_priority'],
                        'rmaref' => $input['rmaref'],
                        'rmarefticketno' => $input['rmarefticketno'],
                        'clientticketno' => $input['clientticketno'],
                        'checklist' => $input['checklist'],
                        'checklist_status' => $status_checklist,
                        'service_requested_id' => $service_requested_id,
                        'service_request_type' => $service_request_type,
                        'request_status' => $requestStatus,
                        'vendor_address' => $fullAddress
                    ]);


                    if ($requestStatus === 1) {
                        DB::table('service_requests')
                            ->where('id',$service_requested_id)
                            // ->where('product_id', $input['product_id'])
                            ->where('request_by_id', $request_by_id)
                            ->update(['active_status' => 1]);
                    }

                    //update ticket no
                    $awb_no = Config::get('app.ticketprefix') . $service->id;
                    $servicelist = VendorShipment::find($service->id);
                    $servicelist->awb_no = $awb_no;
                    $servicelist->save();

                    //update ticket no
                    //end  added by brijesh on 21-12-2019 
                }
            }
            /*end brijesh 17-03-2020*/
             else {
                if (!empty($input['service_id'])) {
                    // echo $input['service_id'];die;
                    $service = VendorShipment::create([
                        'vendor_id' => $input['vendor_id'],
                        'product_id' => $input['product_id'],
                        'service_description' => $input['service_description'],

                        'awb_no' => $awb_no,
                        'order_time' => Carbon::now()->toDateTimeString(),
                        'target_date' => $input['target_date'],
                        'delivery_status' => "New",
                        'created_type' => $typ,
                        'created_by' => $username,
                        //created_by'=>$username,
                        'service_type' => $input['service_type'],
                        'instructions' => $input['instructions'],
                        'mobno' => $input['mobileno'],
                        'new_priority' => $input['new_priority'],
                        'rmaref' => $input['rmaref'],
                        'rmarefticketno' => $input['rmarefticketno'],
                        'clientticketno' => $input['clientticketno'],
                        'service_provider_id' => $input['service_id'],
                        'checklist' => $input['checklist'],
                        'checklist_status' => $status_checklist,
                        'service_requested_id' => $service_requested_id,
                        'service_request_type' => $service_request_type,
                        'request_status' => $requestStatus,
                        'vendor_address' => $fullAddress
                    ]);

                    if ($requestStatus === 1) {
                        DB::table('service_requests')
                            // ->where('product_id', $input['product_id'])
                            ->where('id',$service_requested_id)
                            ->where('request_by_id', $request_by_id)
                            ->update(['active_status' => 1]);
                    }
                    //update ticket no
                    $awb_no = Config::get('app.ticketprefix') . $service->id;
                    $servicelist = VendorShipment::find($service->id);
                    $servicelist->awb_no = $awb_no;
                    $servicelist->save();
                    //update ticket no
                } else {

                    $service = VendorShipment::create([
                        'vendor_id' => $input['vendor_id'],
                        'product_id' => $input['product_id'],
                        'service_description' => $input['service_description'],
                        'awb_no' => $awb_no,
                        'order_time' => Carbon::now()->toDateTimeString(),
                        'target_date' => $input['target_date'],
                        'delivery_status' => "New",
                        'created_type' => $typ,
                        'created_by' => $username,
                        //created_by'=>$username,
                        'service_type' => $input['service_type'],
                        'instructions' => $input['instructions'],
                        'mobileno' => $input['mobileno'],
                        'new_priority' => $input['new_priority'],
                        'rmaref' => $input['rmaref'],
                        'rmarefticketno' => $input['rmarefticketno'],
                        'clientticketno' => $input['clientticketno'],
                        //'service_provider_id' => $input['service_id'],
                        'checklist' => $input['checklist'],
                        'checklist_status' => $status_checklist,
                        'service_requested_id' => $service_requested_id,
                        'service_request_type' => $service_request_type,
                        'request_status' => $requestStatus,
                        'vendor_address' => $fullAddress
                    ]);

                    // if($service){
                    //     echo "in";die;
                    // }else{
                    //     echo "out";die;
                    // }

                    if ($requestStatus === 1) {
                        DB::table('service_requests')
                            // ->where('product_id', $input['product_id'])
                            ->where('id',$service_requested_id)
                            ->where('request_by_id', $request_by_id)
                            ->update(['active_status' => 1]);
                    }

                    //update ticket no
                    $awb_no = Config::get('app.ticketprefix') . $service->id;
                    $servicelist = VendorShipment::find($service->id);
                    $servicelist->awb_no = $awb_no;
                    $servicelist->save();
                    //update ticket no
                }
            }

            $vinfo = DB::table('vendor')
                ->select('*')
                ->where('vendor.id', '=', $input['vendor_id'])
                ->first();
            // code by mehul sir to fetch 'setting' column and decode it from site_settings table                
            $supportemail = DB::table('site_settings')
                ->select('settings')
                ->get();
            $settings_arr = array();
            if ($supportemail) {
                foreach ($supportemail as $val) {
                    $settings_str = urldecode($val->settings);
                    $settings_arr = unserialize($settings_str);
                }
            } // code by mehul sir
            $servicedesc = $input['service_description'];
            //echo "<pre>"; print_r($settings_arr); die();
            // added this variable to get support emial in this '$semail'
            if (!empty($settings_arr)) {
                $support_mail = str_replace(' ', '', $settings_arr['support_email_to']);
                $semail = explode(',', $support_mail);
                $mails = array();
                for ($i = 0; $i <= count($semail) - 1; $i++) {
                    array_push($mails, $semail[$i]);
                }
            }
            $vname = $vinfo->name;
            $vemail = $vinfo->email;
            $vpwd = $vinfo->plain_password;

            $enquiry_message = Config::get('app.companyname') . " Admin(" . $admin . ") created ticket for you with the complain " . $input['service_description'] . " For Product " . $product_code->product_name . ".";
            $emailcontent = array(
                'email' => $vemail,
                'password' => $vpwd,
                'cno' => $awb_no
            );
            //code by gaurav to send mail to multiple recepients one to the customer and to support system 

            $emailcontent1 = array(
                'email' => $vemail,
                'password' => $vpwd,
                'cno' => $awb_no,
                'productname' => $product_code->product_name,
                'servicedesc' => $servicedesc,
                'vendorcompany' => $vinfo->company_name,
                'vendorname' => $vinfo->name
            );
            $mobno = $input['mobileno'];
            $st = str_replace(' ', '%20', $awb_no);
            $link3 = "https://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20" . Config::get('app.companypnone') . ".From" . Config::get('app.companyname') . ".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";

            $client3 = new \GuzzleHttp\Client();
            $this->response = $client3->get($link3)->getBody()->getContents();
            //print_r($this->response); exit();
            //send sms
            $m1 = $vinfo->mobile_no;

            $link1 = "https://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20" . Config::get('app.companypnone') . ".From" . Config::get('app.companyname') . ".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
            $client1 = new \GuzzleHttp\Client();
            $this->response = $client1->get($link1)->getBody()->getContents();
            //end


            //temp comment
            /* StatusHistory::create([
            'by_whom_role' => "Vendor", 
            'by_whom_id' => $input['vendor_id'],
            'date_time' => Carbon::now()->toDateTimeString(),
            'shipment_id' => $service->id,
            'status' => "New",
            ]);*/

            /* Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        
          
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));

            $message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');

        });*/


            //Added by gaurav on 26-08-20 for sending mail while creating tickets 
            // if(!empty($support_mail)){
            //     Mail::send('emails.createticketsupport', $emailcontent1, function ($message) use($mails) {
            //         $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
            //         $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
            //         // changes by gaurav on 3-march-2020 for sending mail to multiple recepients 
            //         foreach ($mails as $mail) {
            //             $message->to($mail); 
            //         }
            //         $message->subject(Config::get('app.companyname').' Create Ticket Request');
            //     });
            // }
            //Ended here 
        } //else
        if (isset($custid) && $custid) {
            $request->session()->flash('flash_message', 'Service added successfully !!!');
            return back();
        } else {
            if ($input['future_date']) {
                $request->session()->flash('flash_message', 'Service added successfully !!!');
                return redirect('managedelivery?type=future');
            } else {
                $request->session()->flash('flash_message', 'Service added successfully !!!');
                return redirect('managedelivery?type=today');
            }
        }
    }
    public function getcheklistdata(Request $request)
    {
        $input = $request->all();
        $product_id = $input['product_id'];

        $checklists = DB::table('check_list')
            ->select('title', 'id')
            ->where('deleted_at', '=', '0000-00-00')
            ->where('product_id', $product_id)
            ->get();

        $data = ['checklist' => $checklists];
        return response()->json($data);
    }
    public function getpriorities(Request $request)
    {
        $priorities = DB::table('priority')
            ->select('name', 'id')
            ->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00" OR deleted_at = "N")')
            ->get();

        $data = ['priorities' => $priorities];
        return response()->json($data);
    }
    public function smscheck()
    {
        $vinfo = DB::table('vendor')
            ->select('*')
            ->where('vendor.id', '=', '75')
            ->first();
        $product_code = DB::table('products')
            ->select('*')
            ->where('products.id', '=', '4')
            ->first();
        $m1 = $vinfo->mobile_no;
        $awb_date = Carbon::now()->format('dmYHis');
        $awb_no = Config::get('app.ticketprefix') . $service->id;
        $st = str_replace(' ', '%20', $awb_no);
        $link1 = "https://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,Your%20complaint%20has%20been%20registered,Complaint No.$st,%20Your%20Complaint%20Will%20Attend%20Shortly.For%20further%20assistance%20pls%20call%208080922970.&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
        $client1 = new \GuzzleHttp\Client();
        $this->response = $client1->get($link1)->getBody()->getContents();
    }

    public function createautoservice(Request $request)
    {
        $amcs = DB::table('amcs')
            ->select('*')
            ->where('end_date', '>=', date('Y-m-d'))
            ->where('next_service_date', '=', date('Y-m-d'))
            ->get();

        if ($amcs) {
            foreach ($amcs as $amc) {

                $product_id = $amc->product_id;
                $vendor_id = $amc->vendor_id;

                $product_code = DB::table('products')
                    ->select('*')
                    ->where('products.id', '=', $product_id)
                    ->first();

                $user = Auth::user();

                $username =  "Admin - " . $user->first_name . " " . $user->last_name;

                $typ = "Desktop - Auto Generate Service";
                $awb_date = Carbon::now()->format('dmYHis');
                $awb_no = "SUPP" . $awb_date . $product_code->product_code;

                $admin = "Auto Generated";

                $service_description = 'auto generated ticket';
                $service_type = 'Complain';
                $mobno = '';

                $service = VendorShipment::create([
                    'vendor_id' => $vendor_id,
                    'product_id' => $product_id,
                    'service_description' => $service_description,
                    'awb_no' => $awb_no,
                    'order_time' => Carbon::now()->toDateTimeString(),
                    'delivery_status' => "New",
                    'created_type' => $typ,
                    // 'created_by'=>"Admin",
                    'created_by' => $username,
                    'service_type' => $service_type,
                    'mobno' => $mobno,
                ]);

                //update ticket no
                $awb_no = Config::get('app.ticketprefix') . $service->id;
                $servicelist = VendorShipment::find($service->id);
                $servicelist->awb_no = $awb_no;
                $servicelist->save();
                //update ticket no



                $vinfo = DB::table('vendor')
                    ->select('*')
                    ->where('vendor.id', '=', $vendor_id)
                    ->first();
                $vname = $vinfo->name;
                $vemail = $vinfo->email;
                $vpwd = $vinfo->plain_password;
                $enquiry_message = Config::get('app.companyname') . " Admin(" . $admin . ") created ticket for you with the complain " . $service_description . " For Product " . $product_code->product_name . ".";
                $emailcontent = array(
                    'email' => $vemail,
                    'password' => $vpwd,
                    'cno' => $awb_no
                );

                $st = str_replace(' ', '%20', $awb_no);
                $link3 = "https://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20" . Config::get('app.companypnone') . ".From" . Config::get('app.companyname') . ".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
                $client3 = new \GuzzleHttp\Client();
                $this->response = $client3->get($link3)->getBody()->getContents();
                //print_r($this->response); exit();
                //send sms
                $m1 = $vinfo->mobile_no;


                $link1 = "https://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20" . Config::get('app.companypnone') . ".From" . Config::get('app.companyname') . ".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
                $client1 = new \GuzzleHttp\Client();
                $this->response = $client1->get($link1)->getBody()->getContents();
                //end

                StatusHistory::create([
                    'by_whom_role' => "Vendor",
                    'by_whom_id' => $vendor_id,
                    'date_time' => Carbon::now()->toDateTimeString(),
                    'shipment_id' => $service->id,
                    'status' => "New",
                ]);

                //update
                $service_timeframe = '';
                $next_service_date = '';

                if ($amc->service_timeframe != '') {
                    $service_timeframe = $amc->service_timeframe;
                    switch ($service_timeframe) {
                        case '15 Days':

                            $daystoadd = 15;
                            $next_service_date = date('Y-m-d', strtotime("+15 days", strtotime($amc->next_service_date)));
                            break;

                        case 'Monthly':
                            $next_service_date = date('Y-m-d', strtotime("+1 month", strtotime($amc->next_service_date)));
                            break;

                        case 'Quaterly':
                            $next_service_date = date('Y-m-d', strtotime("+3 months", strtotime($amc->next_service_date)));
                            break;
                    }
                }

                DB::table('amcs')
                    ->where('id', $amc->id)
                    ->update(['next_service_date' => $next_service_date]);

                //update
                //Mail::send('emails.createticket', $emailcontent, function ($message) use($vemail) {        

                //$message->from(Config::get('app.fromemail'), Config::get('app.companyname'));

                //$message->to($vemail)->subject(Config::get('app.companyname').' Create Ticket Request');


                //}); 
                //$request->session()->flash('flash_message','Service successfully added');
                //return redirect('service/create');
            } //foreach
        }
    }
    public function spclientselect(Request $request)
    {

        // echo "<pre>" ; print_r($request-> all()); die;
        // echo "ppp1"; echo "<pre>";print_r($request->all());

        $selected_sp = DB::table('vendor')
            ->leftjoin('service_providers', 'vendor.service_provider_id', '=', 'service_providers.id')
            ->select('service_providers.id')
            ->where('vendor.id', '=', $request->clientsec_id)
            ->get();


        $count = count($selected_sp);

        // echo "<pre>"; print_r($selectedbranch); die; 
        if ($count > 0) {
            return json_encode($selected_sp);
        } else {
            return json_encode(0);
        }


        //return json_encode($selected_sp);
        //  echo "<pre>"; print_r($selected_sp); die;   
    }
}
