<?php

namespace App\Http\Controllers\Ratings;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Amcs;
use App\Ratings;
use Input;
use Auth;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;
use Excel;
use Illuminate\Pagination\Paginator;
use Config;
use DateInterval;

class RatingsController extends Controller
{
   
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'rating.vendor_id';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }
		
        $sort_data = array(
            'b.first_name',
		    'rating.app',
            'rating.technician',
            'rating.desc',
            'rating.awd',
            'v.company_name',
            'v.p_company_name',
        );
        //$query = Amcs::select();
		
		$query = Ratings::leftjoin('vendor as v','rating.vendor_id','=','v.id')
					->leftjoin('bikers as b','rating.tech_id','=','b.id')
                        ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.company_name','v.name','b.first_name','b.last_name','rating.created_by');
       
        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "rating.vendor_id";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
        if(!empty(Input::get('filter_name'))) {
            $query->where(function($query) {
                 $query->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
                ->orWhere('rating.desc', 'LIKE', "%".Input::get('filter_name')."%")
				->orWhere('rating.awd', 'LIKE', "%".Input::get('filter_name')."%")
				->orWhere('b.first_name', 'LIKE', "%".Input::get('filter_name')."%")
				->orWhere('b.last_name', 'LIKE', "%".Input::get('filter_name')."%")
                ->orWhere('v.p_company_name', 'LIKE', "%".Input::get('filter_name')."%")
						;
            });
        }
		//dd($query->toSql());
		
    
		$ratings = $query->paginate(10);
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
		//export start
		 if(Input::get('report') == 1) {
		 $query1 = DB::table('rating as rating')          
                  ->leftjoin('vendor as v','rating.vendor_id','=','v.id')
					->leftjoin('bikers as b','rating.tech_id','=','b.id')
                        ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.company_name','b.first_name','b.last_name')
				  ->orderBy('rating.id','DESC')
				  ->get();
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('Company Name/Client Name', 'Company Rating', 'Technician Rating', 'Technician Name', 'Ticket No', 'Description'));
			 foreach ($query1 as $line) { 
                $data = array(
                    'company_name' => $line->company_name,
                    'company_rating' => $line->app,
                    'technician_rating' => $line->technician,
                    'technician_name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'ticket_no' => $line->awd,
                    'description' => $line->desc
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
			    ob_end_clean();

            $csv->output('ratings_report.csv');
            return;
		}
		//end start
        return view('ratings.index')->withRatings($ratings)->withFilter($filter);

        //return view('ratings.index');

    }
	
	public function indexnew()
    {
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 's.created_at';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'DESC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }
		
        $sort_data = array(
            'b.first_name',
		    'rating.app',
            'rating.technician',
            'rating.desc',
            'rating.awd',
            'v.company_name',
			'rating.created_at',
            //'v.p_company_name',
        );
        //$query = Amcs::select();
		//pending rating start
        $bikers = DB::table('bikers as b')
              ->select('id','first_name','last_name','email')
              ->where('b.status','=','Active')
              ->where('b.profile_status','=','Available')
              ->whereNull('b.deleted_at')
              ->orderBy('b.first_name','ASC')
              ->get();
        $vendors = DB::table('vendor as v')
              ->select('id','company_name','name','email')
              ->where('v.deleted_at','=','N')
              ->orderBy('v.company_name','ASC')
              ->get();
		$query1 = DB::table('shipment as s')  
				->leftjoin('vendor as v','s.vendor_id','=','v.id')
                ->leftjoin('bikers as b','s.biker_id','=','b.id')
                ->leftjoin('rating as r','r.awd','=','s.awb_no')
                ->select('s.awb_no','s.delivery_status','s.created_at','s.updated_at','v.company_name','v.name','v.id','b.first_name','b.last_name','b.id as biker_id','v.deleted_at');
        // Added by gaurav on 27-4-20 for filtering data og manage rating page by start and end date..
        if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('bikers_id')) || !empty(Input::get('vendors_id')) ) {
            if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                $start_date = Input::get('start_date');
                $end_date = Input::get('end_date');
                
                $start_time = '00:00:00';
                $end_time = '23:59:59';

                $date = new DateTime($start_date);
                $start_date = $date->format('Y-m-d '. $start_time);
                $date = new DateTime($end_date);
                $end_date = $date->format('Y-m-d '. $end_time);
                $query1->whereBetween('s.created_at', array($start_date,$end_date));
            } 
            if(!empty(Input::get('biker_id'))) 
            {
                $biker_id = Input::get('biker_id');
                $query1->where('s.biker_id','=',$biker_id); 
            }
            if(!empty(Input::get('vendor_id'))) 
            {
                $vendor_id = Input::get('vendor_id');
                $query1->where('v.id','=',$vendor_id);  
            }  
        }//ended here
   
        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "s.created_at";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1->orderby($sort_col_name,'desc');
        } else {
            $query1->orderby($sort_col_name,'asc');
        }
		 $query1->where('s.delivery_status','=','Closed');  
		 $query1->where('v.deleted_at','=','N');               
		 $query1->whereRaw('( r.awd IS NULL OR r.awd = "")');

		//$query1->where('rating.awd','!=','s.awb_no');
		
    if(!empty(Input::get('filter_name'))) {
            $query1->where(function($query1) {
                 $query1->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('v.name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('r.desc', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('r.awd', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('b.first_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('b.last_name', 'LIKE', "%".trim(Input::get('filter_name'))."%") 
                        ;
            });
        }		
        
		//dd($query1->toSql());die;
		
        //DB::getPaginator()->setPageName('page_pending');
		$ratings1 = $query1->paginate(10, ['*'], 'page_pending');
		//dd($query1->toSql());
		//print_r($ratings1);
		//exit();
		
		$query = Ratings::leftjoin('vendor as v','rating.vendor_id','=','v.id')
		  ->leftjoin('bikers as b','rating.tech_id','=','b.id')
          ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.name','v.company_name','b.first_name','b.last_name','rating.created_by','rating.created_at','v.deleted_at','v.id as vendor_id','b.id');
        /*$query = DB::table('rating as rating')
                ->leftjoin('vendor as v','rating.vendor_id','=','v.id')
                ->leftjoin('bikers as b','rating.tech_id','=','b.id')
                ->select('v.id','b.id','rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.name','v.company_name','b.first_name','b.last_name','rating.created_by','rating.created_at','v.deleted_at','v.id as vendor_id'); */           
        // Added by gaurav on 27-4-20 for filtering data og manage rating page by start and end date..
        if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('bikers_id')) || !empty(Input::get('vendors_id')) ) {
                    if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                        $start_date = Input::get('start_date');
                        $end_date = Input::get('end_date');
                        
                        $start_time = '00:00:00';
                        $end_time = '23:59:59';

                        $date = new DateTime($start_date);
                        $start_date = $date->format('Y-m-d '. $start_time);
                        $date = new DateTime($end_date);
                        $end_date = $date->format('Y-m-d '. $end_time);
                        $query->whereBetween('rating.created_at', array($start_date,$end_date));
                    } 
                    if(!empty(Input::get('biker_id'))) 
                    {
                        $biker_id = Input::get('biker_id');
                        $query->where('b.id','=',$biker_id); 
                    }
                    if(!empty(Input::get('vendor_id'))) 
                    {
                        $vendor_id = Input::get('vendor_id');
                        $query->where('v.id','=',$vendor_id);  
                    }     
        }//ended here       

        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "rating.created_at";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
		 $query->where('v.deleted_at','=','N');               
        if(!empty(Input::get('filter_name'))) {
            $query->where(function($query) {
                 $query->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
                        ->orWhere('v.name', 'LIKE', "%".Input::get('filter_name')."%")
                        ->orWhere('rating.desc', 'LIKE', "%".Input::get('filter_name')."%")
				        ->orWhere('rating.awd', 'LIKE', "%".Input::get('filter_name')."%")
				        ->orWhere('b.first_name', 'LIKE', "%".Input::get('filter_name')."%")
				        ->orWhere('b.last_name', 'LIKE', "%".Input::get('filter_name')."%") 
						;
            });
        }
		//dd($query->toSql());
		
        //DB::getPaginator()->setPageName('page_completed');
        //Post::paginate(1, ['*'], 'new-page-name');
		$ratings = $query->paginate(10, ['*'], 'page_completed');
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
		//export start
		 if(Input::get('report') == 1) {
		 $query1 = DB::table('rating as rating')          
                  ->leftjoin('vendor as v','rating.vendor_id','=','v.id')
					->leftjoin('bikers as b','rating.tech_id','=','b.id')
                        ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.company_name','v.name','b.first_name','b.last_name','v.deleted_at')
						->where('v.deleted_at','=','N')
				  ->orderBy('rating.id','DESC')
				  ->get();
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','RATINGS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Client Name','Company Name', 'Company Rating', 'Technician Rating', 'Technician Name', 'Ticket No', 'Remark'));
			 foreach ($query1 as $line) { 
                $data = array(
                    'client_name' => $line->name,
                    'company_name' => $line->company_name,
                    'company_rating' => $line->app,
                    'technician_rating' => $line->technician,
                    'technician_name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'ticket_no' => $line->awd,
                    'description' => $line->desc
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
			    ob_end_clean();

            $csv->output('ratings_report.csv');
            return;
		}
		$user_id = Auth::user()->id;
		$rid = Auth::user()->role_id;
		//end start
        return view('ratings.indexnew',['rid'=>$rid])->withRatings($ratings)->withRatings1($ratings1)->withFilter($filter)->withBikers($bikers)->withVendors($vendors);
		//return view('ratings.indexnew', compact('ratings','ratings1','filter','rid'));

    }

    // Added by gaurav on 7-4-20 for showing cities according to the states.
    /*public function tableview(Request $request)
    {
        $startdate = $request->startdate;
        $enddate = $request->enddate;
        $biker_id = $request->biker_id;
        $vendor_id = $request->vendor_id;        
        // var_dump($startdate); var_dump($enddate); var_dump($biker_id); var_dump($vendor_id);
       
        // After getting a particular state name, sending all the city name in dropdown box
        // $cities = DB::table('states_cities as sc')
        //         ->leftjoin('state as s','sc.state_code','=','s.id')
        //         ->select('sc.city_name','sc.state_code')
        //         ->get();

        // $query1 = DB::table('shipment as s')  
        //         ->leftjoin('vendor as v','s.vendor_id','=','v.id')
        //         ->leftjoin('bikers as b','s.biker_id','=','b.id')
        //         ->leftjoin('rating as r','r.awd','=','s.awb_no')
        //         ->select('s.awb_no','s.delivery_status','s.created_at','s.updated_at','v.company_name','v.name','v.id','b.first_name','b.last_name','b.id as biker_id','v.deleted_at')->get();

        $query = Ratings::leftjoin('vendor as v','rating.vendor_id','=','v.id')
          ->leftjoin('bikers as b','rating.tech_id','=','b.id')
          ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.name','v.company_name','b.first_name','b.last_name','rating.created_by','rating.created_at','v.deleted_at','v.id as vendor_id','b.id')->where(function($query) use ($request) {
            if($s = $request->startdate) {
                // var_dump($s);
                $s_date = Carbon::parse($s)->format("Y-m-d");
                $query->whereDate("rating.created_at", ">=", $s_date);
            }
            if($e = $request->enddate) {
                // var_dump($e);
                $e_date = Carbon::parse($e)->format("Y-m-d");
                $query->whereDate("rating.created_at", "<=", $e_date);
            }
            if($biker_id = $request->biker_id) {
                // var_dump($biker_id);
                $query->where('b.id','=', $biker_id);
            }
            if($vendor_id = $request->vendor_id) {
                // var_dump($vendor_id);
                $query->where('v.id','=', $vendor_id);  
            }
        })->paginate(10);*/

        /*$query = Ratings::leftjoin('vendor as v','rating.vendor_id','=','v.id')
          ->leftjoin('bikers as b','rating.tech_id','=','b.id')
          ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.name','v.company_name','b.first_name','b.last_name','rating.created_by','rating.created_at','v.deleted_at','v.id as vendor_id','b.id')->get();  
        
        // Added by gaurav on 27-4-20 for filtering data og manage rating page by start and end date..
        // if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('bikers_id')) || !empty(Input::get('vendors_id')) ) {
        // if((isset($startdate)) && (isset($enddate)) || (isset($biker_id)) || (isset($vendor_id)) ) {
        if( $request->startdate && $request->enddate || $request->biker_id || $request->vendor_id )
        {
            // var_dump("hello if");
                if((isset($startdate)) && (isset($enddate))) {
                    $start_date = $request->startdate;
                    $end_date = $request->enddate;
                    
                    $start_time = '00:00:00';
                    $end_time = '23:59:59';

                    $date = new DateTime($start_date);
                    $start_date = $date->format('Y-m-d '. $start_time);
                    $date = new DateTime($end_date);
                    $end_date = $date->format('Y-m-d '. $end_time);
                    $query->where('rating.created_at', '>=', $start_date)->where('rating.created_at', '<=', $end_date);
                    // $query->whereBetween('rating.created_at', array($start_date,$end_date));
                } 
                if((isset($biker_id))) 
                {
                    // $biker_id = $biker_id;
                    var_dump($biker_id);
                    $query->where('b.id','=', $biker_id); 
                }
                if((isset($vendor_id))) 
                {
                    // $vendor_id = $vendor_id;
                    var_dump($vendor_id);
                    $query->where('v.id','=', $vendor_id);  
                }     
        }//ended here*/
        
        //$ratings = $query->paginate(10, ['*'], 'page_completed');
        //$ratings1 = $query1->paginate(10, ['*'], 'page_pending');
        
        //$ratings1 = $query1;
        /*$ratings = $query;

        $data = ['$ratings'=> $query];
        //$data = ['$ratings'=> $query, '$ratings1'=> $query1];
        return response()->json($data);
        
    }*/

	    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
		$bikers = DB::table('bikers')->orderBy('first_name','asc')->get();
		$ships = DB::table('shipment')->orderBy('id','desc')->get();
		$vendors = DB::table('vendor')->orderBy('company_name','asc')->get();
	    return view('ratings.create')->withBikers($bikers)->withVendors($vendors)->withShips($ships);
    }
	
 public function create1($cname,$tno,$vid)
    {
		$bikers = DB::table('bikers')->orderBy('first_name','asc')->get();
		$ships = DB::table('shipment')->where('awb_no','=',$tno)->orderBy('id','desc')->get();
		$vendors = DB::table('vendor')->orderBy('company_name','asc')->get();
	    return view('ratings.create',['cname'=>$cname,'tno'=>$tno,'vid'=>$vid])->withBikers($bikers)->withVendors($vendors)->withShips($ships);
    }
	
	public function graph()
    {
		$bikers = DB::table('bikers')->orderBy('first_name','asc')->where('deleted_at','=',NULL)->get();
		
	    return view('ratings.graph')->withBikers($bikers);
    }

public function ajax()
    {
		$bikers = DB::table('bikers')->orderBy('first_name','asc')->get();
		$ships = DB::table('shipment')->orderBy('id','desc')->get();
		$vendors = DB::table('vendor')->orderBy('company_name','asc')->get();

    return view('ratings.ajax')->withBikers($bikers)->withVendors($vendors)->withShips($ships);
    }
	
	
	
	   public function showgraph(Request $request)
    {
	   $input = $request->all();
	   $biker_id =  $input['biker_id'];
		$sdate = Carbon::parse($request->input('start_date'));
		$edate = Carbon::parse($request->input('end_date'));
		
		//date query start
		$start_time = '00:00:00';
        $end_time = '23:59:59';
		$date = new DateTime($input['start_date']);
        $start_date = $date->format('Y-m-d '.$start_time);
        $date = new DateTime($input['end_date']);
        $end_date = $date->format('Y-m-d '.$end_time);
		// $res = DB::table('rating')
  //       ->whereBetween('created_at',array($start_date,$end_date))
  //       ->get();
		//print_r($res);
		//end

        $res = DB::table('bikers')
        ->where('id','=',$biker_id)
        ->first();
        $resn = count($res);
        $technician_name = '';
        if($resn!=0)
        {
            $technician_name = $res->first_name.' '.$res->last_name;
        }
		
		//$sdt = "'".substr($sdate,0,10)."'";  
		
		$string = "";
		
		$count = $sdate->diffInDays($edate);
		$string1 = "";
		$string2 = "";
		for($i=0;$i<=$count;$i++){
			$dt = Carbon::parse($request->input('start_date'));
			$dt1 = Carbon::parse($request->input('start_date'));
			$results[$i] = $sdate->addDays($i);
			
			$sdate = $dt;
			$uu = substr($sdate->addDays($i),0,10);
			$rr = Ratings::where('cdate', '=', $uu)->where('tech_id','=',$biker_id)->first();
			$n = count($rr);
			if($n != 0){
				$string1 .= $rr->app.",";
				$string2 .= $rr->technician.",";
			}else{
				$string1 .= "0,";
				$string2 .= "0,";
			}
			$temp[$i] = substr($sdate->addDays($i),0,10);
			$sdate = $dt1;
			$string .= "'".substr($sdate->addDays($i),0,10)."',";
		}
		$stringx = substr($string, 0, -1);
		$stringy = substr($string1, 0, -1);
		$stringy1 = substr($string2, 0, -1);
		
		
		 return view('ratings.showgraph',['string'=>$stringx,'stringy'=>$stringy,'stringz'=>$stringy1,'technicianname'=>$technician_name]);
	}
	
	   public function store(Request $request)
    {
	   $input = $request->all();
	    $user_id = Auth::user()->id;
		$users = DB::table('users')
                        ->select('*')
                        ->where('users.id','=',$user_id)
                        ->first();
		$uname = "Desktop - ".$users->first_name." ".$users->last_name;				
		if(!empty($input['vid1'])){
		$vendor_id = $input['vid1'];
		}else{
		$vendor_id = $input['vendor_id'];
		}
		$rating1 = $input['rating1'];
		$rating2 = $input['rating2'];
		$ship_id =  $input['ship_id'];
		$biker_id =  $input['biker_id'];
		$desc =  $input['desc'];
		$today = Carbon::today();
		$today1 = substr($today,0,10);


       // echo $today = $date->format('Y-m-d');
		 $rating = Ratings::create([

            'vendor_id' => $vendor_id,
            'app' => $input['rating1'],
            'technician' => $input['rating2'],
            'tech_id' => $input['biker_id'],
            'awd' => $input['ship_id'],
			'desc'=> $input['desc'],
			'created_by'=> $uname,
			'cdate'=>$today1
            ]);
		 $request->session()->flash('success', 'Ratings added successfully !');
		 return redirect("ratings/indexnew/");
	}

	public function show($id) {
        $rating = Ratings::findOrFail($id);
		//dd($amc);
		$tid = $rating->tech_id;
		$bikers = DB::table('bikers')
                     ->where('id', '=', $tid)
                     ->get();

		$vid = $rating->vendor_id;
		$vendors = DB::table('vendor')
                     ->where('id', '=', $vid)
                     ->get();


        
        return view('ratings.show')->withRating($rating)->withBikers($bikers)->withVendors($vendors);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
	    $rating = Ratings::findOrFail($id);
      	$vid = $rating->vendor_id;
		$bid = $rating->tech_id;
		//$bikers = DB::table('bikers')->orderBy('first_name','asc')->get();
		$bikers = DB::table('shipment as sh')
		    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                ->select('biker.*')
                ->where('sh.vendor_id','=',$vid)
				->groupBy('sh.biker_id')
                ->orderBy('id', 'DESC')
                ->get();
	
		//$ships = DB::table('shipment')->orderBy('id','desc')->get();
		$ships = DB::table('shipment as sh')
		    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                ->select('sh.*')
                ->where('sh.vendor_id','=',$vid)
				->where('sh.biker_id','=',$bid)
				->groupBy('sh.biker_id')
                ->orderBy('id', 'DESC')
                ->get();
		$vendors = DB::table('vendor')->orderBy('company_name','asc')->get();

        return view('ratings.edit')->withRating($rating)->withBikers($bikers)->withVendors($vendors)->withShips($ships);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
		$rating = Ratings::findOrFail($id);
        $input = $request->all();
        
	   $rating->fill($input)->save();
       $request->session()->flash('success', 'Rating updated successfully.');
       return redirect('ratings/');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++){
            $ratings = ratings::destroy($ids[$i]);
        }
       session()->flash('success', 'Rating deleted successfully.');
       return redirect('ratings/');
    }	
	
	public function fetchtechname(){
		  if (Request::ajax())
        	{
			$vid = Request::get('tid');
			$result = DB::table('shipment')
                ->select('*')
                ->where('vendor_id','=',$vid)
                ->orderBy('id', 'DESC')
                ->get();
	
						//print_r($result);exit();
			$data = ['result' => $result];
			return response()->json($data);
			}
        }

 public function ajax1(Request $request)
    {
           // $tid = Request::get('tid');
		   $input = $request->all();
		   $vendor_id = $input['tid'];
           //return response()->json(['success' => '0']);
		   $result = DB::table('shipment')
                ->select('*')
                ->where('vendor_id','=',$vendor_id)
                ->orderBy('id', 'DESC')
                ->get();
	
						//print_r($result);exit();
			$data = ['result' => $result];
			return response()->json($data);
		
	}

 public function ajax2()
    {
          // if (Request::ajax())
          //{
		  //echo "in"; 
		  //exit();
		   $vendor_id = Input::get('tid');
		   
		   $result = DB::table('shipment as sh')
		    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                ->select('biker.*')
                ->where('sh.vendor_id','=',$vendor_id)
				->groupBy('sh.biker_id')
                ->orderBy('id', 'DESC')
                ->get();
	
						//print_r($result);exit();
			//$data = ['result' => $result];
			$msg = '<select name="biker_id" class="form-control" onchange="calltid1(this.value);"><option value="">Please Select</option>';
			foreach($result as $b)
			{
			$bid = $b->id;
			$fname = $b->first_name;
			$lname = $b->last_name;
			$msg .= '<option value='.$bid.'>'.$fname.'&nbsp;'.$lname.'</option>';
			}
			$msg .='</select>';
			
			return response()->json(array('msg'=>$msg),200);
			//}
		
	}

	   public function getmsg(){
		   $vendor_id = Input::get('vid');
		   $biker_id = Input::get('bid');
		   
		   $result = DB::table('shipment as sh')
		    ->leftJoin('bikers as biker','biker.id','=','sh.biker_id')
                ->select('sh.*')
                ->where('sh.vendor_id','=',$vendor_id)
                ->where('sh.biker_id','=',$biker_id)
				->groupBy('sh.biker_id')
                ->orderBy('id', 'DESC')
                ->get();
	
						//print_r($result);exit();
			//$data = ['result' => $result];
			$msg = '<select name="ship_id" class="form-control"><option value="">Please Select</option>';
			foreach($result as $b)
			{
			$awb_no = $b->awb_no;
			$msg .= '<option value='.$awb_no.'>'.$awb_no.'</option>';
			}
			$msg .='</select>';
			
			return response()->json(array('msg'=>$msg),200);
   }
//mehul 30dec2019
public function cronjobs_badratingsemails()
{
  
  //first check if daily service report is enabled 
  $send_daily_report = false;
  $send_daily_report_emailto = '';
  $site_settings = DB::table('site_settings')
                        ->select('*')
                        ->get();
  $settings_arr = array();
  if($site_settings)
  {
    foreach($site_settings as $val)
    {
      $settings_str = urldecode($val->settings);
      $settings_arr = unserialize($settings_str);
    }
  }

  if(isset($settings_arr['bad_rating_email'])) 
    { 
      if($settings_arr['bad_rating_email']=='1') 
        { 
          $send_daily_report = true;
          $send_daily_report_emailto = $settings_arr['bad_rating_email_to'];
        } 
    }
  //first check if daily service report is enabled

  if($send_daily_report && ($send_daily_report_emailto != ''))
  {
    
    $now = new DateTime('now');
    // Create a date interval string to go back to the first day of the previous month
    $int = sprintf('P1M%dD', $now->format('j')-1);
    // Get the first day of the previous month as DateTime
    $fdopm = $now->sub(new DateInterval($int));
    // Verify it works
    $currentMonth = $fdopm->format('m'); 

    $badratings = DB::table('rating as rating')          
            ->leftjoin('vendor as v','rating.vendor_id','=','v.id')
            ->leftjoin('bikers as b','rating.tech_id','=','b.id')
            ->select('rating.id','rating.app','rating.technician','rating.desc','rating.awd','v.company_name','v.name','b.first_name','b.last_name','v.deleted_at')
            ->where('v.deleted_at','=','N')
            ->where('technician','<','3')
            ->whereRaw('MONTH(cdate) = ?',[$currentMonth])
            ->orderBy('rating.id','DESC')
            ->get();
            
//echo "<pre>"; print_r($badratings); die();
  
  $filename = "bad_ratings_Report_".date("d-m-Y").".csv";
  $filepath = public_path()."/uploads/".$filename;
  $company_name = Config::get('app.companyname');
  $company_email = Config::get('app.companyemail');
  $ticketprefix = Config::get('app.ticketprefix');
  if($company_name=='') {$company_name = 'Apniamc';}

   //$csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
        $csv = \League\Csv\Writer::createFromPath($filepath, "w");
             $csv->insertOne(array(' ','Technician Bad Ratings REPORT For The Month Of - '.$fdopm->format('F Y')));
            $csv->insertOne(array());

        if($badratings)
        {

        $csv->insertOne(array('Client Name','Company Name','Company Rating', 'Technician Rating', 'Technician Name','Ticket No','Remark'));

        

       foreach ($badratings as $line) 
       { 

       $technician_name = 'No Technician Assigned';
       
            $data = array(
                'client_name' => $line->name,
                'company_name' => $line->company_name,
                'company_rating' => $line->app,
                'technician_rating' => $line->technician,
                'technician_name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                'ticket_no' => $line->awd,
                'description' => $line->desc
            );

            $line = (array) $data;
            $csv->insertOne($line);
        
        }
      }
      else
      {
        
        $csv->insertOne(array(' ',' NO RECORD FOUND'));
        
      }
        

        try{ 
        Mail::send('emails.bad_rating_report', [], function($message) use($send_daily_report_emailto,$company_name,$company_email, $filepath)
        {
            $message->to($send_daily_report_emailto)
            //$message->to('mehul.mukesoft@gmail.com')
                    ->bcc('mehul.mukesoft@gmail.com')
                    ->from($company_email,$company_name)
                    ->subject('Technician Bad Ratings Report');
            $message->attach($filepath);
        });
          
        } catch (\Exception $ex) { 
            echo "Mail not sent......";
            return "We've got errors!";
            exit;
          } 
        
    echo 'Mail sent';
}
else
{
  echo 'Technician Bad Ratings Report not set';
}

die;
}
//mehul 30dec2019	
}
