<?php

namespace App\Http\Controllers\ProductSerialNo;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Products;
use App\SerialEntry;
use Illuminate\Support\Str;
use App\Models\ProductSerial; // Assuming this is your serial model
// use Illuminate\Support\Carbon;
use Carbon\Carbon;



class SerialController extends Controller
{

    public function index()
    {
        $products = Products::all(); // Load all products
        return view('ProductSerialNo.serial-entry', compact('products'));
    }

    
    // public function store(Request $request)
    // {
    // $entries = $request->input('entries');

    // foreach ($entries as $entry) {
    //     DB::table('serial_entries')->insert([
    //         'brand' => $entry['brand'],
    //         'product' => $entry['product'],
    //         'serial_no' => $entry['serial'],
    //         'imei_no' => $entry['imei'],
    //         'location' => $entry['location'],
    //         'created_at' => Carbon::now(),
    //         'updated_at' => Carbon::now(),
    //     ]);
    // }

    // return redirect()->back()->with('success', 'Serial entries saved successfully!');
    // }
    
// public function store(Request $request)
// {
//     $brand = $request->brand;
//     $product = $request->product;
//     $imei = $request->imei_no;
//     $location = $request->location;

//     // Get the product short code (e.g., Laptop => LP)
//     $productShort = strtoupper(substr($product, 0, 2));

//     // Count total serials generated so far (no repeat)
//     $total = SerialEntry::count() + 1;

//     // Format the serial number
//     $serialFormatted = 'Mk-' . $productShort . '-' . str_pad($total, 4, '0', STR_PAD_LEFT) . '-' . date('m') . '-' . date('y');

//     // Save to database
//     SerialEntry::create([
//         'brand' => $brand,
//         'product' => $product,
//         'serial_no' => $serialFormatted,
//         'imei_no' => $imei,
//         'location' => $location,
//                'created_at' => Carbon::now(),
//             'updated_at' => Carbon::now(),
//     ]);

//     return redirect()->back()->with('success', 'Serial Entry Saved Successfully');
// }


    public function store(Request $request)
    {
        $entries = $request->input('entries');

        $total = SerialEntry::count(); // get current serial count to start from

        foreach ($entries as $entry) {
            $brand = $entry['brand'];
            $product = $entry['product'];
            $imei = $entry['imei'];
            $location = $entry['location'];

            // Generate serial
            $productShort = strtoupper(substr($product, 0, 2));
            $total++; // increment for each new record
            // $serialFormatted = 'MK-' . $productShort . '-' . .$location. . str_pad($total, 4, '0', STR_PAD_LEFT) . '-' . date('m') . '-' . date('y');
            
            $serialFormatted = 'MK-' . $productShort . '-' . strtoupper(substr($location, 0, 2)) . '-' . str_pad($total, 4, '0', STR_PAD_LEFT) . '-' . date('m') . '-' . date('y');


            SerialEntry::create([
                'brand' => $brand,
                'product' => $product,
                'serial_no' => $serialFormatted,
                'imei_no' => $imei,
                'location' => $location,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }

        return redirect()->back()->with('success', 'Generated Successfully!');
    }

    public function listData(Request $request)
    {
        $query = DB::table('serial_entries');

        if ($request->has('search') && $request->input('search') !== '') {
            $search = $request->input('search');
            $query->where(function ($q) use ($search) {
                $q->where('brand', 'like', "%$search%")
                  ->orWhere('product', 'like', "%$search%")
                  ->orWhere('serial_no', 'like', "%$search%")
                  ->orWhere('imei_no', 'like', "%$search%");
            });
        }

        // Must call `select()` before `paginate()` to return a Paginator
        $entries = $query->select('*')->orderBy('id', 'desc')->paginate(9);

        return view('ProductSerialNo.serial-entry-list', compact('entries'));
    }


    // public function listData(Request $request)
    // {
    //     $query = DB::table('serial_entries');

    //     if ($request->has('search') && $request->search != '') {
    //         $search = $request->search;
    //         $query->where(function ($q) use ($search) {
    //             $q->where('brand', 'like', "%$search%")
    //             ->orWhere('product', 'like', "%$search%")
    //             ->orWhere('serial_no', 'like', "%$search%")
    //             ->orWhere('imei_no', 'like', "%$search%");
    //         });
    //     }

    //     $entries = $query->get();

    //     return view('ProductSerialNo.serial-entry-list', compact('entries'));
    // }


    
    public function edit($id)
    {
        $entry = DB::table('serial_entries')->where('id', $id)->first();
        $products = Products::all(); // Load all products

        if (!$entry) {
            abort(404);
        }

        return view('ProductSerialNo.serial-entry-edit', compact('entry','products'));
    }



    // public function update(Request $request, $id)
    // {
    //     $brand = $request->input('brand');
    //     $product = $request->input('product');
    //     $imei = $request->input('imei_no');
    //     $location = $request->input('location');

    //     // Recalculate serial number with updated data
    //     $productShort = strtoupper(substr($product, 0, 2));
    //     $serialFormatted = 'MK-' . $productShort . '-' . strtoupper(substr($location, 0, 2)) . '-' . str_pad($id, 4, '0', STR_PAD_LEFT) . '-' . date('m') . '-' . date('y');


    //     DB::table('serial_entries')->where('id', $id)->update([
    //         'brand' => $request->input('brand'),
    //         'product' => $request->input('product'),
    //         'serial_no' => $request->input('serial_no'),
    //         'imei_no' => $request->input('imei_no'),
    //         'location' => $request->input('location'),
    //         'updated_at' => Carbon::now(),
    //     ]);

    //     return redirect()->route('product.serialEntryList')->with('success', 'Entry updated successfully!');
    // }


    public function update(Request $request, $id)
    {
        $brand = $request->input('brand');
        $product = $request->input('product');
        $imei = $request->input('imei_no');
        $location = $request->input('location');

        // Recalculate serial number with updated data
        $productShort = strtoupper(substr($product, 0, 2));
        $serialFormatted = 'MK-' . $productShort . '-' . strtoupper(substr($location, 0, 2)) . '-' . str_pad($id, 4, '0', STR_PAD_LEFT) . '-' . date('m') . '-' . date('y');

        // Save updated data including the new serial number
        DB::table('serial_entries')->where('id', $id)->update([
            'brand' => $brand,
            'product' => $product,
            'serial_no' => $serialFormatted, // ✅ Correct value used here
            'imei_no' => $imei,
            'location' => $location,
            'updated_at' => Carbon::now(),
        ]);

        return redirect()->route('product.serialEntryList')->with('success', 'Entry updated successfully!');
    }





}
