<?php

namespace App\Http\Controllers\Priority;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Permission;
use App\PermissionRole;
use Auth;
use Input;
use Config;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use App\Priority;
use App\VendorShipment;
use App\StatusHistory;
use Illuminate\Support\Facades\Redirect;

class priorityController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',16)
        ->get();

       
        $user_id = Auth::user()->id;
        $urid = Auth::user()->role_id;
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'id';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if (!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=" . Input::get('filter_name');
        }

        $sort_data = array(
            'name',
        );
         $query = DB::table('priority')->where("deleted_at","=","N")->get();


        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "name";
        }

        $today = Carbon::now();
        
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
        //added by ami
        DB::enableQueryLog();

        //export start
        // echo Input::get('filter_name');die();
        $n = 'N';
        $query1tmp1 = DB::table('priority')->whereRaw("deleted_at = 'N'");
        if(!empty(Input::get('filter_name'))) {
            $query1tmp1->whereRaw("(name LIKE '%".(Input::get('filter_name'))."%')");          
        }
        $priority = $query1tmp1->get();

// and then you can get query log

// dd(DB::getQueryLog());

        
        if(Input::get('report') == 1) {
        //$query1tmp = DB::table('bikers')->select('*');
         $query1tmp = DB::table('priority')
                    ->select('*');

        if(!empty(Input::get('filter_name'))) 
        { 
           $membertype = Input::get('filter_name');
           if($membertype=='1')
           {
            $query1tmp->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00" OR deleted_at = "N")');
           }
           else if($membertype=='2')
           {
            $query1tmp->whereRaw('(deleted_at IS NOT NULL OR deleted_at !="" OR deleted_at != "0000-00-00" OR deleted_at = "N")');
           }
         }
         else
         {
            $query1tmp->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00" OR deleted_at = "N")');
         }

         if(!empty(Input::get('filter_name'))) {
            // echo "fghj";die();
                $query1tmp->whereRaw("(name LIKE '%".(Input::get('filter_name'))."%')");          
        }


        if(!empty(Input::get('reportids'))) {
          
            $selectedval = Input::get('reportids');
             $query1tmp->whereRaw("(id IN (".$selectedval.") )");
        }

         if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }
                  

            $query1 =     $query1tmp->get();

// dd(DB::getQueryLog());

            // print_r($query1);die();                  
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','Priority List Report'));
            $csv->insertOne(array());

            $csv->insertOne(array('ID','Name','Value'));
             foreach ($query1 as $line) { 
               

                $data = array(
                    'id' => $line->id,
                    'name' => $line->name,
                    'value' => $line->value
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('priority_report.csv');
            return;
        }


        //ended
        //   $priority = $query->paginate(20);

        // past amcs

         // $priority = DB::table('priority')->where("deleted_at","=","N")->get();
       
        return view('Priority.index')->withpriorities($priority)->withfilter($filter)->withuserpermission($userpermission);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        $serviceenable_value = 0;
        $serviceenable = false;
        $site_settings = DB::table('site_settings')
            ->select('*')
            ->get();
        $settings_arr = array();
        if ($site_settings) {
            foreach ($site_settings as $val) {
                $settings_str = urldecode($val->settings);
                $settings_arr = unserialize($settings_str);
            }
        }

        if (isset($settings_arr['serviceprovider'])) {
            if ($settings_arr['serviceprovider'] == '1') {
                $serviceenable = true;
                $serviceenable_value = $settings_arr['serviceprovider'];
            }
        }

        $states = DB::table('state')->get();
        $service_pros = DB::table('service_providers')
            ->where('deleted_at', '=', 'N')
            ->where('status', '=', 'Active')
            ->orderBy('name', 'asc')
            ->get();
        return view('Priority.create')->withStates($states)->withServiceenable_value($serviceenable_value)->withservice_pros($service_pros);
    }




    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     * @return Response
     */
    public function store(Request $request)
    {

        
            $this->validate($request, [
                'name' => 'required|regex:/^[a-zA-Z]+$/u|max:55',
                'value' => 'required|integer|between:1,100|unique:priority',
                'priority_color' => 'required|regex:/^[a-zA-Z]+$/u|max:55|unique:priority',
                
            ]);
       

        // echo "inn"; die;
        $priorities = new Priority();
        $date = Carbon::now();
        $priorities = $request->name;
        $prioritiesval = $request->value;
        $priorities2 = $request->priority_color;

        $data = array('name' => $priorities, 'created_at' => $date , 'deleted_at'=>'N','value' => $prioritiesval,'priority_color'=> $priorities2);
        // print_r($data);die;
        $store = DB::table('priority')->insert($data);

        $request->session()->flash('success', 'Priority added successfully !!!');

        return Redirect('priority');
    }

    /**
     * Edit the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function edit($id)
    {

        $priorities = DB::table('priority')->select('*')->where('id', $id)->get();

        // $pointer = explode(',', $priorities[0]);

        return view('Priority.edit')->withP($priorities);
    }


    /**
     * Update the specified resource in storage.
     *
     * 
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    //    echo $id;
    //    die();
        $this->validate($request, [
            'name' => 'required|regex:/^[a-zA-Z]+$/u|max:55',
            
             'value' => 'required|integer|between:1,1000|unique:priority,value,'.$id.',id,deleted_at,N',
            
             'priority_color' => 'required|regex:/^[a-zA-Z]+$/u|max:55|unique:priority,priority_color,'.$id.',id,deleted_at,N',
             
           
            
            
        ]);

        $priorities = priority::findOrFail($id);
        $date = Carbon::now();
        $priorities = $request->name;
        $priorities1 = $request->value;
        $priorities2 = $request->priority_color;

        $data = array('name' => $priorities, 'updated_at' => $date,'value'=> $priorities1,'priority_color'=> $priorities2);
        // print_r($data);die;
        $store = DB::table('priority')
            ->where('id', $id)
            ->update($data);

        $request->session()->flash('success', 'Priority updated successfully !!!');
        return redirect('priority');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {


        // echo "dele"; die;

        $ids = explode(',', $id);
        for ($i = 0; $i < count($ids); $i++) {
            DB::table('priority')->where('id', $ids[$i])->update(['deleted_at' => Carbon::now()]);
        }
        session()->flash('success', 'Priority deleted successfully !!!');
        // session()->flash('Success', 'Priority deleted successfully !!!');
        return Redirect('priority');
    }

    public function show($id)
    {

        
        // echo $id;die();
        $serviceenable_value = 0;
        $serviceenable = false;
        $site_settings = DB::table('site_settings')
            ->select('*')
            ->get();
        $settings_arr = array();
        if ($site_settings) {
            foreach ($site_settings as $val) {
                $settings_str = urldecode($val->settings);
                $settings_arr = unserialize($settings_str);
            }
        }

        if (isset($settings_arr['serviceprovider'])) {
            if ($settings_arr['serviceprovider'] == '1') {
                $serviceenable = true;
                $serviceenable_value = $settings_arr['serviceprovider'];
            }
        }


        $priority = DB::table('priority')
            ->select('*')
            ->where("priority.id", '=', $id)
            ->get();
// echo "in"; die;
        return view('Priority.show')->withServiceenable_value($serviceenable_value)->withpriorities($priority[0])->withservice_pros($id);
    }

    
}
