<?php

namespace App\Http\Controllers\ManageVendorAddress;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB; 

use Validator; // Add this at the top if not already

use Illuminate\Http\Request;
use App\ManageVendorAddress;
use App\Vendor;


class ManageVendorAddressController extends Controller
{


public function indexByVendor($vendor_id)
{
    $addresses = ManageVendorAddress::where('vendor_id', $vendor_id)->get();

    // Get vendor including soft-deleted ones
    $vendor = Vendor::withTrashed()->find($vendor_id);

    return view('ManageVendorAddress.index', compact('addresses', 'vendor'));
}

public function create($vendor_id)
{
    $vendor = Vendor::withTrashed()->findOrFail($vendor_id);

    // Use the correct table name 'state' instead of 'states'
    $states = DB::table('state')->get();

    return view('ManageVendorAddress.create', compact('vendor', 'states'));
}

public function store(Request $request)
{
$validator = Validator::make($request->all(), [
    'vendor_id' => 'required|exists:vendor,id',
    'title_address' => 'required|string|max:255', // ✅ added line
    'address_line1' => 'required|string|max:255',
    'address_line2' => 'string|max:255',
    'landmark' => 'string|max:255',
    'city' => 'required|string|max:100',
    'state' => 'required|string|max:100',
    'country' => 'required|string|max:100',
    'pin_code' => 'string|max:10',
    'contact_number' => 'required|string|max:15',
]);

    if ($validator->fails()) {
        return redirect()->back()
            ->withErrors($validator)
            ->withInput();
    }

    ManageVendorAddress::create($request->all());

    return redirect()->route('vendormultipleaddresses.byvendor', $request->vendor_id)
        ->with('success', 'Address added successfully.');
}


public function edit($vendor_id, $address_id)
{
    $vendor = Vendor::withTrashed()->findOrFail($vendor_id);
    $address = ManageVendorAddress::findOrFail($address_id);
    $states = DB::table('state')->get();

    return view('ManageVendorAddress.edit', compact('vendor', 'address', 'states'));
}
public function update(Request $request, $id)
{
    try {
        $validator = Validator::make($request->all(), [
            'title_address'   => 'required|string|max:255',
            'address_line1'   => 'required|string|max:255',
            'address_line2'   => 'sometimes|string|max:255',
            'landmark'        => 'sometimes|string|max:255',
            'city'            => 'required|string|max:100',
            'state'           => 'required|string|max:100',
            'country'         => 'required|string|max:100',
            'pin_code'        => 'sometimes|string|max:10',
            'contact_number'  => 'required|string|max:15',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $address = ManageVendorAddress::findOrFail($id);

        $address->update([
            'title_address'   => $request->title_address,
            'address_line1'   => $request->address_line1,
            'address_line2'   => $request->address_line2,
            'landmark'        => $request->landmark,
            'city'            => $request->city,
            'state'           => $request->state,
            'country'         => $request->country,
            'pin_code'        => $request->pin_code,
            'contact_number'  => $request->contact_number,
        ]);

        return redirect()
            ->route('vendormultipleaddresses.byvendor', $address->vendor_id)
            ->with('success', 'Address updated successfully.');
    } catch (\Exception $e) {
        // Show the real error in JSON for debugging
        return response()->json(['error' => $e->getMessage()], 500);
    }
}


public function showImportPage($vendor_id)
{
    $vendor = Vendor::withTrashed()->findOrFail($vendor_id);
    return view('ManageVendorAddress.import', compact('vendor'));
}

public function csvsampledownload()
{
    $headers = array(
        'Content-Type' => 'text/csv',
    );
    $path = storage_path('uploads/Bulk_Import_Client/Manage_Vendor_Address_Bulk_Import.csv');
    return response()->download($path, 'Manage_Client_Bulk_Import.csv', $headers);
}

public function importCsv(Request $request, $vendor_id)
{
    // ✅ Use controller's validate method 
    $this->validate($request, [
        'import_file' => 'required|mimes:csv,txt|max:2048',
    ]);

    $file = $request->file('import_file');
    $path = $file->getRealPath();
    $data = array_map('str_getcsv', file($path));
    $header = array_map('trim', array_shift($data));

    foreach ($data as $row) {
        $rowData = array_combine($header, $row);
        $rowData['vendor_id'] = $vendor_id;

        $validator = Validator::make($rowData, [
            'vendor_id' => 'required|exists:vendor,id',
            'title_address' => 'required|string|max:255',
            'address_line1' => 'required|string|max:255',
            'address_line2' =>'string|max:255',
            'landmark' =>'string|max:255',
            'city' => 'required|string|max:100',
            'state' => 'required|string|max:100',
            'country' => 'required|string|max:100',
            'pin_code' =>'string|max:255',
            'contact_number' => 'required|string|max:15',
        ]);

        if ($validator->fails()) continue;

        ManageVendorAddress::create($rowData);
    }

    return redirect()->route('vendormultipleaddresses.byvendor', $vendor_id)
                     ->with('success', 'Addresses imported successfully!');
}


}
// app/Http/Controllers/ManageVendorAddress/ManageVendorAddressController.php





