<?php

namespace App\Http\Controllers\ManageSkill;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Skill;
use DB;
use Auth;

class ManageSkillController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $skills = skill::all();
        return view('manage_skill.index', compact('skills'));

    }


    public function create()
    {
        return view('manage_skill.create');
    }

public function store(Request $request)
    {

        // Validate input
        $this->validate($request, [
            'name' => 'required|regex:/^[\pL\s\-\']+$/u',
        ]);

        // Clean and store
        $input = $request->only('name');
        $input['name'] = trim($input['name']);
        Skill::create($input);

        // Flash success and redirect
        $request->session()->flash('success', 'Skill added successfully.');
        return redirect()->route('manageskill.index');
    }

    public function edit($id)
    {
        $skill = Skill::findOrFail($id);
        return view('manage_skill.edit', compact('skill'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|regex:/^[\pL\s\-\']+$/u',
        ]);

        $skill = Skill::findOrFail($id);
        $input = $request->all();
        $input['name'] = ucwords(strtolower($input['name']));

        $skill->fill($input)->save();

        $request->session()->flash('success', 'Skill updated successfully.');
        return redirect()->route('manageskill.index');
    }
    public function bulkDelete(Request $request)
    {
        $skillIds = $request->input('skill_ids', []);

        if (empty($skillIds)) {
            return response()->json(['message' => 'No skills selected'], 400);
        }

        Skill::whereIn('id', $skillIds)->delete();

        return response()->json(['message' => 'Selected skills deleted successfully.']);
    }



}
// app/Http/Controllers/ManageSkill/ManageSkillController.php
