<?php

namespace App\Http\Controllers\ManageProduct;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Products;
use Mail;
use DB;
use Input;
use Config;
use Auth;

class ManageProductController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
     public function index()
    {
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',19)
        ->get();
        // echo "<pre>"; print_r($userpermission); die();

        if (!empty(Input::get('sort'))) {
                $sort = Input::get('sort');
        } else {
                $sort = 'products.product_name';
        }
        if (!empty(Input::get('order'))) {
                $order = Input::get('order');
        } else {
                $order = 'ASC';
        }

        if ($order == 'ASC') {
                $url = '?order=DESC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
                $url = '?order=ASC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } 

        $sort_data = array(
            'products.product_name',
            'products.product_code'
            );
        

        $query = products::select('*');

            if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "products.product_name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query->orderby($sort_col_name,'desc');
                    } else {
                        $query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        
                        $query->whereRaw("(products.product_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR products.product_code LIKE '%".trim(addslashes(Input::get('filter_name')))."%' )");
                           
                    }

        $products = $query->paginate(10);
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );

            //echo "<pre>"; print_r($products);die;
    	return view('manage_product.index')->withProducts($products)->withFilter($filter)->withUserpermission($userpermission);
    }
    public function create()
    {
    	 return view('manage_product.create');
    }
    public function store(Request $request) 
    {
        $this->validate($request, [
            'product_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'product_code' => 'required|regex:/^[\pLa-zA-Z0-9\s\-\']+$/u',
            'product_desc' => 'required' 
        ]);
        $input = $request->all();

        $input['product_name']=trim($input['product_name']); 
        $input['product_code']=trim($input['product_code']); 
        // Added by gaurav to insert product desc field 
        $input['product_desc']=trim($input['product_desc']);
       // $data['product_name']   = $input['product_name'];
       // $data['product_code'] = $input['product_code'];
        
    //created products in app/products    
        Products::create($input);
        $request->session()->flash('success', 'Product added successfully.');

        return redirect("manageproduct/");
    }

    public function edit($id)
    {
        $products = DB::table('products')
                    ->select('*')
                    ->where('id', '=', $id)
                    ->get();

        return view('manage_product.edit')->withProducts($products[0]);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'product_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'product_code' => 'required|regex:/^[\pL\s\-\']+$/u',
            'product_desc' => 'required' 
        ]);

         
        $input = $request->all();
        $input['product_name'] = ucwords(strtolower($input['product_name']));
        $input['product_code'] = ucwords(strtolower($input['product_code']));
        //   echo "<pre>";
        // print_r($input);
        //  die;
        $product = Products::findOrfail($id);    
        $product->fill($input)->save();
        $request->session()->flash('success', 'Product updated successfully !!!');
        return redirect('manageproduct/?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
    }

      public function destroy($id)
    { 
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++)
        {
            $product = Products::destroy($ids[$i]);
        }
             session()->flash('success', 'Product deleted successfully !!!');
             return redirect('manageproduct/');
    }

    public function release()
{
    $products = Products::orderBy('created_at', 'desc')->get();

    return view('manage_product.product_release', compact('products'));
}
}
?>