<?php

namespace App\Http\Controllers\ManageInventory;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Inventory;
use Mail;
use DB;
use Input;
use Config;

class ManageInventoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
     public function index()
    {
        if (!empty(Input::get('sort'))) {
                $sort = Input::get('sort');
        } else {
                $sort = 'inventory.name';
        }
        if (!empty(Input::get('order'))) {
                $order = Input::get('order');
        } else {
                $order = 'ASC';
        }

        if ($order == 'ASC') {
                $url = '?order=DESC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
                $url = '?order=ASC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } 

        $sort_data = array(
            'inventory.name',
            'inventory.warrenty_period'
            );
        

        $query = inventory::select('*');

            if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "inventory.name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query->orderby($sort_col_name,'desc');
                    } else {
                        $query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        
                        $query->whereRaw("(inventory.name LIKE '%".trim(Input::get('filter_name'))."%' OR inventory.warrenty_period LIKE '%".trim(Input::get('filter_name'))."%' )");
                           
                    }

        $Inventory = $query->paginate(10);
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );

            //echo "<pre>"; print_r($Inventory);die;
    	return view('manage_inventory.index')->withInventory($Inventory)->withFilter($filter);
    }
    public function create()
    {
    	 return view('manage_inventory.create');
    }
    public function store(Request $request) 
    { 
        $this->validate($request, [
            'name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'warrenty_period' => 'required|numeric',
            'description' => 'required',
            'quantity' => 'required|numeric',
        ]);
        $input = $request->all();

        $input['name']=trim($input['name']); 
        $input['warrenty_period']=trim($input['warrenty_period']); 
	$input['description'] = ucwords(strtolower($input['description']));
		
		$fields = array('select_image');
         
        
        $img_dir = "uploads/images/inventory/";
        if (!file_exists($img_dir)) {
            mkdir($img_dir, 0777, true);
        }
        //print_r($fields);
         //$file = $input['select_image']
            
           // $destinationPath = "uploads/images/inventory/";
            //$filename = $file->getClientOriginalName();
            //$upload_success = Input::file('file')->move($img_dir, $filename);
   // echo "<pre>";
       //  print_r($input);
         //die;      
    //created Inventory in app/Inventory    
        Inventory::create($input);
        
        $request->session()->flash('success', 'Inventory added successfully.');

        return redirect("manageinventory/");
    }

    public function edit($id)
    { 
        $inventory = DB::table('inventory')
                    ->select('*')
                    ->where('id', '=', $id)
                    ->get();

        return view('manage_inventory.edit')->withInventory($inventory[0]);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'warrenty_period' => 'required|numeric',
            'description' => 'required',
            'quantity' => 'required|numeric', 
        ]);

         
        $input = $request->all();
        $input['name'] = ucwords(strtolower($input['name']));
        $input['description'] = ucwords(strtolower($input['description']));
        //   echo "<pre>";
        // print_r($input);
        //  die;
        $inventory = Inventory::findOrfail($id);    
        $inventory->fill($input)->save();
        $request->session()->flash('success', 'Product updated successfully !!!');
        return redirect('manageinventory/?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
    }

      public function destroy($id)
    { 
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++)
        {
            $product = Inventory::destroy($ids[$i]);
        }
             session()->flash('success', 'Product deleted successfully !!!');
             return redirect('manageinventory/');
    }
}
?>
