<?php

namespace App\Http\Controllers\ManageInventory;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Inventory;
use Mail;
use DB;
use Input;
use Config;
use Auth;

class ManageInventoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
     public function index()
    {
        // Uncomment this when restriction have to given to superadmin, admin, manager, operation head
        // $userpermission = DB::table('users')
        // ->join('permission_role','permission_role.role_id','=','users.role_id')
        // ->select('*')
        // ->where('users.id',Auth::user()->id)
        // ->where('permission_role.permission_id',1)
        // ->get();
        //  echo "<pre>"; print_r($userpermission); die(); 

        if (!empty(Input::get('sort'))) {
                $sort = Input::get('sort');
        } else {
                $sort = 'inventory.name';
        }
        if (!empty(Input::get('order'))) {
                $order = Input::get('order');
        } else {
                $order = 'ASC';
        }

        if ($order == 'ASC') {
                $url = '?order=DESC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
                $url = '?order=ASC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } 

        $sort_data = array(
            'inventory.name',
            'inventory.warrenty_period'
            );
        
        // Changes by Gaurav and vicky sir, as because select query was not working.
        $query = inventory::select('*');
        // $query = DB::table('inventory')->paginate();

            if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "inventory.name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        //$query->orderby($sort_col_name,'desc');
                    } else {
                        //$query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        
                        $query->whereRaw("(inventory.name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR inventory.warrenty_period LIKE '%".trim(addslashes(Input::get('filter_name')))."%' )");
                           
                    }
            $Inventory = DB::table('inventory')->paginate();
        //$Inventory = $query->paginate(10);
        //echo "<pre>"; print_r($Inventory); die();
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );

            //echo "<pre>"; print_r($Inventory);die;
    	return view('manage_inventory.index')->withInventory($Inventory)->withFilter($filter);
    }
    public function create()
    {
    	 return view('manage_inventory.create');
    }
    public function store(Request $request) 
    {   
        $this->validate($request, [
            'name' => 'required|regex:/^[\pL\s\-\']+$/u',
            // Adding product code here
            'product_code' => 'required', 
            'warrenty_period' => 'required|numeric',
            'description' => 'required',
            'quantity' => 'required|numeric',
        ]);
        $input = $request->all();
        // echo "<pre>"; print_r($input); die();
        $input['name']=trim($input['name']);
        // Adding product code here
        $input['product_code']=trim($input['product_code']); 
        $input['warrenty_period']=trim($input['warrenty_period']);
        $input['quantity']=trim($input['quantity']); 
	    $input['description']=ucwords(strtolower($input['description']));
		
		$fields = array('select_image');
         
        
        $img_dir = "uploads/images/inventory/";
        if (!file_exists($img_dir)) {
            mkdir($img_dir, 0777, true);
        }
        //print_r($fields);
        //$file = $input['select_image']
            
            // $destinationPath = "uploads/images/inventory/";
            //$filename = $file->getClientOriginalName();
            //$upload_success = Input::file('file')->move($img_dir, $filename);
   // echo "<pre>";
       //  print_r($input);
         //die;      
    //created Inventory in app/Inventory    
        Inventory::create($input);
        
        $request->session()->flash('success', 'Inventory added successfully.');

        return redirect("manageinventory/");
    }

    public function edit($id)
    { 
        $inventory = DB::table('inventory')
                    ->select('*')
                    ->where('id', '=', $id)
                    ->get();

        return view('manage_inventory.edit')->withInventory($inventory[0]);
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|regex:/^[\pL\s\-\']+$/u',
            //Changes to update by adding one fields as product code
            'product_code' => 'required',
            'warrenty_period' => 'required|numeric',
            'description' => 'required',
            'quantity' => 'required|numeric', 
        ]);
        
        //code not working for updating the edit inventory
        // $input = $request->all();
        // $input['name'] = ucwords(strtolower($input['name']));
        // $input['product_code'] = ucwords(strtolower($input['product_code']));
        // $input['warrenty_period'] = ucwords(strtolower($input['warrenty_period']));
        // $input['quantity'] = ucwords(strtolower($input['quantity']));
        // $input['description'] = ucwords(strtolower($input['description']));
        // echo "<pre>"; print_r($id); die();
        
        // changes by gaurav on 3-march-2020 for updating the records..
        $check = DB::Table('inventory')->where('id',$id)->first(); 
                if(!is_null($check)){
                    $result =  DB::Table('inventory')->where('id',$id)->update(
                    array(
                        'name' =>  ucwords(strtolower($request['name'])),
                        'product_code' => ucwords(strtolower($request['product_code'])),
                        'warrenty_period' => ucwords(strtolower($request['warrenty_period'])),
                        'quantity'=> ucwords(strtolower($request['quantity'])),
                        'description'=> ucwords(strtolower($request['description']))
                        )
                    );
                    // return $result = array('msg' => 'Updated successfully !! ', 'success' => true);
                    $request->session()->flash('success', 'Product updated successfully !!!');
                    return redirect('manageinventory/?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
                }
                else{
                    break;
                }

        // $inventory = Inventory::findOrfail($id);    
        // $inventory->fill($input)->save();

        // DB::table('inventory')->where('id', $id)->update($input);

        // echo "<pre>";
        // print_r($input);
        // die();

        // update not working in  manage inventory
        
        // $request->session()->flash('success', 'Product updated successfully !!!');
        // return redirect('manageinventory/?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
        
        // $Inventory = DB::table('inventory')->paginate();
    }

    public function destroy($id)
    {   
        DB::table('inventory')->delete($id);
        // $ids = explode(',', $id);
        //     for($i=0;$i<count($ids);$i++)
        //     {
        //         $product = Inventory::destroy($ids[$i]);
        //     }
        session()->flash('success', 'Product deleted successfully !!!');
        return redirect('manageinventory/');
    }
}
?>
