<?php

namespace App\Http\Controllers\VendorMultipleAddress;

ini_set('max_execution_time', 0);

use App\VendorMultipleAddress;
use App\Vendor;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Mail;
use DB;
use Input;
use Config;
use Auth;

class VendorMultipleAddressController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

// public function index()
// {
//     $userpermission = DB::table('users')
//         ->join('permission_role', 'permission_role.role_id', '=', 'users.role_id')
//         ->select('*')
//         ->where('users.id', Auth::user()->id)
//         ->where('permission_role.permission_id', 1)
//         ->get();

//     $sort = Input::get('sort') ?? 'vendor.name';
//     $order = Input::get('order') ?? 'ASC';

//     $url = '?order=' . ($order === 'ASC' ? 'DESC' : 'ASC');
//     $url .= '&filter_name=' . urlencode(Input::get('filter_name'));

//     $sort_data = [
//         'vendor.company_name',
//         'vendor.name',
//         // 'vendor.primary_address',
//         'vendor.mobile_no',
//         'vendor.landline_no',
//         'vendor.email',
//         'vendor.status',
//         'vendor.plain_password',
//         'vendor.client_type'
//     ];

//     // ✅ Main query - include vendorstatus = 1
//     $query = DB::table('vendor')
//         ->select('*')
//         ->where("deleted_at", "=", 'N')
//         ->where("vendor_address_status", 1); // ✅ Show only multi-location vendors

//     $sort_col_name = in_array($sort, $sort_data) ? $sort : 'vendor.name';
//     $query->orderBy($sort_col_name, $order === 'DESC' ? 'desc' : 'asc');

//     if (!empty(Input::get('filter_name'))) {
//         $filter = trim(addslashes(Input::get('filter_name')));
//         $query->whereRaw("(vendor.company_name LIKE '%$filter%' 
//             OR vendor.name LIKE '%$filter%' 
//             OR vendor.primary_address LIKE '%$filter%' 
//             OR vendor.email LIKE '%$filter%' 
//             OR vendor.status LIKE '%$filter%' 
//             OR vendor.mobile_no LIKE '%$filter%' 
//             OR vendor.landline_no LIKE '%$filter%')");
//     }

//     $vendors = $query->paginate(10);

//     $filter = [
//         'sort' => $sort,
//         'url' => $url,
//         'order' => $order
//     ];

//     // ✅ Export logic
//     if (Input::get('report') == 1) {
//         $query1tmp = DB::table('vendor')
//             ->select('*')
//             ->where('deleted_at', '=', 'N')
//             ->where('vendor_address_status', '=', 1); // ✅ Only multi-location vendors for export

//         if (!empty(Input::get('filter_name'))) {
//             $filter = trim(addslashes(Input::get('filter_name')));
//             $query1tmp->whereRaw("(vendor.company_name LIKE '%$filter%' 
//                 OR vendor.name LIKE '%$filter%' 
//                 OR vendor.primary_address LIKE '%$filter%' 
//                 OR vendor.email LIKE '%$filter%' 
//                 OR vendor.status LIKE '%$filter%' 
//                 OR vendor.mobile_no LIKE '%$filter%' 
//                 OR vendor.landline_no LIKE '%$filter%')");
//         }

//         if (!empty(Input::get('reportids'))) {
//             $selectedval = Input::get('reportids');
//             $query1tmp->whereRaw("(vendor.id IN ($selectedval))");
//         }

//         $query1tmp->orderBy($sort_col_name, $order === 'DESC' ? 'desc' : 'asc');
//         $query1 = $query1tmp->get();

//         $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
//         $csv->insertOne([' ', 'CLIENTS REPORT']);
//         $csv->insertOne([]);

//         $csv->insertOne([
//             'Name', 'Company Name', 'Address1', 'Address2', 'Email', 'Password',
//             'MobileNo', 'MobileNo2', 'LandlineNo', 'Landmark', 'Country', 'State',
//             'City', 'Pincode', 'Status', "Client Type"
//         ]);

//         foreach ($query1 as $line) {
//             switch ($line->client_type) {
//                 case 'C': $c_type_new = 'Normal'; break;
//                 case 'W': $c_type_new = 'Warranty Client'; break;
//                 case 'O': $c_type_new = 'Out of vendor client'; break;
//                 case 'A': $c_type_new = 'AMC Client'; break;
//                 case 'B': $c_type_new = 'Call of Basis Client'; break;
//                 default:  $c_type_new = 'Supplier'; break;
//             }

//             $data = [
//                 'name' => $line->name,
//                 'company_name' => $line->company_name,
//                 'address1' => $line->primary_address,
//                 'address2' => $line->secondary_address,
//                 'email' => $line->email,
//                 'password' => $line->plain_password,
//                 'mobileno' => $line->mobile_no,
//                 'mobile_no2' => $line->mobile_no2,
//                 'landlineno' => $line->landline_no,
//                 'landmark' => $line->landmark,
//                 'country' => $line->country,
//                 'state' => $line->state,
//                 'city' => $line->city,
//                 'pincode' => $line->pin_code,
//                 'status' => $line->status,
//                 'client_type' => $c_type_new
//             ];

//             $csv->insertOne((array)$data);
//         }

//         $csv->output('clients_report.csv'); 
//         die;
//     }

//     return view('vendormultipleaddresses.index')
//         ->withVendors($vendors)
//         ->withFilter($filter)
//         ->withUserpermission($userpermission);
// }
public function index()
{
    $userpermission = DB::table('users')
        ->join('permission_role', 'permission_role.role_id', '=', 'users.role_id')
        ->select('*')
        ->where('users.id', Auth::user()->id)
        ->where('permission_role.permission_id', 1)
        ->get();

    $sort = Input::get('sort') ?? 'vendor.name';
    $order = Input::get('order') ?? 'ASC';

    $url = '?order=' . ($order === 'ASC' ? 'DESC' : 'ASC');
    $url .= '&filter_name=' . urlencode(Input::get('filter_name'));

    $sort_data = [
        'vendor.company_name',
        'vendor.name',
        'vendor.mobile_no',
        'vendor.landline_no',
        'vendor.email',
        'vendor.status',
        'vendor.plain_password',
        'vendor.client_type'
    ];

    // ✅ Main query — includes ALL vendors (removed vendor_address_status filter)
    $query = DB::table('vendor')
        ->select('*')
        ->where("deleted_at", "=", 'N');

    $sort_col_name = in_array($sort, $sort_data) ? $sort : 'vendor.name';
    $query->orderBy($sort_col_name, $order === 'DESC' ? 'desc' : 'asc');

    if (!empty(Input::get('filter_name'))) {
        $filter = trim(addslashes(Input::get('filter_name')));
        $query->whereRaw("(vendor.company_name LIKE '%$filter%' 
            OR vendor.name LIKE '%$filter%' 
            OR vendor.primary_address LIKE '%$filter%' 
            OR vendor.email LIKE '%$filter%' 
            OR vendor.status LIKE '%$filter%' 
            OR vendor.mobile_no LIKE '%$filter%' 
            OR vendor.landline_no LIKE '%$filter%')");
    }

    $vendors = $query->paginate(10);

    $filter = [
        'sort' => $sort,
        'url' => $url,
        'order' => $order
    ];

    // ✅ Export logic — now includes ALL vendors
    if (Input::get('report') == 1) {
        $query1tmp = DB::table('vendor')
            ->select('*')
            ->where('deleted_at', '=', 'N');

        if (!empty(Input::get('filter_name'))) {
            $filter = trim(addslashes(Input::get('filter_name')));
            $query1tmp->whereRaw("(vendor.company_name LIKE '%$filter%' 
                OR vendor.name LIKE '%$filter%' 
                OR vendor.primary_address LIKE '%$filter%' 
                OR vendor.email LIKE '%$filter%' 
                OR vendor.status LIKE '%$filter%' 
                OR vendor.mobile_no LIKE '%$filter%' 
                OR vendor.landline_no LIKE '%$filter%')");
        }

        if (!empty(Input::get('reportids'))) {
            $selectedval = Input::get('reportids');
            $query1tmp->whereRaw("(vendor.id IN ($selectedval))");
        }

        $query1tmp->orderBy($sort_col_name, $order === 'DESC' ? 'desc' : 'asc');
        $query1 = $query1tmp->get();

        $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
        $csv->insertOne([' ', 'CLIENTS REPORT']);
        $csv->insertOne([]);

        $csv->insertOne([
            'Name', 'Company Name', 'Address1', 'Address2', 'Email', 'Password',
            'MobileNo', 'MobileNo2', 'LandlineNo', 'Landmark', 'Country', 'State',
            'City', 'Pincode', 'Status', "Client Type"
        ]);

        foreach ($query1 as $line) {
            switch ($line->client_type) {
                case 'C': $c_type_new = 'Normal'; break;
                case 'W': $c_type_new = 'Warranty Client'; break;
                case 'O': $c_type_new = 'Out of vendor client'; break;
                case 'A': $c_type_new = 'AMC Client'; break;
                case 'B': $c_type_new = 'Call of Basis Client'; break;
                default:  $c_type_new = 'Supplier'; break;
            }

            $data = [
                'name'         => $line->name,
                'company_name' => $line->company_name,
                'address1'     => $line->primary_address,
                'address2'     => $line->secondary_address,
                'email'        => $line->email,
                'password'     => $line->plain_password,
                'mobileno'     => $line->mobile_no,
                'mobile_no2'   => $line->mobile_no2,
                'landlineno'   => $line->landline_no,
                'landmark'     => $line->landmark,
                'country'      => $line->country,
                'state'        => $line->state,
                'city'         => $line->city,
                'pincode'      => $line->pin_code,
                'status'       => $line->status,
                'client_type'  => $c_type_new
            ];

            $csv->insertOne((array)$data);
        }

        $csv->output('clients_report.csv');
        die;
    }

    return view('vendormultipleaddresses.index')
        ->withVendors($vendors)
        ->withFilter($filter)
        ->withUserpermission($userpermission);
}

    /**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
public function create()
{
    $serviceenable_value = 0;
    $serviceenable = false;

    $site_settings = DB::table('site_settings')->select('*')->get();
    $settings_arr = array();

    if ($site_settings) {
        foreach ($site_settings as $val) {
            $settings_str = urldecode($val->settings);
            $settings_arr = unserialize($settings_str);
        }
    }

    if (isset($settings_arr['serviceprovider'])) {
        if ($settings_arr['serviceprovider'] == '1') {
            $serviceenable = true;
            $serviceenable_value = $settings_arr['serviceprovider'];
        }
    }

    $states = DB::table('state')->get();
    $service_pros = DB::table('service_providers')
        ->where('deleted_at', '=', 'N')
        ->where('status', '=', 'Active')
        ->orderBy('name', 'asc')
        ->get();

    return view('vendormultipleaddresses.create')
        ->withStates($states)
        ->withServiceenable_value($serviceenable_value)
        ->withService_pros($service_pros);
}


public function store(Request $request)
{

        // echo "<pre>"; print_r($request->all()); die();
    $serviceenable_value = 0;
    $site_settings = DB::table('site_settings')->select('*')->get();
    $settings_arr = [];

    if ($site_settings) {
        foreach ($site_settings as $val) {
            $settings_str = urldecode($val->settings);
            $settings_arr = unserialize($settings_str);
        }
    }

    if (isset($settings_arr['serviceprovider']) && $settings_arr['serviceprovider'] == '1') {
        $serviceenable_value = $settings_arr['serviceprovider'];
    }

    // ✅ Validation rules
    $rules = [
        'url' => 'regex:/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/',
        'name' => 'required|regex:/^[a-zA-Z\s]+$/u|min:3|max:30',
        'mobile_no' => 'numeric',
        'mobile_no2' => 'numeric',
        'landline_no' => 'numeric',
        'company_name' => 'min:5|max:50',
        'email' => 'required|email',
        // 'primary_address' => 'required|min:10|max:700',
        // 'secondary_address' => 'min:10|max:700',
        // 'city' => 'required|regex:/^[\pL\s\-\']+$/u|min:2|max:50',
        'status' => 'required',
        'client_type' => 'required',
        'project' => 'string|max:100',
    ];


    if ($serviceenable_value == 1) {
        $rules['service_provider_id'] = 'required';
    }

    $this->validate($request, $rules);

    try {
        $vendor_mail = 0;
        $site_settings = DB::table('site_settings')->select('*')->get();
        $settings_arr = [];

        foreach ($site_settings as $val) {
            $settings_str = urldecode($val->settings);
            $settings_arr = unserialize($settings_str);
        }

        if (isset($settings_arr['vendor_client_type']) && $settings_arr['vendor_client_type'] == '1') {
            $vendor_mail = 1;
        }

        $generateKey = function ($length = 10) {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $randomString = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[rand(0, strlen($characters) - 1)];
            }
            return $randomString;
        };

        $input = $request->all();
        $input['project'] = $request->input('project'); // ✅ added field
        $input['company_name'] = ucwords($input['company_name']);
        $input['name'] = ucwords(strtolower($input['name']));

        $data['email'] = $input['email'];
        $data['name'] = $input['name'];
        $data['api_key'] = $generateKey(8) . substr(md5($input['email'].time()), 3, 7);
        $data['secret_key'] = substr(md5($input['name'].time()), 5, 9) . $generateKey(6);
        $data['password'] = substr(md5($input['email'].time()), 5, 10);

        // 🔐 Login URL
        $urlArray = Config::get('app.DOMAIN_NAME');
        $replace_url_string = str_replace("@apniamc.com", ".apniamc.com", $urlArray);
        $client_login_url = 'http://' . $replace_url_string . '/client/loginpage';

        // ✅ Email
        $emailcontent = [
            'email' => $data['email'],
            'password' => $data['password'],
            'name' => $data['name'],
            'client_type' => ($input['client_type'] == "S" ? '1' : '2'),
            'client_login_url' => $client_login_url
        ];

        if ($vendor_mail == 1) {
            Mail::send('emails.vendorwelcome', $emailcontent, function ($message) use ($data) {
                $message->from(Config::get('app.fromemail'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
                $message->to($data['email'])->subject(Config::get('app.companyname') . ' New Customer Registration');
            });
        }

        // ✅ Final Data for DB
        $input['password'] = bcrypt($data['password']);
        $input['api_key'] = $data['api_key'];
        $input['secret_key'] = $data['secret_key'];
        $input['plain_password'] = $data['password'];
        $input['pwd'] = $data['password'];

        
        // ✅ Set vendorstatus to 1 (Multi-location vendor)
        $input['vendor_address_status'] = 1;



        // // ✅ Remove unused fields
        // unset(
        //     $input['primary_address'],
        //     $input['secondary_address'],
        //     $input['landmark'],
        //     $input['city'],
        //     $input['state'],
        //     $input['pin_code']
        // );

        // ✅ File Uploads
        $fields = ['identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5'];
        foreach ($fields as $field) {
            if (!empty($request[$field])) {
                $file = $request->file($field);
                if ($file && $file->isValid()) {
                    $filename = time() . $file->getClientOriginalName();
                    $input[$field] = $filename;
                }
            }
        }

        // ✅ Save
        $vendor = VendorMultipleAddress::create($input);

        // ✅ Upload files
        $img_dir = "uploads/images/vendormultipleaddresses/" . $vendor->id . "/";
        if (!file_exists($img_dir)) {
            mkdir($img_dir, 0777, true);
        }

        foreach ($fields as $field) {
            if (!empty($input[$field])) {
                $file = $request->file($field);
                if ($file && $file->isValid()) {
                    $file->move($img_dir, $input[$field]);
                }
            }
        }

        $request->session()->flash('flash_message', 'Client added successfully !!!');
        return redirect()->route('vendormultipleaddresses.index');

    } catch (\Illuminate\Database\QueryException $e) {
        if ($e->errorInfo[1] == 1062) {
            return 'Client already exists. Please try again !!!';
        }
    }
}


    public function edit($id)
{
    $serviceenable_value = 0;
    $serviceenable = false;

    // Site settings
    $site_settings = DB::table('site_settings')->select('*')->get();
    $settings_arr = [];

    if ($site_settings) {
        foreach ($site_settings as $val) {
            $settings_str = urldecode($val->settings);
            $settings_arr = unserialize($settings_str);
        }
    }

    if (isset($settings_arr['serviceprovider']) && $settings_arr['serviceprovider'] == '1') {
        $serviceenable = true;
        $serviceenable_value = 1;
    }

    $img_dir = "uploads/images/vendor/" . $id . "/";

    // ✅ Fetch vendor data from correct table
    $vendor = DB::table('vendor')->select('*')->where("id", '=', $id)->get();

    $service_pros = DB::table('service_providers')
        ->where('deleted_at', '=', 'N')
        ->where('status', '=', 'Active')
        ->orderBy('name', 'asc')
        ->get();

    $states = DB::table('state')->get();

    return view('vendormultipleaddresses.edit')
        ->withVendor($vendor[0])
        ->withStates($states)
        ->withImgDir($img_dir)
        ->withServiceenable_value($serviceenable_value)
        ->withService_pros($service_pros);
}


public function update(Request $request, $id)
{
$this->validate($request, [
    'url' => 'sometimes|regex:/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/',
    'name' => 'required|regex:/^[a-zA-Z\s]+$/u|min:3|max:30',
    'email' => 'required|email',
    'mobile_no' => 'sometimes|numeric',
    'mobile_no2' => 'sometimes|numeric',
    'landline_no' => 'sometimes|numeric',
    'company_name' => 'sometimes|min:5|max:50',
    'status' => 'required',
    'client_type' => 'required',
    'project' => 'string|max:100', // ✅ added project
]);


    $input = $request->all();

    // Remove unwanted fields that shouldn't go to the DB
    unset($input['_token'], $input['_method']);

    // Format fields
    if (!empty($input['company_name'])) {
        $input['company_name'] = ucwords($input['company_name']);
    }

    if (!empty($input['name'])) {
        $input['name'] = ucwords(strtolower($input['name']));
    }

    // Handle file uploads
    $img_dir = "uploads/images/vendor/" . $id . "/";
    if (!file_exists($img_dir)) {
        mkdir($img_dir, 0777, true);
    }

    $fields = ['identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5'];
    foreach ($fields as $field) {
        if ($request->hasFile($field)) {
            $identity_proof_name = time() . $request->file($field)->getClientOriginalName();
            if ($request->file($field)->isValid()) {
                $request->file($field)->move($img_dir, $identity_proof_name);
                $input[$field] = $identity_proof_name;
            }
        }
    }

    // Optional: remove unused fields if not in form
    unset($input['primary_address'], $input['secondary_address']);

    // Update the vendor record
    DB::table('vendor')
        ->where('id', $id)
        ->update($input);

    $request->session()->flash('flash_message', 'Client details updated successfully !!!');

    return redirect()->route('vendormultipleaddresses.index');
}

    public function destroy($id)
    {
        // $vendor = Vendor::findOrFail($id);
        // $vendor->delete();
        // Added by gaurav on 25-4-20 to update the deleted_at column....so that client will not visible in datatable.. 
        $date = date('Y-m-d H:i:s');
        $ids = explode(',', $id);
        $deleted_at = DB::table('vendor')->whereIN('id', $ids)->update(['deleted_at' => $date]);
        for($i=0;$i<count($ids);$i++){
            $vendor = Vendor::destroy($ids[$i]);
        }
        //Vendor::find(explode(',', $id))->destroy();
return redirect('vendormultipleaddresses')->with('flash_message', 'Client(s) deleted successfully!');

    }


}
// app/Http/Controllers/VendorMultipleAddress/VendorMultipleAddressController.php














// public function store(Request $request) {
//     $site_settings = DB::table('site_settings')->get();
//     $settings_arr = [];

//     foreach ($site_settings as $val) {
//         $settings_str = urldecode($val->settings);
//         $settings_arr = unserialize($settings_str);
//     }

//     $serviceenable_value = $settings_arr['serviceprovider'] ?? 0;
//     $vendor_mail = $settings_arr['vendor_client_type'] ?? 0;

//     $rules = [
//         'url' => 'nullable|regex:/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/',
//         'name' => 'required|regex:/^[a-zA-Z\s]+$/u|min:3|max:30',
//         'mobile_no' => 'nullable|numeric',
//         'mobile_no2' => 'nullable|numeric',
//         'landline_no' => 'nullable|numeric', // ✅ Keep only this
//         'company_name' => 'nullable|min:5|max:50',
//         'email' => 'required|email',
//         'status' => 'required',
//         'client_type' => 'required',
//         'service_provider_id' => $serviceenable_value == 1 ? 'required' : 'nullable'
//     ];

//     $this->validate($request, $rules);

//     $generateKey = function($length = 10) {
//         $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
//         $randomString = '';
//         for ($i = 0; $i < $length; $i++) {
//             $randomString .= $characters[rand(0, strlen($characters) - 1)];
//         }
//         return $randomString;
//     };

//     $input = $request->all();
//     $input['company_name'] = ucwords($input['company_name']);
//     $input['name'] = ucwords(strtolower($input['name']));
//     $input['api_key'] = $generateKey(8) . substr(md5($input['email'] . time()), 3, 7);
//     $input['secret_key'] = substr(md5($input['name'] . time()), 5, 9) . $generateKey(6);
//     $input['plain_password'] = substr(md5($input['email'] . time()), 5, 10);
//     $input['password'] = bcrypt($input['plain_password']);
//     $input['pwd'] = $input['plain_password'];

//     // Optional Email Sending
//     if ($vendor_mail == 1) {
//         $urlArray = Config::get('app.DOMAIN_NAME');
//         $replace_url_string = str_replace("@apniamc.com", ".apniamc.com", $urlArray);
//         $client_login_url = 'http://' . $replace_url_string . '/client/loginpage';

//         $emailcontent = [
//             'email' => $input['email'],
//             'password' => $input['plain_password'],
//             'name' => $input['name'],
//             'client_type' => ($input['client_type'] == "S" ? '1' : '2'),
//             'client_login_url' => $client_login_url
//         ];

//         Mail::send('emails.vendorwelcome', $emailcontent, function ($message) use ($input) {
//             $message->from(Config::get('app.fromemail'), Config::get('app.companyname'));
//             $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
//             $message->to($input['email'])->subject(Config::get('app.companyname') . ' New Customer Registration');
//         });
//     }

//     // File uploads
//     $fields = ['identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5'];
//     foreach ($fields as $field) {
//         if ($request->hasFile($field)) {
//             $file = $request->file($field);
//             if ($file->isValid()) {
//                 $filename = time() . $file->getClientOriginalName();
//                 $input[$field] = $filename;
//             }
//         }
//     }

//     // Save to database
//     $vendor = VendorMultipleAddress::create($input);

//     // Create upload directory
//     $img_dir = public_path("uploads/images/vendor/{$vendor->id}/");
//     if (!file_exists($img_dir)) {
//         mkdir($img_dir, 0777, true);
//     }

//     // Move uploaded files
//     foreach ($fields as $field) {
//         if ($request->hasFile($field)) {
//             $file = $request->file($field);
//             $file->move($img_dir, $input[$field]);
//         }
//     }

//     $request->session()->flash('flash_message', 'Client added successfully!');
//     return redirect()->route('vendormultipleaddresses.index');
// }


