<?php

namespace App\Http\Controllers\Checklist;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\checklist;
use App\Permission;
use App\PermissionRole;
use Auth;
use Input;
use Config;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;

class ChecklistController extends Controller
{
   
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user_id = Auth::user()->id;
        $urid = Auth::user()->role_id;
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'amcs.vendor_id';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }

        $sort_data = array(
            'p.product_name',
        'amcs.atype',
        'amcs.service_timeframe',
            'amcs.terms',
            'amcs.start_date',
            'amcs.end_date',
            'v.company_name'
        );
        //$query = Amcs::select();
        
        $query = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name');
       
        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.company_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
        $today = Carbon::now();
        $query->whereDate('amcs.end_date', '>=', $today);
        if(!empty(Input::get('filter_name'))) {
            $query->where(function($query) {
                //$query->whereDate('amcs.end_date', '>=', $today)
                 $query->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('amcs.terms', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                         ->orWhere('amcs.service_timeframe', 'LIKE', "%".trim(Input::get('filter_name')."%"))
            ->orWhere('amcs.atype', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('p.product_name', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ;
            });
        }
        //$query->orderBy('v.name','ASC');
        //dd($query->toSql());
        
        $amcs = $query->paginate(20);
        
        //past amcs
        $queryx = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name');
       
        
        if (isset($order) && ($order == 'DESC')) {
            $queryx->orderby($sort_col_name,'desc');
        } else {
            $queryx->orderby($sort_col_name,'asc');
        }
        $today1 = Carbon::now();
        $queryx->whereDate('amcs.end_date', '<', $today1);
        if(!empty(Input::get('filter_name'))) {
            $queryx->where(function($queryx) {
                //$query->whereDate('amcs.end_date', '>=', $today)
                 $queryx->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('amcs.terms', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                         ->orWhere('amcs.service_timeframe', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('amcs.atype', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('p.product_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ;
            });
        }
        //$queryx->orderBy('v.name','ASC');

        //dd($query->toSql());
        
        $amcs1 = $queryx->paginate(20);
        //end
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
        //export start
        if(Input::get('report') == 1) {
        
         $query1tmp = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name');

          if(!empty(Input::get('filter_name'))) {
           
                //$query->whereDate('amcs.end_date', '>=', $today)
            //      $query1tmp->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('amcs.terms', 'LIKE', "%".Input::get('filter_name')."%")
            // ->orWhere('amcs.atype', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('p.product_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ;

                 $query1tmp->whereRaw("(v.company_name LIKE '%".trim(Input::get('filter_name'))."%' OR  amcs.terms LIKE '%".trim(Input::get('filter_name'))."%' OR amcs.service_timeframe LIKE '%".trim(Input::get('filter_name'))."%' OR amcs.atype LIKE '%".trim(Input::get('filter_name'))."%' OR p.product_name LIKE '%".trim(Input::get('filter_name'))."%')");
            
        }

       /* if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(amcs.id IN (".$selectedval.") )");
            }

        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.company_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }
*/
    $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','TECHNICIANS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Name', 'Email', 'Mobile No','Address1','Address2','Landmark','City','State','Pincode', 'Status', 'Profile Picture', 'Joining Date'));
             foreach ($query1 as $line) { 
                $data = array(
                    'name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'email' => $line->email,
                    'mobile_no' => $line->mobile,
                    'address1' => $line->address,
                    'address2' => $line->address1,
                    'landmark' => $line->landmark,
                    'city' => $line->city,
                    'state' => $line->state,
                    'pincode' => $line->pincode,
                    'status' => $line->status,
                    'profile_picture' => $line->profile_photo,
                    'joining_date' => $line->joining_date
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('technician_report.csv');
            return;
        }
        //end start
        return view('amcs.indexnew',['rid'=>$urid])->withAmcs($amcs)->withAmcs1($amcs1)->withFilter($filter);

    }
	
	public function indexnew1()
    {
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',16)
        ->get();
        //echo "<pre>"; print_r($userpermission); die();

		$user_id = Auth::user()->id;
		$urid = Auth::user()->role_id;
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'amcs.name';
        }
        
        if (!empty(Input::get('ajax'))) {
            $ajax = Input::get('ajax');
        } else {
            $ajax = 0;
        }

        if (!empty(Input::get('show'))) {
            $show = Input::get('show');
        } else {
            $show = 'allrecords';
        }        

        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC&show='.$show.'&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
            $url = '?order=ASC&show='.$show.'&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }

        $sort_data = array(
            'p.product_name',
	        'amcs.atype',
            'amcs.service_timeframe',
            'amcs.terms',
            'amcs.start_date',
            'amcs.end_date',
            'v.name',
            'v.company_name'
        );
        //$query = Amcs::select();
		
       

		$query = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
					->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.service_timeframe','amcs.atype','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','v.name','p.product_name','v.deleted_at','p.product_code');
       
        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
		$today = Carbon::now();
        
        if($show=="ongoing")
        {
            $query->whereDate('amcs.end_date', '>=', $today);
        }
        elseif($show=="pastrecords")
        {
            $query->whereDate('amcs.end_date', '<', $today);
        }		
        if(!empty(Input::get('filter_name'))) {
            $query->where(function($query) {
				//$query->whereDate('amcs.end_date', '>=', $today)
                 $query->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                         ->orWhere('v.name', 'LIKE', "%".trim(Input::get('filter_name'))."%")                                              			
						->orWhere('p.product_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
						;
            });
        }
		$query->where('v.deleted_at','=','N');
		//$query->orderBy('v.name','ASC');
		//dd($query->toSql());
		
		$amcs = $query->paginate(10);
		/*
		//past amcs
		$queryx = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
					->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name','v.deleted_at');
       
        
        if (isset($order) && ($order == 'DESC')) {
            $queryx->orderby($sort_col_name,'desc');
        } else {
            $queryx->orderby($sort_col_name,'asc');
        }
		$today1 = Carbon::now();
		$queryx->whereDate('amcs.end_date', '<', $today1);
		$queryx->where('v.deleted_at','=','N');
        if(!empty(Input::get('filter_name'))) {
            $queryx->where(function($queryx) {
				//$query->whereDate('amcs.end_date', '>=', $today)
                 $queryx->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
                        ->orWhere('amcs.terms', 'LIKE', "%".Input::get('filter_name')."%")
                         ->orWhere('amcs.service_timeframe', 'LIKE', "%".Input::get('filter_name')."%")
			->orWhere('amcs.atype', 'LIKE', "%".Input::get('filter_name')."%")
						->orWhere('p.product_name', 'LIKE', "%".Input::get('filter_name')."%")
						;
            });
        }
		//$queryx->orderBy('v.name','ASC');
		
		//dd($query->toSql());
		
		$amcs1 = $queryx->paginate(10);
        */
		//end
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
		//export start
        if(Input::get('report') == 1) {
		
         $query1tmp = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.service_timeframe','amcs.atype','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','v.name','p.product_name','v.deleted_at');

          if(!empty(Input::get('filter_name'))) {
           
                //$query->whereDate('amcs.end_date', '>=', $today)
            //      $query1tmp->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('amcs.terms', 'LIKE', "%".Input::get('filter_name')."%")
            // ->orWhere('amcs.atype', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('p.product_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ;

                 $query1tmp->whereRaw("(v.company_name LIKE '%".trim(Input::get('filter_name'))."%' OR  amcs.terms LIKE '%".trim(Input::get('filter_name'))."%'OR amcs.service_timeframe LIKE '%".trim(Input::get('filter_name'))."%'  OR amcs.atype LIKE '%".trim(Input::get('filter_name'))."%' OR p.product_name LIKE '%".trim(Input::get('filter_name'))."%')");
            
        }

        if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(amcs.id IN (".$selectedval.") )");
            }

        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.company_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }
		$query1tmp->where('v.deleted_at','=','N');
		$query1 =  $query1tmp->get();
		 
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('Client Name', 'Company Name','Type', 'Terms&Condition', 'Start Date', 'End Date', 'Product'));
			 foreach ($query1 as $line) { 
                $data = array(
                    'client_name' => $line->name,
                    'company_name' => $line->company_name,
                    'type' => $line->atype,
                    'tearms_condition' => $line->terms,
                    'start_date' => date('d-F-Y',strtotime($line->start_date)),
                    'end_date' => date('d-F-Y',strtotime($line->end_date)),
                    'product' => $line->product_name
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('amcs_report.csv');
            die;
            return;
		}

		//end start
        if($ajax==0)
        {
            return view('amcs.indexnew',['rid'=>$urid])->withFilter($filter)->withUserpermission($userpermission);
        }
        if($ajax==1)
        {
            return view('amcs.ajaxdata',['rid'=>$urid])->withAmcs($amcs)->withFilter($filter)->withUserpermission($userpermission);
        }

    }
	public function indexnew()
    {
        # code...
        // echo "string";
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',16)
        ->get();


        $user_id = Auth::user()->id;
        $urid = Auth::user()->role_id;
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'title';
        }
        
        if (!empty(Input::get('ajax'))) {
            $ajax = Input::get('ajax');
        } else {
            $ajax = 0;
        }

        if (!empty(Input::get('show'))) {
            $show = Input::get('show');
        } else {
            $show = 'allrecords';
        }        

        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC&show='.$show.'&filter_name='.(!empty(Input::get('title'))?Input::get('title'):'');
        } else {
            $url = '?order=ASC&show='.$show.'&filter_name='.(!empty(Input::get('title'))?Input::get('title'):'');
        }

        if(!empty(Input::get('title'))) {
            $url .= "&filter_name=".Input::get('title');
        }

        $sort_data = array(
            'title',
            'id',
            'checklist'
        );
        
        // $emailcontent1[] = "Demo";
        $emailcontent1 = array (
                    'name' => 'Ami',
                    'ex' => 'aa',
                    'msg'=>'gnm,',
                    'vemail'=>'ami.mukesoft@gmail.com'
                    );

        $vemail = 'ami.mukesoft@gmail.com';

      /*  Mail::send('emails.checklist', $emailcontent1, function ($message) use ($vemail) {        
                $message->from(Config::get('app.DOMAIN_NAME1'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
                    
                    $message->to($vemail)->subject(Config::get('app.companyname').'AMC Report');
                    //service code end
                 });*/

               /*   $contactName = 'Ami Mehta';
                    $contactEmail = 'ami.mukesoft@gmail.com';
                    $contactMessage = 'Demo Test';

                    $data = array('name'=>$contactName, 'email'=>$contactEmail, 'message'=>$contactMessage);
                    Mail::send('emails.checklist', $data, function($message) use ($contactEmail, $contactName, $contactMessage)
                    {
                        $message->setBody($contactMessage);
                        $message->from($contactEmail, $name = null);
                        $message->to('amimeha377@gmail.com', 'Test')->subject('There is a bug on budgetd ya dufus');
                    }, compact('data'));
                */




        if(Input::get('report') == 0) {
             $query = DB::table('check_list')
                        ->select('*');
                        // ->where('deleted_at','=','0000-00-00');


        if(!empty(Input::get('filter_membertype'))) 
         { 
           $membertype = Input::get('filter_membertype');
           if($membertype=='1')
           {
                $query->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00")');
                // $query->whereNull('leaving_date');
           }
           else if($membertype=='2')
           {
             $query->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00")');
            // $query->whereNotNull('leaving_date');
           }
         }
         else
         {
            $query->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00")');
         }

        if(!empty(Input::get('filter_name'))) {
                $query->whereRaw("(title LIKE '%".(Input::get('filter_name'))."%')");          
        }

        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "title";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
        
       /* $bikers = $query->toSql();
         dd($bikers);die;
        */
        $check_list_query = $query->paginate(10);

        }

        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
        //export start

        if(Input::get('report') == 1) {
        //$query1tmp = DB::table('bikers')->select('*');
         $query1tmp = DB::table('check_list')
                    ->select('*');

        if(!empty(Input::get('filter_membertype'))) 
        { 
           $membertype = Input::get('filter_membertype');
           if($membertype=='1')
           {
            $query1tmp->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00")');
           }
           else if($membertype=='2')
           {
            $query1tmp->whereRaw('(deleted_at IS NOT NULL OR deleted_at !="" OR deleted_at != "0000-00-00")');
           }
         }
         else
         {
            $query1tmp->whereRaw('(deleted_at IS NULL OR deleted_at="" OR deleted_at = "0000-00-00")');
         }

         if(!empty(Input::get('filter_name'))) {
                $query1tmp->whereRaw("(title LIKE '%".(Input::get('filter_name'))."%')");          
        }


        if(!empty(Input::get('reportids'))) {
          
            $selectedval = Input::get('reportids');
             $query1tmp->whereRaw("(id IN (".$selectedval.") )");
        }

         if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "title";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }
                  

            $query1 =     $query1tmp->get();
            // print_r($query1);die();                  
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','Check List Report'));
            $csv->insertOne(array());

            $csv->insertOne(array('Title','Pointers','Force Update','Create At'));
             foreach ($query1 as $line) { 
                if($line->force_update == 1)
                    $force_update1 = 'Yes';
                else
                    $force_update1 = 'No';

                $data = array(
                    'title' => $line->title,
                    'checklist' => $line->checklist,
                    'force_update' => $force_update1,
                    'created_at' => $line->created_at,
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('checklist_report.csv');
            return;
        }

        $technician_number = '';
        $client_plan       = '';

        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
                    //echo "<pre>";print_r($clients);die;    
        if(!empty($clients)) {
            $technician_number = $clients->technician_number;
            $client_plan = $clients->client_plan;
        }            
        $bikers_data= DB::table('bikers')->where('deleted_at','=',NULL)->get();
        $bikers_count = count($bikers_data);

        $technician_number = Config::get('app.technicianNumber');
        if(empty($technician_number)) {
            $technician_number = 100;
        }
        // $technician_number = 100;

        $img_dir_new = '';
        return view('checklist.index')->withcheck_list_query($check_list_query)->withFilter($filter)->withImgDir($img_dir_new)->withBikersCount($bikers_count)
        ->withTechnicianNumber($technician_number)->withClientPlan($client_plan)->withUserpermission($userpermission);

    }
	    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        # code...
         $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',16)
        ->get();
        return view('checklist.create')->withUserpermission($userpermission);

    }
    public function insert(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'force_update' => 'required',
        ]); 
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',16)
        ->get();

        if (!empty(Input::get('title'))) {
            $title = Input::get('title');
        } else {
            $title = 'Please enter Title';
        }
        if(!empty(Input::get('force_update'))){
            $fupdate = Input::get('force_update');
        }else{
            $fupdate = "Please select one";
        }
         $rules = [];

         $pointer_string = '';
        foreach(Input::get('pointer') as $key => $value) {

            $rules["pointer.{$key}"] = $value;
            $pointer_string .= $value.',';
        }
       $date = Carbon::now();


        $pointer_string = substr_replace($pointer_string, "", -1);
   
        $data=array('title'=>$title,"checklist"=>$pointer_string,"force_update"=>$fupdate,"created_at"=>$date);
        DB::table('check_list')->insert($data);


         $request->session()->flash('success', 'Checklist added successfully !!!');
        return redirect("checklist/indexnew");
    }

	/**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
   public function store(Request $request)
    {
        $this->validate($request, [
            'vendor_id' => 'required',
            'service_timeframe' => 'required',
            //'terms' => 'required',
            'start_date' => 'required|date|date_format:d-m-Y|before:end_date',
		  'end_date' => 'required|date|date_format:d-m-Y|after:start_date',
            'product_id' =>'required'

        ]); 
        $input = $request->all();
		
        //$data['vendor_id'] = $input['vendor_id'];
        if ($input['start_date'] != '') {
            $start_date = new DateTime($request['start_date']);
            $input['start_date'] = $start_date->format('Y-m-d');
			$today = Carbon::createFromFormat('Y-m-d',$input['start_date']);
			$today1 = Carbon::createFromFormat('Y-m-d',$input['start_date']);
			$s1 = $today->toDateTimeString();
			$s2 = $today->addMonths(3)->toDateTimeString();
			$s3 = $today->addMonths(3)->toDateTimeString();
			//$edt = $today1->addYear()->toDateTimeString();               
        } else {
            $input['start_date'] = NULL;
        }
		
		if ($input['end_date'] != '') {
            $end_date = new DateTime($request['end_date']);
            $input['end_date'] = $end_date->format('Y-m-d');
        } else {
            $input['end_date'] = NULL;
        }
     	//$input['end_date'] = $edt;
		$input['s1'] = $s1;
		$input['s2'] = $s2;
		$input['s3'] = $s3;

        $service_timeframe = '';
        $next_service_date = '';

        if($input['service_timeframe']!='')
        {
            $service_timeframe = $input['service_timeframe'];
            switch($service_timeframe)
            {
                case '15 Days' :

                    $daystoadd = 15;
                    $next_service_date = date('Y-m-d', strtotime("+15 days",strtotime($input['start_date'])));
                    break;

                case 'Monthly' :
                    $next_service_date = date('Y-m-d', strtotime("+1 month",strtotime($input['start_date'])));
                    break;

                case 'Quaterly' :
                    $next_service_date = date('Y-m-d', strtotime("+3 months",strtotime($input['start_date'])));
                    break;

                case 'Yearly' :
                    $next_service_date = date('Y-m-d', strtotime("+12 months",strtotime($input['start_date'])));
                    break;
            }
        }  

        $input['next_service_date'] =  $next_service_date;   

           
		
        $amc_id = Amcs::create($input);
		//print_r($input);
        $request->session()->flash('success', 'AMC added successfully !!!');
        return redirect("amcs/indexnew");
    }
/**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        $amc = checklist::findOrFail($id);
		 //dd($amc);
		/*$pid = $amc->product_id;
		$products = DB::table('products')
                     ->where('id', '=', $pid)
                     ->get();

		$vid = $amc->vendor_id;
		$vendors = DB::table('vendor')
                     ->where('id', '=', $vid)
                     ->get();*/


        /*if ($amc->start_date != '') {
            $start_date = new DateTime($amc->start_date);
            $amc['start_date'] = $start_date->format('d-m-Y');
        } else {
            $amc['start_date'] = NULL;
        }
        if ($amc->end_date != '') {
            $end_date = new DateTime($amc->end_date);
            $amc['end_date'] = $end_date->format('d-m-Y');
        } else {
             $amc['end_date'] = NULL;
        }*/
        return view('checklist.show')->withAmc($amc);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        // echo $id;die();
        $amc = checklist::findOrFail($id);
        // echo $amc;die();
       /* if ($amc->start_date != '') {
            $start_date = new DateTime($amc->start_date);
            $amc['start_date'] = $start_date->format('d-m-Y');
		
        } else {
            $amc['start_date'] = NULL;
        }
		
        if ($amc->end_date != '') {
            $end_date = new DateTime($amc->end_date);
            $amc['end_date'] = $end_date->format('d-m-Y');
        } else {
             $amc['end_date'] = NULL;
        }*/

        $pointer = explode(',', $amc['checklist']);
        // print_r($arr);die();
		// $products = DB::table('products')->get();
		// $vendors = DB::table('vendor')->where('deleted_at','=','N')->get();
        return view('checklist.edit')->withAmc($amc)->withPointer($pointer);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

       $this->validate($request, [
       'title' => 'required',
            'force_update' => 'required',  
        ]);
        $amc = checklist::findOrFail($id);

        $input = $request->all();

        $str_pointer = implode(',', $input['pointer']);
		
        $input1 = array('title' => $input['title'],
                        'force_update' => $input['force_update'],
                        'checklist' => $str_pointer,
                         );

	   $amc->fill($input1)->save();
       $request->session()->flash('success', 'Checklist updated successfully !!!');
       return redirect('checklist/indexnew?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']."&show=".$_GET['show']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++){
            DB::table('check_list')->where('id', $ids[$i])->update(['deleted_at' => Carbon::now()]);
        }
       session()->flash('success', 'Checklist deleted successfully !!!');
       return redirect('checklist/indexnew');
    }
    public function amcservice()
    {
        //return view('amcs.create');
		//$data = DB::table('amc_service_history')->get();
       // return $data;
	   //return view('amcs.service')->withData($data);
	   
	   $amcs = DB::table('amcs')->get();
		$today1 = Carbon::now()->format('Y-m-d');
		//$today = $today1." 00:00:00";

		foreach($amcs as $amc)
		{
			$aid = $amc->id;
			$sdate = $amc->start_date;
			$s1 = $amc->s1;
			$rs1 = substr($s1, 0, 10);
			$s2 = $amc->s2;
			$rs2 = substr($s2, 0, 10);
			$s3 = $amc->s3;
			$rs3 = substr($s3, 0, 10);
			$vid = $amc->vendor_id;
			$vemail_query = DB::table('vendor')
                        ->select('*')
                        ->where('id','=',$vid)
                        ->first();
						//print_r($vemail_query);
			$vemail = $vemail_query->email;
			$vname = $vemail_query->name;
			$date1 = Carbon::createFromFormat('Y-m-d', $rs3);
			$rs4 = $date1->subWeek();
			$rs5 = substr($rs4, 0, 10);
			$vid = $amc->vendor_id;
			$pid = $amc->product_id;
			$sr = $amc->service;
			$st = "";
			if($sr == "0"){
				$sr = "1";
				$st = "First";
			}
			if($sr == "1"){
				$sr = "2";
				$st = "Second";
			}
			if($sr == "2"){
				$sr = "3";
				$st = "Last";
			}	
			
			if($sr <=3){	
				if($today1 == $rs5){
				//echo $vemail;
					$msg = "Your AMC is Expire after 7 days.";
					$emailcontent1 = array (
					'name' => $vname,
					'ex' => $st,
					'msg'=>$msg,
					'vemail'=>$vemail
					);
					Mail::send('emails.amcmail', $emailcontent1, function ($message) use ($vemail) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
					
					$message->to($vemail)->subject(Config::get('app.companyname').'AMC Report');
					//service code end
				 });
				}	
				if($today1 == $rs1 || $today1 == $rs2 || $today1 == $rs3){
			
					DB::table('amcs')->where('id', $aid)->update(['service' => $sr]);
					//service code start
					$msg = "Your ".$st." Service for AMC is Completed today.";
					
					
					$emailcontent1 = array (
					'name' => $vname,
					'ex' => $st,
					'msg'=>$msg,
					'vemail'=>$vemail
					);
					Mail::send('emails.amcmail', $emailcontent1, function ($message) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
					
					$message->to($vemail)->subject(Config::get('app.companyname').'AMC Report');
					//service code end
				 });
			}
			}
			
		}
    }

	public function amcmail()
    {
	   //$ss = ["Order Received"];
       $amcs = DB::table('shipment_status_history')->get();
		
	   $amcs1 = DB::table('shipment_status_history')
	   ->where('status', '=', "Order Received")
	   ->where('by_whom_role', '<>', "Bikers")
	   ->get();
	   $n = count($amcs1);
	   
	   $amcs2 = DB::table('shipment_status_history')
	   ->where('status', '=', "Delivered")
	   ->where('by_whom_role', '<>', "Bikers")
	   ->orwhere('status', '=', "RTN Delivered")
	   ->orwhere('status', '=', "Delivered_Cash collected")
	   ->orwhere('status', '=', "Delivered_card on delivery")
	   ->orwhere('status', '=', "Delivered_Open box")
	   ->get();
	   $c = count($amcs2);
	   
	   $amcs3 = DB::table('shipment_status_history')
	   ->where('by_whom_role', '<>', "Bikers")
	   ->orwhere('status', '=', "Order Assigned")
	   ->orwhere('status', '=', "Order Assigned not ready")
	   ->orwhere('status', '=', "Order Reassigned_1")
	   ->orwhere('status', '=', "Order Reassigned_2")
	    ->orwhere('status', '=', "At_substation")
	   ->orwhere('status', '=', "At_Substation_Reattempt1")
	   ->orwhere('status', '=', "At_Substation_Reattempt2")
	   ->orwhere('status', '=', "At_substation_rtn")
	    ->orwhere('status', '=', "At_Substation_rtn_Reattempt1")
	   ->orwhere('status', '=', "At_Substation_rtn_Reattempt2")
	   ->orwhere('status', '=', "Order picked_in transit")
	   ->orwhere('status', '=', "Order picked_weight changed")
	    ->orwhere('status', '=', "In transit")
	   ->orwhere('status', '=', "In transit_address changed")
	   ->orwhere('status', '=', "In transit_Business_or_house closed")
	   ->orwhere('status', '=', "In transit_COD amount not ready")
	    ->orwhere('status', '=', "In transit_Customer Refused_or_Rejected")
	   ->orwhere('status', '=', "In transit_undelivered")
	   ->orwhere('status', '=', "In transit_Reattempt1")
	   ->orwhere('status', '=', "In transit_Reattempt2")
	    ->orwhere('status', '=', "In transit_delay out of our control")
	   ->orwhere('status', '=', "In Transit_Out for Delivery")
	   ->orwhere('status', '=', "In Transit_Out for Delivery1")
	    ->orwhere('status', '=', "In Transit_Out for Delivery2")
	   ->orwhere('status', '=', "In transit_Shipment Lost")
	   ->orwhere('status', '=', "RTN Order picked_in transit")
	   ->orwhere('status', '=', "RTN Order picked_weight changed")
	   ->orwhere('status', '=', "RTN In transit")
	   ->orwhere('status', '=', "RTN In transit_address changed")
	   ->orwhere('status', '=', "RTN In transit_Business_or_house closed")
	   ->orwhere('status', '=', "RTN In transit_COD amount not ready")
	   ->orwhere('status', '=', "RTN In transit_Customer Refused_or_Rejected")
	   ->orwhere('status', '=', "RTN In transit_undelivered")
	   ->orwhere('status', '=', "RTN In transit_Reattempt1")
	   ->orwhere('status', '=', "RTN In transit_Reattempt2")
	   ->orwhere('status', '=', "RTN In transit_delay out of our control")
	   ->orwhere('status', '=', "RTN In Transit_Out for Delivery")
	   ->orwhere('status', '=', "RTN In Transit_Out for Delivery1")
	   ->orwhere('status', '=', "RTN In Transit_Out for Delivery2")
	   ->orwhere('status', '=', "RTN In transit_Shipment Lost")
	   ->get();
	   $i = count($amcs3);
	   
	   //$t = count($amcs4);
	  	$t = $n+$c+$i;
      // session()->flash('success', 'Mail send successfully.');
	   
	   $emailcontent = array (
            'new' => $n,
			'inprogress' => $i,
			'total' => $t,
            'complete' => $c
            );
	   Mail::send('emails.amcs', $emailcontent, function ($message) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));          
            $message->to(Config::get('app.adminemail'))->subject('Service Ticket Request Report');
        });
       return "New Request : ".$n." Completed Request : ".$c." InProgress Request : ".$i." Total Request : ".$t;
    }
}
