<?php

namespace App\Http\Controllers\Bikers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Bikers;
use App\Substation;
use App\Bikers_reading;
use Input;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use Config;
use Auth;


class BikersController extends Controller
{
    private $img_dir = "";
    public function __construct()
    {
        $this->img_dir = "uploads/images/client_".Config::get('app.client_id');
        if (!file_exists($this->img_dir)) {
            mkdir($this->img_dir, 0777, true);
            mkdir($this->img_dir.'/biker/', 0777, true);            
        }            
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',3)
        ->get();
        // echo "<pre>"; print_r($userpermission); die(); 

        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'bikers.first_name';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }

        if(!empty(Input::get('filter_membertype'))) 
         { 
             $url .= "&filter_membertype=".Input::get('filter_membertype');
         }

        $sort_data = array(
            'bikers.first_name',
            'bikers.mobile',
            'bikers.email',
            'bikers.profile_status',
            'bikers.status',
            'bikers.cod_amount_receivable',
            'ss.name'
        );
        //$query = Bikers::leftjoin('sub_station as ss','bikers.substation_id','=','ss.id')->select('bikers.*','ss.name as substation_name');

        if(Input::get('report') == 0) {
            $admintypes = Auth::user()->types;
            if($admintypes==='External'){
                $externaladmin_id = Auth::user()->id;
                    $query = DB::table('bikers')
                        ->leftJoin('sub_station as ss', 'bikers.substation_id', '=', 'ss.id')
                        ->select('bikers.*','ss.name as substation_name')
                        ->whereRaw("bikers.created_by = $externaladmin_id AND types = 'External'");
            }else{
                    $query = DB::table('bikers')
                            ->leftJoin('sub_station as ss', 'bikers.substation_id', '=', 'ss.id')
                            ->select('bikers.*','ss.name as substation_name');
            }

        /*if(Session::get('sub_station_id')){          
            $query->where('substation_id', Session::get('sub_station_id'))->whereNull('leaving_date');
        } else{           
            $query->whereNull('leaving_date');
        }*/

            if(!empty(Input::get('filter_membertype'))) 
            { 
               $membertype = Input::get('filter_membertype');
               if($membertype=='1')
               {
                    $query->whereRaw('(bikers.deleted_at IS NULL OR bikers.deleted_at="" OR bikers.deleted_at = "0000-00-00 00:00:00")');
                    $query->whereNull('leaving_date');
               }
               else if($membertype=='2')
               {
                //$query->whereRaw('(bikers.deleted_at IS NOT NULL OR bikers.deleted_at !="" OR bikers.deleted_at != "0000-00-00 00:00:00")');
                 $query->whereRaw('(bikers.deleted_at IS NULL OR bikers.deleted_at="" OR bikers.deleted_at = "0000-00-00 00:00:00")');
                $query->whereNotNull('leaving_date');
               }
            }
            else
            {
                $query->whereRaw('(bikers.deleted_at IS NULL OR bikers.deleted_at="" OR bikers.deleted_at = "0000-00-00 00:00:00")');
            }

             if(!empty(Input::get('filter_name'))) {
              
                    $query->whereRaw("(bikers.first_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  bikers.last_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR bikers.mobile LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR ss.name LIKE '%".trim(addslashes(Input::get('filter_name')))."%')");
            }

            if (isset($sort) && in_array($sort, $sort_data)) {
                $sort_col_name = $sort;
            } else {
                $sort_col_name = "bikers.first_name";
            }
            if (isset($order) && ($order == 'DESC')) {
                $query->orderby($sort_col_name,'desc');
            } else {
                $query->orderby($sort_col_name,'asc');
            }
            
            // $bikers = $query->toSql();
            // dd($bikers);die;

            $bikers = Bikers::with(['skill', 'shipments.vendor'])->paginate(10); // ✅ ADDED


        //<<<<<<<<<<<<<<<<<<<<<<_____ Add skill names to each biker___>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$skills = \App\Skill::all()->keyBy('id');

foreach ($bikers as $bikerItem) {
    $skillNames = [];

    if (!empty($bikerItem->skill_id)) {
        $skillIds = json_decode($bikerItem->skill_id, true); // decode JSON array

        if (is_array($skillIds)) {
            foreach ($skillIds as $id) {
                $id = trim($id);
                if (isset($skills[$id])) {
                    $skillNames[] = $skills[$id]->name;
                }
            }
        }
    }

    $bikerItem->skill_names = implode(', ', $skillNames);
}

        }

        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
		//export start

        if(Input::get('report') == 1) {
		//$query1tmp = DB::table('bikers')->select('*');
         $query1tmp = DB::table('bikers')
                    ->leftJoin('sub_station as ss', 'bikers.substation_id', '=', 'ss.id')
                    ->select('bikers.*','ss.name as substation_name');

        if(Session::get('sub_station_id')){
            $query1tmp->where('substation_id', Session::get('sub_station_id'))->whereNull('leaving_date');
        } else{
            $query1tmp->whereNull('leaving_date');
        }


				  //->where('deleted_at','=',NULL)

         if(!empty(Input::get('filter_membertype'))) 
         { 
           $membertype = Input::get('filter_membertype');
           if($membertype=='1')
           {
            $query1tmp->whereRaw('(bikers.deleted_at IS NULL OR bikers.deleted_at="" OR bikers.deleted_at = "0000-00-00 00:00:00")');
           }
           else if($membertype=='2')
           {
            $query1tmp->whereRaw('(bikers.deleted_at IS NOT NULL OR bikers.deleted_at !="" OR bikers.deleted_at != "0000-00-00 00:00:00")');
           }
         }
         else
         {
            $query1tmp->whereRaw('(bikers.deleted_at IS NULL OR bikers.deleted_at="" OR bikers.deleted_at = "0000-00-00 00:00:00")');
         }

         if(!empty(Input::get('filter_name'))) {
          
                $query1tmp->whereRaw("(bikers.first_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  bikers.last_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR bikers.mobile LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR ss.name LIKE '%".trim(addslashes(Input::get('filter_name')))."%')");
        }

        if(!empty(Input::get('reportids'))) {
          
                //$query1tmp->whereRaw("(bikers.first_name LIKE '%".Input::get('filter_name')."%' OR  bikers.last_name LIKE '%".Input::get('filter_name')."%' OR bikers.mobile LIKE '%".Input::get('filter_name')."%' OR ss.name LIKE '%".Input::get('filter_name')."%')");
            $selectedval = Input::get('reportids');
             $query1tmp->whereRaw("(bikers.id IN (".$selectedval.") )");
        }

         if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "bikers.first_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }

			$query1 =	  $query1tmp->get();
                  
                  
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','TECHNICIANS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Name', 'Email', 'Mobile No','Address1','Address2','Landmark','City','State','Pincode', 'Status', 'Profile Picture', 'Joining Date'));
			 foreach ($query1 as $line) { 
                $data = array(
                    'name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'email' => $line->email,
                    'mobile_no' => $line->mobile,
                    'address1' => $line->address,
                    'address2' => $line->address1,
					'landmark' => $line->landmark,
					'city' => $line->city,
					'state' => $line->state,
					'pincode' => $line->pincode,
					'status' => $line->status,
					'profile_picture' => $line->profile_photo,
                    'joining_date' => $line->joining_date
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('technician_report.csv');
            
            return;
		}
		//end start
        $img_dir_new = $this->img_dir."/biker/";

        $technician_number = '';
        $client_plan       = '';

        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
                    //echo "<pre>";print_r($clients);die;    
        if(!empty($clients)) {
            $technician_number = $clients->technician_number;
            $client_plan = $clients->client_plan;
        }            
        $bikers_data= DB::table('bikers')->where('deleted_at','=',NULL)->get();
        $bikers_count = count($bikers_data);

        //$technician_number = Config::get('app.technicianNumber');
        // if(empty($technician_number)) {
        //     $technician_number = 100;
        // }

        return view('bikers.index')->withBikers($bikers)->withFilter($filter)->withImgDir($img_dir_new)->withBikersCount($bikers_count)
        ->withTechnicianNumber($technician_number)->withClientPlan($client_plan)->withUserpermission($userpermission);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $states = DB::table('state')->get();
        $substations = Substation::all();
         $skills = DB::table('skills')->get();
        return view('bikers.create')->withStates($states)->withskills($skills)->withSubstations($substations);
    }

    public function updateallvendorsname()
    {
        
        $query = DB::table('bikers')->select('*');
        //$query->where("deleted_at","=",NULL);
        $vendors = $query->get();
        $i=0;
        foreach($vendors as $vendor)
        {
            $input = array();
            //echo $i++.' '.$vendor->company_name.'<br>';
            $vendor = Bikers::findOrFail($vendor->id);
            $input['first_name'] = ucwords(strtolower($vendor->first_name));
            $input['last_name'] = ucwords(strtolower($vendor->last_name));
            $vendor->fill($input)->save();

        }
        echo 'end';
        die;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {    
        //get user have which plan from apniamc_master db
        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
        $client_plan = ''; 
        $technician_number = '';
        $client_code = '';

        if(!empty($clients)) {
            $client_plan = $clients->client_plan;
            $technician_number = $clients->technician_number;
            $client_code = $clients->client_code;
        } 

        $all_bikers = DB::table('bikers')->where('deleted_at','=',NULL)->get();
        $count_bikers = count($all_bikers);

        //if user has BASIC plan then check and restrict it to make only 1 technician
        if($client_plan == 'BA') {
            if($count_bikers >= $technician_number) {
                session::flash('unable_create_biker_mesg', 'Please upgrade your plan to make more Technicians. Please contact on this number 9137858155.');
                return redirect('/bikers/create');
            } else {
                return  $this->finalStoreBikers($request);
            }
        } 

        //if user has Bronze plan then check and restrict it to make only 5 technician
        else if($client_plan == 'BR') {
            if($count_bikers >= $technician_number) {
                session::flash('unable_create_biker_mesg', 'Please upgrade your plan to make more Technicians. Please contact on this number 9137858155.');
                return redirect('/bikers/create');
            } else {
                return  $this->finalStoreBikers($request);
            }
        }  

        //if user has Silver plan then check and restrict it to make only 10 technician
        else if($client_plan == 'S') {
            if($count_bikers >= $technician_number) {
                session::flash('unable_create_biker_mesg', 'Please upgrade your plan to make more Technicians. Please contact on this number 9137858155.');
                return redirect('/bikers/create');
            } else {
                return  $this->finalStoreBikers($request);
            }
        }

         //if user has Gold plan then check and restrict it to make only 20 technician
        else if($client_plan == 'G') {
            if($count_bikers >= $technician_number) {
                session::flash('unable_create_biker_mesg', 'Please upgrade your plan to make more Technicians. Please contact on this number 9137858155.');
                return redirect('/bikers/create');
            } else {
                return  $this->finalStoreBikers($request);
            }
        }
        else {
            return  $this->finalStoreBikers($request);
        }    

    }


    public function finalStoreBikers(Request $request) {
        $this->validate($request, [
           // 'first_name' => 'regex:/^[a-zA-Z]+$/u|max:255|',
        'first_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'last_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'email' => 'required|unique:bikers,email,NULL,id,deleted_at,NULL',
            'mobile' => 'required|digits:10|numeric',
            'pincode' => 'required|digits:6|numeric',
            'employee_id' => 'required | unique:bikers',
            'address' => 'required',
            'landmark' => 'required',
            'joining_date' => 'required',
            'city' => 'regex:/^[\pL\s\-\']+$/u',
            'state' => 'required|regex:/^[\pL\s\-\']+$/u',
            'profile_photo' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof1' => 'required|mimes:jpeg,bmp,png,JPEG',
            'identity_proof2' => 'mimes:jpeg,bmp,png,JPEG',
            'identity_proof3' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof4' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof5' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof1_text' => 'required',
            'password' => 'required',
            'types' => 'required',
            'skill_id' => 'required|array',          // Expect multiple skills as array
            'skill_id.*' => 'exists:skills,id',     // Each must exist in skills table

            //'identity_proof2_text' =>'required'

        ]); 
        $input = $request->all();
        $input['skill_id'] = json_encode($input['skill_id']);
        $data['password'] = $input['password'];
        //added by gaurav to store auth user id in bikers table
        $input['created_by'] = Auth::user()->id;

            $input['first_name'] = ucwords(strtolower($input['first_name']));
            $input['last_name'] = ucwords(strtolower($input['last_name']));
            $input['types'] = trim($input['types']);
            $input['password'] = bcrypt($input['password']);
            $input['created_by'] = trim($input['created_by']);
            
        $data['email'] = $input['email'];
        $data['name'] = ucfirst(strtolower($input['first_name']))." ".ucfirst(strtolower($input['last_name']));
        //$data['password'] = substr(md5($input['email'].time()), 5, 10);
        

        //get user client code from apniamc_master db
        $clients = DB::connection('apniamc_master')
                    ->table('client_master')
                    ->where('domain_name',$_SERVER['SERVER_NAME'])
                    ->where('is_active','Y')
                    ->first();
      
        $client_code = '';

        if(!empty($clients->client_code)) {
            $client_code = $clients->client_code;
        } 

        $data['client_code'] = $client_code;

        $emailcontent = array (
            'email' => $data['email'],
            'password' => $data['password'],
            'name' => $data['name'],
            'client_code' => $data['client_code']
            );
        //$cname = \Config::get('constants.company_name');
        //$sb = 'Welcome to '.$cname.'!';

        Mail::send('emails.bikers', $emailcontent, function ($message) use ($data) {      
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
            $message->to($data['email'])->subject('Welcome to'.Config::get('app.companyname'));
        });
        
        // $input['password'] = bcrypt($data['password']);

        if ($input['joining_date'] != '') {
            $joining_date = new DateTime($request['joining_date']);
            $input['joining_date'] = $joining_date->format('Y-m-d');
        } else {
            $input['joining_date'] = NULL;
        }
        // To make default status available
        $input['profile_status'] = "Available";

       //  $img_dir = "uploads/images/biker/";
       //  if (!file_exists($img_dir)) {
       //      mkdir($img_dir, 0777, true);
       //  }
       // if (!empty($request['profile_photo'])) {
       //      $profile_image_name = Input::file('profile_photo')->getClientOriginalName();
       //      $file = $request->file('profile_photo');
       //      if ($request->file('profile_photo')->isValid())
       //          {
       //          //$i = $request->file('profile_photo')->move($img_dir, $profile_image_name);
       //          $input['profile_photo'] = $img_dir.$profile_image_name;
       //          }
       //  }
        $fields = array('profile_photo','identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5');
        foreach ($fields as $key => $field) {
        if (!empty($request[$field])) {
            $identity_proof_name = Input::file($field)->getClientOriginalName();
            $identity_proof_name = time().$identity_proof_name;
            $file = $request->file($field);
            if ($request->file($field)->isValid())
                {
                $input[$field] = $identity_proof_name;
                }
            }
        }
        $biker_id = Bikers::create($input);

        $img_dir2 = $this->img_dir."/biker/".$biker_id->id."/";
        if (!file_exists($img_dir2)) {
            
            mkdir($img_dir2, 0777, true);
        }
       // if (!empty($request['profile_photo'])) {
       //      $profile_image_name = Input::file('profile_photo')->getClientOriginalName();
       //      $profile_image_name = time().$profile_image_name;
       //      $file = $request->file('profile_photo');
       //      if ($request->file('profile_photo')->isValid())
       //          {
       //          $i = $request->file('profile_photo')->move($img_dir, $profile_image_name);
       //          }
       //  }

        foreach ($fields as $key => $field) {
        if (!empty($request[$field])) {
            //$identity_proof_name = Input::file($field)->getClientOriginalName();
            //$identity_proof_name = time().$identity_proof_name;
            $file = $request->file($field);
            if ($request->file($field)->isValid()) {
                $request->file($field)->move($img_dir2, $input[$field]);
                }
            }
        }
        // echo '<pre>'; print_r($input); exit;
        $request->session()->flash('success', 'Technician added successfully !');
        return redirect("bikers/");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request) {
        $img_dir2 = $this->img_dir."/biker/".$id."/";

try{
        $biker = Bikers::findOrFail($id);
        if ($biker->joining_date != '') {
            $joining_date = new DateTime($biker->joining_date);
            $biker['joining_date'] = $joining_date->format('d-m-Y');
        } else {
            $biker['joining_date'] = NULL;
        }
        if ($biker->leaving_date != '') {
            $leaving_date = new DateTime($biker->leaving_date);
            $biker['leaving_date'] = $leaving_date->format('d-m-Y');
        } else {
             $biker['leaving_date'] = NULL;
        }
        //$substation = Substation::findOrFail($biker->substation_id);
        return view('bikers.show')->withBiker($biker)->withImgDir($img_dir2);
    }
    catch(\Exception $e){
       
         $request->session()->flash('success', 'Sorry!!! You cannot edit deleted Technician.');
        return redirect("bikers/");
    }        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,Request $request)
    {
        $img_dir2 =  $this->img_dir."/biker/".$id."/";

        try{
        $biker = Bikers::findOrFail($id);
        // $biker = Bikers::find($id);

        $shipments_count = DB::table('shipment')
                            ->select(DB::raw('count(*) as shipments_count'))
                            ->where('biker_id', $id)
                            ->where('delivery_status', "<>",'Delivered')
                            ->first();
        $states = DB::table('state')->get();
        $cities = DB::table('states_cities')->get();
        if ($biker->joining_date != '') {
            $joining_date = new DateTime($biker->joining_date);
            $biker['joining_date'] = $joining_date->format('d-m-Y');
        } else {
            $biker['joining_date'] = NULL;
        }
        if ($biker->leaving_date != '') {
            $leaving_date = new DateTime($biker->leaving_date);
            $biker['leaving_date'] = $leaving_date->format('d-m-Y');
        } else {
             $biker['leaving_date'] = NULL;
        }

        $substations = Substation::all();
        $skills = DB::table('skills')->get();
        $selectedSkills = json_decode($biker->skill_id, true) ?? [];

         
        return view('bikers.edit')->withBiker($biker)->withStates($states)->withCities($cities)->withSubstations($substations)->withShipmentsCount($shipments_count)->withImgDir($img_dir2)->withskills($skills)    ->with('selectedSkills', $selectedSkills); // ✅ add this

    }
    catch(\Exception $e){

       
       $request->session()->flash('success', 'Sorry!!! You cannot edit deleted Technician......');
        return redirect("bikers/");
    }
    }

    public function getAllBikers(Request $request) {
        $all_bikers = DB::table('bikers')
                        ->where('status', 'Active')
                        ->get();
        //echo "<pre>";print_r($all_bikers);die;
        echo $count_bikers = count($all_bikers); 
        // $clients = DB::connection('apniamc_master')
        //             ->table('client_master')
        //             ->where('domain_name',$_SERVER['SERVER_NAME'])
        //             ->where('is_active','Y')
        //             ->first();
        // if(!empty($clients)) {
        //     if($clients->client_plan == 'BA') {

        //     }
        // }            

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $this->validate($request, [
            'first_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'last_name' => 'required|regex:/^[\pL\s\-\']+$/u',
            'email' => 'required|email',
            'mobile' => 'required|digits:10|numeric',
            'pincode' => 'required|digits:6|numeric',
            'employee_id' => 'required',
            'address' => 'required',
            'landmark' => 'required',
            'city' => 'required|regex:/^[\pL\s\-\']+$/u',
            'state' => 'required|regex:/^[\pL\s\-\']+$/u',
            'profile_photo' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof1' => 'mimes:jpeg,bmp,png,JPEG',
            'identity_proof2' => 'mimes:jpeg,bmp,png,JPEG',
            'identity_proof3' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof4' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof5' => 'mimes:jpeg,jpg,bmp,png,JPEG',
            'identity_proof1_text' => 'required',
            'types' => 'required',
            'skill_id' => 'required|array',          // Expect multiple skills as array
            'skill_id.*' => 'exists:skills,id',             //'identity_proof2_text' =>'required'
            
        ]);
        $biker = Bikers::findOrFail($id);
        $input = $request->all();

        // $biker->skill_id = $request->input('skill_id');
        $input['skill_id'] = json_encode($input['skill_id']);


        $input['first_name'] = ucwords(strtolower($input['first_name']));
        $input['last_name'] = ucwords(strtolower($input['last_name']));
        $input['types'] = ucwords(strtolower($input['types']));
        if ($input['joining_date'] != '') {
            $joining_date = new DateTime($request['joining_date']);
            $input['joining_date'] = $joining_date->format('Y-m-d');
        } else {
            $input['joining_date'] = NULL;
        }
        if ($input['leaving_date'] != '') {
            $leaving_date = new DateTime($request['leaving_date']);
            $input['leaving_date'] = $leaving_date->format('Y-m-d');
            $input['status'] = 'Inactive';
        } else {
             $input['leaving_date'] = NULL;
        }

        // To make default status available
        $input['profile_status'] = "Available";

        
         
        if(!empty($input['password']) ) {
            $input['password'] = bcrypt($input['password']);
        } else {
            $bikers_old_password = DB::table('bikers') 
                                    ->where('id', $id)
                                    ->first();
            $input['password'] = $bikers_old_password->password;                       
        }
       // $data['password'] = substr(md5($input['email'].time()), 5, 10); 

        $img_dir2 = $this->img_dir."/biker/".$id."/";
        if (!file_exists($img_dir2)) {
            mkdir($img_dir2, 0777, true);
        }
       // if (!empty($request['profile_photo'])) {
       //      $profile_image_name = Input::file('profile_photo')->getClientOriginalName();
       //      $file = $request->file('profile_photo');
       //      if ($request->file('profile_photo')->isValid())
       //          {
       //          $i = $request->file('profile_photo')->move($img_dir, $profile_image_name);
       //          $input['profile_photo'] = $profile_image_name;
       //          }
       //      } else {
       //          $input['profile_photo'] = $request['profile_photo_old'];
       //      }

        $fields = array('profile_photo','identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5');
        foreach ($fields as $key => $field) {
        if (!empty($request[$field])) {
            $identity_proof_name = Input::file($field)->getClientOriginalName();
            $identity_proof_name = time().$identity_proof_name;
            $file = $request->file($field);
            if ($request->file($field)->isValid())
                {
                $request->file($field)->move($img_dir2, $identity_proof_name);
                $input[$field] = $identity_proof_name;
                }
            }
        else {
            $input['field'] = $request['field_old'];
        }
    }
        if(isset($_POST['reset_password'])) {
            $data['email'] = $input['email'];
            $data['name'] = ucfirst(strtolower($input['first_name']))." ".ucfirst(strtolower($input['last_name']));
            $data['password'] = substr(md5($input['email'].time()), 5, 10);
			//$cname = config('constants.company_name');
			//$cemail = config('constants.company_email');			
			//$sb = 'Reset '.$cname.' Password';

            Mail::send('emails.bikersreset', $data, function ($message) use ($data) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));
                $message->to($data['email'])->subject('Reset Password - '.Config::get('app.companyname'));
                
            });
            $input['password'] = bcrypt($data['password']);
        }
       $biker->fill($input)->save();
       $request->session()->flash('success', 'Technician updated successfully !!!');
       return redirect('bikers?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order'].'&filter_membertype='.$_GET['filter_membertype']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       // $biker = Bikers::findOrFail($id);
       // $biker->delete();
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++){
            $bikers = bikers::destroy($ids[$i]);
        }
       session()->flash('success', 'Technician deleted successfully !!!');
       return redirect('bikers/');
    }
    public function add_cod_details(Request $request)
    {
        $input = $request->all();
        $cod_date = new DateTime($input['datetime']);
        $datetime = $cod_date->format('Y-m-d H:i:s');
        var_dump($input);
        $results = DB::table('cod_collected')
                     ->whereIn('shipment_id', $input['selected'])
                     ->get();

        $cod_collected = array();
        foreach ($results as $result) {
            if(empty($cod_collected[$result->biker_id])) {
                $cod_collected[$result->biker_id] =  array('shipments' => array(), 'amount' => 0);
                $result->amount;
            } 
            $cod_collected[$result->biker_id]['shipments'][] = $result->shipment_id;
            $cod_collected[$result->biker_id]['amount'] = $cod_collected[$result->biker_id]['amount'] + $result->amount;
        }
        foreach ($cod_collected as $key => $value) {
            $inserted_row_id = DB::table('biker_cod_deposit')->insertGetId([
                                    'user_id' => $request->user()->id,
                                    'amount' => $value['amount'],
                                    'biker_id' => $key,
                                    'datetime' => $datetime,
                                ]);
            DB::table('cod_collected')
                ->whereIn('shipment_id', $value['shipments'])
                ->update([
                        'biker_cod_paid_flag' => $inserted_row_id
                ]);
                
            $cod_amount_receivable = DB::table('bikers')
                 ->select(DB::raw('cod_amount_receivable'))
                 ->where('id', $key)
                 ->first();
            $total_cod_amt = $cod_amount_receivable->cod_amount_receivable - $value['amount'];
            DB::table('bikers')
                    ->where('id', $key)
                    ->update([
                        'cod_amount_receivable' => $total_cod_amt
                    ]);
        }
        // //echo '<pre>'; var_dump($cod_collected,$results); exit;
        // $input['user_id'] = $request->user()->id;
        // $cod_date = new DateTime($input['datetime']);
        // $input['datetime'] = $cod_date->format('Y-m-d H:i:s');
        $sub_station = DB::table('sub_station')
                 ->select(DB::raw('*'))
                 ->where('user_id', $request->user()->id)
                 ->first();
        $cod_amount_collected = $sub_station->cod_amount_collected + $input['amount'];
        Session::put('sub_station_cod_amt',$cod_amount_collected);
        DB::table('sub_station')
                ->where('user_id', $request->user()->id)
                ->update([
                    'cod_amount_collected' => $cod_amount_collected
                ]);
        
        session()->flash('success', 'Transaction is successfully added.');
        return redirect('bikers/'); 
    }

    public function bikermapdetails($id)
    {
        $data = array();
      //return response()->json($data);
      //if (Request::ajax())
      //{
         //debug
          $biker_query= DB::table('bikers as b')
                      ->select('*')
                      //->where('b.profile_status','=','Available')
                      //->where('b.status','=','Active')
                      ->where('b.id','=',$id);
                      //->where('b.substation_id','=',$substation_id)
                      //->groupby('b.id')
                      //->whereNull('b.deleted_at');
          $biker_records = $biker_query->get();

          $bikername = '';
          if($biker_records)
          {
            foreach($biker_records as $biker)
            {
                $bikername = $biker->first_name.' '.$biker->last_name;
            }
          }
                
          $date_filter = date('Y-m-d');
          if(isset($_REQUEST['filter_date']))
          {
            if($_REQUEST['filter_date']!='')
            {
                $date_filter_arr = explode("-",$_REQUEST['filter_date']);
                $date_filter = $date_filter_arr[2].'-'.$date_filter_arr[1].'-'.$date_filter_arr[0];

            }
          }
          $biker_location_query1 = DB::table('biker_location as t1')
                            ->select('b.id','b.first_name','b.last_name','b.type','t1.latitude','t1.longitude',DB::raw('MAX(date_time) as date_time ') )
                            ->join('bikers as b','b.id','=','t1.biker_id')
                             ->whereRaw('b.id="'.$id.'"')
                            ->whereRaw('t1.date_time >= "'.$date_filter.' 00:00:00" and t1.date_time <= "'.$date_filter.' 23:59:59"')
                            ->groupby('t1.latitude','t1.longitude')
                            ->orderBy('t1.date_time','ASC');
        
       
        $biker_location_query1_sql=$biker_location_query1->toSql();

         $biker_location_query=DB::table(DB::raw("($biker_location_query1_sql) AS a"))
                        ->select('*')
                        ->groupby(DB::raw('ROUND(latitude,4)'), DB::raw('ROUND(longitude,4)'),DB::raw('DATE_FORMAT(date_time, "%Y-%m-%d %H:%i")') )
                        ->orderBy('date_time','ASC');

          $biker_location = $biker_location_query->get();
            // $biker_location = $biker_location_query->toSql();
            // dd($biker_location);die;
          //echo '<pre>';
            // print_r($biker_location);
            // echo '</pre>'; 


          $biker_lat = "";
          $biker_log = "";
          $biker_time = "";
          //$bikers  = array();
          $bikerstmp = array();
          
            if($biker_location) {
                foreach ($biker_location as $key => $location) {
                  
                    $biker_lat = $location->latitude;
                    $biker_log = $location->longitude;
                    $biker_time = $location->date_time;
                    
                  
                  $bikerstmp[] = array(
                'id' => $location->id,
                'first_name' =>$location->first_name,
                'last_name' => $location->last_name,
                // 'type' => $biker_record->type,
                // 'weight' => $biker_record->total_weight,
                'latitude' => $biker_lat,
                'longitude' => $biker_log,
                'date_time' => $biker_time
                );
                  

                }
            } else {
                    $biker_lat = "";
                    $biker_log = "";
                    $biker_time = "";
            }
              
           

            // echo '<pre>';
            // print_r($bikerstmp);
            // echo '</pre>'; 

            //debug ->withBikerstmp($bikerstmp)
            $data['bikerdetails'] = $bikerstmp;
            $data['bikerid'] = $id;
            $data['bikername'] = $bikername;
        return view('bikers.technicianmap',['data'=>$data]); 
            
        // $returnHTML = view('delivery.technicianmap')->with('data', $data)->render();
        // return response()->json(array('success' => true, 'html'=>$returnHTML));
    }

    // Added by gaurav on 7-4-20 for showing cities according to the states.
    public function techniciancitystatedetails(Request $request)
    {
        //echo 'reachde';die;
        $state = $request->state;

        //After getting a particular state name, sending all the city name in dropdown box
        $cities = DB::table('states_cities as sc')
                ->leftjoin('state as s','sc.state_code','=','s.id')
                ->select('sc.city_name','sc.state_code')
                ->where("s.name", '=', $state)
                ->get();

        $data = ['cities'=> $cities];
        return response()->json($data);
        
    }


    // public function calculate_distance()
    // {
    //     $date_time = Carbon::now()->toDateTimeString();
    //     $records = DB::table('biker_location as bl')
    //                 ->where('bl.distance_calculated','=',0)
    //                 ->get();

    //     $data = array();
              
    //     foreach ($records as $key => $row) {
    //         $date = new DateTime($row->date_time);
    //         $row->date = $date->format('Y-m-d');
    //         $data[$row->biker_id][$row->date][] = $row;
    //     }
               
    //     foreach($data as $biker_id => $value) {
    //         foreach ($value as $date => $distance) {
    //                         //echo "<pre>"; print_r($biker_id);print_r($date);print_r(count($distance));
    //             $km = 0;
    //              for ($i=1; $i < count($distance); $i++) {
    //                     //echo "<pre>"; print_r($distance[$i-1]->latitude);   
    //                     $km = $this->distanceCalculation((double)$distance[$i-1]->latitude, (double)$distance[$i-1]->longitude, (double)$distance[$i]->latitude, (double)$distance[$i]->longitude);
    //                 }
    //             $biker = DB::table('bikers_reading')
    //                     ->where('bikers_id','=',$biker_id)
    //                     ->where('reading_date','=',$date)
    //                     ->first();

    //             if($biker) {
    //                 DB::table('bikers_reading')
    //                     ->where('bikers_id','=',$biker_id)
    //                     ->where('reading_date','=',$date)
    //                     ->update(['distance_m_to_e' => $km,'updated_at' => $date_time]);
    //             } else {
    //                 DB::table('bikers_reading')
    //                     ->insert(['bikers_id'=> $biker_id,'reading_date' => $date,'distance_m_to_e' => $km,'created_at'=> $date_time,'updated_at'=> $date_time]);
    //             }

    //             DB::table('biker_location')
    //                 ->where('biker_id','=',$biker_id)
    //                 ->wherebetween('date_time',array($date.' 00:00:00',$date.' 23:59:59'))
    //                 ->update(['distance_calculated' => 1]);
    //         }
    //     }
    // }

    // public function distanceCalculation($point1_lat, $point1_long, $point2_lat, $point2_long, $unit = 'km', $decimals = 2) {
    //     // Calculate the distance in degrees
    //     $start  = urlencode($point1_lat.','.$point1_long);
    //     $finish = urlencode($point2_lat.','.$point2_long);

    //     $distance   = '0';
    //     $time       = '0';
    //     $raw = false;


    //     $url = 'http://maps.googleapis.com/maps/api/directions/xml?origin='.$start.'&destination='.$finish.'&sensor=false';
    //     if($data = file_get_contents($url))
    //     {
    //         $xml = new \SimpleXMLElement($data);

    //         if(isset($xml->route->leg->duration->value) AND (int)$xml->route->leg->duration->value > 0)
    //         {
    //             if($raw)
    //             {
    //                 $distance = (string)$xml->route->leg->distance->text;
    //                 $time     = (string)$xml->route->leg->duration->text;
    //             }
    //             else
    //             {
    //                 $distance = (int)$xml->route->leg->distance->value / 1000 / 1.609344; 
    //                 $time     = (int)$xml->route->leg->duration->value;
    //             }
    //         }
    //         else
    //         {
    //             echo ('Could not find that route');
    //         }

    //         return $distance * 1.60934; //convert to kms 
    //     }
    //     else
    //     {
    //         echo('Could not resolve URL');
    //     }

    //     return $distance * 1.60934; //convert to kms  
    //     round($distance, $decimals);
    // }
}
