<?php 
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Bikers;
use App\Vendor;
use DB;
use Response;
use Auth;
use Role;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use Session;
use App\VendorShipment;
use App\StatusHistory;
use Illuminate\Support\Facades\Input;
use Config;

class AutoCompleteController extends Controller {
    
    public function index(){
		$vendors = Vendor::all();
        $products = DB::table('products')
                    ->get();  
    	return view('autocomplete.index')->withVendors($vendors)->withProducts($products);
       // return view('autocomplete.index');
   }
   
   	public function store(Request $request){
        $this->validate($request, [
            'vendor_id' => 'required',
            'product_id' => 'required',
            'service_description' => 'required',
            ]);
		
        $input = $request->all();
		$products=Vendor::where('name','LIKE','%'.$input['vendor_id'].'%')->get();
        
       foreach ($products as $product) {
                $vid = $product->id;
        }
        $product_code = DB::table('products')
                        ->select('products.product_code')
                        ->where('products.id','=',$input['product_id'])
                        ->first();
                
        $awb_date = Carbon::now()->format('dmYHis');
        $awb_no = "SUPP".$awb_date.$product_code->product_code;
        $service = VendorShipment::create([
            'vendor_id' => $vid,
            'product_id' => $input['product_id'],
            'service_description' => $input['service_description'],
            'awb_no' => $awb_no,
            'order_time' => Carbon::now()->toDateTimeString(),
            'delivery_status' => "New",
            ]);

        //update ticket no
        $awb_no = Config::get('app.ticketprefix').$service->id;
        $servicelist = VendorShipment::find($service->id);
        $servicelist->awb_no = $awb_no;
        $servicelist->save();
        //update ticket no

        StatusHistory::create([
            'by_whom_role' => "Vendor",
            'by_whom_id' => $input['vendor_id'],
            'date_time' => Carbon::now()->toDateTimeString(),
            'shipment_id' => $service->id,
            'status' => "New",
            ]);

        $request->session()->flash('flash_message','Service successfully added');
        return redirect('autocomplete');
		
	}

       public function autoComplete(Request $request) {
        $query = $request->get('term','');
        
        //$products=Vendor::where('name','LIKE','%'.$query.'%')->get();
	  $products = DB::table('vendor')
                     ->where('name','LIKE','%'.$query.'%')
					 ->orWhere('company_name','LIKE','%'.$query.'%')
					 ->orWhere('email','LIKE','%'.$query.'%')
					 ->orWhere('mobile_no','LIKE','%'.$query.'%')
					 ->orWhere('landline_no','LIKE','%'.$query.'%')
					 ->get();
        
        $data=array();
        foreach ($products as $product) {
                $data[]=array('value'=>$product->name,'id'=>$product->id);
        }
        if(count($data))
             return $data;
        else
            return ['value'=>'No Result Found','id'=>''];
    }
    
}

?>