<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

//Route::group(array('domain' => 'seller.{domain}.{tld}'), function()
//{
    Route::get('/', 'VendorLogin\LoginController@login');
    Route::get('login', 'VendorLogin\LoginController@login');
    Route::post('login', 'VendorLogin\LoginController@login');
    Route::get('logout', 'VendorLogin\LoginController@logout');
    Route::post('logout', 'VendorLogin\LoginController@logout');
    Route::get('validateVendor', 'VendorLogin\LoginController@validateVendor');
    Route::post('validateVendor', 'VendorLogin\LoginController@validateVendor');
    Route::resource('shipment', 'VendorLogin\ShipmentController');
    Route::resource('/shipment_report', 'VendorLogin\OrderController@ShipmentReport');
    //Route::resource('invoice/', 'VendorLogin\InvoiceController');
    Route::get('order', 'VendorLogin\OrderController@index');
    Route::get('order/filter/{status}', 'VendorLogin\OrderController@index');
    Route::get('order/downloadExel', 'VendorLogin\OrderController@DownloadExel');
    // Route::get('order', 'VendorLogin\OrderController@index');
    //Route::get('invoice/{id}', 'VendorLogin\OrderController@show');
    Route::get('invoice/{id}', ['uses' =>'VendorLogin\OrderController@printinvoice']);
    Route::get('forgotpassword', 'VendorLogin\LoginController@forgotPassword');
    Route::post('forgotpassword', 'VendorLogin\LoginController@forgotPassword');
    Route::get('forgotpasswordindex', 'VendorLogin\LoginController@forgotPasswordIndex');

    Route::get('resetpassword', 'VendorLogin\LoginController@resetPassword');
    Route::post('resetpassword', 'VendorLogin\LoginController@resetPassword');
    Route::get('resetpasswordindex', 'VendorLogin\LoginController@resetPasswordIndex');

    //Sudo login for vendor
    Route::get('autologin/{url}', ['uses' =>'VendorLogin\LoginController@autoLogin']);
    //for bulk upload
    Route::get('bulkupload', 'VendorLogin\BulkUploadController@bulkupload');
    Route::get('upload', 'VendorLogin\BulkUploadController@bulkupload');
    Route::post('upload', 'VendorLogin\BulkUploadController@upload');
    Route::get('bulkuploaderror', 'VendorLogin\BulkUploadController@BulkUploadError');

//});
    //APIs For Showing Vendor Details using api_key/secret_key
Route::group(array('domain' => 'api.{domain}.{tld}'), function(){
    Route::get('status/{api_key?}/{secret_key?}/{awb_no?}', 'Api\WebApiController@status');
    Route::post('createshipment/{api_key?}/{secret_key?}', 'Api\WebApiController@createshipment');
});




Route::post('getintouch', 'VendorLogin\LoginController@getInTouch');
Route::get('getintouch', 'VendorLogin\LoginController@getInTouch');
Route::post('eliminate_logistics_challenges', 'VendorLogin\LoginController@LandingPage');
Route::get('eliminate_logistics_challenges', 'VendorLogin\LoginController@LandingPage');
Route::post('landing_page_email', 'VendorLogin\LoginController@LandingPageEmail');
Route::get('landing_page_email', 'VendorLogin\LoginController@LandingPageEmail');

Route::get('/', function () {
    
    $handle = @fopen(app_path()."/../counter.txt", "r");
    $counter = 0; 
    if($handle) { 
        $counter = (int) fread($handle,20); 
        fclose ($handle); 
    } 
        
    if(!Session::has('counted')) {
        Session::put('counted', 1);
        $counter++; 
        $handle = fopen(app_path()."/../counter.txt", "w" ); 
        fwrite($handle, $counter); 
        fclose($handle); 
    }
    return view('welcome')->withCounter($counter);
});



Route::get('api/awb/{awb}', 'Api\ApiController@awb');
Route::get('api/getTickets/{vendorid}', 'Api\ApiController@getTickets');
Route::get('api/delivery/{id}', 'Api\ApiController@delivery');
Route::get('api/delivery1/{id}', 'Api\ApiController@delivery1');
Route::get('api/delivery2/{id}', 'Api\ApiController@delivery2');
Route::get('api/getTechnicianStatus/{id}', 'Api\ApiController@getTechnicianStatus');
Route::get('api/getServiceDetails/{serviceId}', 'Api\ApiController@getServiceDetails');
Route::get('api/profilestatus/{id}', 'Api\ApiController@profilestatus');
Route::get('api/bikerstatus/{id}/{status}/{date_time}','Api\ApiController@StatusUpdate');
Route::get('api/deliverystatus/{id}/{awb_no}/{status}/{mode}/{date_time}/{service_action}','Api\ApiController@DeliveryUpdate');
Route::get('api/LocationUpdate/{id}/{currlat}/{currlng}/{date_time}','Api\ApiController@LocationUpdate');
Route::get('api/bikerlogin', 'Api\ApiController@ValidateBiker');
Route::post('api/bikerlogin', 'Api\ApiController@ValidateBiker');
Route::get('api/bikerlogout/{id}/{is_ios}', 'Api\ApiController@ValidateBikerlogout');
Route::get('api/vendorlogout/{id}/{is_ios}', 'Api\ApiController@ValidateVendorlogout');
//Route::post('api/bikerlogout', 'Api\ApiController@ValidateBikerlogout');
Route::post('api/servicerequest', 'Api\ApiController@servicerequest');
Route::post('api/servicerequestnew', 'Api\ApiController@servicerequestnew');
Route::post('api/requesthistory', 'Api\ApiController@requesthistory');
Route::get('api/amchistory/{vendor_id}', 'Api\ApiController@amchistory');
Route::post('api/setRating', 'Api\ApiController@setRating');
Route::post('api/requesthistorynumber', 'Api\ApiController@requesthistorynumber');
Route::get('api/requesthistorynumber1/{vendor_id}/{tech_id}', 'Api\ApiController@requesthistorynumber1');
Route::post('api/ValidateVendor', 'Api\ApiController@ValidateVendor');
Route::get('api/ValidateVendor', 'Api\ApiController@ValidateVendor');
Route::post('api/resetpasswordnew', 'Api\ApiController@resetpasswordnew');
Route::get('api/storesign', 'Api\ApiController@storesign');
Route::post('api/storesign', 'Api\ApiController@storesign');
Route::post('api/storesignios', 'Api\ApiController@storesignios');
Route::post('api/gcmregid', 'Api\ApiController@gcmregid');
Route::post('api/gcmregidvendor', 'Api\ApiController@gcmregidvendor');
Route::get('api/transactionNumber/{id}/{awb_no}/{mode}/{date_time}/{transactionNumber}','Api\ApiController@transactionNumber');
Route::get('api/resetpassword/{bikerid}/{password}', 'Api\ApiController@resetpassword');
Route::get('api/requesthistoryfilter/{vid}/{status}', 'Api\ApiController@requesthistoryfilter');
Route::get('api/requesthistoryEmpfilter/{vid}/{status}', 'Api\ApiController@requesthistoryEmpfilter');
Route::get('api/requesthistorytype/{vid}/{type}', 'Api\ApiController@requesthistorytype');
Route::get('api/requesthistoryEmptype/{vid}/{type}', 'Api\ApiController@requesthistoryEmptype');
Route::get('api/requesthistoryEmpsearchfilter/{vid}/{searchtxt}', 'Api\ApiController@requesthistoryEmpsearchfilter');
Route::get('api/requesthistorysearchfilter/{vid}/{searchtxt}', 'Api\ApiController@requesthistorysearchfilter');

Route::get('api/apiforgetpassword/{email}', 'Api\ApiController@apiforgetpassword');
Route::get('api/resetgcm/{vid}/{gcmid}', 'Api\ApiController@resetgcm');
Route::get('api/resetpassword1/{bikerid}/{password}', 'Api\ApiController@resetpassword1');
Route::get('api/dropdown', 'Api\ApiController@drop_down_list');
Route::get('auth/login', 'Auth\AuthController@getLogin');
Route::get('admin', 'Auth\AuthController@getLogin');
Route::post('auth/login', 'Auth\AuthController@postLogin');
Route::get('auth/logout', 'Auth\AuthController@getLogout');
Route::post('auth/forgotpassword', 'Auth\PasswordController@forgotPassword');
Route::get('auth/register', 'Auth\AuthController@getRegister');
Route::post('auth/register', 'Auth\AuthController@postRegister');
Route::post('api/VendorRegistration', 'Api\ApiController@VendorRegistration');
Route::get('api/getproductlist', 'Api\ApiController@getproductlist');
Route::get('api/getproductlist1', 'Api\ApiController@getproductlist1');
Route::get('api/getvendorlist', 'Api\ApiController@getvendorlist');

Route::get('calculatedistance','Bikers\CalculateDistanceController@calculate_distance');

Route::controllers([
    'auth' => 'Auth\AuthController',
    'password' => 'Auth\PasswordController',
]);


Route::get('home', 'HomeController@index');
Route::get('home/error', 'HomeController@error');

Route::get('resetpassword', 'HomeController@resetPassword');
Route::post('resetpassword', 'HomeController@resetPassword');


Route::group(['middleware' => 'acl:manage_vendor'], function () {
	Route::resource('managevendor', 'Vendor\VendorController');
});

Route::group(['middleware' => 'acl:manage_admin'], function () {
    Route::resource('manageadmin', 'ManageAdmin\ManageAdminController');
});

Route::group(['middleware' => 'acl:manage_biker'], function () {
    Route::resource('bikers', 'Bikers\BikersController');
    Route::resource('bikers_reading', 'Bikers\Bikers_readingController');
    Route::get('add_cod_details', 'Bikers\BikersController@add_cod_details');
    Route::post('add_cod_details', 'Bikers\BikersController@add_cod_details');

    Route::get('addReading', 'Bikers\BikersController@addReading');
    Route::post('addReading', 'Bikers\BikersController@addReading');
    Route::get('fetch_reading', 'Bikers\Bikers_readingController@fetch_reading');
    Route::post('fetch_reading', 'Bikers\Bikers_readingController@fetch_reading');
	Route::get('bikers/{id}/bikermapdetails', 'Bikers\BikersController@bikermapdetails');
});

Route::group(['middleware' => 'acl:manage_amc'], function () {
 Route::get('amcs/indexnew', 'Amcs\AmcsController@indexnew');
    Route::get('amcs/amcservice', 'Amcs\AmcsController@amcservice');
Route::get('amcs/amcmail', 'Amcs\AmcsController@amcmail');
Route::resource('amcs', 'Amcs\AmcsController');
});

//Route::group(['middleware' => 'acl:manage_rating'], function () {

//Route::post('ratings/selectshipment','Ratings\RatingsController@selectshipment');
Route::get('ratings/create1/{cname}/{tno}/{vid}', 'Ratings\RatingsController@create1');
Route::get('ratings/indexnew', 'Ratings\RatingsController@indexnew');
Route::post('ratings/showgraph','Ratings\RatingsController@showgraph');
Route::get('ratings/graph','Ratings\RatingsController@graph');
Route::get('ratings/ajax','Ratings\RatingsController@ajax');
Route::post('ratings/ajax1','Ratings\RatingsController@ajax1');
Route::get('ratings/ajax2','Ratings\RatingsController@ajax2');
Route::get('ratings/getmsg','Ratings\RatingsController@getmsg');

Route::post('ratings/fetchtechname','Ratings\RatingsController@fetchtechname');
Route::resource('ratings', 'Ratings\RatingsController');


//});
//Route::get('ratings/create','Ratings\RatingsController@create');
//Route::post('ratings/store','Ratings\RatingsController@store');
//Route::get('ratings/index','Ratings\RatingsController@index');


Route::group(['middleware' => 'acl:manage_substation'], function () {
    Route::resource('substation', 'Substation\SubstationController');
});

Route::group(['middleware' => 'acl:bank_cod_collected'], function () {
    Route::post('bank_cod_deposit', 'Substation\SubstationController@bank_cod_deposit');
    Route::get('bankdeposit', 'Substation\SubstationController@bankdeposit');
});

Route::group(['middleware' => 'acl:update_status'], function () {
    Route::resource('updatestatus', 'Shipment\UpdateStatusController');
});



Route::group(['middleware' => 'acl:download_deliveries'], function () {
    Route::resource('downloadreport', 'Shipment\GenerateReportController');
});

Route::group(['middleware' => 'acl:manage_delivery'], function () {
    Route::resource('managedelivery', 'Delivery\ManageDeliveryController');
    Route::post('managedelivery/deliverydetails','Delivery\ManageDeliveryController@deliverydetails');
	    Route::post('managedelivery/bikermapdetails','Delivery\ManageDeliveryController@bikermapdetails');
    Route::post('managedelivery/assignbiker','Delivery\ManageDeliveryController@assignbiker');
	Route::post('managedelivery/assignbiker1','Delivery\ManageDeliveryController@assignbiker1');
	Route::post('managedelivery/assignbiker3','Delivery\ManageDeliveryController@assignbiker3');
    Route::post('managedelivery/updatestatus','Delivery\ManageDeliveryController@updatestatus');
Route::post('managedelivery/updatestatus1','Delivery\ManageDeliveryController@updatestatus1');
Route::post('managedelivery/updatepriority','Delivery\ManageDeliveryController@updatepriority');
    Route::post('managedelivery/transfersubstation','Delivery\ManageDeliveryController@transfersubstation');
    Route::post('managedelivery/advancesearch','Delivery\ManageDeliveryController@advancesearch');
    Route::post('managedelivery/countorders','Delivery\ManageDeliveryController@countorders');
    Route::post('managedelivery/countweight','Delivery\ManageDeliveryController@countweight');
    Route::post('managedelivery/bikerdetails','Delivery\ManageDeliveryController@bikerdetails');
	//Route::post('managedelivery/fetchtechname','Delivery\ManageDeliveryController@fetchtechname');
 Route::get('mailcheck','Delivery\ManageDeliveryController@mailcheck');
});
Route::group(['middleware' => 'acl:manage_permission'], function () {
    Route::resource('managepermission', 'ManagePermission\ManagePermissionController');
    // Route::post('managepermission/managepermissions','ManagePermission\ManagePermissionController@managepermissions');
});

Route::group(['middleware' => 'acl:report'], function () {
    Route::get('report', 'Report\ReportController@index');
    Route::post('report/orderdetails','Delivery\ManageDeliveryController@deliverydetails');
    
});
Route::group(['middleware' => 'acl:inventory_reconciliation'], function () {
    Route::get('/inventoryreconciliation','Report\ReportController@inventoryreconciliation');
});  
Route::group(['middleware' => 'acl:billing_n_accounting_report'], function () {
    Route::get('/billing_n_acc_report','Report\ReportController@billingAccountingReport');
    Route::post('/billing_n_acc_report','Report\ReportController@billingAccountingReport');
});
Route::group(['middleware' => 'acl:biker_report'], function () {
    Route::get('/bikers_report','Report\ReportController@bikerReport');
    Route::post('/bikers_report','Report\ReportController@bikerReport');
	 Route::get('/amc_report','Report\ReportController@amcReport');
    Route::post('/amc_report','Report\ReportController@amcReport');
	Route::get('/customer_report','Report\ReportController@vendorReport');
    Route::post('/customer_report','Report\ReportController@vendorReport');
    Route::get('/bikercodreport','Report\ReportController@bikercodreport');
    //Route::get('/biker_report_download','Report\ReportController@bikerReportDownload');
});
Route::group(['middleware' => 'acl:create_shipment'], function () {
    Route::get('/create_shipment','Vendor\VendorController@CreateShipment');
});

Route::get('service/create','Service\ServiceController@create');
Route::post('service/store','Service\ServiceController@store');
Route::get('service/smscheck','Service\ServiceController@smscheck');
Route::get('service/createautoservice','Service\ServiceController@createautoservice');
//Route::get('service/auto','Service\ServiceController@auto');
//Route::get('service/autocomplete', 'Service\ServiceController@autocomplete');


Route::get('autocomplete',array('as'=>'autocomplete','uses'=>'AutoCompleteController@index'));
Route::post('store',array('as'=>'store','uses'=>'AutoCompleteController@store'));
Route::get('searchajax',array('as'=>'searchajax','uses'=>'AutoCompleteController@autoComplete'));

// Event::listen('illuminate.query', function($query)
// {
//     var_dump($query);
// });
