<?php

namespace App\Http\Controllers\Amcs;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Amcs;
use App\Permission;
use App\PermissionRole;
use Auth;
use Input;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;


class AmcsController extends Controller
{
   
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user_id = Auth::user()->id;
        $urid = Auth::user()->role_id;
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'amcs.vendor_id';
        }
        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC';
        } else {
            $url = '?order=ASC';
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }

        $sort_data = array(
            'p.product_name',
        'amcs.atype',
        'amcs.service_timeframe',
            'amcs.terms',
            'amcs.start_date',
            'amcs.end_date',
            'v.company_name'
        );
        //$query = Amcs::select();
        
        $query = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name');
       
        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.company_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
        $today = Carbon::now();
        $query->whereDate('amcs.end_date', '>=', $today);
        if(!empty(Input::get('filter_name'))) {
            $query->where(function($query) {
                //$query->whereDate('amcs.end_date', '>=', $today)
                 $query->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('amcs.terms', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                         ->orWhere('amcs.service_timeframe', 'LIKE', "%".trim(Input::get('filter_name')."%"))
            ->orWhere('amcs.atype', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('p.product_name', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ;
            });
        }
        //$query->orderBy('v.name','ASC');
        //dd($query->toSql());
        
        $amcs = $query->paginate(20);
        
        //past amcs
        $queryx = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name');
       
        
        if (isset($order) && ($order == 'DESC')) {
            $queryx->orderby($sort_col_name,'desc');
        } else {
            $queryx->orderby($sort_col_name,'asc');
        }
        $today1 = Carbon::now();
        $queryx->whereDate('amcs.end_date', '<', $today1);
        if(!empty(Input::get('filter_name'))) {
            $queryx->where(function($queryx) {
                //$query->whereDate('amcs.end_date', '>=', $today)
                 $queryx->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('amcs.terms', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                         ->orWhere('amcs.service_timeframe', 'LIKE', "%".trim(Input::get('filter_name')."%"))
                        ->orWhere('amcs.atype', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ->orWhere('p.product_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                        ;
            });
        }
        //$queryx->orderBy('v.name','ASC');

        //dd($query->toSql());
        
        $amcs1 = $queryx->paginate(20);
        //end
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
        //export start
        if(Input::get('report') == 1) {
        
         $query1tmp = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name');

          if(!empty(Input::get('filter_name'))) {
           
                //$query->whereDate('amcs.end_date', '>=', $today)
            //      $query1tmp->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('amcs.terms', 'LIKE', "%".Input::get('filter_name')."%")
            // ->orWhere('amcs.atype', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('p.product_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ;

                 $query1tmp->whereRaw("(v.company_name LIKE '%".trim(Input::get('filter_name'))."%' OR  amcs.terms LIKE '%".trim(Input::get('filter_name'))."%' OR amcs.service_timeframe LIKE '%".trim(Input::get('filter_name'))."%' OR amcs.atype LIKE '%".trim(Input::get('filter_name'))."%' OR p.product_name LIKE '%".trim(Input::get('filter_name'))."%')");
            
        }

        if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(amcs.id IN (".$selectedval.") )");
            }

        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.company_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }

        $query1 =  $query1tmp->get();
         
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
             $csv->insertOne(array(' ','AMCS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Client Name','Company Name', 'Type', 'Terms&Condition', 'Start Date', 'End Date', 'Product'));
             foreach ($query1 as $line) { 
                $data = array(
                     'client_name' => $line->name,
                    'company_name' => $line->company_name,
                    'type' => $line->atype,
                    'tearms_condition' => $line->terms,
                    'start_date' => date('d-F-Y',strtotime($line->start_date)),
                    'end_date' => date('d-F-Y',strtotime($line->end_date)),
                    'product' => $line->product_name
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('amcs_report.csv');
            die;
            return;
        }
        
        //end start
        return view('amcs.indexnew',['rid'=>$urid])->withAmcs($amcs)->withAmcs1($amcs1)->withFilter($filter);

    }
	
	public function indexnew()
    {
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',16)
        ->get();
        // echo "<pre>"; print_r($userpermission); die();

		$user_id = Auth::user()->id;
		$urid = Auth::user()->role_id;
        if (!empty(Input::get('sort'))) {
            $sort = Input::get('sort');
        } else {
            $sort = 'amcs.name';
        }
        
        if (!empty(Input::get('ajax'))) {
            $ajax = Input::get('ajax');
        } else {
            $ajax = 0;
        }

        if (!empty(Input::get('show'))) {
            $show = Input::get('show');
        } else {
            $show = 'allrecords';
        }        

        if (!empty(Input::get('order'))) {
            $order = Input::get('order');
        } else {
            $order = 'ASC';
        }

        if ($order == 'ASC') {
            $url = '?order=DESC&show='.$show.'&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
            $url = '?order=ASC&show='.$show.'&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        }

        if(!empty(Input::get('filter_name'))) {
            $url .= "&filter_name=".Input::get('filter_name');
        }

        $sort_data = array(
            'p.product_name',
	        'amcs.atype',
            'amcs.service_timeframe',
            'amcs.terms',
            'amcs.start_date',
            'amcs.end_date',
            'v.name',
            'v.company_name'
        );
        //$query = Amcs::select();
		
       

		$query = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
					->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.service_timeframe','amcs.atype','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','v.name','p.product_name','v.deleted_at','p.product_code');
       
        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query->orderby($sort_col_name,'desc');
        } else {
            $query->orderby($sort_col_name,'asc');
        }
		$today = Carbon::now();
        
        if($show=="ongoing")
        {
            $query->whereDate('amcs.end_date', '>=', $today);
        }
        elseif($show=="pastrecords")
        {
            $query->whereDate('amcs.end_date', '<', $today);
        }		
        if(!empty(Input::get('filter_name'))) {
            $query->where(function($query) {
				//$query->whereDate('amcs.end_date', '>=', $today)
                 $query->where('v.company_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
                         ->orWhere('v.name', 'LIKE', "%".trim(Input::get('filter_name'))."%")                                              			
						->orWhere('p.product_name', 'LIKE', "%".trim(Input::get('filter_name'))."%")
						;
            });
        }
		$query->where('v.deleted_at','=','N');
		//$query->orderBy('v.name','ASC');
		//dd($query->toSql());
		
		$amcs = $query->paginate(10);
		/*
		//past amcs
		$queryx = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
					->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.service_timeframe','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name','v.deleted_at');
       
        
        if (isset($order) && ($order == 'DESC')) {
            $queryx->orderby($sort_col_name,'desc');
        } else {
            $queryx->orderby($sort_col_name,'asc');
        }
		$today1 = Carbon::now();
		$queryx->whereDate('amcs.end_date', '<', $today1);
		$queryx->where('v.deleted_at','=','N');
        if(!empty(Input::get('filter_name'))) {
            $queryx->where(function($queryx) {
				//$query->whereDate('amcs.end_date', '>=', $today)
                 $queryx->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
                        ->orWhere('amcs.terms', 'LIKE', "%".Input::get('filter_name')."%")
                         ->orWhere('amcs.service_timeframe', 'LIKE', "%".Input::get('filter_name')."%")
			->orWhere('amcs.atype', 'LIKE', "%".Input::get('filter_name')."%")
						->orWhere('p.product_name', 'LIKE', "%".Input::get('filter_name')."%")
						;
            });
        }
		//$queryx->orderBy('v.name','ASC');
		
		//dd($query->toSql());
		
		$amcs1 = $queryx->paginate(10);
        */
		//end
        $filter = array(
            'sort' => $sort,
            'url' => $url,
            'order' => $order
        );
		//export start
        if(Input::get('report') == 1) {
		
         $query1tmp = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.service_timeframe','amcs.atype','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','v.name','p.product_name','v.deleted_at');

          if(!empty(Input::get('filter_name'))) {
           
                //$query->whereDate('amcs.end_date', '>=', $today)
            //      $query1tmp->where('v.company_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('amcs.terms', 'LIKE', "%".Input::get('filter_name')."%")
            // ->orWhere('amcs.atype', 'LIKE', "%".Input::get('filter_name')."%")
            //             ->orWhere('p.product_name', 'LIKE', "%".Input::get('filter_name')."%")
            //             ;

                 $query1tmp->whereRaw("(v.company_name LIKE '%".trim(Input::get('filter_name'))."%' OR  amcs.terms LIKE '%".trim(Input::get('filter_name'))."%'OR amcs.service_timeframe LIKE '%".trim(Input::get('filter_name'))."%'  OR amcs.atype LIKE '%".trim(Input::get('filter_name'))."%' OR p.product_name LIKE '%".trim(Input::get('filter_name'))."%')");
            
        }

        if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(amcs.id IN (".$selectedval.") )");
            }

        if (isset($sort) && in_array($sort, $sort_data)) {
            $sort_col_name = $sort;
        } else {
            $sort_col_name = "v.company_name";
        }
        if (isset($order) && ($order == 'DESC')) {
            $query1tmp->orderby($sort_col_name,'desc');
        } else {
            $query1tmp->orderby($sort_col_name,'asc');
        }
		$query1tmp->where('v.deleted_at','=','N');
		$query1 =  $query1tmp->get();
		 
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('Client Name', 'Company Name','Type', 'Terms&Condition', 'Start Date', 'End Date', 'Product'));
			 foreach ($query1 as $line) { 
                $data = array(
                    'client_name' => $line->name,
                    'company_name' => $line->company_name,
                    'type' => $line->atype,
                    'tearms_condition' => $line->terms,
                    'start_date' => date('d-F-Y',strtotime($line->start_date)),
                    'end_date' => date('d-F-Y',strtotime($line->end_date)),
                    'product' => $line->product_name
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('amcs_report.csv');
            die;
            return;
		}
		
		//end start
        if($ajax==0)
        {
            return view('amcs.indexnew',['rid'=>$urid])->withFilter($filter)->withUserpermission($userpermission);
        }
        if($ajax==1)
        {
            return view('amcs.ajaxdata',['rid'=>$urid])->withAmcs($amcs)->withFilter($filter)->withUserpermission($userpermission);
        }

    }
	
	    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */



    //  new function for get service_requests data   , hari 11-06-2025
     public function indexrequest()
{
    // Fetch and pass AMC requests data to amcs.indexrequest.blade.php file

  $requests = DB::table('service_requests')
    ->join('amcs', 'service_requests.amc_id', '=', 'amcs.id')
    ->join('vendor', 'amcs.vendor_id', '=', 'vendor.id')
    ->join('products', 'amcs.product_id', '=', 'products.id')
    ->where('service_requests.request_done', 1) // Only entries where request was done
    //  ->where('service_requests.active_status', 1) // Only entries where request was done
    ->orderBy('service_requests.updated_date', 'desc')
    ->select(
        'service_requests.*',
        'vendor.company_name',
        'vendor.name as vendor_name',
        'products.product_name',
        'amcs.end_date',
        'amcs.start_date'
    )
    ->get();
      foreach ($requests as $index => $request) {
            $request->serial = $index + 1;
        }


    return view('amcs.indexrequest', compact('requests'));
}



public function updateStatus(Request $request)
{
      DB::table('service_requests')
        ->where('id', $request->request_id)
        ->update([
            'status' => $request->status,
            'updated_date' => Carbon::now()
        ]);

    return redirect()->back()->with('success', 'Request status updated.');
}


    public function create()
    {
        //return view('amcs.create');
		$vendors = DB::table('vendor')
                    ->where('deleted_at','=','N')
                    ->where('status','=','Active')
                    ->orderBy('name','asc')
                    ->get(); 
		$products = DB::table('products')->orderBy('product_name','asc')->get();

          $site_setting = DB::table('site_settings')->first();
          $settings = [];

        if ($site_setting && $site_setting->settings) {
            $settings = unserialize(urldecode($site_setting->settings));
        }

        return view('amcs.create')->withProducts($products)->withsettings($settings)->withVendors($vendors);
    }

	/**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
   public function store(Request $request)
    {
        $this->validate($request, [
            'vendor_id' => 'required',
            'service_timeframe' => 'required',
            //'terms' => 'required',
            'start_date' => 'required|date|date_format:d-m-Y|before:end_date',
		  'end_date' => 'required|date|date_format:d-m-Y|after:start_date',
            'product_id' =>'required'

        ]); 
        $input = $request->all();
		
        //$data['vendor_id'] = $input['vendor_id'];
        if ($input['start_date'] != '') {
            $start_date = new DateTime($request['start_date']);
            $input['start_date'] = $start_date->format('Y-m-d');
			$today = Carbon::createFromFormat('Y-m-d',$input['start_date']);
			$today1 = Carbon::createFromFormat('Y-m-d',$input['start_date']);
			$s1 = $today->toDateTimeString();
			$s2 = $today->addMonths(3)->toDateTimeString();
			$s3 = $today->addMonths(3)->toDateTimeString();
			//$edt = $today1->addYear()->toDateTimeString();               
        } else {
            $input['start_date'] = NULL;
        }
		
		if ($input['end_date'] != '') {
            $end_date = new DateTime($request['end_date']);
            $input['end_date'] = $end_date->format('Y-m-d');
        } else {
            $input['end_date'] = NULL;
        }
     	//$input['end_date'] = $edt;
		$input['s1'] = $s1;
		$input['s2'] = $s2;
		$input['s3'] = $s3;

        $service_timeframe = '';
        $next_service_date = '';

        if($input['service_timeframe']!='')
        {
            $service_timeframe = $input['service_timeframe'];
            switch($service_timeframe)
            {
                case '15 Days' :

                    $daystoadd = 15;
                    $next_service_date = date('Y-m-d', strtotime("+15 days",strtotime($input['start_date'])));
                    break;

                case 'Monthly' :
                    $next_service_date = date('Y-m-d', strtotime("+1 month",strtotime($input['start_date'])));
                    break;

                case 'Quaterly' :
                    $next_service_date = date('Y-m-d', strtotime("+3 months",strtotime($input['start_date'])));
                    break;

                case 'Yearly' :
                    $next_service_date = date('Y-m-d', strtotime("+12 months",strtotime($input['start_date'])));
                    break;
            }
        }  

        $input['next_service_date'] =  $next_service_date;   

           
		
        $amc_id = Amcs::create($input);
		//print_r($input);
        $request->session()->flash('success', 'AMC added successfully !!!');
        return redirect("amcs/indexnew");
    }
/**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        $amc = Amcs::findOrFail($id);
		//  dd($amc);
		$pid = $amc->product_id;
		$products = DB::table('products')
                     ->where('id', '=', $pid)
                     ->get();

		$vid = $amc->vendor_id;
		$vendors = DB::table('vendor')
                     ->where('id', '=', $vid)
                     ->get();


        if ($amc->start_date != '') {
            $start_date = new DateTime($amc->start_date);
            $amc['start_date'] = $start_date->format('d-m-Y');
        } else {
            $amc['start_date'] = NULL;
        }
        if ($amc->end_date != '') {
            $end_date = new DateTime($amc->end_date);
            $amc['end_date'] = $end_date->format('d-m-Y');
        } else {
             $amc['end_date'] = NULL;
        }
        return view('amcs.show')->withAmc($amc)->withProducts($products)->withVendors($vendors);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $amc = Amcs::findOrFail($id);
      
        if ($amc->start_date != '') {
            $start_date = new DateTime($amc->start_date);
            $amc['start_date'] = $start_date->format('d-m-Y');
		
        } else {
            $amc['start_date'] = NULL;
        }
		
        if ($amc->end_date != '') {
            $end_date = new DateTime($amc->end_date);
            $amc['end_date'] = $end_date->format('d-m-Y');
        } else {
             $amc['end_date'] = NULL;
        }

		$products = DB::table('products')->get();
		$vendors = DB::table('vendor')->where('deleted_at','=','N')->get();
        $site_setting = DB::table('site_settings')->first();
          $settings = [];

        if ($site_setting && $site_setting->settings) {
            $settings = unserialize(urldecode($site_setting->settings));
        }
        $selected_location_id = $amc->vendor_location ?? null;
        return view('amcs.edit')->withAmc($amc)->withProducts($products)->withsettings($settings)->withVendors($vendors)->withselected_location_id($selected_location_id);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $this->validate($request, [
            'vendor_id' => 'required',
             'service_timeframe' => 'required',
            
            'start_date' => 'required',
            'end_date' => 'required',
            'product_id' =>'required'

        ]);
        $amc = Amcs::findOrFail($id);
        $input = $request->all();
        if ($input['start_date'] != '') {
            $start_date = new DateTime($request['start_date']);
            $input['start_date'] = $start_date->format('Y-m-d');
			$today = Carbon::createFromFormat('Y-m-d',$input['start_date']);
			$today1 = Carbon::createFromFormat('Y-m-d',$input['start_date']);
			$s1 = $today->toDateTimeString();
			$s2 = $today->addMonths(3)->toDateTimeString();
			$s3 = $today->addMonths(3)->toDateTimeString();
        } else {
            $input['start_date'] = NULL;
        }
        if ($input['end_date'] != '') {
            $end_date = new DateTime($request['end_date']);
            $input['end_date'] = $end_date->format('Y-m-d');
        } else {
             $input['end_date'] = NULL;
        }

		$input['s1'] = $s1;
		$input['s2'] = $s2;
		$input['s3'] = $s3;
		
	   $amc->fill($input)->save();
       $request->session()->flash('success', 'AMC updated successfully !!!');
       return redirect('amcs/indexnew?sort='.$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']."&show=".$_GET['show']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ids = explode(',', $id);
        for($i=0;$i<count($ids);$i++){
            $amcs = amcs::destroy($ids[$i]);
        }
       session()->flash('success', 'AMC deleted successfully !!!');
       return redirect('amcs/indexnew');
    }

public function amcservice()
    {
        //return view('amcs.create');
		//$data = DB::table('amc_service_history')->get();
       // return $data;
	   //return view('amcs.service')->withData($data);
	   
	   $amcs = DB::table('amcs')->get();
		$today1 = Carbon::now()->format('Y-m-d');
		//$today = $today1." 00:00:00";

		foreach($amcs as $amc)
		{
			$aid = $amc->id;
			$sdate = $amc->start_date;
			$s1 = $amc->s1;
			$rs1 = substr($s1, 0, 10);
			$s2 = $amc->s2;
			$rs2 = substr($s2, 0, 10);
			$s3 = $amc->s3;
			$rs3 = substr($s3, 0, 10);
			$vid = $amc->vendor_id;
			$vemail_query = DB::table('vendor')
                        ->select('*')
                        ->where('id','=',$vid)
                        ->first();
						//print_r($vemail_query);
			$vemail = $vemail_query->email;
			$vname = $vemail_query->name;
			$date1 = Carbon::createFromFormat('Y-m-d', $rs3);
			$rs4 = $date1->subWeek();
			$rs5 = substr($rs4, 0, 10);
			$vid = $amc->vendor_id;
			$pid = $amc->product_id;
			$sr = $amc->service;
			$st = "";
			if($sr == "0"){
				$sr = "1";
				$st = "First";
			}
			if($sr == "1"){
				$sr = "2";
				$st = "Second";
			}
			if($sr == "2"){
				$sr = "3";
				$st = "Last";
			}	
			
			if($sr <=3){	
				if($today1 == $rs5){
				//echo $vemail;
					$msg = "Your AMC is Expire after 7 days.";
					$emailcontent1 = array (
					'name' => $vname,
					'ex' => $st,
					'msg'=>$msg,
					'vemail'=>$vemail
					);
					Mail::send('emails.amcmail', $emailcontent1, function ($message) use ($vemail) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
					
					$message->to($vemail)->subject(Config::get('app.companyname').'AMC Report');
					//service code end
				 });
				}	
				if($today1 == $rs1 || $today1 == $rs2 || $today1 == $rs3){
			
					DB::table('amcs')->where('id', $aid)->update(['service' => $sr]);
					//service code start
					$msg = "Your ".$st." Service for AMC is Completed today.";
					
					
					$emailcontent1 = array (
					'name' => $vname,
					'ex' => $st,
					'msg'=>$msg,
					'vemail'=>$vemail
					);
					Mail::send('emails.amcmail', $emailcontent1, function ($message) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));  
					
					$message->to($vemail)->subject(Config::get('app.companyname').'AMC Report');
					//service code end
				 });
			}
			}
			
		}
    }

	public function amcmail()
    {
	   //$ss = ["Order Received"];
       $amcs = DB::table('shipment_status_history')->get();
		
	   $amcs1 = DB::table('shipment_status_history')
	   ->where('status', '=', "Order Received")
	   ->where('by_whom_role', '<>', "Bikers")
	   ->get();
	   $n = count($amcs1);
	   
	   $amcs2 = DB::table('shipment_status_history')
	   ->where('status', '=', "Delivered")
	   ->where('by_whom_role', '<>', "Bikers")
	   ->orwhere('status', '=', "RTN Delivered")
	   ->orwhere('status', '=', "Delivered_Cash collected")
	   ->orwhere('status', '=', "Delivered_card on delivery")
	   ->orwhere('status', '=', "Delivered_Open box")
	   ->get();
	   $c = count($amcs2);
	   
	   $amcs3 = DB::table('shipment_status_history')
	   ->where('by_whom_role', '<>', "Bikers")
	   ->orwhere('status', '=', "Order Assigned")
	   ->orwhere('status', '=', "Order Assigned not ready")
	   ->orwhere('status', '=', "Order Reassigned_1")
	   ->orwhere('status', '=', "Order Reassigned_2")
	    ->orwhere('status', '=', "At_substation")
	   ->orwhere('status', '=', "At_Substation_Reattempt1")
	   ->orwhere('status', '=', "At_Substation_Reattempt2")
	   ->orwhere('status', '=', "At_substation_rtn")
	    ->orwhere('status', '=', "At_Substation_rtn_Reattempt1")
	   ->orwhere('status', '=', "At_Substation_rtn_Reattempt2")
	   ->orwhere('status', '=', "Order picked_in transit")
	   ->orwhere('status', '=', "Order picked_weight changed")
	    ->orwhere('status', '=', "In transit")
	   ->orwhere('status', '=', "In transit_address changed")
	   ->orwhere('status', '=', "In transit_Business_or_house closed")
	   ->orwhere('status', '=', "In transit_COD amount not ready")
	    ->orwhere('status', '=', "In transit_Customer Refused_or_Rejected")
	   ->orwhere('status', '=', "In transit_undelivered")
	   ->orwhere('status', '=', "In transit_Reattempt1")
	   ->orwhere('status', '=', "In transit_Reattempt2")
	    ->orwhere('status', '=', "In transit_delay out of our control")
	   ->orwhere('status', '=', "In Transit_Out for Delivery")
	   ->orwhere('status', '=', "In Transit_Out for Delivery1")
	    ->orwhere('status', '=', "In Transit_Out for Delivery2")
	   ->orwhere('status', '=', "In transit_Shipment Lost")
	   ->orwhere('status', '=', "RTN Order picked_in transit")
	   ->orwhere('status', '=', "RTN Order picked_weight changed")
	   ->orwhere('status', '=', "RTN In transit")
	   ->orwhere('status', '=', "RTN In transit_address changed")
	   ->orwhere('status', '=', "RTN In transit_Business_or_house closed")
	   ->orwhere('status', '=', "RTN In transit_COD amount not ready")
	   ->orwhere('status', '=', "RTN In transit_Customer Refused_or_Rejected")
	   ->orwhere('status', '=', "RTN In transit_undelivered")
	   ->orwhere('status', '=', "RTN In transit_Reattempt1")
	   ->orwhere('status', '=', "RTN In transit_Reattempt2")
	   ->orwhere('status', '=', "RTN In transit_delay out of our control")
	   ->orwhere('status', '=', "RTN In Transit_Out for Delivery")
	   ->orwhere('status', '=', "RTN In Transit_Out for Delivery1")
	   ->orwhere('status', '=', "RTN In Transit_Out for Delivery2")
	   ->orwhere('status', '=', "RTN In transit_Shipment Lost")
	   ->get();
	   $i = count($amcs3);
	   
	   //$t = count($amcs4);
	  	$t = $n+$c+$i;
      // session()->flash('success', 'Mail send successfully.');
	   
	   $emailcontent = array (
            'new' => $n,
			'inprogress' => $i,
			'total' => $t,
            'complete' => $c
            );
	   Mail::send('emails.amcs', $emailcontent, function ($message) {        
                $message->from(Config::get('app.DOMAIN_NAME'), Config::get('app.companyname'));
                $message->replyTo(Config::get('app.fromemail'), Config::get('app.companyname'));          
            $message->to(Config::get('app.adminemail'))->subject('Service Ticket Request Report');
        });
       return "New Request : ".$n." Completed Request : ".$c." InProgress Request : ".$i." Total Request : ".$t;
    }
}
