<?php

namespace App\Http\Controllers\Amcs;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Amcs;
use Auth;
use Input;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use App\Vendor;
use App\VendorShipment;
use App\StatusHistory;

class AmcSchedulerController extends Controller
{
   
   public function __construct()
    {
         
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
    }

    public function schedule_amc_service() {
        
        $emailcontent = array (
            'new' => 1,
            'inprogress' => 2,
            'total' => 3,
            'complete' => 4
            );

        try {  
            Mail::send('emails.amcs', $emailcontent, function ($message) {        
                    $message->from('gajendra@mukesoft.com');        
                $message->to('gajendra.mukesoft@gmail.com')->subject('Service Ticket Request Report');
            });
            echo "Email sent successfully.....";
        } catch (\Exception $ex) { 
            echo "Email not sent....";
        }
    }

    public function createautoserviceamc(Request $request)
    {
        $amcs = DB::table('amcs')
                ->select('*')
                ->where('end_date','>',date('Y-m-d'))
                ->where('next_service_date','=',date('Y-m-d', strtotime('+7 days')))
                ->get();
                        
        if($amcs)
        {
            foreach($amcs as $amc)
            {

                $product_id = $amc->product_id;
                $vendor_id = $amc->vendor_id;
        
                $product_code = DB::table('products')
                                ->select('*')
                                ->where('products.id','=',$product_id)
                                ->first();
                //echo "<pre>"; print_r($product_code); die();
                $user = Auth::user();   

                $username =  "Admin - " .$user->first_name." ".$user->last_name; 
         
                $typ = "Desktop - Auto Generate Service";     
                $awb_date = Carbon::now()->format('dmYHis');
                $awb_no = "SUPP".$awb_date.$product_code->product_code;

                $admin = "Auto Generated";

                $service_description = 'auto generated ticket';
                $service_type = 'Complain';
                $mobno = '';

                $service = VendorShipment::create([
                    'vendor_id' => $vendor_id,
                    'product_id' => $product_id,
                    'service_description' => $service_description,
                    'awb_no' => $awb_no,
                  // 'order_time' => Carbon::now()->toDateTimeString(),
                     'order_time' => Carbon::now()->addDays(7),
                    'delivery_status' => "New",
                    'created_type'=> $typ,
                    // 'created_by'=>"Admin",
                    'created_by'=> $username,
                    'service_type'=> $service_type,
                    'mobno'=> $mobno,
                    ]);

            
                //echo $order_time; die();
                //update ticket no
                $awb_no = Config::get('app.ticketprefix').$service->id;
                $servicelist = VendorShipment::find($service->id);
                $servicelist->awb_no = $awb_no;
                $servicelist->save();
                //update ticket no
        

                echo "<pre>";print_r($service);die;
         

                $vinfo = DB::table('vendor')
                       ->select('*')
                       ->where('vendor.id','=',$vendor_id)
                       ->first();
                $vname = $vinfo->name;
                $vemail = $vinfo->email;
                $vpwd = $vinfo->plain_password;
                $enquiry_message = Config::get('app.companyname')." Admin(".$admin.") created ticket for you with the complain ".$service_description." For Product ".$product_code->product_name.".";
                $emailcontent = array (
                'email'=>$vemail,
                   'password'=>$vpwd,
                    'cno' => $awb_no
                );
          
                $st = str_replace(' ', '%20', $awb_no);



                //SMS code start
                // $link3 ="http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$mobno&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
                //     $client3 = new \GuzzleHttp\Client();
                //     $this->response = $client3->get($link3)->getBody()->getContents(); 

                //SMS COde end
                    //print_r($this->response); exit();
                    //send sms
                $m1 = $vinfo->mobile_no;

                //SMS code start
                // $link1 = "http://enterprise.smsgupshup.com/GatewayAPI/rest?method=sendMessage&send_to=91$m1&msg=Dear%20Customer,%20Your%20Complaint%20No.$st,%20has%20been%20Registered%20and%20will%20be%20attended%20shortly.%20For%20further%20assistance%20please%20call%20on%20".Config::get('app.companypnone').".From".Config::get('app.companyname').".%20&msg_type=TEXT&userid=2000062127&auth_scheme=plain&password=3ZhWNJSwg&v=1.1&format=text";
                //     $client1 = new \GuzzleHttp\Client();
                //     $this->response = $client1->get($link1)->getBody()->getContents();
                //SMS code end
                //end
        
                StatusHistory::create([
                    'by_whom_role' => "Vendor",
                    'by_whom_id' => $vendor_id,
                    'date_time' => Carbon::now()->toDateTimeString(),
                    'shipment_id' => $service->id,
                    'status' => "New",
                    ]);

                    //update
                    $service_timeframe = '';
                    $next_service_date = '';

                if($amc->service_timeframe!='')
                {
                    $service_timeframe = $amc->service_timeframe;
                    switch($service_timeframe)
                    {
                        case '15 Days' :

                            $daystoadd = 15;
                            $next_service_date = date('Y-m-d', strtotime("+15 days",strtotime($amc->next_service_date)));
                            break;

                            case 'Monthly' :
                                $next_service_date = date('Y-m-d', strtotime("+1 month",strtotime($amc->next_service_date)));
                                break;

                            case 'Quaterly' :
                                $next_service_date = date('Y-m-d', strtotime("+3 months",strtotime($amc->next_service_date)));
                                break;
                    }
                }  

                DB::table('amcs')
                ->where('id', $amc->id)
                ->update(['next_service_date' => $next_service_date]);

            } //foreach
        }   
    }
}
