<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bikers extends Model
{
	protected $table = 'bikers';
	protected $fillable = ['substation_id', 'first_name', 'last_name', 'email','password', 'mobile', 'address','address1','landmark', 'city', 'state', 'employee_id', 'pincode', 'profile_photo','identity_proof1', 'identity_proof2', 'identity_proof3', 'identity_proof4', 'identity_proof5','identity_proof1_text','identity_proof2_text','identity_proof3_text','identity_proof4_text','identity_proof5_text', 'profile_status', 'status', 'type', 'cod_amount_receivable', 'joining_date', 'leaving_date', 'types','skill_id','created_by'];
	use SoftDeletes;
	/**
	* The attributes that should be mutated to dates.
	*
	* @var array
	*/
	protected $dates = ['deleted_at'];

		public function skill()
{
    return $this->belongsTo(Skill::class, 'skill_id');
}


	// app/Biker.php
public function shipments()
{
    return $this->hasMany(\App\VendorShipment::class, 'biker_id');
}
}
