<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Amcs extends Model
{
	protected $table = 'amcs';
	protected $fillable = ['vendor_id', 'terms', 'start_date', 'end_date','product_id','service','s1','s2','s3','atype','service_timeframe','next_service_date','product_code','vendor_address','amc_price'];
	//use SoftDeletes;
	/**
	* The attributes that should be mutated to dates.
	*
	* @var array
	*/
	//protected $dates = ['deleted_at']; 

	 // ✅ ADD THIS RELATIONSHIP  
    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id');
    }

    // ✅ (Optional) Add product relationship if needed
    public function product()
    {
        return $this->belongsTo(Products::class, 'product_id');
    }

	// In Amc.php
public function quotations()
{
    return $this->hasMany(AmcQuotation::class, 'amc_id');
}
}
