<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Vendor;
use App\Products;

class AmcQuotation extends Model
{
    // Specify the table name
    protected $table = 'amc_quotation';

    // Disable Laravel's automatic timestamps (since you use varchar for created_at/updated_at)
    public $timestamps = false;

    // Fillable fields for mass assignment
    protected $fillable = [
        'vendor_id',
        'terms',
        'start_date',
        'end_date',
        'product_id',
        'created_at',
        'updated_at',
        'service',
        's1',
        's2',
        's3',
        'atype',
        'service_timeframe',
        'next_service_date',
        'amc_price',
        'quotation_type',
        'sending_type',
        'amcs_id'
    ];
public function vendor()
{
    return $this->belongsTo(Vendor::class, 'vendor_id');
}

public function product()
{
    return $this->belongsTo(Products::class, 'product_id');
}



// public function quotations()
// {
//     return $this->hasMany(AmcQuotation::class, 'vendor_id', 'vendor_id')
//                 ->whereDate('end_date', '>=', now());
// }

}
// app/AmcQuotation.php